/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListUtils;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uccext.bo.PortalCmsInfoListBO;
import com.tydic.uccext.bo.UccCommodityRecommendIDListReqBO;
import com.tydic.uccext.bo.UccCommodityRecommendIDListRspBO;
import com.tydic.uccext.dao.UccCommoRecommendMapper;
import com.tydic.uccext.dao.po.UccCommoRecommendPO;
import com.tydic.uccext.service.UccCommodityRecommendListQryBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccCommodityRecommendListQryBusiService.class)
public class UccCommodityRecommendListQryBusiServiceImpl
implements UccCommodityRecommendListQryBusiService {
    @Autowired
    private UccCommoRecommendMapper commoRecommendMapper;

    public UccCommodityRecommendIDListRspBO qryRecommendIDList(UccCommodityRecommendIDListReqBO reqBO) {
        reqBO.setSupplierId(reqBO.getOrgIdIn());
        UccCommodityRecommendIDListRspBO rspBO = new UccCommodityRecommendIDListRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        UccCommoRecommendPO commoRecommendPO = new UccCommoRecommendPO();
        commoRecommendPO.setColumnCode(reqBO.getColumnCode());
        commoRecommendPO.setSupplierId(reqBO.getSupplierId());
        try {
            List<UccCommoRecommendPO> uccCommoRecommendPOS = this.commoRecommendMapper.queryCommoRecommendID(commoRecommendPO);
            if (CollectionUtils.isEmpty(uccCommoRecommendPOS)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2cms\u4fe1\u606f\u4e3a\u7a7a");
                return rspBO;
            }
            if (reqBO.getTitleSource() == 1) {
                PortalCmsInfoListBO cmsInfoListBO = new PortalCmsInfoListBO();
                List commodityids = uccCommoRecommendPOS.stream().map(UccCommoRecommendPO::getCommodityId).collect(Collectors.toList());
                cmsInfoListBO.setCommodityId(commodityids);
                rspBO.setCmsInfoListBOList((List)Lists.newArrayList((Object[])new PortalCmsInfoListBO[]{cmsInfoListBO}));
            } else if (reqBO.getTitleSource() == 2) {
                ArrayList portalCmsInfoListBOS = Lists.newArrayList();
                List catIds = uccCommoRecommendPOS.stream().map(UccCommoRecommendPO::getCategoryId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty((Collection)(catIds = ListUtils.removeNull(catIds)))) {
                    rspBO.setRespDesc("\u67e5\u8be2cms\u7684\u5546\u6237ID\u4e3a\u7a7a");
                    rspBO.setRespCode("0000");
                    return rspBO;
                }
                Map<String, List<UccCommoRecommendPO>> uccCommoRecommendPOMap = uccCommoRecommendPOS.stream().collect(Collectors.groupingBy(UccCommoRecommendPO::getCategoryId));
                for (Map.Entry<String, List<UccCommoRecommendPO>> longListEntry : uccCommoRecommendPOMap.entrySet()) {
                    longListEntry.getKey();
                    PortalCmsInfoListBO cmsInfoListBO = new PortalCmsInfoListBO();
                    cmsInfoListBO.setSkuLocation(longListEntry.getKey());
                    List commodityids = longListEntry.getValue().stream().map(UccCommoRecommendPO::getCommodityId).collect(Collectors.toList());
                    cmsInfoListBO.setCommodityId(commodityids);
                    portalCmsInfoListBOS.add(cmsInfoListBO);
                    rspBO.setCmsInfoListBOList((List)portalCmsInfoListBOS);
                }
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

