/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uccext.bo.UccCommodityRecommendTitleAddReqBO;
import com.tydic.uccext.bo.UccCommodityRecommendTitleAddRspBO;
import com.tydic.uccext.dao.UccCommoRecommendTitleMapper;
import com.tydic.uccext.service.UccCommodityRecommendTitleAddBusiService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccCommodityRecommendTitleAddBusiService.class)
public class UccCommodityRecommendTitleAddBusiServiceImpl
implements UccCommodityRecommendTitleAddBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityRecommendTitleAddBusiServiceImpl.class);
    @Autowired
    private UccCommoRecommendTitleMapper commoRecommendTitleMapper;
    private Sequence uccBannerSequence = Sequence.getInstance();
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public UccCommodityRecommendTitleAddRspBO addRecommendTitle(UccCommodityRecommendTitleAddReqBO reqBO) {
        UccCommodityRecommendTitleAddRspBO rspBO = new UccCommodityRecommendTitleAddRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspBO.setRespCode(e.getMsgCode());
            rspBO.setRespCode(e.getMsgInfo());
            return rspBO;
        }
        reqBO.setId(Long.valueOf(this.uccBannerSequence.nextId()));
        try {
            List<SupplierShopPo> supplierShopPos;
            if (null != reqBO.getOrgIdIn() && CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn()))) {
                reqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
            }
            reqBO.setSupplierId(reqBO.getOrgIdIn());
            this.commoRecommendTitleMapper.addCommoRecommendTitle(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u63a8\u8350\u6807\u9898\u5931\u8d25,\u539f\u56e0:" + e);
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        rspBO.setId(reqBO.getId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

