/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.XextSkuChangeMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.XextSkuChangePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccCommodityBatchShelvesReqBO;
import com.tydic.uccext.bo.UccExtSkuChangeDealReqBO;
import com.tydic.uccext.bo.UccExtSkuChangeDealRspBO;
import com.tydic.uccext.service.UccCommodityBatchShelvesBusiService;
import com.tydic.uccext.service.UccExtSkuChangeDealBusiService;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccExtSkuChangeDealBusiService.class)
public class UccExtSkuChangeDealBusiServiceImpl
implements UccExtSkuChangeDealBusiService {
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Reference(interfaceClass=UccCommodityBatchShelvesBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccCommodityBatchShelvesBusiService uccCommodityBatchShelvesBusiService;
    @Autowired
    private XextSkuChangeMapper xextSkuChangeMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccExtSkuChangeDealBusiServiceImpl.class);

    public UccExtSkuChangeDealRspBO updateCommdAndSku(UccExtSkuChangeDealReqBO reqBO) {
        XextSkuChangePo xextSkuChangePo;
        UccSkuPo uccSkuPo;
        UccCommodityPo uccCommodityPo;
        UccExtSkuChangeDealRspBO rspBO = new UccExtSkuChangeDealRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5904\u7406\u6210\u529f");
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getDCommdDownList())) {
            try {
                for (Long dCommdDown : reqBO.getDCommdDownList()) {
                    uccCommodityPo = new UccCommodityPo();
                    uccCommodityPo.setRemark("\u6e20\u9053\u65b9\u7981\u552e");
                    uccCommodityPo.setCommodityId(dCommdDown);
                    this.uccCommodityMapper.updateCommodity(uccCommodityPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5546\u54c1\u7535\u5546\u4e0b\u67b6\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getDSkuDownList())) {
            try {
                uccSkuPo = new UccSkuPo();
                uccSkuPo.setRemark("\u6e20\u9053\u65b9\u7981\u552e");
                uccSkuPo.setSkuStatus(7);
                this.uccSkuMapper.batchUpdateById(reqBO.getDSkuDownList(), uccSkuPo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5355\u54c1\u7535\u5546\u4e0b\u67b6\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getUpCommdList())) {
            try {
                UccCommodityBatchShelvesReqBO uccCommodityBatchShelvesReqBO = new UccCommodityBatchShelvesReqBO();
                uccCommodityBatchShelvesReqBO.setCommodityId(reqBO.getUpCommdList());
                this.uccCommodityBatchShelvesBusiService.batchShelves(uccCommodityBatchShelvesReqBO);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5546\u54c1\u4e0a\u67b6\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getKillCommdList())) {
            try {
                for (Long killCommd : reqBO.getKillCommdList()) {
                    uccCommodityPo = new UccCommodityPo();
                    uccCommodityPo.setCommodityStatus(4);
                    uccCommodityPo.setCommodityId(killCommd);
                    this.uccCommodityMapper.updateCommodity(uccCommodityPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5546\u54c1\u5931\u6548\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getKillSkuList())) {
            try {
                uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuStatus(6);
                this.uccSkuMapper.batchUpdateById(reqBO.getKillSkuList(), uccSkuPo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5355\u54c1\u5931\u6548\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSuccessIdList())) {
            try {
                xextSkuChangePo = new XextSkuChangePo();
                xextSkuChangePo.setExtSkuState(1);
                xextSkuChangePo.setExtSkuHandleState(1);
                this.xextSkuChangeMapper.batchUpdateById(xextSkuChangePo, reqBO.getSuccessIdList());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u63a8\u9001\u6d88\u606f\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getFailIdList())) {
            try {
                xextSkuChangePo = new XextSkuChangePo();
                xextSkuChangePo.setExtSkuState(1);
                xextSkuChangePo.setExtSkuHandleState(0);
                this.xextSkuChangeMapper.batchUpdateById(xextSkuChangePo, reqBO.getFailIdList());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u63a8\u9001\u6d88\u606f\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
        }
        return rspBO;
    }
}

