/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccGoodsInfoCheckAtomService;
import com.tydic.commodity.atom.bo.UccGoodsInfoCheckAtomReqBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccGoodsUpdateAndPublishAbilityRspBO;
import com.tydic.uccext.bo.UccGoodsUpdateAndPublishReqBO;
import com.tydic.uccext.bo.UccGoodsUpdateBusiReqBO;
import com.tydic.uccext.bo.UccGoodsUpdateBusiRspBO;
import com.tydic.uccext.bo.UccPreProcessAuditReqBO;
import com.tydic.uccext.bo.UccPreProcessAuditRspBO;
import com.tydic.uccext.service.UccGoodsUpdateBusiService;
import com.tydic.uccext.service.UccPreProcessAuditBusiService;
import com.tydic.uccext.service.UccRecordEditDetailsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccGoodsUpdateBusiService.class)
public class UccGoodsUpdateBusiServiceImpl
implements UccGoodsUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccGoodsUpdateBusiServiceImpl.class);
    @Reference(interfaceClass=UccPreProcessAuditBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccPreProcessAuditBusiService preProcessAuditBusiService;
    @Autowired
    private UccGoodsInfoCheckAtomService goodsInfoCheckAtomService;
    @Reference(interfaceClass=UccRecordEditDetailsService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccRecordEditDetailsService recordEditDetailsService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Value(value="${ZONE_GOODS_UPDATE_APPROVAL_DEF_ID}")
    private String processDefId;
    @Reference(interfaceClass=BatchUpdateCommoStatusForMarketService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService statusForMarketService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ProperticeVo properticeVo;

    public UccGoodsUpdateBusiRspBO dealUccGoodsUpdate(UccGoodsUpdateBusiReqBO reqBO) {
        UccPreProcessAuditRspBO preProcessAuditRspBO;
        UccGoodsUpdateBusiRspBO rspBO = new UccGoodsUpdateBusiRspBO();
        ArrayList<Long> skuIds = new ArrayList<Long>(reqBO.getGoodsAgreementAndCommodityBOS().size());
        for (UccGoodsAgreementAndCommodityBO goodsAgreementAndCommodityBO : reqBO.getGoodsAgreementAndCommodityBOS()) {
            UccGoodsInfoCheckAtomReqBO goodsInfoCheckAtomReqBO = new UccGoodsInfoCheckAtomReqBO();
            goodsInfoCheckAtomReqBO.setSkuId(goodsAgreementAndCommodityBO.getSkuId());
            goodsInfoCheckAtomReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            this.goodsInfoCheckAtomService.dealUccGoodsInfoCheck(goodsInfoCheckAtomReqBO);
            skuIds.add(goodsAgreementAndCommodityBO.getSkuId());
        }
        UccPreProcessAuditReqBO preProcessAuditReqBO = new UccPreProcessAuditReqBO();
        preProcessAuditReqBO.setSyncAdtFlag(Integer.valueOf(0));
        preProcessAuditReqBO.setSkuIds(skuIds);
        preProcessAuditReqBO.setSupplierShopId(reqBO.getSupplierShopId());
        preProcessAuditReqBO.setObjType(Integer.valueOf(ApprovalTypeEnum.APPROVAL_EDIT.getStep()));
        HashMap<Integer, SkuStatusEnum> map = new HashMap<Integer, SkuStatusEnum>();
        map.put(SkuStatusEnum.ON_SHELVES_STATUS.getStatus(), SkuStatusEnum.ON_SHELVES_STATUS);
        map.put(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), SkuStatusEnum.DOWN_FRAME_STATUS);
        preProcessAuditReqBO.setCurrentStatus(map);
        preProcessAuditReqBO.setStatus(SkuStatusEnum.PENDING_APPROVAL_STATUS);
        preProcessAuditReqBO.setSupplierId(reqBO.getSupplierId());
        UccPreProcessAuditRspBO uccPreProcessAuditRspBO = this.preProcessAuditBusiService.dealCheckParameters(preProcessAuditReqBO);
        if (uccPreProcessAuditRspBO.getRespCode().equals("8888")) {
            throw new BusinessException("8888", uccPreProcessAuditRspBO.getRespDesc());
        }
        UccGoodsUpdateAndPublishAbilityRspBO uccGoodsUpdateAndPublishAbilityRspBO = this.recordEditDetailsService.saveEditRecord((UccGoodsUpdateAndPublishReqBO)reqBO);
        if (uccGoodsUpdateAndPublishAbilityRspBO.getRespCode().equals("8888")) {
            throw new BusinessException("8888", uccGoodsUpdateAndPublishAbilityRspBO.getRespDesc());
        }
        preProcessAuditReqBO.setProcessDefId(this.processDefId);
        preProcessAuditReqBO.setSupplierId(reqBO.getSupplierId());
        if ("0000".equals(uccPreProcessAuditRspBO.getRespCode())) {
            preProcessAuditReqBO.setSkuAndCommodity(uccPreProcessAuditRspBO.getAgreementAndCommodityBOS());
        }
        if ("8888".equals((preProcessAuditRspBO = this.preProcessAuditBusiService.dealPreProcessAudit(preProcessAuditReqBO)).getRespCode())) {
            throw new BusinessException("8888", preProcessAuditRspBO.getRespDesc());
        }
        UccCommodityPo commodityPo = null;
        for (UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO : uccPreProcessAuditRspBO.getAgreementAndCommodityBOS()) {
            commodityPo = this.uccCommodityMapper.getCommodityById(uccGoodsAgreementAndCommodityBO.getCommodityId());
            CommodityBo commodityBo = new CommodityBo();
            BeanUtils.copyProperties((Object)commodityPo, (Object)commodityBo);
            commodityBo.setCommodityStatus(null);
            commodityBo.setApprovalStatus(preProcessAuditRspBO.getStepId());
            this.statusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Pass);
        }
        UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
        try {
            notifyMessageBO.setStationCode(preProcessAuditRspBO.getNextStationCode());
            notifyMessageBO.setAgreementId(commodityPo.getAgreementId());
            notifyMessageBO.setAgreementSkuIds((List)Lists.newArrayList((Object[])new String[]{((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getAgreementDetailsId()}));
            notifyMessageBO.setAgreementSkuStatus("3");
            notifyMessageBO.setAuditStatus("2");
            notifyMessageBO.setMemIdIn(reqBO.getUserId());
            notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_EDIT.code());
            this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
        }
        catch (Exception var16) {
            LOGGER.error("\u7f16\u8f91\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
            throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

