/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.dao.XextSkuChangeMapper;
import com.tydic.commodity.dao.po.XextSkuChangePo;
import com.tydic.commodity.external.util.SignUtil;
import com.tydic.uccext.bo.LinkmallItemList;
import com.tydic.uccext.bo.LinknallAddSkuList;
import com.tydic.uccext.bo.UccLinkmallPushItemRspBo;
import com.tydic.uccext.bo.UccLinkmallPushModifyItemReqBo;
import com.tydic.uccext.service.UccLinkmallPushModifyItemBusiService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccLinkmallPushModifyItemBusiService.class)
public class UccLinkmallPushModifyItemBusiServiceImpl
implements UccLinkmallPushModifyItemBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccLinkmallPushModifyItemBusiServiceImpl.class);
    @Value(value="linkmall_appSecret")
    private String appSecret;
    @Autowired
    private XextSkuChangeMapper xextSkuChangeMapper;
    @Autowired
    private OrderSequence uccExtSkuSequence;

    public UccLinkmallPushItemRspBo pushItem(UccLinkmallPushModifyItemReqBo reqBo) {
        UccLinkmallPushItemRspBo rspBo = new UccLinkmallPushItemRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getAppKey())) {
            rspBo.setCode("fail");
            rspBo.setMessage("\u8bf7\u4f20\u5165 appKey");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getItemList())) {
            rspBo.setCode("fail");
            rspBo.setMessage("\u8bf7\u4f20\u5165 itemList");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getSign())) {
            rspBo.setCode("fail");
            rspBo.setMessage("\u8bf7\u4f20\u5165 sign");
            return rspBo;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", reqBo.getAppKey());
        map.put("itemList", reqBo.getItemList());
        String sign = null;
        try {
            sign = SignUtil.getSignMp(map, this.appSecret);
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace();
        }
        if (!reqBo.getAppKey().equals(sign)) {
            rspBo.setCode("1000");
            rspBo.setMessage("\u7b7e\u540d\u9519\u8bef");
            return rspBo;
        }
        List array = JSONArray.parseArray((String)reqBo.getItemList(), LinkmallItemList.class);
        for (LinkmallItemList each : array) {
            XextSkuChangePo po = new XextSkuChangePo();
            po.setExtSkuId(each.getItemId());
            po.setMsgGetType(2);
            po.setExtSkuState(0);
            List<XextSkuChangePo> xextSkuChangePos = this.xextSkuChangeMapper.querMsg(po);
            if (xextSkuChangePos.size() > 0) continue;
            try {
                po.setId(this.uccExtSkuSequence.nextId());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            po.setMsgGetId(String.valueOf(po.getId()));
            po.setExtSkuId(each.getItemId());
            po.setMsgGetType(2);
            po.setExtSkuState(0);
            po.setSupplierId(10025L);
            po.setSupplierShopId(10025L);
            po.setMsgGetTime(new Date());
            po.setCreateTime(new Date());
            if (each.getSkuList() != null && each.getSkuList().size() > 0) {
                ArrayList<String> skuLIst = new ArrayList<String>();
                for (LinknallAddSkuList sku : each.getSkuList()) {
                    skuLIst.add(sku.getSkuId());
                }
                po.setRemark(((Object)skuLIst).toString());
            }
            try {
                this.xextSkuChangeMapper.insertMsg(po);
            }
            catch (Exception e) {
                LOGGER.error("\u5546\u54c1\u4fee\u6539\u63a8\u9001\u63a8\u9001\uff1a" + e.getMessage());
            }
        }
        rspBo.setCode("success");
        return rspBo;
    }
}

