/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.annotation.RegisterMerchantUpdateAnnotation;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.RegisterMerchantStepEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccCovertShopCommodityReqBO;
import com.tydic.uccext.bo.UccCovertShopCommodityRspBO;
import com.tydic.uccext.bo.UccMallBannerConfigureRspBO;
import com.tydic.uccext.bo.UccMallCatalogConfigureRspBO;
import com.tydic.uccext.bo.UccMallConfigureReqBO;
import com.tydic.uccext.bo.UccMallConfigureRspBO;
import com.tydic.uccext.bo.UccMallIndexConfigureRspBO;
import com.tydic.uccext.service.UccMallBannerConfigureBusiService;
import com.tydic.uccext.service.UccMallCatalogConfigureBusiService;
import com.tydic.uccext.service.UccMallConfigureBusiService;
import com.tydic.uccext.service.UccMallIndexConfigureBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccMallConfigureBusiService.class)
public class UccMallConfigureBusiServiceImpl
implements UccMallConfigureBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallConfigureBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Reference(interfaceClass=UccMallBannerConfigureBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccMallBannerConfigureBusiService uccMallBannerConfigureBusiService;
    @Reference(interfaceClass=UccMallCatalogConfigureBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccMallCatalogConfigureBusiService uccMallCatalogConfigureBusiService;
    @Reference(interfaceClass=UccMallIndexConfigureBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccMallIndexConfigureBusiService uccMallIndexConfigureBusiService;

    @RegisterMerchantUpdateAnnotation(step=RegisterMerchantStepEnum.MALL_CONFIG)
    public UccMallConfigureRspBO createMallConfig(UccMallConfigureReqBO reqBO) {
        UccMallConfigureRspBO uccMallConfigureRspBO = new UccMallConfigureRspBO();
        try {
            UccMallBannerConfigureRspBO mallBannerConfigureRspBO = this.uccMallBannerConfigureBusiService.createMallBannerConfig(reqBO);
            if (Objects.equals(mallBannerConfigureRspBO.getRespCode(), "8888")) {
                throw new BusinessException("8888", mallBannerConfigureRspBO.getRespDesc());
            }
            UccMallCatalogConfigureRspBO mallCatalogConfigureRspBO = this.uccMallCatalogConfigureBusiService.createMallCatalogConfigure(reqBO);
            if (Objects.equals(mallCatalogConfigureRspBO.getRespCode(), "8888")) {
                throw new BusinessException("8888", mallCatalogConfigureRspBO.getRespDesc());
            }
            UccMallIndexConfigureRspBO mallIndexConfigureRspBO = this.uccMallIndexConfigureBusiService.createMallIndexConfigure(reqBO);
            if (Objects.equals(mallIndexConfigureRspBO.getRespCode(), "8888")) {
                throw new BusinessException("8888", mallIndexConfigureRspBO.getRespDesc());
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMsgCode(), e.getMsgInfo());
        }
        uccMallConfigureRspBO.setRespCode("0000");
        uccMallConfigureRspBO.setRespDesc("\u6210\u529f");
        return uccMallConfigureRspBO;
    }

    public UccCovertShopCommodityRspBO convertShopCommodity(UccCovertShopCommodityReqBO reqBO) {
        UccCovertShopCommodityRspBO rspBO;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityIds())) {
            rspBO = this.doConvert(reqBO.getCommodityIds(), reqBO.getSupplierId(), reqBO.getOrgId());
        } else {
            ArrayList comoditys = Lists.newArrayList();
            comoditys.add(reqBO.getCommodityId());
            rspBO = this.doConvert(comoditys, reqBO.getSupplierId(), reqBO.getOrgId());
        }
        return rspBO;
    }

    private UccCovertShopCommodityRspBO doConvert(List<Long> commodityIds, Long supplierId, Long ordId) {
        List<UccCommodityPo> uccCommodityPos;
        UccCovertShopCommodityRspBO uccCovertShopCommodityRspBO = new UccCovertShopCommodityRspBO();
        Long supplierShopId = null;
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(supplierId);
        if (CollectionUtils.isNotEmpty(supplierShopPos)) {
            supplierShopId = supplierShopPos.get(0).getSupplierShopId();
        }
        if (CollectionUtils.isNotEmpty(uccCommodityPos = this.uccCommodityMapper.batchQryCommd(commodityIds, supplierShopId))) {
            ArrayList commoditysIds = Lists.newArrayList();
            ArrayList extSkuIds = Lists.newArrayList();
            for (UccCommodityPo uccCommodityPo : uccCommodityPos) {
                extSkuIds.add(uccCommodityPo.getExtSkuId());
            }
            Long supplierShopId2 = null;
            List<SupplierShopPo> supplierShopPos2 = this.supplierShopMapper.selectSupplierShopBySupplierId(ordId);
            if (CollectionUtils.isNotEmpty(supplierShopPos)) {
                supplierShopId2 = supplierShopPos2.get(0).getSupplierShopId();
            }
            long count = 0L;
            List<UccCommodityPo> commodityPos = this.uccCommodityMapper.batchQryCommdByExtSkuId(extSkuIds, supplierShopId2);
            if (CollectionUtils.isNotEmpty(commodityPos)) {
                for (UccCommodityPo commodityPo : commodityPos) {
                    commoditysIds.add(commodityPo.getCommodityId());
                    if (++count != (long)extSkuIds.size()) continue;
                    break;
                }
            }
            uccCovertShopCommodityRspBO.setCommodityIds((List)commoditysIds);
        }
        return uccCovertShopCommodityRspBO;
    }
}

