/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private boolean hasInit = false;
    private int socketTimeout = 60000;
    private int connectTimeout = 30000;
    private RequestConfig requestConfig;
    private CloseableHttpClient closeableHttpClient;
    private static HttpClient httpClient = HttpClientBuilder.create().build();
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public HttpUtil() {
        this.init();
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        this.closeableHttpClient = HttpClients.createDefault();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
        this.hasInit = true;
    }

    public static String sendPost(String url, Map<String, String> params) throws IOException {
        return HttpUtil.sendPost(url, params, 0, 0);
    }

    public static String sendPost(String url, Map<String, String> params, int socketTimeout, int connectTimeout) throws IOException {
        HttpUtil httpUtil = new HttpUtil();
        if (socketTimeout > 0) {
            httpUtil.setSocketTimeout(socketTimeout);
        }
        if (connectTimeout > 0) {
            httpUtil.setConnectTimeout(connectTimeout);
        }
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (String key : params.keySet()) {
            list.add(new BasicNameValuePair(key, params.get(key)));
        }
        UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(list, "UTF-8");
        httpPost.setEntity((HttpEntity)uefEntity);
        httpPost.setConfig(httpUtil.getRequestConfig());
        CloseableHttpResponse response = httpUtil.getHttpClient().execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        httpPost.abort();
        return result;
    }

    public static String sendRequest(String reqData, String uri, String method, String charSet) throws Exception {
        URL httpUrl = new URL(uri);
        HttpURLConnection httpURLConnection = (HttpURLConnection)httpUrl.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod(method);
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setReadTimeout(10000);
        httpURLConnection.connect();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(reqData.getBytes(charSet));
        InputStream inputStream = httpURLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charSet));
        StringBuffer stringBuffer = new StringBuffer();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            stringBuffer.append(line);
        }
        String resp = stringBuffer.toString();
        if (stringBuffer != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException var18) {
                log.error("bufferedReader close is error" + var18.getMessage());
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException var17) {
                log.error("inputStream close is error" + var17.getMessage());
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException var16) {
                log.error("outputStream close is error" + var16.getMessage());
            }
        }
        return resp;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        this.resetRequestConfig();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.resetRequestConfig();
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    private void resetRequestConfig() {
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
    }

    public CloseableHttpClient getHttpClient() {
        return this.closeableHttpClient;
    }

    static {
        if (httpClient == null) {
            httpClient = HttpClientBuilder.create().build();
        }
    }
}

