/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.service.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.security.service.AutzQueryService;
import com.tydic.umc.security.utils.UtilString;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutzQueryServiceImpl
implements AutzQueryService {
    private static final Logger log = LoggerFactory.getLogger(AutzQueryServiceImpl.class);
    @Autowired
    private CacheClient cacheService;

    @Override
    public String getCurrentIPCode(String host) {
        String verificationCode = null;
        verificationCode = (String)this.cacheService.get("verificationCode" + host);
        return verificationCode;
    }

    @Override
    public Integer getCurrentIdCaptcha(String host) {
        String verificationCode = null;
        verificationCode = (String)this.cacheService.get("verificationCode" + host);
        if (UtilString.isNotEmpty((CharSequence)verificationCode)) {
            log.debug("key={},\u6ed1\u5757\u4f4d\u7f6e\u7f13\u5b58\u503c{}", (Object)host, (Object)verificationCode);
            return Integer.parseInt(verificationCode);
        }
        return 0;
    }

    @Override
    public String putCurrentIpCode(String host) {
        String veriCode = "";
        if (UtilString.isNotEmpty((CharSequence)host)) {
            String code;
            veriCode = code = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 6);
        }
        return veriCode;
    }

    @Override
    public String getCaptchaImageBase64Str(String imageName) {
        String base64Str = null;
        base64Str = (String)this.cacheService.get("captchaImage" + imageName);
        return base64Str;
    }

    @Override
    public void removeCurrentIPCode(String host) {
        this.cacheService.delete("verificationCode" + host);
    }
}

