/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.signature.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.security.signature.filter.SignatureFilter;
import com.tydic.umc.security.signature.properties.SignatureProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnProperty(prefix="signature.plugin", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={SignatureProperties.class})
public class SignatureConfigurableConfig {
    private static final Logger log = LoggerFactory.getLogger(SignatureConfigurableConfig.class);
    private final SignatureProperties signatureProperties;
    private final CacheClient cacheService;
    private final ApplicationContext applicationContext;

    public SignatureConfigurableConfig(SignatureProperties signatureProperties, CacheClient cacheService, ApplicationContext applicationContext) {
        this.signatureProperties = signatureProperties;
        this.cacheService = cacheService;
        this.applicationContext = applicationContext;
    }

    @Bean(value={"buildSignatureFilter"})
    public FilterRegistrationBean<SignatureFilter> buildSignatureCheckFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        SignatureFilter signatureFilter = new SignatureFilter(this.signatureProperties, this.cacheService);
        registration.setOrder(Integer.MIN_VALUE);
        registration.setFilter((Filter)signatureFilter);
        registration.setName("signatureFilter");
        List<String> controllerList = this.getRequestMappingHandlerMapping(this.signatureProperties.getNotIntercept(), this.signatureProperties.getMustIntercept());
        log.info("\u8981\u62e6\u622a\u7684\u63a5\u53e3:" + controllerList);
        if (!CollectionUtils.isEmpty(controllerList)) {
            registration.setUrlPatterns(controllerList);
        }
        log.info("\u7b7e\u540d\u63d2\u4ef6\u521d\u59cb\u5316\u5b8c\u6210");
        return registration;
    }

    private List<String> getRequestMappingHandlerMapping(String notIntercept, String mustIntercept) {
        ArrayList exclusionControllers = new ArrayList();
        ArrayList mustInterceptControllers = new ArrayList();
        if (StringUtils.hasText((String)notIntercept)) {
            exclusionControllers.addAll(Arrays.stream(notIntercept.split("[,\uff0c]")).map(String::trim).distinct().collect(Collectors.toList()));
        }
        if (StringUtils.hasText((String)mustIntercept)) {
            mustInterceptControllers.addAll(Arrays.stream(mustIntercept.split("[,\uff0c]")).map(String::trim).distinct().collect(Collectors.toList()));
        }
        log.error("\u8fc7\u6ee4\u4e0d\u62e6\u622a\u7684controller:" + exclusionControllers);
        log.error("\u5fc5\u987b\u62e6\u622a\u7684controller:" + mustInterceptControllers);
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map handlerMethods = mapping.getHandlerMethods();
        ArrayList<String> requestMappingUrls = new ArrayList<String>();
        for (RequestMappingInfo requestMappingInfo : handlerMethods.keySet()) {
            for (String url : requestMappingInfo.getPatternsCondition().getPatterns()) {
                if (!CollectionUtils.isEmpty(mustInterceptControllers)) {
                    if (!mustInterceptControllers.stream().anyMatch(url::contains)) continue;
                    requestMappingUrls.add(url);
                    continue;
                }
                if (CollectionUtils.isEmpty(exclusionControllers)) {
                    requestMappingUrls.add(url);
                    continue;
                }
                if (!exclusionControllers.stream().noneMatch(url::contains)) continue;
                requestMappingUrls.add(url);
            }
        }
        log.error("\u6700\u7ec8\u8981\u62e6\u622a\u7684controller:" + requestMappingUrls);
        return requestMappingUrls;
    }
}

