/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.log;

import com.alibaba.fastjson.JSON;
import com.tydic.umc.security.log.WafRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpKit {
    private static final Logger log = LoggerFactory.getLogger(HttpKit.class);

    public static String getIp() {
        return HttpKit.getRequest().getRemoteHost();
    }

    public static Map<String, String> getRequestParameters() {
        HashMap<String, String> values = new HashMap<String, String>();
        HttpServletRequest request = HttpKit.getRequest();
        Enumeration enums = request.getParameterNames();
        while (enums.hasMoreElements()) {
            String paramName = (String)enums.nextElement();
            String paramValue = request.getParameter(paramName);
            values.put(paramName, paramValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("HttpKit.getRequestParameters.HttpServletRequest.getParameter\uff1a{}", (Object)JSON.toJSONString(values));
        }
        return values;
    }

    public static String getRequestApplicationJson() {
        HashMap values = new HashMap();
        HttpServletRequest request = HttpKit.getRequest();
        if (request.getContentType() != null && request.getContentType().contains("application/json")) {
            StringBuilder stringBuilder;
            block29: {
                stringBuilder = new StringBuilder();
                try (ServletInputStream inputStream = request.getInputStream();){
                    if (inputStream == null) break block29;
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                        int bytesRead;
                        char[] charBuffer = new char[1024];
                        while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                            stringBuilder.append(charBuffer, 0, bytesRead);
                        }
                    }
                }
                catch (IOException e) {
                    log.error("\u83b7\u53d6\u5165\u53c2\u8f93\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("HttpKit.getRequestApplicationJson.HttpServletRequest.getInputStream\uff1a{}", (Object)stringBuilder.toString());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        return response;
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return new WafRequestWrapper(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String url, Map<String, String> param) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            StringBuffer query = new StringBuffer();
            for (Map.Entry<String, String> kv : param.entrySet()) {
                query.append(URLEncoder.encode(kv.getKey(), "UTF-8") + "=");
                query.append(URLEncoder.encode(kv.getValue(), "UTF-8") + "&");
            }
            if (query.lastIndexOf("&") > 0) {
                query.deleteCharAt(query.length() - 1);
            }
            String urlNameString = url + "?" + query.toString();
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            Map<String, List<String>> map = connection.getHeaderFields();
            for (String key : map.keySet()) {
                System.out.println(key + "--->" + map.get(key));
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception var19) {
            System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + var19);
            var19.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception var18) {
                var18.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, Map<String, String> param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            String para = "";
            for (String key : param.keySet()) {
                para = para + key + "=" + param.get(key) + "&";
            }
            if (para.lastIndexOf("&") > 0) {
                para = para.substring(0, para.length() - 1);
            }
            String urlNameString = url + "?" + para;
            URL realUrl = new URL(urlNameString);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception var18) {
            System.out.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + var18);
            var18.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException var17) {
                var17.printStackTrace();
            }
        }
        return result;
    }
}

