/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.menu.bo.AccessMenu;
import com.ohaotian.authority.menu.bo.SelectAccessMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAccessMenuRspBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuRspBO;
import com.ohaotian.authority.menu.service.SelectAccessMenuService;
import com.ohaotian.authority.menu.service.SelectAuthoritysMenuService;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysReqBO;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysRspBO;
import com.ohaotian.authority.role.service.SelectRoleAuthoritysService;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.ListUtils;
import com.tydic.umc.ability.DictionaryAbilityService;
import com.tydic.umc.ability.UmcApplicationPropertyAbilityService;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcQryOrgByUserStationAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQryOrgByUserStationAbilityRspBO;
import com.tydic.umc.ability.bo.UmcQrySingleValuePropertyAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQrySingleValuePropertyAbilityRspBO;
import com.tydic.umc.ability.org.UmcQryOrgByUserStationAbilityService;
import com.tydic.umc.common.UmcSubMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcUserCheckAccessTokenReqBo;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.base.UmcUserInfoByUserIdReqBo;
import com.tydic.umc.security.entity.AuthorityInfo;
import com.tydic.umc.security.entity.MenuInfo;
import com.tydic.umc.security.service.GetUserInfoByUserIdService;
import com.tydic.umc.security.utils.RegexUtils;
import com.tydic.umcext.ability.member.UmcQryMemIdByUserIdAbilityService;
import com.tydic.umcext.ability.member.bo.UmcQryMemInfoByUserIdAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcQryMemInfoByUserIdAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetUserInfoByUserIdServiceImpl
implements GetUserInfoByUserIdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetUserInfoByUserIdServiceImpl.class);
    @Autowired
    private SelectUserInfoService selectUserInfoService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Autowired
    private SelectRoleAuthoritysService selectRoleAuthoritysService;
    @Autowired
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Autowired
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Autowired
    private UmcQryMemIdByUserIdAbilityService umcQryMemIdByUserIdAbilityService;
    @Autowired
    private UmcQryOrgByUserStationAbilityService umcQryOrgByUserStationAbilityService;
    @Autowired
    private SelectAuthoritysMenuService selectAuthoritysMenuService;
    @Autowired
    private SelectAccessMenuService selectAccessMenuService;
    @Autowired
    private CacheClient cacheTemplate;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${loginDeniedEnable:false}")
    private boolean loginDeniedEnable;
    @Value(value="${loginDeniedAllowedUserAccount:}")
    private String loginDeniedAllowedUserAccount;
    @Value(value="${loginDeniedHintMsg:\u7cfb\u7edf\u7ef4\u62a4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u767b\u5f55}")
    private String loginDeniedHintMsg;
    @Autowired
    private DictionaryAbilityService dictionaryAbilityService;
    @Autowired
    private UmcApplicationPropertyAbilityService umcApplicationPropertyAbilityService;
    @Value(value="${auth_address2:https://112.64.180.205:4433/esc-sso}")
    private String oauth_Address2;
    @Value(value="${umc.ua.auth.check.access.token.flag:0}")
    private String authCheckAccessTokenFlag;
    @Value(value="${umc.ua.auth.check.access.token.connection.timeout:5}")
    private int authCheckAccessTokenConnectionTimeout;
    @Value(value="${umc.ua.auth.check.access.token.read.timeout:5}")
    private int authCheckAccessTokenReadTimeout;
    @Value(value="${loginDeniedShowLoginErrorFlag:0}")
    private String showLoginError;
    private final String YES = "1";
    @Value(value="${umc.ua.used.ssl:0}")
    private String usedSSL;

    @Override
    public UmcUserDetails getUserInfoByUserId(Long userId, String token, String appCode, String uri) {
        List mcs;
        String o;
        UmcMemInfoBO uInfo;
        UmcUserDetails umcUserDetails = new UmcUserDetails();
        umcUserDetails.setRespCode("0000");
        umcUserDetails.setRespDesc("\u6210\u529f");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bf7\u6c42uri==>{}", (Object)uri);
        }
        if ((uInfo = (UmcMemInfoBO)JSONObject.parseObject((String)(o = (String)this.cacheTemplate.get(token)), UmcMemInfoBO.class)) != null && uInfo.getUserId() != null && uInfo.getMemIdExt() != null) {
            List mcs2;
            if (this.loginDeniedEnable && StringUtils.isNotBlank((CharSequence)this.loginDeniedAllowedUserAccount) && Arrays.stream(this.loginDeniedAllowedUserAccount.split("[,\uff0c]")).noneMatch(str -> str.equals(uInfo.getUsername()))) {
                umcUserDetails.setRespCode("99999");
                umcUserDetails.setRespDesc(this.loginDeniedHintMsg);
                this.cacheTemplate.delete(token);
                return umcUserDetails;
            }
            umcUserDetails.setUserDetails(uInfo);
            Object obj = this.cacheTemplate.get("DIC_MENU_CODE_REDIS_" + uri);
            if (obj != null && !CollectionUtils.isEmpty((Collection)(mcs2 = (List)obj))) {
                for (String menuCode : mcs2) {
                    if (!uInfo.getMenuCodeList().contains(menuCode)) continue;
                    return umcUserDetails;
                }
                umcUserDetails.setRespDesc("\u65e0\u6743\u9650\u64cd\u4f5c[" + uri + "]");
                umcUserDetails.setRespCode("AE403");
            }
            return umcUserDetails;
        }
        UmcMemInfoBO userInfo = this.loadUserInfo(userId, token);
        if (userInfo == null) {
            umcUserDetails.setRespCode("8888");
            umcUserDetails.setRespDesc("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return umcUserDetails;
        }
        if (this.loginDeniedEnable && StringUtils.isNotBlank((CharSequence)this.loginDeniedAllowedUserAccount) && Arrays.stream(this.loginDeniedAllowedUserAccount.split("[,\uff0c]")).noneMatch(str -> str.equals(userInfo.getUsername()))) {
            umcUserDetails.setRespCode("99999");
            umcUserDetails.setRespDesc(this.loginDeniedHintMsg);
            return umcUserDetails;
        }
        String defaultAppCode = "pes";
        if (StringUtils.isBlank((CharSequence)appCode)) {
            appCode = defaultAppCode;
        }
        try {
            if ("01".equals(userInfo.getMemAffiliation())) {
                this.loadUserMenus(userInfo, appCode);
                this.loadUserAuthoritys(userInfo, appCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cacheTemplate.set(token, (Object)JSONObject.toJSONString((Object)userInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), this.expTime);
        umcUserDetails.setUserDetails(userInfo);
        Object obj = this.cacheTemplate.get("DIC_MENU_CODE_REDIS_" + uri);
        if (obj != null && !CollectionUtils.isEmpty((Collection)(mcs = (List)obj))) {
            for (String menuCode : mcs) {
                if (!userInfo.getMenuCodeList().contains(menuCode)) continue;
                return umcUserDetails;
            }
            umcUserDetails.setRespDesc("\u65e0\u6743\u9650\u64cd\u4f5c[" + uri + "]");
            umcUserDetails.setRespCode("AE403");
        }
        return umcUserDetails;
    }

    @Override
    public UmcUserDetails getUserInfoByUserId(Long userId, String token, String accessToken, String appCode, String uri) {
        UmcUserDetails checkAccessTokenRspBo = this.checkAccessToken(accessToken, userId, token);
        if (!"0000".equals(checkAccessTokenRspBo.getRespCode())) {
            return checkAccessTokenRspBo;
        }
        return this.getUserInfoByUserId(userId, token, appCode, uri);
    }

    @Override
    public UmcUserDetails getUserInfoByUserId(UmcUserInfoByUserIdReqBo reqBo) {
        UmcUserDetails checkAccessTokenRspBo;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u53c2\u6570==>{}", (Object)JSON.toJSONString((Object)reqBo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
        if ("1".equals(this.showLoginError)) {
            LOGGER.error("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u53c2\u6570==>{}", (Object)JSON.toJSONString((Object)reqBo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
        Long userId = reqBo.getUserId();
        String token = reqBo.getToken();
        String appCode = reqBo.getAppCode();
        if (StringUtils.isBlank((CharSequence)appCode)) {
            appCode = "pes";
        }
        if (!"0000".equals((checkAccessTokenRspBo = this.checkAccessToken(reqBo.getAccessToken(), reqBo.getUserId(), reqBo.getToken())).getRespCode())) {
            return checkAccessTokenRspBo;
        }
        UmcUserDetails umcUserDetails = new UmcUserDetails();
        umcUserDetails.setRespCode("0000");
        umcUserDetails.setRespDesc("\u6210\u529f");
        String o = (String)this.cacheTemplate.get(token);
        UmcMemInfoBO uInfo = (UmcMemInfoBO)JSONObject.parseObject((String)o, UmcMemInfoBO.class);
        if (uInfo != null && uInfo.getUserId() != null && uInfo.getMemIdExt() != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bfb\u53d6\u7f13\u5b58==>{}", (Object)o);
            }
            umcUserDetails.setUserDetails(uInfo);
            UmcUserDetails checkIntercept = this.checkIntercept(uInfo.getUsername(), uInfo.getMenuCodeList(), reqBo);
            if (!"0000".equals(checkIntercept.getRespCode())) {
                return checkIntercept;
            }
            return umcUserDetails;
        }
        UmcMemInfoBO userInfo = this.loadUserInfo(userId, token);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5b9e\u65f6\u67e5\u8be2==>{}.user:{}", (Object)userId, (Object)JSON.toJSONString((Object)userInfo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
        if (userInfo == null) {
            umcUserDetails.setRespCode("8888");
            umcUserDetails.setRespDesc("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return umcUserDetails;
        }
        try {
            if ("01".equals(userInfo.getMemAffiliation())) {
                this.loadUserMenus(userInfo, appCode);
                this.loadUserAuthoritys(userInfo, appCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cacheTemplate.set(token, (Object)JSONObject.toJSONString((Object)userInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), this.expTime);
        umcUserDetails.setUserDetails(userInfo);
        UmcUserDetails checkIntercept = this.checkIntercept(userInfo.getUsername(), userInfo.getMenuCodeList(), reqBo);
        if (!"0000".equals(checkIntercept.getRespCode())) {
            return checkIntercept;
        }
        return umcUserDetails;
    }

    @Override
    public UmcUserDetails checkAccessToken(UmcUserCheckAccessTokenReqBo reqBo) {
        String TRACE_ID = UUID.fastUUID().toString().replace("-", "").toUpperCase();
        LOGGER.error(TRACE_ID + "|checkAccessToken|START|req:{}", (Object)JSON.toJSONString((Object)reqBo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        String LOG_PREFIX = StrUtil.format((CharSequence)"{}|checkAccessToken|USERID-{}|SYS-{}|", (Object[])new Object[]{TRACE_ID, reqBo.getUserId(), reqBo.getSysCode()});
        UmcUserDetails umcUserDetails = new UmcUserDetails();
        umcUserDetails.setRespCode("0000");
        umcUserDetails.setRespDesc("\u6210\u529f");
        if (!"1".equals(this.authCheckAccessTokenFlag)) {
            LOGGER.error(LOG_PREFIX + "\u914d\u7f6e\u4e0d\u6821\u9a8c\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1TOKEN");
            umcUserDetails.setRespDesc("\u914d\u7f6e\u4e0d\u6821\u9a8c\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1TOKEN");
            return umcUserDetails;
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getAccessToken())) {
            LOGGER.error(LOG_PREFIX + "\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1TOKEN\u4e3a\u7a7a\u4e0d\u6821\u9a8c\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1TOKEN");
            umcUserDetails.setRespDesc("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1TOKEN\u4e3a\u7a7a\u4e0d\u6821\u9a8c\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1TOKEN");
            return umcUserDetails;
        }
        String accessToken = reqBo.getAccessToken();
        long startTime = System.currentTimeMillis();
        String url = this.oauth_Address2 + "/api/v1/loginLog/checkAccessToken?accesstoken=" + accessToken;
        LOGGER.error(LOG_PREFIX + "URL:{}.\u8fde\u63a5\u8d85\u65f6\uff1a{}.\u54cd\u5e94\u8d85\u65f6:{}", new Object[]{url, this.getConnectionTimeout(), this.getReadTimeout()});
        String result = "";
        try {
            result = ((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("Content-Type", "application/json;charset=utf-8")).header("accesstoken", accessToken)).setConnectionTimeout(this.getConnectionTimeout()).setReadTimeout(this.getReadTimeout()).execute().body();
            String formatBetween = DateUtil.formatBetween((long)(System.currentTimeMillis() - startTime));
            LOGGER.error(LOG_PREFIX + "\u7528\u65f6:{}.\u54cd\u5e94\u62a5\u6587:{}", (Object)formatBetween, (Object)result);
        }
        catch (Exception e) {
            String formatBetween = DateUtil.formatBetween((long)(System.currentTimeMillis() - startTime));
            LOGGER.error(LOG_PREFIX + "\u7528\u65f6:{}.\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u6821\u9a8c\u8eab\u4efd\u6709\u6548\u6027\u5f02\u5e38", (Object)formatBetween);
            umcUserDetails.setRespCode("AE4001FAIL");
            umcUserDetails.setRespDesc("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u6821\u9a8c\u8eab\u4efd\u6709\u6548\u6027\u5f02\u5e38");
            return umcUserDetails;
        }
        if (StrUtil.isBlank((CharSequence)result)) {
            LOGGER.error(LOG_PREFIX + "\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a.\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u6821\u9a8c\u8eab\u4efd\u6709\u6548\u6027\u5f02\u5e38");
            umcUserDetails.setRespCode("AE4001FAIL");
            umcUserDetails.setRespDesc("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u6821\u9a8c\u8eab\u4efd\u6709\u6548\u6027\u5f02\u5e38");
            return umcUserDetails;
        }
        try {
            JSONObject resultJson = JSON.parseObject((String)result);
            String errorCode = resultJson.getString("errorCode");
            String errorMsg = resultJson.getString("errorMsg");
            String data = resultJson.getString("data");
            String successCode = "0";
            if (!successCode.equals(errorCode)) {
                umcUserDetails.setRespCode("AE4001");
                umcUserDetails.setRespDesc("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u767b\u9646\u5931\u6548");
                if (StrUtil.isNotBlank((CharSequence)errorMsg)) {
                    umcUserDetails.setRespDesc("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u767b\u9646\u5931\u6548:" + errorMsg);
                }
                return umcUserDetails;
            }
            return umcUserDetails;
        }
        catch (Exception e) {
            LOGGER.error(LOG_PREFIX + "\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u6821\u9a8c\u8eab\u4efd\u6709\u6548\u6027\u5f02\u5e38-\u51fa\u53c2\u6821\u9a8c\u5f02\u5e38.error:{}", (Object)e.getMessage());
            umcUserDetails.setRespCode("AE4001FAIL");
            umcUserDetails.setRespDesc("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u6821\u9a8c\u8eab\u4efd\u6709\u6548\u6027\u5f02\u5e38");
            return umcUserDetails;
        }
    }

    private UmcUserDetails checkIntercept(String userName, List<String> menuCodeList, UmcUserInfoByUserIdReqBo reqBo) {
        String systemMenuUri;
        UmcUserDetails umcUserDetails = new UmcUserDetails();
        umcUserDetails.setRespCode("0000");
        umcUserDetails.setRespDesc("\u6210\u529f");
        if (this.checkLoginIntercept(userName)) {
            umcUserDetails.setRespCode("99999");
            umcUserDetails.setRespDesc(this.loginDeniedHintMsg);
            this.cacheTemplate.delete(reqBo.getToken());
            return umcUserDetails;
        }
        if (this.checkMenuIntercept(menuCodeList, reqBo.getUri())) {
            umcUserDetails.setRespDesc("\u65e0\u6743\u9650\u64cd\u4f5c[" + reqBo.getUri() + "]");
            umcUserDetails.setRespCode("AE403");
            return umcUserDetails;
        }
        if (!RegexUtils.wildcardEquals("**/**/noauth/**", reqBo.getUri()) && "pc".equals(reqBo.getSystemSource()) && (StringUtils.isBlank((CharSequence)(systemMenuUri = reqBo.getSystemMenuUri())) || !"*".equals(systemMenuUri) && !menuCodeList.contains(systemMenuUri))) {
            umcUserDetails.setRespDesc("\u5f88\u62b1\u6b49\uff0c\u60a8\u65e0\u6743\u9650\u8bbf\u95ee\u8df3\u8f6c\u9875\u9762\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u83dc\u5355\u6743\u9650\uff0c\u5e76\u91cd\u65b0\u767b\u9646");
            umcUserDetails.setRespCode("AE4003");
            return umcUserDetails;
        }
        return umcUserDetails;
    }

    private boolean checkMenuIntercept(List<String> menuCodeList, String uri) {
        List mcs;
        Object obj = this.cacheTemplate.get("DIC_MENU_CODE_REDIS_" + uri);
        if (obj != null && !CollectionUtils.isEmpty((Collection)(mcs = (List)obj))) {
            for (String menuCode : mcs) {
                if (!menuCodeList.contains(menuCode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkLoginIntercept(String userName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7528\u6237\u540d\uff1a{}.loginDeniedEnable:{}.loginDeniedAllowedUserAccount:{}", new Object[]{userName, this.loginDeniedEnable, this.loginDeniedAllowedUserAccount});
        }
        if (StringUtils.isBlank((CharSequence)userName) || !this.loginDeniedEnable || StringUtils.isBlank((CharSequence)this.loginDeniedAllowedUserAccount)) {
            return false;
        }
        return Arrays.stream(this.loginDeniedAllowedUserAccount.split("[,\uff0c]")).noneMatch(userName::equals);
    }

    private UmcMemInfoBO loadUserInfo(Long userId, String token) {
        UmcMemInfoBO userInfo = null;
        SelectUserInfoReqBO userInfoReqBO = new SelectUserInfoReqBO();
        userInfoReqBO.setUserId(userId);
        UmcQryMemInfoByUserIdAbilityReqBO abilityReqBO = new UmcQryMemInfoByUserIdAbilityReqBO();
        abilityReqBO.setUserIdWeb(userId);
        UmcQryMemInfoByUserIdAbilityRspBO rspUser = this.umcQryMemIdByUserIdAbilityService.qryMemInfoByUserId(abilityReqBO);
        if (rspUser != null && "0000".equals(rspUser.getRespCode())) {
            userInfo = new UmcMemInfoBO();
            BeanUtils.copyProperties((Object)rspUser, (Object)userInfo);
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setMisconducts(rspUser.getMisconducts());
            userInfo.setName(rspUser.getMemName2());
            userInfo.setCompanyIdExt(userInfo.getCompanyId());
            userInfo.setMgOrgIdsExt(rspUser.getMgOrgIds());
            userInfo.setMemIdIn(rspUser.getMemId());
            userInfo.setOrgIdIn(userInfo.getOrgId());
            userInfo.setUserIdIn(userInfo.getUserId());
            userInfo.setMemAffiliationExt(userInfo.getMemAffiliation());
            userInfo.setMemIdExt(rspUser.getMemId());
            userInfo.setSupSaleOrgList(rspUser.getSupSaleOrgList());
            userInfo.setIsprofess(rspUser.getIsprofess());
            userInfo.setSex(rspUser.getSex());
            userInfo.setRegEmail(rspUser.getRegEmail());
            userInfo.setPsDiscountRate(rspUser.getPsDiscountRate());
            userInfo.setOrgLevelIn(rspUser.getOrgLevel());
            userInfo.setUmcStationsListWebExt(rspUser.getUmcStationsListWeb());
            userInfo.setUsername(rspUser.getRegAccount());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setOrgCodeIn(rspUser.getOrgCode());
            userInfo.setCellphone(rspUser.getRegMobile());
            userInfo.setOrgTypeIn(rspUser.getOrgType());
            userInfo.setOrgPath(rspUser.getOrgTreePath());
            userInfo.setOrgName(rspUser.getOrgName());
            userInfo.setOldMemIdIn(rspUser.getOldMemIdIn());
            userInfo.setMemUserType(rspUser.getUserType());
            userInfo.setMainMemIdIn(rspUser.getMainMemId());
            userInfo.setIsActUser(rspUser.getIsActUser());
            userInfo.setEsbMemCodeIn(rspUser.getEsbMemCode());
            userInfo.setCnerpMemCodeIn(rspUser.getCnerpMemCode());
            userInfo.setEsbOrgCodeIn(rspUser.getEsbOrgCode());
            userInfo.setCompanyEsbOrgCodeIn(rspUser.getCompanyEsbOrgCode());
            userInfo.setSecondaryCompanyIdIn(rspUser.getSecondaryCompanyId());
            userInfo.setSecondaryCompanyNameIn(rspUser.getSecondaryCompanyName());
            userInfo.setSecondaryCompanyOrgTreePathIn(rspUser.getSecondaryCompanyOrgTreePath());
            userInfo.setSecondaryCompanyEsbOrgCodeIn(rspUser.getSecondaryCompanyEsbOrgCode());
            Long adminId = 1L;
            if (adminId.equals(rspUser.getMemId())) {
                ArrayList<Long> mgOrgIds = new ArrayList<Long>();
                mgOrgIds.add(1L);
                userInfo.setMgOrgIdsExt(mgOrgIds);
            }
            ArrayList<String> outerUserTypes = new ArrayList<String>();
            if ("2".equals(rspUser.getIsProfessionalOrgExt())) {
                if (null != rspUser.getIsBranchUnit() && 1 == rspUser.getIsBranchUnit()) {
                    outerUserTypes.add("6");
                } else {
                    outerUserTypes.add("5");
                }
            } else {
                outerUserTypes.add(rspUser.getUserType());
            }
            if (!CollectionUtils.isEmpty((Collection)rspUser.getUmcSubMemInfos())) {
                for (UmcSubMemInfoBO umcSubMemInfoBO : rspUser.getUmcSubMemInfos()) {
                    if (!umcSubMemInfoBO.getUserType().equals("1")) continue;
                    outerUserTypes.add("11");
                    break;
                }
            }
            String loginSource = (String)this.cacheTemplate.get(token + "loginSource");
            userInfo.setLoginSource(loginSource);
            userInfo.setOuterUserTypes(outerUserTypes);
            UmcQrySingleValuePropertyAbilityReqBO umcQrySingleValuePropertyAbilityReqBO = new UmcQrySingleValuePropertyAbilityReqBO();
            umcQrySingleValuePropertyAbilityReqBO.setKey("staff.welfare.pay.config.enable");
            UmcQrySingleValuePropertyAbilityRspBO umcQrySingleValuePropertyAbilityRspBO = this.umcApplicationPropertyAbilityService.qrySingleValue(umcQrySingleValuePropertyAbilityReqBO);
            if ("0000".equals(umcQrySingleValuePropertyAbilityRspBO.getRespCode()) && !StringUtils.isBlank((CharSequence)umcQrySingleValuePropertyAbilityRspBO.getValue())) {
                userInfo.setStaffWelfarePayConfigEnable(Boolean.parseBoolean(umcQrySingleValuePropertyAbilityRspBO.getValue()));
            }
        }
        return userInfo;
    }

    private void loadUserMenus(UmcMemInfoBO userInfo, String appCode) throws Exception {
        SelectAccessMenuReqBO menuReqBO = new SelectAccessMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        menuReqBO.setApplicationCode(appCode);
        SelectAccessMenuRspBO menuRspBO = this.selectAccessMenuService.selectAccessMenuService(menuReqBO);
        ArrayList<String> menuCodeList = new ArrayList<String>();
        List menuList = menuRspBO.getAccessMenuList();
        if (menuList != null && menuList.size() > 0) {
            for (AccessMenu menu : menuList) {
                if (StringUtils.isNotBlank((CharSequence)menu.getMenuDomain())) {
                    menu.setDomain(menu.getMenuDomain());
                }
                menuCodeList.add(menu.getMenuCode());
            }
            List unMenuInfos = ListUtils.copyListProperties((List)menuList, MenuInfo.class);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appCode})) {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setOrgPath(userInfo.getOrgPath());
                applicationByUserReqBO.setUserId(userInfo.getUserId());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                applicationBOS.forEach(a -> {
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{a.getApplicationCode()}) && a.getApplicationCode().equals(appCode) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getUrl()})) {
                        MenuInfo m = new MenuInfo();
                        m.setUrl(a.getUrl());
                        unMenuInfos.add(m);
                    }
                });
            }
            MenuInfo m = new MenuInfo();
            m.setUrl("/index.html");
            unMenuInfos.add(m);
            MenuInfo m1 = new MenuInfo();
            m1.setUrl("/rest/**");
            unMenuInfos.add(m1);
            userInfo.setUnstructuredMunes(unMenuInfos);
            HashMap<String, List<MenuInfo>> menuMap = new HashMap<String, List<MenuInfo>>();
            Map<String, List<AccessMenu>> menuListMap = this.groupBillingDataByAppCode(menuList);
            menuListMap.keySet().forEach(key -> {
                List accessMenus = (List)menuListMap.get(key);
                List menuInfos = ListUtils.copyListProperties((List)accessMenus, MenuInfo.class);
                if (menuInfos.size() > 0) {
                    List<MenuInfo> buildByRecursive = this.buildByRecursive(menuInfos);
                    menuMap.put((String)key, buildByRecursive);
                }
            });
            userInfo.setMenus(menuMap);
            userInfo.setMenuCodeList(menuCodeList);
        }
    }

    private void loadManagerOrg(UmcMemInfoBO userInfo) {
        UmcQryOrgByUserStationAbilityReqBO reqBO = new UmcQryOrgByUserStationAbilityReqBO();
        reqBO.setMemIdExt(userInfo.getMemIdExt());
        reqBO.setStationType("ORDER_QRY_ORG_AUTH");
        UmcQryOrgByUserStationAbilityRspBO rspBO = this.umcQryOrgByUserStationAbilityService.qryOrgByUserStation(reqBO);
        userInfo.setManagerOrgListIn(rspBO.getRows());
    }

    private List<MenuInfo> buildByRecursive(List<MenuInfo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<MenuInfo> trees = new ArrayList<MenuInfo>();
        for (MenuInfo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private MenuInfo findChildren(MenuInfo root, List<MenuInfo> allMenus) {
        for (MenuInfo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getSubMenus() == null) {
                root.setSubMenus(new ArrayList<MenuInfo>());
            }
            root.getSubMenus().add(this.findChildren(it, allMenus));
        }
        return root;
    }

    private void loadUserAuthoritys(UmcMemInfoBO userInfo, String appCode) {
        HashSet<AuthorityInfo> authorities = new HashSet<AuthorityInfo>();
        SelectAuthoritysMenuReqBO menuReqBO = new SelectAuthoritysMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setApplicationCode(appCode);
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectAuthoritysMenuRspBO authoritysMenuRspBO = this.selectAuthoritysMenuService.selectAuthoritysMenuService(menuReqBO);
        List authorityMenuList = authoritysMenuRspBO.getAuthorityMenuList();
        if (authorityMenuList != null && authorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)authorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
        }
        SelectRoleAuthoritysReqBO roleAuthoritysReqBO = new SelectRoleAuthoritysReqBO();
        roleAuthoritysReqBO.setUserId(userInfo.getUserId());
        roleAuthoritysReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectRoleAuthoritysRspBO roleAuthoritysRspBO = this.selectRoleAuthoritysService.selectRoleAuthoritysService(roleAuthoritysReqBO);
        List roleAuthoritysRspBOAuthorityMenuList = roleAuthoritysRspBO.getAuthorityMenuList();
        if (roleAuthoritysRspBOAuthorityMenuList != null && roleAuthoritysRspBOAuthorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)roleAuthoritysRspBOAuthorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
            ArrayList<String> roleNames = new ArrayList<String>();
            roleAuthoritysRspBOAuthorityMenuList.forEach(roleBO -> roleNames.add(roleBO.getTitle()));
            userInfo.setRoleNames(roleNames);
        }
        userInfo.setPermission(authorities);
    }

    private Map<String, List<AccessMenu>> groupBillingDataByAppCode(List<AccessMenu> billingList) throws Exception {
        HashMap<String, List<AccessMenu>> resultMap = new HashMap<String, List<AccessMenu>>();
        try {
            for (AccessMenu accessMenu : billingList) {
                if (resultMap.containsKey(accessMenu.getAppCode())) {
                    ((List)resultMap.get(accessMenu.getAppCode())).add(accessMenu);
                    continue;
                }
                ArrayList<AccessMenu> tmpList = new ArrayList<AccessMenu>();
                tmpList.add(accessMenu);
                resultMap.put(accessMenu.getAppCode(), tmpList);
            }
        }
        catch (Exception e) {
            throw new Exception("\u6309\u7167\u5b50\u7cfb\u7edf\u7f16\u7801\u5bf9\u83dc\u5355\u6570\u636e\u8fdb\u884c\u5206\u7ec4\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
        return resultMap;
    }

    private UmcUserDetails checkAccessToken(String accessToken, Long userId, String token) {
        UmcUserCheckAccessTokenReqBo checkAccessTokenReqBo = new UmcUserCheckAccessTokenReqBo();
        checkAccessTokenReqBo.setAccessToken(accessToken);
        checkAccessTokenReqBo.setUserId(userId);
        checkAccessTokenReqBo.setToken(token);
        checkAccessTokenReqBo.setSysCode("EMP");
        return this.checkAccessToken(checkAccessTokenReqBo);
    }

    private int getConnectionTimeout() {
        if (this.authCheckAccessTokenConnectionTimeout < 1 || this.authCheckAccessTokenConnectionTimeout > 600) {
            return 5000;
        }
        return this.authCheckAccessTokenConnectionTimeout * 1000;
    }

    private int getReadTimeout() {
        if (this.authCheckAccessTokenReadTimeout < 1 || this.authCheckAccessTokenReadTimeout > 600) {
            return 5000;
        }
        return this.authCheckAccessTokenReadTimeout * 1000;
    }
}

