/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.signature.filter;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.security.signature.properties.SignatureProperties;
import com.tydic.umc.security.signature.utils.SignatureUtil;
import com.tydic.umc.security.signature.wrapper.CustomHttpServletRequestWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SignatureFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SignatureFilter.class);
    private final SignatureProperties signatureProperties;
    private final CacheClient cacheClient;
    private String contentType;

    public SignatureFilter(SignatureProperties signatureProperties, CacheClient cacheClient) {
        this.signatureProperties = signatureProperties;
        this.cacheClient = cacheClient;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String requestDataStr;
        log.info("\u7279\u6b8a\u4e1a\u52a1\u8bf7\u6c42\u8fc7\u6ee4\u5668\u89e6\u53d1");
        this.contentType = request.getContentType();
        if (this.contentType == null || this.contentType.startsWith(ContentType.MULTIPART_FORM_DATA.getMimeType())) {
            filterChain.doFilter(request, response);
            return;
        }
        if (!StringUtils.hasText((String)request.getCharacterEncoding())) {
            request.setCharacterEncoding("UTF-8");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        log.error("\u7279\u6b8a\u4e1a\u52a1\u8bf7\u6c42\u8fc7\u6ee4\u5668\u89e6\u53d1" + httpServletRequest.getRequestURI());
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String signature = httpServletRequest.getHeader(this.signatureProperties.getSignatureKey());
        String authToken = httpServletRequest.getHeader("auth-token");
        if (StrUtil.isEmpty((CharSequence)signature) || StrUtil.isEmpty((CharSequence)authToken)) {
            this.writeMessage("\u5f53\u524d\u8bf7\u6c42\u975e\u6cd5", httpServletResponse);
            return;
        }
        String uri = httpServletRequest.getRequestURI();
        String newUri = uri.substring(uri.lastIndexOf("/") + 1);
        if (StringUtils.hasText((String)this.signatureProperties.getNotAntiReplay()) && this.validateRepeat(signature, this.cacheClient)) {
            this.writeMessage("\u64cd\u4f5c\u592a\u5feb\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5", httpServletResponse);
            return;
        }
        Object requestWrapper = httpServletRequest;
        if (this.contentType.contains("application/json")) {
            requestWrapper = new CustomHttpServletRequestWrapper(httpServletRequest);
            requestDataStr = ((CustomHttpServletRequestWrapper)((Object)requestWrapper)).getRequestData();
        } else {
            Map parameterMap = httpServletRequest.getParameterMap();
            if (MapUtil.isEmpty((Map)parameterMap)) {
                filterChain.doFilter((ServletRequest)requestWrapper, response);
                return;
            }
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.disableHtmlEscaping();
            Gson gson = gsonBuilder.create();
            requestDataStr = gson.toJson(new LinkedHashMap(parameterMap));
        }
        JSONObject jsonObject = JSON.parseObject((String)requestDataStr);
        if (jsonObject.get((Object)"callsource") != null && "out".equals(jsonObject.getString("callsource"))) {
            filterChain.doFilter((ServletRequest)requestWrapper, response);
            return;
        }
        if (SignatureUtil.validateSign(requestDataStr, authToken, signature, newUri)) {
            if (this.signatureProperties.getExpireTime() == null || this.signatureProperties.getExpireTime() == 0) {
                this.cacheClient.set(signature, (Object)signature, 1);
            } else {
                this.cacheClient.set(signature, (Object)signature, this.signatureProperties.getExpireTime().intValue());
            }
            filterChain.doFilter((ServletRequest)requestWrapper, response);
            return;
        }
        this.writeMessage("\u8bf7\u6c42\u975e\u6cd5\uff01", httpServletResponse);
    }

    private boolean validateRepeat(String signature, CacheClient cacheClient) {
        if (ObjectUtil.isNotEmpty((Object)cacheClient.get(signature))) {
            return true;
        }
        cacheClient.set(signature, (Object)signature, 1);
        return false;
    }

    private void writeMessage(String message, HttpServletResponse response) {
        JSONObject retJson = new JSONObject();
        retJson.put("code", (Object)"1");
        retJson.put("message", (Object)message);
        response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        response.setContentType(this.contentType);
        try (PrintWriter writer = response.getWriter();){
            writer.write(retJson.toJSONString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("\u7279\u6b8a\u4e1a\u52a1\u8bf7\u6c42\u8fc7\u6ee4\u5668\u6210\u529f\u62e6\u622a:" + message);
    }

    public void destroy() {
        super.destroy();
    }
}

