/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.signature.utils;

import cn.hutool.crypto.digest.MD5;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtil.class);
    private static final String REGX = "[^a-zA-Z0-9]";
    private static final int TRUNCATED_LENGTH = 20;

    public static String getSignature(String data, String authToken, String uri) {
        data = data.replaceAll(REGX, "");
        StringBuilder stringBuilder = new StringBuilder();
        if (data.length() > 20) {
            stringBuilder.append(data, 0, 20);
            stringBuilder.append(data, data.length() - 20, data.length());
        } else {
            stringBuilder.append(data);
        }
        stringBuilder.append(authToken);
        stringBuilder.append(uri);
        return new MD5().digestHex(stringBuilder.toString(), StandardCharsets.UTF_8);
    }

    public static boolean validateSign(String data, String authToken, String signature, String uri) {
        String newSignature = SignatureUtil.getSignature(data, authToken, uri);
        if (!newSignature.equals(signature)) {
            log.info("\u9a8c\u7b7e\u4e0d\u901a\u8fc7\u7684\u6570\u636e:" + signature + " , " + newSignature);
            log.info("\u5f85\u9a8c\u7b7e\u7684\u6570\u636e:" + data);
        }
        return newSignature.equals(signature);
    }
}

