package com.tydic.dyc.pro.base.core.apollo;

import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

import java.util.Objects;

class DecryptingPropertySource extends PropertySource<Object> {

    private static final String PREFIX = "ENC(";
    private static final String SUFFIX = ")";

    private final PropertySource<?> delegate;
    private final boolean enumerable;

    DecryptingPropertySource(PropertySource<?> delegate) {
        super(delegate.getName(), delegate.getSource());
        this.delegate = delegate;
        this.enumerable = delegate instanceof EnumerablePropertySource;
    }

    @Override
    public Object getProperty(String name) {
        Object v = delegate.getProperty(name);
        if (!(v instanceof String)) {
            return v;
        }
        String s = ((String) v).trim();
        if (!s.startsWith(PREFIX) || !s.endsWith(SUFFIX)) {
            return v;
        }
        System.out.println("[ENC-DEC] hit ENC for key='" + name + "' in PS='" + delegate.getName() + "'");
        // caching by property key and raw value
        String cached = DecryptingCache.get(name, s);
        if (cached != null) {
            System.out.println("[ENC-DEC] cache hit for key='" + name + "'");
            return cached;
        }
        String payload = s.substring(PREFIX.length(), s.length() - SUFFIX.length());
        try {
            byte[] key = SecretKeyProvider.loadKey();
            String plain = AesGcmCrypto.decryptBase64Url(payload, key);
            DecryptingCache.put(name, s, plain);
            System.out.println("[ENC-DEC] decrypt ok for key='" + name + "'");
            return plain;
        } catch (Exception e) {
            // On failure, return original value transparently
            System.out.println("[ENC-DEC] decrypt fail for key='" + name + "' err=" + e.getMessage());
            return v;
        }
    }

    @Override
    public boolean containsProperty(String name) {
        return delegate.containsProperty(name);
    }

    @Override
    public String getName() {
        return delegate.getName();
    }

    @Override
    public Object getSource() {
        return delegate.getSource();
    }

    String[] getPropertyNames() {
        if (enumerable) {
            return ((EnumerablePropertySource<?>) delegate).getPropertyNames();
        }
        return new String[0];
    }

    static PropertySource<?> wrap(PropertySource<?> src) {
        if (src instanceof DecryptingPropertySource) {
            return src;
        }
        if (src instanceof EnumerablePropertySource) {
            return new EnumerableWrapper((EnumerablePropertySource<?>) src);
        }
        return new DecryptingPropertySource(src);
    }

    static class EnumerableWrapper extends EnumerablePropertySource<Object> {
        private final EnumerablePropertySource<?> delegate;

        EnumerableWrapper(EnumerablePropertySource<?> delegate) {
            super(delegate.getName(), delegate.getSource());
            this.delegate = delegate;
        }

        @Override
        public String[] getPropertyNames() {
            return delegate.getPropertyNames();
        }

        @Override
        public Object getProperty(String name) {
            Object v = delegate.getProperty(name);
            if (!(v instanceof String)) {
                return v;
            }
            String s = ((String) v).trim();
            if (!s.startsWith(PREFIX) || !s.endsWith(SUFFIX)) {
                return v;
            }
            System.out.println("[ENC-DEC] hit ENC for key='" + name + "' in PS='" + delegate.getName() + "'");
            String cached = DecryptingCache.get(name, s);
            if (cached != null) {
                System.out.println("[ENC-DEC] cache hit for key='" + name + "'");
                return cached;
            }
            String payload = s.substring(PREFIX.length(), s.length() - SUFFIX.length());
            try {
                byte[] key = SecretKeyProvider.loadKey();
                String plain = AesGcmCrypto.decryptBase64Url(payload, key);
                DecryptingCache.put(name, s, plain);
                System.out.println("[ENC-DEC] decrypt ok for key='" + name + "'");
                return plain;
            } catch (Exception e) {
                System.out.println("[ENC-DEC] decrypt fail for key='" + name + "' err=" + e.getMessage());
                return v;
            }
        }
    }
}
