/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.apollo;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesGcmCrypto {
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int GCM_TAG_LENGTH_BITS = 128;
    private static final int IV_LENGTH = 12;
    private static final int TAG_LENGTH = 16;
    private static final SecureRandom RANDOM = new SecureRandom();

    public static String decryptBase64Url(String base64UrlPayload, byte[] keyBytes) throws Exception {
        byte[] payload = Base64.getUrlDecoder().decode(AesGcmCrypto.normalizeBase64Url(base64UrlPayload));
        if (payload.length < 28) {
            throw new IllegalArgumentException("Invalid GCM payload length");
        }
        byte[] iv = new byte[12];
        byte[] tag = new byte[16];
        byte[] ciphertext = new byte[payload.length - 12 - 16];
        System.arraycopy(payload, 0, iv, 0, 12);
        System.arraycopy(payload, 12, ciphertext, 0, ciphertext.length);
        System.arraycopy(payload, 12 + ciphertext.length, tag, 0, 16);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, (Key)keySpec, spec);
        try {
            return new String(cipher.doFinal(AesGcmCrypto.concat(ciphertext, tag)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Cipher cipher2 = Cipher.getInstance(TRANSFORMATION);
            cipher2.init(2, (Key)keySpec, spec);
            return new String(cipher2.doFinal(ciphertext), StandardCharsets.UTF_8);
        }
    }

    public static String encryptBase64Url(String plaintext, byte[] keyBytes) throws Exception {
        byte[] iv = new byte[12];
        RANDOM.nextBytes(iv);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, (Key)keySpec, spec);
        byte[] ctAndTag = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
        if (ctAndTag.length < 16) {
            throw new IllegalStateException("GCM output too short");
        }
        int ctLen = ctAndTag.length - 16;
        byte[] ciphertext = new byte[ctLen];
        byte[] tag = new byte[16];
        System.arraycopy(ctAndTag, 0, ciphertext, 0, ctLen);
        System.arraycopy(ctAndTag, ctLen, tag, 0, 16);
        byte[] payload = AesGcmCrypto.concat(iv, AesGcmCrypto.concat(ciphertext, tag));
        return AesGcmCrypto.toBase64UrlNoPadding(payload);
    }

    private static String normalizeBase64Url(String s) {
        int mod = s.length() % 4;
        if (mod == 2) {
            return s + "==";
        }
        if (mod == 3) {
            return s + "=";
        }
        return s;
    }

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] out = new byte[a.length + b.length];
        System.arraycopy(a, 0, out, 0, a.length);
        System.arraycopy(b, 0, out, a.length, b.length);
        return out;
    }

    private static String toBase64UrlNoPadding(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

