/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.apollo;

import com.tydic.dyc.pro.base.core.apollo.AesGcmCrypto;
import com.tydic.dyc.pro.base.core.apollo.SecretKeyProvider;
import java.security.SecureRandom;
import java.util.Base64;

public class CryptoTool {
    private static final SecureRandom RANDOM = new SecureRandom();

    public static void main(String[] args) throws Exception {
        String cmd;
        if (args == null || args.length == 0) {
            CryptoTool.printHelp();
            return;
        }
        switch (cmd = args[0].toLowerCase()) {
            case "gen-key": {
                CryptoTool.genKey();
                break;
            }
            case "encrypt": {
                if (args.length < 2) {
                    System.out.println("\u7f3a\u5c11\u660e\u6587\u53c2\u6570\uff0c\u5982: encrypt myPassword");
                    return;
                }
                CryptoTool.encrypt(CryptoTool.joinFrom(args, 1));
                break;
            }
            case "decrypt": {
                if (args.length < 2) {
                    System.out.println("\u7f3a\u5c11\u5bc6\u6587\u53c2\u6570\uff0c\u5982: decrypt ENC(....)");
                    return;
                }
                CryptoTool.decrypt(CryptoTool.joinFrom(args, 1));
                break;
            }
            default: {
                CryptoTool.printHelp();
            }
        }
    }

    private static void genKey() {
        byte[] key = new byte[32];
        RANDOM.nextBytes(key);
        String b64u = Base64.getUrlEncoder().withoutPadding().encodeToString(key);
        System.out.println("\u751f\u621032\u5b57\u8282\u5bc6\u94a5\uff1a");
        System.out.println("Base64Url(\u63a8\u8350\uff0c\u8bbe\u7f6e\u4e3a APP_SECRET_KEY)\uff1a" + b64u);
    }

    private static void encrypt(String plaintext) throws Exception {
        byte[] key = SecretKeyProvider.loadKey();
        String payload = AesGcmCrypto.encryptBase64Url(plaintext, key);
        System.out.println("ENC(" + payload + ")");
    }

    private static void decrypt(String input) throws Exception {
        String payload = CryptoTool.extractPayload(input.trim());
        byte[] key = SecretKeyProvider.loadKey();
        String plain = AesGcmCrypto.decryptBase64Url(payload, key);
        System.out.println(plain);
    }

    private static String extractPayload(String s) {
        if (s.startsWith("ENC(") && s.endsWith(")")) {
            return s.substring(4, s.length() - 1);
        }
        return s;
    }

    private static void printHelp() {
        System.out.println("\u7528\u6cd5:\n  gen-key\n  encrypt <plaintext>\n  decrypt <ENC(payload)|payload>\n\u5bc6\u94a5\u6765\u6e90\uff1a\u73af\u5883\u53d8\u91cf APP_SECRET_KEY \u6216\u6587\u4ef6 APP_SECRET_KEY_FILE (\u9ed8\u8ba4 /etc/app/secret.key)");
    }

    private static String joinFrom(String[] arr, int startIdx) {
        StringBuilder sb = new StringBuilder();
        for (int i = startIdx; i < arr.length; ++i) {
            if (i > startIdx) {
                sb.append(' ');
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }
}

