/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.apollo;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class DecryptingCache {
    private static final ConcurrentHashMap<String, Entry> CACHE = new ConcurrentHashMap();

    DecryptingCache() {
    }

    static String get(String key, String raw) {
        Entry e = CACHE.get(key);
        if (e != null && Objects.equals(e.raw, raw)) {
            return e.plain;
        }
        return null;
    }

    static void put(String key, String raw, String plain) {
        CACHE.put(key, new Entry(raw, plain));
    }

    static void evict(String key) {
        CACHE.remove(key);
    }

    static void clearAll() {
        CACHE.clear();
    }

    static class Entry {
        final String raw;
        final String plain;

        Entry(String raw, String plain) {
            this.raw = raw;
            this.plain = plain;
        }
    }
}

