/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.apollo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;

public class SecretKeyProvider {
    private static final String ENV_KEY = "APP_SECRET_KEY";
    private static final String ENV_KEY_FILE = "APP_SECRET_KEY_FILE";
    private static final String DEFAULT_KEY_FILE = "/etc/app/secret.key";

    public static byte[] loadKey() {
        String k = System.getenv(ENV_KEY);
        if (k != null && !k.trim().isEmpty()) {
            byte[] key = SecretKeyProvider.parseKey(k.trim());
            SecretKeyProvider.validateKey(key);
            return key;
        }
        String path = System.getenv(ENV_KEY_FILE);
        if (path == null || path.trim().isEmpty()) {
            path = DEFAULT_KEY_FILE;
        }
        try {
            String fileContent = new String(Files.readAllBytes(Paths.get(path, new String[0]))).trim();
            byte[] key = SecretKeyProvider.parseKey(fileContent);
            SecretKeyProvider.validateKey(key);
            return key;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load secret key from env or file: " + path, e);
        }
    }

    private static byte[] parseKey(String raw) {
        String s = raw.trim();
        if (SecretKeyProvider.looksLikeBase64Url(s)) {
            return Base64.getUrlDecoder().decode(SecretKeyProvider.normalizeBase64Url(s));
        }
        return s.getBytes();
    }

    private static boolean looksLikeBase64Url(String s) {
        return s.matches("[-A-Za-z0-9_]+={0,2}");
    }

    private static String normalizeBase64Url(String s) {
        int mod = s.length() % 4;
        if (mod == 2) {
            return s + "==";
        }
        if (mod == 3) {
            return s + "=";
        }
        return s;
    }

    private static void validateKey(byte[] key) {
        if (key == null || key.length != 32) {
            throw new IllegalStateException("Invalid AES-256 key, require 32 bytes, got " + (key == null ? 0 : key.length));
        }
    }
}

