package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author yuhao
 * @Date 2025/6/10 11:32
 * @Description:
 **/
@Data
public class DycProBaseCallEsbUtilGetSkuDetailForJdResultBO implements Serializable {

    private static final long serialVersionUID = 3007998057922435121L;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 主图
     */
    private String imagePath;
    /**
     * 属性信息
     */
    private List<DycProBaseCallEsbUtilSkuParamForJdBO> paramJson;
    /**
     * 商品最小起购量
     */
    private String LowestBuy;
    /**
     * 重量
     */
    private String weight;
    /**
     * 商品69条码
     */
    private String upc69;
    /**
     * UPC码区分实物、图书、音像、三种场景
     */
    private String upc;
    /**
     * 包装清单
     */
    private String wareQD;
    /**
     * 售卖计量单位
     */
    private String saleUnit;
    /**
     * 是否厂直商品
     */
    private String isFactoryShip;
    /**
     * 商品税率
     */
    private String taxInfo;
    /**
     * 商品名称
     */
    private String name;
    /**
     * 规格参数
     */
    private String seoModel;
    /**
     * 商品上下架状态 (1上架 0下架)
     */
    private Integer state;
    /**
     * 分类
     */
    private List<String> category;
    /**
     * 商品编码
     */
    private Long sku;
    /**
     * 商品详情页
     */
    private String introduction;
    /**
     * 是否自营
     */
    private Integer isSelf;
}
