package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class DycProBaseCallEsbUtilOrderEsPreOrderSubmitRspSkuBO implements Serializable {
    private static final long serialVersionUID = -4251425053556682175L;
    /**
     * skuID
     */
    private String skuId;

    /**
     * 类别
     */
    private String category;

    /**
     * 购买数量
     */
    private Integer num;

    /**
     * 总价
     */
    private BigDecimal price;

    /**
     * 主商品skuid，如果本身是主商品，则 oid 为 0
     */
    private String oid;

    /**
     * 税率
     */
    private Integer tax;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 税额
     */
    private BigDecimal taxPrice;

    /**
     * 裸价
     */
    private BigDecimal nakedPrice;

    /**
     * 类型：0 普通、1 附件、2 赠品
     */
    private Integer type;

    /**
     * 销售单位
     */
    private String saleUnit;

    /**
     * 结算数量
     */
    private BigDecimal settleNum;

    /**
     * 结算单位
     */
    private String settleUnit;

    /**
     * 结算转换率
     */
    private String settleRate;

    /**
     * 分子
     */
    private Integer molecule;

    /**
     * 分母
     */
    private Integer denominator;

    /**
     * 规格型号
     */
    private String unit;

    /**
     * 税收分类编码
     */
    private String taxId;

    /**
     * 税收分类编码名称
     */
    private String taxName;

    /**
     * 用途
     */
    private String use;

}


