package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 标题：DycProBaseCallEsbUtilServiceOrderParamForJdBO
 * 描述：申请售后param字段参数（京东）
 */
@Data
public class DycProBaseCallEsbUtilServiceOrderParamForJdBO implements Serializable {

    private static final long serialVersionUID = 2747199044489252872L;

    /**
     * 京东子订单号
     */
    private String orderId;

    /**
     * 申请批次号，同一子订单下不可重复（长度最大20）
     */
    private String thirdApplyId;

    /**
     * 是否有发票
     */
    private Boolean isHasInvoice;

    /**
     * 用户信息
     */
    private DycProBaseCallEsbUtilServiceOrderAfsCustomerInfoForJdBO customerInfo;

    /**
     * 取件信息，即原商品如何返回京东或者卖家
     */
    private DycProBaseCallEsbUtilServiceOrderAfsPickupWareInfoForJdBO pickwareInfo;

    /**
     * 返件信息，商品如何返回客户手中。当售后类型为换货、维修时，表示商品如何返回客户手中；当售后类型为退货时，表示退货失败商品返回客户手中的地址
     */
    private DycProBaseCallEsbUtilServiceOrderAfsReturnWareInfoForJdBO returnWareInfo;

    /***
     * 申请信息集合，一个SKU只能有一个条目，一个SKU不能有两个或两个以上条目
     */
    private List<DycProBaseCallEsbUtilServiceOrderAfsApplyInfoItemForJdBO> afsApplyInfoItemList;

}
