/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.supplierUser.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.tydic.dyc.base.utils.SmcIdUtil;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.base.utils.StrUtil;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.po.SmcSysAuthDistributePo;
import com.tydic.dyc.smc.po.SmcSysRoleInfoPo;
import com.tydic.dyc.smc.po.SmcUmcCustInfoPo;
import com.tydic.dyc.smc.po.SmcUmcExtUserSyncLogsPo;
import com.tydic.dyc.smc.po.SmcUmcExtUserSyncTempPo;
import com.tydic.dyc.smc.po.SmcUmcUserInfoPo;
import com.tydic.dyc.smc.po.SmcUmcUserTagRelPo;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcOrgInfoRepository;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoQryDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgTagRelDO;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtUserSyncLogsRepository;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtUserSyncTempRepository;
import com.tydic.dyc.smc.repository.role.api.SmcSysAuthDistributeRepository;
import com.tydic.dyc.smc.repository.role.api.SmcSysRoleInfoRepository;
import com.tydic.dyc.smc.repository.role.bo.SmcSysRoleInfoDO;
import com.tydic.dyc.smc.repository.user.api.SmcUmcCustInfoRepository;
import com.tydic.dyc.smc.repository.user.api.SmcUmcUserInfoRepository;
import com.tydic.dyc.smc.repository.user.api.SmcUmcUserTagRelRepository;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserInfoDO;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserInfoQryDO;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserTagRelDO;
import com.tydic.dyc.smc.supplierUser.api.SmcUmcDealSupplierUserInfoSyncService;
import com.tydic.dyc.smc.supplierUser.bo.SmcUmcDealSupplierUserInfoBO;
import com.tydic.dyc.smc.supplierUser.bo.SmcUmcDealSupplierUserInfoSyncReqBO;
import com.tydic.dyc.smc.supplierUser.bo.SmcUmcDealSupplierUserInfoSyncRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.supplierUser.api.SmcUmcDealSupplierUserInfoSyncService"})
public class SmcUmcDealSupplierUserInfoSyncServiceImpl
implements SmcUmcDealSupplierUserInfoSyncService {
    @Autowired
    private SmcUmcCustInfoRepository umcCustInfoRepository;
    @Autowired
    private SmcUmcOrgInfoRepository umcOrgInfoRepository;
    @Autowired
    private SmcSysRoleInfoRepository sysRoleInfoRepository;
    @Autowired
    private SmcUmcUserInfoRepository umcUserInfoRepository;
    @Autowired
    private SmcUmcUserTagRelRepository umcUserTagRelRepository;
    @Autowired
    private SmcSysAuthDistributeRepository sysAuthDistributeRepository;
    @Autowired
    private SmcUmcExtUserSyncTempRepository umcExtUserSyncTempRepository;
    @Autowired
    private SmcUmcExtUserSyncLogsRepository umcExtUserSyncLogsRepository;
    @Value(value="${dealSupplierUserInfoSync.dealUserMaxCount}")
    private Integer dealUserMaxCount;
    @Value(value="${dealSupplierUserInfoSync.maxRepeatLoginNum}")
    private Integer maxRepeatLoginNum;
    @Value(value="${dealSupplierUserInfoSync.initialPassword}")
    private String initialPassword;
    private static final String authorityType = "auth:system:manage";

    @Override
    @PostMapping(value={"dealSupplierUserInfoSync"})
    public SmcUmcDealSupplierUserInfoSyncRspBO dealSupplierUserInfoSync(@RequestBody SmcUmcDealSupplierUserInfoSyncReqBO reqBO) {
        List orgCodeList = reqBO.getDealUserInfoBOList().stream().map(SmcUmcDealSupplierUserInfoBO::getOrgCode).collect(Collectors.toList());
        List regAccountList = reqBO.getDealUserInfoBOList().stream().map(SmcUmcDealSupplierUserInfoBO::getRegAccount).collect(Collectors.toList());
        List authIdentityList = reqBO.getDealUserInfoBOList().stream().flatMap(item -> item.getAuthIdentityList().stream()).distinct().collect(Collectors.toList());
        HashMap<String, SmcUmcOrgInfoDO> orgInfoMap = new HashMap();
        SmcUmcOrgInfoQryDO orgInfoQryDO = new SmcUmcOrgInfoQryDO();
        orgInfoQryDO.setOrgCodes(orgCodeList);
        orgInfoQryDO.setOrgTagId("2");
        orgInfoQryDO.setQrySideInfo(Boolean.TRUE);
        List umcOrgInfoDOList = this.umcOrgInfoRepository.getOrgInfoByTag(orgInfoQryDO).getRows();
        if (ObjectUtil.isNotEmpty((Object)umcOrgInfoDOList)) {
            orgInfoMap = umcOrgInfoDOList.stream().collect(Collectors.toMap(SmcUmcOrgInfoDO::getOrgCode, Function.identity()));
        }
        HashMap<String, SmcUmcUserInfoDO> custInfoMap = new HashMap();
        SmcUmcUserInfoQryDO userInfoQryDO = new SmcUmcUserInfoQryDO();
        userInfoQryDO.setRegAccountList(regAccountList);
        userInfoQryDO.setIsMain("1");
        userInfoQryDO.setQrySideInfo(Boolean.TRUE);
        List umcCustInfoPoList = this.umcUserInfoRepository.qryUserInfoList(userInfoQryDO).getRows();
        if (ObjectUtil.isNotEmpty((Object)umcCustInfoPoList)) {
            custInfoMap = umcCustInfoPoList.stream().collect(Collectors.toMap(item -> item.getRegAccount().toUpperCase(), Function.identity()));
        }
        HashMap<String, SmcSysRoleInfoPo> roleInfoMap = new HashMap();
        if (ObjectUtil.isNotEmpty(authIdentityList)) {
            LambdaQueryWrapper roleQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)roleQueryWrapper.in(SmcSysRoleInfoPo::getAuthIdentity, authIdentityList)).eq(SmcSysRoleInfoPo::getDelFlag, (Object)"0");
            List sysRoleInfoPoList = this.sysRoleInfoRepository.list((Wrapper)roleQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)sysRoleInfoPoList)) {
                roleInfoMap = sysRoleInfoPoList.stream().collect(Collectors.toMap(SmcSysRoleInfoPo::getAuthIdentity, Function.identity()));
            }
        }
        HashMap<Long, String> failResultMap = new HashMap<Long, String>();
        ArrayList<Long> nextIdList = new ArrayList<Long>();
        ArrayList<Long> successIdList = new ArrayList<Long>();
        ArrayList<SmcUmcExtUserSyncLogsPo> insertUserLogsList = new ArrayList<SmcUmcExtUserSyncLogsPo>();
        ArrayList<SmcUmcCustInfoPo> insertCustInfoList = new ArrayList<SmcUmcCustInfoPo>();
        ArrayList<SmcUmcCustInfoPo> updateCustInfoList = new ArrayList<SmcUmcCustInfoPo>();
        ArrayList<Long> deleteCustIdList = new ArrayList<Long>();
        ArrayList<SmcUmcUserInfoPo> insertUserInfoList = new ArrayList<SmcUmcUserInfoPo>();
        ArrayList<SmcUmcUserInfoPo> updateUserInfoList = new ArrayList<SmcUmcUserInfoPo>();
        ArrayList<Long> deleteUserIdList = new ArrayList<Long>();
        ArrayList<SmcUmcUserTagRelPo> insertUserTagList = new ArrayList<SmcUmcUserTagRelPo>();
        ArrayList<SmcSysAuthDistributePo> insertUserRoleList = new ArrayList<SmcSysAuthDistributePo>();
        for (SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO : reqBO.getDealUserInfoBOList()) {
            try {
                StrUtil.noNullStringAttr((Object)dealSupplierUserInfoBO);
                if (this.dealMaxCount(dealSupplierUserInfoBO, orgInfoMap, failResultMap) || this.dealDelData(dealSupplierUserInfoBO, custInfoMap, deleteUserIdList, deleteCustIdList, successIdList, failResultMap)) continue;
                if (!custInfoMap.containsKey(dealSupplierUserInfoBO.getRegAccount().toUpperCase())) {
                    if (!orgInfoMap.containsKey(dealSupplierUserInfoBO.getOrgCode())) {
                        nextIdList.add(dealSupplierUserInfoBO.getId());
                        continue;
                    }
                    SmcUmcOrgInfoDO orgInfo = (SmcUmcOrgInfoDO)orgInfoMap.get(dealSupplierUserInfoBO.getOrgCode());
                    SmcUmcCustInfoPo custInfoPo = this.insertCustInfo(dealSupplierUserInfoBO, insertCustInfoList);
                    SmcUmcUserInfoPo userInfoPo = this.insertUserInfo(dealSupplierUserInfoBO, custInfoPo, orgInfo, insertUserInfoList);
                    this.insertUserTag(orgInfo, userInfoPo, custInfoPo, insertUserTagList, null);
                    this.insertUserRole(dealSupplierUserInfoBO, userInfoPo, roleInfoMap, custInfoPo, orgInfo, insertUserRoleList, null);
                    successIdList.add(dealSupplierUserInfoBO.getId());
                } else {
                    if (ObjectUtil.isNotEmpty((Object)dealSupplierUserInfoBO.getOrgCode()) && !orgInfoMap.containsKey(dealSupplierUserInfoBO.getOrgCode())) {
                        nextIdList.add(dealSupplierUserInfoBO.getId());
                        continue;
                    }
                    SmcUmcUserInfoDO oldCustInfo = (SmcUmcUserInfoDO)custInfoMap.get(dealSupplierUserInfoBO.getRegAccount().toUpperCase());
                    SmcUmcOrgInfoDO orgInfo = (SmcUmcOrgInfoDO)orgInfoMap.get(dealSupplierUserInfoBO.getOrgCode());
                    SmcUmcCustInfoPo custInfoPo = this.updateCustInfo(dealSupplierUserInfoBO, oldCustInfo, updateCustInfoList);
                    SmcUmcUserInfoPo userInfoPo = this.updateUserInfo(dealSupplierUserInfoBO, oldCustInfo, custInfoPo, orgInfo, updateUserInfoList);
                    List<String> oldTagList = oldCustInfo.getUserTagList().stream().map(SmcUmcUserTagRelDO::getTagId).collect(Collectors.toList());
                    this.insertUserTag(orgInfo, userInfoPo, custInfoPo, insertUserTagList, oldTagList);
                    List<Long> oldRoleList = oldCustInfo.getUserRoleList().stream().map(SmcSysRoleInfoDO::getRoleId).collect(Collectors.toList());
                    this.insertUserRole(dealSupplierUserInfoBO, userInfoPo, roleInfoMap, custInfoPo, orgInfo, insertUserRoleList, oldRoleList);
                    successIdList.add(dealSupplierUserInfoBO.getId());
                }
            }
            catch (Exception e) {
                failResultMap.put(dealSupplierUserInfoBO.getId(), e.getMessage());
            }
            this.dealInsert(insertCustInfoList, insertUserInfoList, insertUserTagList, insertUserRoleList);
            this.dealUpdate(updateCustInfoList, updateUserInfoList);
            this.dealDelete(deleteCustIdList, deleteUserIdList);
            this.dealTemp(failResultMap, reqBO.getFailIdList(), insertUserLogsList, nextIdList, successIdList);
        }
        return null;
    }

    private void dealTemp(Map<Long, String> failResultMap, List<Long> failIdList, List<SmcUmcExtUserSyncLogsPo> insertUserLogsList, List<Long> nextIdList, List<Long> successIdList) {
        if (ObjectUtil.isNotEmpty(failResultMap)) {
            ArrayList<Long> dealFailIdList = new ArrayList<Long>(failResultMap.keySet());
            List dealFailTempList = this.umcExtUserSyncTempRepository.listByIds(dealFailIdList);
            dealFailTempList.forEach(temp -> {
                SmcUmcExtUserSyncLogsPo logs = (SmcUmcExtUserSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtUserSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc((String)failResultMap.get(temp.getId()));
                insertUserLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(failIdList)) {
            List failTempList = this.umcExtUserSyncTempRepository.listByIds(failIdList);
            failTempList.forEach(temp -> {
                SmcUmcExtUserSyncLogsPo logs = (SmcUmcExtUserSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtUserSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc("\u5fc5\u4f20\u53c2\u6570\u7f3a\u5931");
                insertUserLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(nextIdList)) {
            LambdaUpdateWrapper nextUserDeal = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)nextUserDeal.in(SmcUmcExtUserSyncTempPo::getId, nextIdList)).set(SmcUmcExtUserSyncTempPo::getDealTime, (Object)new Date())).set(SmcUmcExtUserSyncTempPo::getDealResult, (Object)SmcUmcConstants.DealResult.NEXT);
            this.umcExtUserSyncTempRepository.update((Wrapper)nextUserDeal);
        }
        if (ObjectUtil.isNotEmpty(successIdList)) {
            List successTemp = this.umcExtUserSyncTempRepository.listByIds(successIdList);
            successTemp.forEach(temp -> {
                SmcUmcExtUserSyncLogsPo logs = (SmcUmcExtUserSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtUserSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.SUCCESS);
                logs.setDealResultDesc("\u5904\u7406\u6210\u529f");
                insertUserLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(insertUserLogsList)) {
            List ids = insertUserLogsList.stream().map(SmcUmcExtUserSyncLogsPo::getId).collect(Collectors.toList());
            this.umcExtUserSyncLogsRepository.saveBatch(insertUserLogsList);
            this.umcExtUserSyncTempRepository.removeBatchByIds(ids);
        }
    }

    private void dealDelete(List<Long> deleteCustIdList, List<Long> deleteUserIdList) {
        if (ObjectUtil.isNotEmpty(deleteCustIdList)) {
            LambdaUpdateWrapper delCustWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delCustWrapper.in(SmcUmcCustInfoPo::getCustId, deleteCustIdList)).set(SmcUmcCustInfoPo::getDelFlag, (Object)"1");
            this.umcCustInfoRepository.update((Wrapper)delCustWrapper);
        }
        if (ObjectUtil.isNotEmpty(deleteUserIdList)) {
            LambdaUpdateWrapper delUserWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delUserWrapper.in(SmcUmcUserInfoPo::getUserId, deleteUserIdList)).set(SmcUmcUserInfoPo::getDelFlag, (Object)"1");
            this.umcUserInfoRepository.update((Wrapper)delUserWrapper);
            LambdaUpdateWrapper delUserTagWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delUserTagWrapper.in(SmcUmcUserTagRelPo::getUserId, deleteUserIdList)).set(SmcUmcUserTagRelPo::getDelFlag, (Object)"1");
            this.umcUserTagRelRepository.update((Wrapper)delUserTagWrapper);
            LambdaUpdateWrapper delUserRoleWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delUserRoleWrapper.in(SmcSysAuthDistributePo::getUserId, deleteUserIdList)).set(SmcSysAuthDistributePo::getDelFlag, (Object)"1");
            this.sysAuthDistributeRepository.update((Wrapper)delUserRoleWrapper);
        }
    }

    private void dealUpdate(List<SmcUmcCustInfoPo> updateCustInfoList, List<SmcUmcUserInfoPo> updateUserInfoList) {
        if (ObjectUtil.isNotEmpty(updateCustInfoList)) {
            updateCustInfoList.forEach(updateCustInfo -> this.umcCustInfoRepository.updateById(updateCustInfo));
        }
        if (ObjectUtil.isNotEmpty(updateUserInfoList)) {
            updateUserInfoList.forEach(updateUserInfo -> this.umcUserInfoRepository.updateById(updateUserInfo));
        }
    }

    private void dealInsert(List<SmcUmcCustInfoPo> insertCustInfoList, List<SmcUmcUserInfoPo> insertUserInfoList, List<SmcUmcUserTagRelPo> insertUserTagList, List<SmcSysAuthDistributePo> insertUserRoleList) {
        if (ObjectUtil.isNotEmpty(insertCustInfoList)) {
            this.umcCustInfoRepository.saveBatch(insertCustInfoList);
        }
        if (ObjectUtil.isNotEmpty(insertUserInfoList)) {
            this.umcUserInfoRepository.saveBatch(insertUserInfoList);
        }
        if (ObjectUtil.isNotEmpty(insertUserTagList)) {
            this.umcUserTagRelRepository.saveBatch(insertUserTagList);
        }
        if (ObjectUtil.isNotEmpty(insertUserRoleList)) {
            this.sysAuthDistributeRepository.saveBatch(insertUserRoleList);
        }
    }

    private boolean dealDelData(SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO, Map<String, SmcUmcUserInfoDO> custInfoMap, List<Long> deleteUserIdList, List<Long> deleteCustIdList, List<Long> successIdList, Map<Long, String> failResultMap) {
        if (dealSupplierUserInfoBO.getDelFlag().equals("1")) {
            if (custInfoMap.containsKey(dealSupplierUserInfoBO.getRegAccount().toUpperCase())) {
                deleteUserIdList.add(custInfoMap.get(dealSupplierUserInfoBO.getRegAccount().toUpperCase()).getUserId());
                deleteCustIdList.add(custInfoMap.get(dealSupplierUserInfoBO.getRegAccount().toUpperCase()).getCustId());
                successIdList.add(dealSupplierUserInfoBO.getId());
            } else {
                failResultMap.put(dealSupplierUserInfoBO.getId(), "\u5f53\u524d\u5ba2\u6237\u5728\u6b63\u5f0f\u8868\u4e0d\u5b58\u5728");
            }
            return true;
        }
        return false;
    }

    private SmcUmcUserInfoPo updateUserInfo(SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO, SmcUmcUserInfoDO oldCustInfo, SmcUmcCustInfoPo custInfoPo, SmcUmcOrgInfoDO orgInfo, List<SmcUmcUserInfoPo> updateUserInfoList) {
        SmcUmcUserInfoPo userInfoPo = new SmcUmcUserInfoPo();
        userInfoPo.setUserId(oldCustInfo.getUserId());
        userInfoPo.setUserType(custInfoPo.getCustType());
        userInfoPo.setStopStatus(dealSupplierUserInfoBO.getStopStatus());
        userInfoPo.setUpdateTime(custInfoPo.getUpdateTime());
        userInfoPo.setUpdateOperId(custInfoPo.getUpdateOperId());
        userInfoPo.setUpdateOperName(custInfoPo.getUpdateOperName());
        userInfoPo.setDelFlag(custInfoPo.getDelFlag());
        if (!oldCustInfo.getOrgId().equals(orgInfo.getOrgId())) {
            userInfoPo.setOrgId(orgInfo.getOrgId());
            userInfoPo.setCompanyId(orgInfo.getCompanyId());
            userInfoPo.setOrgTreePath(orgInfo.getOrgTreePath());
        }
        updateUserInfoList.add(userInfoPo);
        return userInfoPo;
    }

    private SmcUmcCustInfoPo updateCustInfo(SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO, SmcUmcUserInfoDO oldCustInfo, List<SmcUmcCustInfoPo> updateCustInfoList) {
        SmcUmcCustInfoPo custInfoPo = (SmcUmcCustInfoPo)SmcRu.js((Object)dealSupplierUserInfoBO, SmcUmcCustInfoPo.class);
        custInfoPo.setCustId(oldCustInfo.getCustId());
        custInfoPo.setPasswd(null);
        if (ObjectUtil.isNotEmpty((Object)dealSupplierUserInfoBO.getUpdateOperId())) {
            custInfoPo.setUpdateOperId(dealSupplierUserInfoBO.getUpdateOperId());
        } else {
            custInfoPo.setUpdateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isNotEmpty((Object)dealSupplierUserInfoBO.getUpdateOperName())) {
            custInfoPo.setUpdateOperName(dealSupplierUserInfoBO.getUpdateOperName());
        } else {
            custInfoPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isNotEmpty((Object)dealSupplierUserInfoBO.getUpdateTime())) {
            custInfoPo.setUpdateTime(dealSupplierUserInfoBO.getUpdateTime());
        } else {
            custInfoPo.setUpdateTime(new Date());
        }
        updateCustInfoList.add(custInfoPo);
        return custInfoPo;
    }

    private void insertUserRole(SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO, SmcUmcUserInfoPo userInfoPo, Map<String, SmcSysRoleInfoPo> roleInfoMap, SmcUmcCustInfoPo custInfoPo, SmcUmcOrgInfoDO orgInfo, List<SmcSysAuthDistributePo> insertUserRoleList, List<Long> oldRoleList) {
        if (ObjectUtil.isEmpty(dealSupplierUserInfoBO.getAuthIdentityList())) {
            for (String roleCode : dealSupplierUserInfoBO.getAuthIdentityList()) {
                if (!roleInfoMap.containsKey(roleCode) || ObjectUtil.isNotEmpty(oldRoleList) && oldRoleList.contains(roleInfoMap.get(roleCode).getRoleId())) continue;
                SmcSysAuthDistributePo userRolePo = new SmcSysAuthDistributePo();
                userRolePo.setAuthId(Long.valueOf(SmcIdUtil.nextId()));
                userRolePo.setUserId(userInfoPo.getUserId());
                userRolePo.setRoleId(roleInfoMap.get(roleCode).getRoleId());
                userRolePo.setDisFlag(SmcUmcConstants.AuthDisFlag.USER);
                userRolePo.setOrgExtend(SmcUmcConstants.AuthOrgExtend.NO);
                userRolePo.setDisAgFlag(SmcUmcConstants.AuthDisAgFlag.VIEW);
                userRolePo.setCreateTime(custInfoPo.getCreateTime());
                userRolePo.setCreateOperId(custInfoPo.getCreateOperId());
                userRolePo.setCreateOperName(custInfoPo.getCreateOperName());
                userRolePo.setDelFlag(custInfoPo.getDelFlag());
                userRolePo.setManageLevel(orgInfo.getManageLevel());
                insertUserRoleList.add(userRolePo);
            }
        }
    }

    private void insertUserTag(SmcUmcOrgInfoDO orgInfo, SmcUmcUserInfoPo userInfoPo, SmcUmcCustInfoPo custInfoPo, List<SmcUmcUserTagRelPo> insertUserTagList, List<String> oldTagList) {
        for (SmcUmcOrgTagRelDO orgTag : orgInfo.getOrgTagRelList()) {
            if (ObjectUtil.isNotEmpty(oldTagList) && oldTagList.contains(orgTag.getTagId())) continue;
            SmcUmcUserTagRelPo userTagRelPo = new SmcUmcUserTagRelPo();
            userTagRelPo.setRelId(Long.valueOf(SmcIdUtil.nextId()));
            userTagRelPo.setUserId(userInfoPo.getUserId());
            userTagRelPo.setTenantId(custInfoPo.getTenantId());
            userTagRelPo.setTagId(orgTag.getTagId());
            userTagRelPo.setIsDefalt("0");
            userTagRelPo.setCreateTime(custInfoPo.getCreateTime());
            userTagRelPo.setCreateOperId(custInfoPo.getCreateOperId());
            userTagRelPo.setCreateOperName(custInfoPo.getCreateOperName());
            userTagRelPo.setDelFlag(custInfoPo.getDelFlag());
            if ("2".equals(orgTag.getTagId())) {
                userTagRelPo.setIsDefalt("1");
            }
            insertUserTagList.add(userTagRelPo);
        }
    }

    private SmcUmcUserInfoPo insertUserInfo(SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO, SmcUmcCustInfoPo custInfoPo, SmcUmcOrgInfoDO orgInfo, List<SmcUmcUserInfoPo> insertUserInfoList) {
        SmcUmcUserInfoPo userInfoPo = (SmcUmcUserInfoPo)SmcRu.js((Object)dealSupplierUserInfoBO, SmcUmcUserInfoPo.class);
        userInfoPo.setUserId(Long.valueOf(SmcIdUtil.nextId()));
        userInfoPo.setCustId(custInfoPo.getCustId());
        userInfoPo.setMainCustId(userInfoPo.getCustId());
        userInfoPo.setCompanyId(orgInfo.getCompanyId());
        userInfoPo.setOrgId(orgInfo.getOrgId());
        userInfoPo.setOrgTreePath(orgInfo.getOrgTreePath());
        userInfoPo.setUserType(custInfoPo.getCustType());
        userInfoPo.setAuthorityType(authorityType);
        userInfoPo.setIsMain("1");
        userInfoPo.setCreateTime(custInfoPo.getCreateTime());
        userInfoPo.setCreateOperId(custInfoPo.getCreateOperId());
        userInfoPo.setCreateOperName(custInfoPo.getCreateOperName());
        userInfoPo.setDelFlag(custInfoPo.getDelFlag());
        insertUserInfoList.add(userInfoPo);
        return userInfoPo;
    }

    private SmcUmcCustInfoPo insertCustInfo(SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO, List<SmcUmcCustInfoPo> insertCustInfoList) {
        SmcUmcCustInfoPo custInfoPo = (SmcUmcCustInfoPo)SmcRu.js((Object)dealSupplierUserInfoBO, SmcUmcCustInfoPo.class);
        custInfoPo.setCustId(Long.valueOf(SmcIdUtil.nextId()));
        custInfoPo.setIsOnline("0");
        custInfoPo.setIsPasswdValid("0");
        custInfoPo.setMaxRepeatLoginNum(this.maxRepeatLoginNum);
        custInfoPo.setInitialPassword(this.initialPassword);
        custInfoPo.setDelFlag("0");
        if (ObjectUtil.isNotEmpty((Object)custInfoPo.getPasswd())) {
            custInfoPo.setIsPasswdValid("1");
            custInfoPo.setInitialPassword(null);
        }
        if (ObjectUtil.isEmpty((Object)dealSupplierUserInfoBO.getCreateOperId())) {
            custInfoPo.setCreateOperId(dealSupplierUserInfoBO.getCreateOperId());
        } else {
            custInfoPo.setCreateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isEmpty((Object)dealSupplierUserInfoBO.getCreateOperName())) {
            custInfoPo.setCreateOperName(dealSupplierUserInfoBO.getCreateOperName());
        } else {
            custInfoPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isEmpty((Object)dealSupplierUserInfoBO.getCreateTime())) {
            custInfoPo.setCreateTime(dealSupplierUserInfoBO.getCreateTime());
        } else {
            custInfoPo.setCreateTime(new Date());
        }
        custInfoPo.setDelFlag("1");
        insertCustInfoList.add(custInfoPo);
        return custInfoPo;
    }

    private boolean dealMaxCount(SmcUmcDealSupplierUserInfoBO dealSupplierUserInfoBO, Map<String, SmcUmcOrgInfoDO> orgInfoMap, Map<Long, String> failResultMap) {
        if (dealSupplierUserInfoBO.getCurrentDealCount() > this.dealUserMaxCount) {
            if (orgInfoMap.containsKey(dealSupplierUserInfoBO.getOrgCode())) {
                failResultMap.put(dealSupplierUserInfoBO.getId(), "\u5904\u7406\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff0c\u6570\u636e\u65e0\u6cd5\u5904\u7406");
            } else {
                failResultMap.put(dealSupplierUserInfoBO.getId(), "\u5904\u7406\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff0c\u6240\u5c5e\u673a\u6784\u3010" + dealSupplierUserInfoBO.getOrgCode() + "\u3011\u4e0d\u5b58\u5728");
            }
            return true;
        }
        return false;
    }
}

