/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.base.wordfilter;

public class FilterSet {
    private final long[] elements = new long[1024];

    FilterSet() {
    }

    public void add(int no) {
        int n = no >>> 6;
        this.elements[n] = this.elements[n] | 1L << (no & 0x3F);
    }

    public void add(int ... no) {
        for (int currNo : no) {
            int n = currNo >>> 6;
            this.elements[n] = this.elements[n] | 1L << (currNo & 0x3F);
        }
    }

    public void remove(int no) {
        int n = no >>> 6;
        this.elements[n] = this.elements[n] & (1L << (no & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean addAndNotify(int no) {
        int eWordNum = no >>> 6;
        long oldElements = this.elements[eWordNum];
        int n = eWordNum;
        this.elements[n] = this.elements[n] | 1L << (no & 0x3F);
        return this.elements[eWordNum] != oldElements;
    }

    public boolean removeAndNotify(int no) {
        int eWordNum = no >>> 6;
        long oldElements = this.elements[eWordNum];
        int n = eWordNum;
        this.elements[n] = this.elements[n] & (1L << (no & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        return this.elements[eWordNum] != oldElements;
    }

    boolean contains(int no) {
        return (this.elements[no >>> 6] & 1L << (no & 0x3F)) == 0L;
    }

    public int size() {
        int size = 0;
        for (long element : this.elements) {
            size += Long.bitCount(element);
        }
        return size;
    }
}

