/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.admmanager;

import com.tydic.dyc.authority.model.admmanager.ISysAdministratorModel;
import com.tydic.dyc.authority.model.admmanager.SysAdmOrgRelDo;
import com.tydic.dyc.authority.model.authDistribute.ISysAuthDistributeModel;
import com.tydic.dyc.authority.model.authDistribute.SysAuthDistributeDo;
import com.tydic.dyc.authority.service.admmanager.AuthCreateAdministratorService;
import com.tydic.dyc.authority.service.admmanager.bo.AuthCreateAdministratorServiceReqBo;
import com.tydic.dyc.authority.service.admmanager.bo.AuthCreateAdministratorServiceRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.admmanager.AuthCreateAdministratorService"})
public class AuthCreateAdministratorServiceImpl
implements AuthCreateAdministratorService {
    @Autowired
    private ISysAdministratorModel iSysAdministratorModel;
    @Autowired
    private ISysAuthDistributeModel iSysAuthDistributeModel;
    @Value(value="${default_manager_role:4}")
    private Long default_manager_role;
    @Value(value="${default_manager_type:auth:org:manage}")
    private String default_manager_type;
    @Autowired
    private IUmcUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"createAdministrator"})
    public AuthCreateAdministratorServiceRspBo createAdministrator(@RequestBody AuthCreateAdministratorServiceReqBo reqBo) {
        this.validateArg(reqBo);
        SysAdmOrgRelDo js = AuthRu.js(reqBo, SysAdmOrgRelDo.class);
        Date date = new Date();
        js.setCreateOperId(reqBo.getUserIdIn());
        js.setCreateOperName(reqBo.getUserName());
        js.setCreateTime(date);
        js.setAdmOrgRelId(IdUtil.nextId());
        SysAdmOrgRelDo sysAdmOrgRelDo = this.iSysAdministratorModel.addAdministrator(js);
        SysAuthDistributeDo sysAuthDistributeDo = new SysAuthDistributeDo();
        sysAuthDistributeDo.setAuthId(IdUtil.nextId());
        sysAuthDistributeDo.setRoleId(this.default_manager_role);
        sysAuthDistributeDo.setUserId(reqBo.getUserId());
        sysAuthDistributeDo.setDisFlag(1);
        sysAuthDistributeDo.setDelFlag("0");
        sysAuthDistributeDo.setCreateOperId(reqBo.getUserIdIn());
        sysAuthDistributeDo.setCreateOperName(reqBo.getUserName());
        sysAuthDistributeDo.setCreateTime(new Date());
        sysAuthDistributeDo.setDisAgFlag(1);
        sysAuthDistributeDo.setManageLevel(100);
        this.iSysAuthDistributeModel.insert(sysAuthDistributeDo);
        UmcUserInfoDo sysUserInfoDo = new UmcUserInfoDo();
        sysUserInfoDo.setUserId(reqBo.getUserId());
        sysUserInfoDo.setAuthorityType(this.default_manager_type);
        this.iSysUserInfoModel.modifyUserInfo(sysUserInfoDo);
        return AuthRu.success(AuthCreateAdministratorServiceRspBo.class);
    }

    private void validateArg(AuthCreateAdministratorServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateAdministratorServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

