/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.sub.SysBusiObjField;
import com.tydic.dyc.authority.service.role.AuthBusiObjFieldSyncService;
import com.tydic.dyc.authority.service.role.bo.AuthBusiObjFieldSyncReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthBusiObjFieldSyncRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthBusiObjFieldSyncService"})
public class AuthBusiObjFieldSyncServiceImpl
implements AuthBusiObjFieldSyncService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"syncBusiObjField"})
    public AuthBusiObjFieldSyncRspBo syncBusiObjField(@RequestBody AuthBusiObjFieldSyncReqBo reqBo) {
        AuthBusiObjFieldSyncRspBo rspBo = AuthRu.success(AuthBusiObjFieldSyncRspBo.class);
        if (CollectionUtils.isEmpty((Collection)reqBo.getBusiObjList())) {
            return rspBo;
        }
        this.validateArg(reqBo);
        List list = reqBo.getBusiObjList();
        List<SysBusiObjField> busiObjFieldList = list.stream().map(fiel -> {
            SysBusiObjField field = new SysBusiObjField();
            field.setBusiObjCode(fiel.getBusiObjCode());
            return field;
        }).collect(Collectors.toList());
        SysRoleInfoDo reqDo = new SysRoleInfoDo();
        reqDo.setBusiObjFieldList(busiObjFieldList);
        this.iSysRoleInfoModel.deleteBusiObjField(reqDo);
        List<SysBusiObjField> jsl = AuthRu.jsl(list, SysBusiObjField.class);
        for (SysBusiObjField field : jsl) {
            if (field.getId() == null) {
                field.setId(IdUtil.nextId());
            }
            field.setDelFlag("0");
        }
        reqDo.setBusiObjFieldList(jsl);
        this.iSysRoleInfoModel.addBusiObjField(reqDo);
        return rspBo;
    }

    private void validateArg(AuthBusiObjFieldSyncReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthBusiObjFieldSyncReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBusiObjList() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[busiObjList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

