/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import cn.hutool.core.convert.Convert;
import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthRoleMenuDataOrgSubDo;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuDataAuthSubDo;
import com.tydic.dyc.authority.service.role.AuthUserDataPowerQryService;
import com.tydic.dyc.authority.service.role.bo.AuthUserDataPowerQryReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthUserDataPowerQryRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryRspBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgTagRelQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthUserDataPowerQryService"})
public class AuthUserDataPowerQryServiceImpl
implements AuthUserDataPowerQryService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    private static final String SELF = "0";
    private static final String OTHER = "1";
    @Autowired
    private IUmcEnterpriseInfoModel iSysOrgInfoModel;
    private static final Long ORG_TYPE_GROUP = 1L;
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"qryUserDataPower"})
    public AuthUserDataPowerQryRspBo qryUserDataPower(@RequestBody AuthUserDataPowerQryReqBo reqBo) {
        this.val(reqBo);
        if (null == reqBo.getMenuId()) {
            reqBo.setMenuId(this.qryMenuId(reqBo.getMenuCode()));
        }
        AuthUserDataPowerQryRspBo authUserDataPowerQryRspBo = AuthRu.success(AuthUserDataPowerQryRspBo.class);
        HashMap<Long, String> extendOrgIdTreesMap = new HashMap<Long, String>();
        HashMap<Long, String> notExtendOrgIdTreesMap = new HashMap<Long, String>();
        boolean selfFlag = false;
        SysRoleInfoQryBo sysRoleInfoQryBo = new SysRoleInfoQryBo();
        sysRoleInfoQryBo.setRoleIds(reqBo.getRoleIds());
        sysRoleInfoQryBo.setMenuId(reqBo.getMenuId());
        List roleMenuDataAuthList = this.iSysRoleInfoModel.getRoleMenuDataAuthList(sysRoleInfoQryBo).getRows();
        ArrayList<Long> listAuthId = new ArrayList<Long>();
        HashSet<String> authItemSubSet = new HashSet<String>();
        for (SysRoleMenuDataAuthSubDo sysRoleMenuDataAuthSubDo : roleMenuDataAuthList) {
            if (SELF.equals(sysRoleMenuDataAuthSubDo.getDataAuthItem())) {
                authItemSubSet.add(sysRoleMenuDataAuthSubDo.getDataAuthItemSub());
            }
            if (!OTHER.equals(sysRoleMenuDataAuthSubDo.getDataAuthItem())) continue;
            listAuthId.add(sysRoleMenuDataAuthSubDo.getDataAuthId());
        }
        if (!CollectionUtils.isEmpty(authItemSubSet)) {
            UmcEnterpriseInfoDo sysOrgInfoDo = new UmcEnterpriseInfoDo();
            sysOrgInfoDo.setOrgTreePathList(Collections.singletonList(reqBo.getOrgTreePathIn()));
            sysOrgInfoDo.setOrderBy("org_tree_path desc");
            UmcEnterpriseInfoQryRspBo sysOrgInfoListRspBo = this.iSysOrgInfoModel.getList(sysOrgInfoDo);
            if (!CollectionUtils.isEmpty((Collection)sysOrgInfoListRspBo.getRows())) {
                UmcEnterpriseInfoDo localOrgInfo = (UmcEnterpriseInfoDo)((Object)sysOrgInfoListRspBo.getRows().get(0));
                Long groupOrgId = null;
                String groupOrgTreePath = null;
                for (UmcEnterpriseInfoDo orgInfoDo : sysOrgInfoListRspBo.getRows()) {
                    if (!ORG_TYPE_GROUP.equals(orgInfoDo.getOrgType())) continue;
                    groupOrgId = orgInfoDo.getOrgId();
                    groupOrgTreePath = orgInfoDo.getOrgTreePath();
                    break;
                }
                for (String dataAuthItemSub : authItemSubSet) {
                    if (OTHER.equals(dataAuthItemSub) && null != groupOrgId) {
                        extendOrgIdTreesMap.putIfAbsent(groupOrgId, groupOrgTreePath);
                    }
                    if (SELF.equals(dataAuthItemSub)) {
                        selfFlag = true;
                    }
                    if ("2".equals(dataAuthItemSub)) {
                        notExtendOrgIdTreesMap.putIfAbsent(localOrgInfo.getCompanyId(), localOrgInfo.getOrgTreePath());
                    }
                    if ("3".equals(dataAuthItemSub)) {
                        notExtendOrgIdTreesMap.putIfAbsent(localOrgInfo.getOrgId(), localOrgInfo.getOrgTreePath());
                    }
                    if (!"4".equals(dataAuthItemSub)) continue;
                    extendOrgIdTreesMap.putIfAbsent(localOrgInfo.getOrgId(), localOrgInfo.getOrgTreePath());
                }
            }
        }
        if (!CollectionUtils.isEmpty(listAuthId)) {
            SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
            qryBo.setAuthIds(listAuthId);
            SysRoleInfoDo authRoleMenuDataOrgList = this.iSysRoleInfoModel.getAuthRoleMenuDataOrgList(qryBo);
            List<SysAuthRoleMenuDataOrgSubDo> roleMenuDataOrgList = authRoleMenuDataOrgList.getAuthRoleMenuDataOrgList();
            roleMenuDataOrgList.forEach(sysAuthRoleMenuDataOrgSubDo -> {
                if (AuthConstant.ORG_EXTEND.YES.equals(sysAuthRoleMenuDataOrgSubDo.getOrgExtend())) {
                    extendOrgIdTreesMap.putIfAbsent(sysAuthRoleMenuDataOrgSubDo.getOrgId(), sysAuthRoleMenuDataOrgSubDo.getOrgTreePath());
                } else {
                    notExtendOrgIdTreesMap.putIfAbsent(sysAuthRoleMenuDataOrgSubDo.getOrgId(), sysAuthRoleMenuDataOrgSubDo.getOrgTreePath());
                }
            });
            Iterator iterator = notExtendOrgIdTreesMap.entrySet().iterator();
            block3: while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                for (String sOrgId : ((String)next.getValue()).split("-")) {
                    if (null == extendOrgIdTreesMap.get(Convert.toLong((Object)sOrgId))) continue;
                    iterator.remove();
                    continue block3;
                }
            }
        }
        this.buildRspBo(notExtendOrgIdTreesMap, extendOrgIdTreesMap, authUserDataPowerQryRspBo);
        authUserDataPowerQryRspBo.setSeflFlag(Boolean.valueOf(selfFlag));
        return authUserDataPowerQryRspBo;
    }

    private Long qryMenuId(String menuCode) {
        SysMenuQryBo sysMenuQryBo = new SysMenuQryBo();
        sysMenuQryBo.setMenuCode(menuCode);
        sysMenuQryBo.setApplicationCode("dyc");
        SysMenuDo sysMenuDo = this.iSysMenuModel.getMenuInfoDetails(sysMenuQryBo);
        if (null == sysMenuDo || null == sysMenuDo.getMenuId()) {
            throw new BaseBusinessException("100001", "\u83b7\u53d6\u83dc\u5355id\u5931\u8d25");
        }
        return sysMenuDo.getMenuId();
    }

    private void buildRspBo(Map<Long, String> notExtendOrgIdTreesMap, Map<Long, String> extendOrgIdTreesMap, AuthUserDataPowerQryRspBo authUserDataPowerQryRspBo) {
        if (CollectionUtils.isEmpty(notExtendOrgIdTreesMap) && CollectionUtils.isEmpty(extendOrgIdTreesMap)) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.addAll(extendOrgIdTreesMap.keySet());
        orgIds.addAll(notExtendOrgIdTreesMap.keySet());
        UmcEnterpriseInfoDo sysOrgInfoDo = new UmcEnterpriseInfoDo();
        sysOrgInfoDo.setOrgIds(orgIds);
        UmcEnterpriseInfoQryRspBo sysOrgInfoListRspBo = this.iSysOrgInfoModel.getList(sysOrgInfoDo);
        Map orgBelongCompanyMap = sysOrgInfoListRspBo.getRows().stream().collect(Collectors.groupingByConcurrent(UmcEnterpriseInfoDo::getCompanyId));
        List<UmcOrgTagRel> sysOrgTagRelSubDos = this.qryOrgTagList(new ArrayList<Long>(orgBelongCompanyMap.keySet()));
        ArrayList purExtendOrgIds = new ArrayList();
        ArrayList purNotExtendOrgIds = new ArrayList();
        ArrayList proExtendOrgIds = new ArrayList();
        ArrayList proNotExtendOrgIds = new ArrayList();
        ArrayList supExtendOrgIds = new ArrayList();
        ArrayList supNotExtendOrgIds = new ArrayList();
        sysOrgTagRelSubDos.forEach(sysOrgTagRelSubDo -> {
            if (SELF.equals(Convert.toStr((Object)sysOrgTagRelSubDo.getTagId()))) {
                this.buildRspOrgList(proNotExtendOrgIds, notExtendOrgIdTreesMap, orgBelongCompanyMap, sysOrgTagRelSubDo.getOrgId());
                this.buildRspOrgList(proExtendOrgIds, extendOrgIdTreesMap, orgBelongCompanyMap, sysOrgTagRelSubDo.getOrgId());
            }
            if (OTHER.equals(Convert.toStr((Object)sysOrgTagRelSubDo.getTagId()))) {
                this.buildRspOrgList(purNotExtendOrgIds, notExtendOrgIdTreesMap, orgBelongCompanyMap, sysOrgTagRelSubDo.getOrgId());
                this.buildRspOrgList(purExtendOrgIds, extendOrgIdTreesMap, orgBelongCompanyMap, sysOrgTagRelSubDo.getOrgId());
            }
            if ("2".equals(Convert.toStr((Object)sysOrgTagRelSubDo.getTagId()))) {
                this.buildRspOrgList(supNotExtendOrgIds, notExtendOrgIdTreesMap, orgBelongCompanyMap, sysOrgTagRelSubDo.getOrgId());
                this.buildRspOrgList(supExtendOrgIds, extendOrgIdTreesMap, orgBelongCompanyMap, sysOrgTagRelSubDo.getOrgId());
            }
        });
        authUserDataPowerQryRspBo.setProExtendOrgIds(proExtendOrgIds);
        authUserDataPowerQryRspBo.setProNotExtendOrgIds(proNotExtendOrgIds);
        authUserDataPowerQryRspBo.setPurExtendOrgIds(purExtendOrgIds);
        authUserDataPowerQryRspBo.setPurNotExtendOrgIds(purNotExtendOrgIds);
        authUserDataPowerQryRspBo.setSupExtendOrgIds(supExtendOrgIds);
        authUserDataPowerQryRspBo.setSupNotExtendOrgIds(supNotExtendOrgIds);
    }

    private void buildRspOrgList(List<Long> orgIdList, Map<Long, String> orgTreeMap, Map<Long, List<UmcEnterpriseInfoDo>> orgBelongCompanyMap, Long orgId) {
        List<UmcEnterpriseInfoDo> sysOrgInfoDos = orgBelongCompanyMap.get(orgId);
        if (!CollectionUtils.isEmpty(sysOrgInfoDos)) {
            for (UmcEnterpriseInfoDo sysOrgInfoDo : sysOrgInfoDos) {
                if (null == orgTreeMap.get(sysOrgInfoDo.getOrgId())) continue;
                orgIdList.add(sysOrgInfoDo.getOrgId());
            }
        }
    }

    private void val(AuthUserDataPowerQryReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgTreePathIn())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u673a\u6784\u6811\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getRoleIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u89d2\u8272ID\u96c6\u5408\u4e0d\u4e3a\u7a7a");
        }
        if (null == reqBo.getMenuId() && StringUtils.isBlank((CharSequence)reqBo.getMenuCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u83dc\u5355ID\u548c\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    private List<UmcOrgTagRel> qryOrgTagList(List<Long> orgIdList) {
        UmcOrgTagRelQryBo sysOrgTagRelQryBo = new UmcOrgTagRelQryBo();
        sysOrgTagRelQryBo.setOrgIdList(orgIdList);
        UmcEnterpriseInfoDo sysOrgInfoDo = this.iSysOrgInfoModel.getOrgTagList(sysOrgTagRelQryBo);
        if (CollectionUtils.isEmpty(sysOrgInfoDo.getOrgTagList())) {
            throw new BaseBusinessException("102101", "\u673a\u6784\u8eab\u4efd\u67e5\u8be2\u4e3a\u7a7a");
        }
        return sysOrgInfoDo.getOrgTagList();
    }
}

