/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.service.enterprise.UmcAddEnterpriseBankService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcAddEnterpriseBankReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcAddEnterpriseBankRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcBankBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.umc.service.enterprise.UmcAddEnterpriseBankService"})
public class UmcAddEnterpriseBankServiceImpl
implements UmcAddEnterpriseBankService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"addBank"})
    public UmcAddEnterpriseBankRspBo addBank(@RequestBody UmcAddEnterpriseBankReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcBankBoList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        for (UmcBankBo umcBankBo : reqBo.getUmcBankBoList()) {
            if (null == umcBankBo) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)umcBankBo.getBankAccount())) {
                throw new BaseBusinessException("0001", "\u94f6\u884c\u8d26\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)umcBankBo.getBankName())) continue;
            throw new BaseBusinessException("0001", "\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
        umcEnterpriseInfoDo.setEnterpriseBankList(UmcRu.jsl(reqBo.getUmcBankBoList(), UmcEnterpriseBank.class));
        for (UmcEnterpriseBank umcEnterpriseBank : umcEnterpriseInfoDo.getEnterpriseBankList()) {
            umcEnterpriseBank.setBankId(IdUtil.nextId());
            umcEnterpriseBank.setDelFlag("0");
        }
        this.iUmcEnterpriseInfoModel.createEnterpriseBank(umcEnterpriseInfoDo);
        return UmcRu.success(UmcAddEnterpriseBankRspBo.class);
    }
}

