/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.repository.dao.SysAdmOrgRelMapper;
import com.tydic.dyc.authority.repository.dao.SysAuthDistributeMapper;
import com.tydic.dyc.authority.repository.dao.SysLoginLogMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysThirdBindMapper;
import com.tydic.dyc.authority.repository.dao.SysUserChngLogMapper;
import com.tydic.dyc.authority.repository.po.SysAdmOrgRelPo;
import com.tydic.dyc.authority.repository.po.SysAuthDistributePo;
import com.tydic.dyc.authority.repository.po.SysAuthRoleInfoPo;
import com.tydic.dyc.authority.repository.po.SysLoginLogPo;
import com.tydic.dyc.authority.repository.po.SysRoleInfoPo;
import com.tydic.dyc.authority.repository.po.SysThirdBindPo;
import com.tydic.dyc.authority.repository.po.SysUserChngLogPo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.user.AuthUserRoleStationListDo;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.AuthQryUserByOrgAndRoleBo;
import com.tydic.dyc.umc.model.user.qrybo.AuthQryUserByOrgAndRoleReqBo;
import com.tydic.dyc.umc.model.user.qrybo.AuthQryUserByOrgAndRoleRspBo;
import com.tydic.dyc.umc.model.user.qrybo.AuthUserRoleStationListQryBO;
import com.tydic.dyc.umc.model.user.qrybo.SysThirdBindQryBo;
import com.tydic.dyc.umc.model.user.qrybo.SysUserChngLogQryBo;
import com.tydic.dyc.umc.model.user.qrybo.SysUserChngLogSubListRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcAdmUserQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcAdmUserSubRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustExtMapQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoSubListRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoSyncListQryReqBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoSyncListQryRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustUserQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcMemberQryListPageQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserByRoleAndOrgQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoListRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserListAdmQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserListAdmSubListRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserRoleRelQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserTagRelQryBo;
import com.tydic.dyc.umc.model.user.sub.AuthUserRoleStationListRspDO;
import com.tydic.dyc.umc.model.user.sub.SysThirdBindSubDo;
import com.tydic.dyc.umc.model.user.sub.SysUserChngLogSubDo;
import com.tydic.dyc.umc.model.user.sub.UmcAdmUserSubDo;
import com.tydic.dyc.umc.model.user.sub.UmcBatchAddUser;
import com.tydic.dyc.umc.model.user.sub.UmcCustExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcCustExtMapSubDo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfoSubDo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfoSyncTemp;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfos;
import com.tydic.dyc.umc.model.user.sub.UmcCustUserSubDo;
import com.tydic.dyc.umc.model.user.sub.UmcCustUserSubListRspDo;
import com.tydic.dyc.umc.model.user.sub.UmcMember;
import com.tydic.dyc.umc.model.user.sub.UmcMemberQryListPageRspBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserInfoDos;
import com.tydic.dyc.umc.model.user.sub.UmcUserInfoQryRspBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserListAdmSubDo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRelListBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRelDos;
import com.tydic.dyc.umc.repository.UmcUserInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcCustExtMapMapper;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoSyncTempMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserExtMapMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserPartJobBatchMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserPartJobSyncTempLogMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserPartJobSyncTempMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserRoleRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcCustExtMapPo;
import com.tydic.dyc.umc.repository.po.UmcCustInfoPo;
import com.tydic.dyc.umc.repository.po.UmcCustInfoSyncTempPO;
import com.tydic.dyc.umc.repository.po.UmcCustUserPo;
import com.tydic.dyc.umc.repository.po.UmcCustUserSubPo;
import com.tydic.dyc.umc.repository.po.UmcMemberPo;
import com.tydic.dyc.umc.repository.po.UmcMemberQryListPageQryPo;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserExtMapPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserPartJobBatchPo;
import com.tydic.dyc.umc.repository.po.UmcUserPartJobSyncTempLogPo;
import com.tydic.dyc.umc.repository.po.UmcUserPartJobSyncTempPo;
import com.tydic.dyc.umc.repository.po.UmcUserRoleRelPo;
import com.tydic.dyc.umc.repository.po.UmcUserTagRelPo;
import com.tydic.dyc.umc.service.user.bo.UmcAddCustPartJobBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobSyncBatchFinishReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempDealReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempDealRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempResultUpdateReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcGetCustPartJobTempListReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcGetCustPartJobTempListRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcPartJobUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcPartJobUserRoleBo;
import com.tydic.dyc.umc.service.user.bo.UmcPartJobUserTagRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcUserInfoRepositoryImpl
implements UmcUserInfoRepository {
    @Autowired
    private UmcCustExtMapMapper umcCustExtMapMapper;
    @Autowired
    private UmcCustInfoMapper umcCustInfoMapper;
    @Autowired
    private UmcUserExtMapMapper umcUserExtMapMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private UmcUserRoleRelMapper umcUserRoleRelMapper;
    @Autowired
    private UmcUserTagRelMapper umcUserTagRelMapper;
    @Autowired
    private UmcCustInfoSyncTempMapper umcCustInfoSyncTempMapper;
    @Autowired
    private UmcUserPartJobSyncTempMapper umcUserPartJobSyncTempMapper;
    @Autowired
    private UmcUserPartJobBatchMapper umcUserPartJobBatchMapper;
    @Autowired
    private UmcUserPartJobSyncTempLogMapper umcUserPartJobSyncTempLogMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private SysAuthDistributeMapper sysAuthDistributeMapper;
    @Autowired
    private SysUserChngLogMapper sysUserChngLogMapper;
    @Autowired
    private SysRoleInfoMapper sysRoleInfoMapper;
    @Autowired
    SysAdmOrgRelMapper sysAdmOrgRelMapper;
    @Autowired
    private SysLoginLogMapper sysLoginLogMapper;
    @Autowired
    SysThirdBindMapper sysThirdBindMapper;
    @Value(value="${umc.part.job.cust.fail.times:3}")
    private int partJobFailTimes;
    @Value(value="${auth.part.job.user.role.default.ids:5}")
    private String defaultRoleIds;
    private static final Integer FINISH = 1;

    public UmcUserInfoDo createUserInfo(UmcUserInfoDo userInfoDo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)userInfoDo, UmcUserInfoPo.class);
        this.umcUserInfoMapper.insert(umcUserInfoPo);
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserTagRelList())) {
            List umcUserTagRelPoList = UmcRu.jsl((List)userInfoDo.getUserTagRelList(), UmcUserTagRelPo.class);
            this.umcUserTagRelMapper.insertBatch(umcUserTagRelPoList);
        }
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getSysAuthDistributeDoList())) {
            List sysAuthDistributePos = UmcRu.jsl((List)userInfoDo.getSysAuthDistributeDoList(), SysAuthDistributePo.class);
            this.sysAuthDistributeMapper.insertBatch(sysAuthDistributePos);
        }
        if (ObjectUtil.isNotEmpty((Object)userInfoDo.getUserExtMapList())) {
            List umcUserExtMapPoList = UmcRu.jsl((List)userInfoDo.getUserExtMapList(), UmcUserExtMapPo.class);
            this.umcUserExtMapMapper.insertBatch(umcUserExtMapPoList);
        }
        return userInfoDo;
    }

    public UmcCustInfo createCustInfo(UmcCustInfo custInfo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)custInfo, UmcCustInfoPo.class);
        this.umcCustInfoMapper.insert(umcCustInfoPo);
        if (ObjectUtil.isNotEmpty((Object)custInfo.getCustExtMapList())) {
            List umcCustExtMapPoList = UmcRu.jsl((List)custInfo.getCustExtMapList(), UmcCustExtMapPo.class);
            this.umcCustExtMapMapper.insertBatch(umcCustExtMapPoList);
        }
        return custInfo;
    }

    public void updateUserInfo(UmcUserInfoDo set) {
        UmcUserInfoPo setPo = (UmcUserInfoPo)UmcRu.js((Object)set, UmcUserInfoPo.class);
        UmcUserInfoPo wherePo = new UmcUserInfoPo();
        wherePo.setUserId(set.getUserId());
        StrUtil.noNullStringAttr((Object)setPo);
        StrUtil.noNullStringAttr((Object)wherePo);
        this.umcUserInfoMapper.updateBy(setPo, wherePo);
        if (ObjectUtil.isNotEmpty((Object)set.getUserRoleRelList())) {
            for (UmcUserRoleRel userRoleRel : set.getUserRoleRelList()) {
                UmcUserRoleRelPo umcUserRoleRelPo = (UmcUserRoleRelPo)UmcRu.js((Object)userRoleRel, UmcUserRoleRelPo.class);
                StrUtil.noNullStringAttr((Object)umcUserRoleRelPo);
                if (null == umcUserRoleRelPo.getRelId()) {
                    umcUserRoleRelPo.setRelId(IdUtil.nextId());
                    this.umcUserRoleRelMapper.insert(umcUserRoleRelPo);
                    continue;
                }
                int i = this.umcUserRoleRelMapper.updateById(umcUserRoleRelPo);
                if (i == 1) continue;
                throw new BaseBusinessException("203003", "\u7528\u6237\u66f4\u65b0\u5931\u8d25\uff0c\u66f4\u65b0\u7528\u6237\u89d2\u8272\u5931\u8d25\uff01");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)set.getUserExtMapList())) {
            for (UmcUserExtMap userExtMap : set.getUserExtMapList()) {
                UmcUserExtMapPo umcUserExtMapPo = (UmcUserExtMapPo)UmcRu.js((Object)userExtMap, UmcUserExtMapPo.class);
                StrUtil.noNullStringAttr((Object)umcUserExtMapPo);
                this.umcUserExtMapMapper.updateById(umcUserExtMapPo);
            }
        }
    }

    public void updateCustInfo(UmcCustInfo set) {
        UmcCustInfoPo setPo = (UmcCustInfoPo)UmcRu.js((Object)set, UmcCustInfoPo.class);
        UmcCustInfoPo wherePo = new UmcCustInfoPo();
        wherePo.setCustId(setPo.getCustId());
        StrUtil.noNullStringAttr((Object)setPo);
        if (StringUtils.isEmpty((CharSequence)setPo.getOfficePhone())) {
            setPo.setOfficePhone("");
        }
        if (StringUtils.isEmpty((CharSequence)setPo.getWorkNo())) {
            setPo.setWorkNo("");
        }
        StrUtil.noNullStringAttr((Object)wherePo);
        this.umcCustInfoMapper.updateBy(setPo, wherePo);
        if (ObjectUtil.isNotEmpty((Object)set.getCustExtMapList())) {
            for (UmcCustExtMap custExtMap : set.getCustExtMapList()) {
                UmcCustExtMapPo umcCustExtMapPo = (UmcCustExtMapPo)UmcRu.js((Object)custExtMap, UmcCustExtMapPo.class);
                StrUtil.noNullStringAttr((Object)umcCustExtMapPo);
                this.umcCustExtMapMapper.updateById(umcCustExtMapPo);
            }
        }
    }

    public UmcUserInfoDo getUserInfo(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        if (null == (umcUserInfoPo = this.umcUserInfoMapper.getModelBy(umcUserInfoPo))) {
            throw new BaseBusinessException("203004", "\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u7528\u6237\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcUserInfoDo userInfoDo = (UmcUserInfoDo)UmcRu.js((Object)umcUserInfoPo, UmcUserInfoDo.class);
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        if (!CollectionUtils.isEmpty(umcUserTagRelPoList)) {
            userInfoDo.setUserTagRelList(UmcRu.jsl(umcUserTagRelPoList, UmcUserTagRel.class));
        }
        SysAuthDistributePo userRoleRelPo = new SysAuthDistributePo();
        userRoleRelPo.setUserId(umcUserInfoPo.getUserId());
        List<SysAuthDistributePo> umcUserRoleRelPoList = this.sysAuthDistributeMapper.getList(userRoleRelPo);
        if (!CollectionUtils.isEmpty(umcUserRoleRelPoList)) {
            userInfoDo.setUserRoleRelList(UmcRu.jsl(umcUserRoleRelPoList, UmcUserRoleRel.class));
        }
        UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
        umcUserExtMapPo.setUserId(umcUserInfoPo.getUserId());
        List<UmcUserExtMapPo> umcUserExtMapPoList = this.umcUserExtMapMapper.getList(umcUserExtMapPo);
        if (!CollectionUtils.isEmpty(umcUserExtMapPoList)) {
            userInfoDo.setUserExtMapList(UmcRu.jsl(umcUserExtMapPoList, UmcUserExtMap.class));
        }
        return userInfoDo;
    }

    public UmcCustInfo getCustInfo(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        StrUtil.noNullStringAttr((Object)umcCustInfoPo);
        umcCustInfoPo = this.umcCustInfoMapper.getModelBy(umcCustInfoPo);
        if (ObjectUtil.isEmpty((Object)umcCustInfoPo)) {
            throw new BaseBusinessException("203004", "\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u5ba2\u6237\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcCustInfo custInfo = (UmcCustInfo)UmcRu.js((Object)umcCustInfoPo, UmcCustInfo.class);
        UmcCustExtMapPo umcCustExtMapPo = new UmcCustExtMapPo();
        umcCustExtMapPo.setCustId(umcCustInfoPo.getCustId());
        List<UmcCustExtMapPo> umcCustExtMapPoList = this.umcCustExtMapMapper.getList(umcCustExtMapPo);
        if (ObjectUtil.isNotEmpty(umcCustExtMapPoList)) {
            custInfo.setCustExtMapList(UmcRu.jsl(umcCustExtMapPoList, UmcCustExtMap.class));
        }
        return custInfo;
    }

    public UmcUserInfoDos getUserInfoPageList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        if (null != qryBo.getCustInfo()) {
            umcUserInfoPo.setRegAccount(qryBo.getCustInfo().getRegAccount());
            umcUserInfoPo.setRegMobile(qryBo.getCustInfo().getRegMobile());
            umcUserInfoPo.setCustName(qryBo.getCustInfo().getCustName());
        }
        StrUtil.noNullStringAttr((Object)umcUserInfoPo);
        List<UmcUserInfoDo> umcUserInfoDoList = this.umcUserInfoMapper.getListPage(umcUserInfoPo, (Page<UmcUserInfoPo>)page);
        if (!CollectionUtils.isEmpty(umcUserInfoDoList)) {
            for (UmcUserInfoDo row : umcUserInfoDoList) {
                if (StringUtils.isEmpty((CharSequence)row.getUserTagRel())) continue;
                List<String> userTagRels = Arrays.asList(row.getUserTagRel().split(","));
                List userTagRelList = userTagRels.stream().map(item -> {
                    UmcUserTagRel userTagRel = new UmcUserTagRel();
                    userTagRel.setUserId(row.getUserId());
                    userTagRel.setTagId(item);
                    return userTagRel;
                }).collect(Collectors.toList());
                row.setUserTagRelList(userTagRelList);
            }
        }
        UmcUserInfoDos rspBo = new UmcUserInfoDos();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(umcUserInfoDoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UmcCustInfos getCustInfoPageList(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getListPage(umcCustInfoPo, (Page<UmcCustInfoPo>)page);
        UmcCustInfos rspBo = new UmcCustInfos();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(umcCustInfoPoList) ? UmcRu.jsl(umcCustInfoPoList, UmcCustInfo.class) : new ArrayList(0));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UmcCustInfos getCustInfoList(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)qryBo, UmcCustInfoPo.class);
        List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getList(umcCustInfoPo);
        UmcCustInfos umcUserInfoDos = new UmcCustInfos();
        umcUserInfoDos.setRows(UmcRu.jsl(umcCustInfoPoList, UmcCustInfo.class));
        return umcUserInfoDos;
    }

    public UmcUserInfoDo getCheckUserInfo(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        int checkBy = this.umcUserInfoMapper.getCheckBy(umcUserInfoPo);
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        umcUserInfoDo.setCheck(Integer.valueOf(checkBy));
        return umcUserInfoDo;
    }

    public UmcUserTagRelDos getUserTagRel(UmcUserTagRelQryBo qryBo) {
        UmcUserTagRelPo umcUserTagRelPo = (UmcUserTagRelPo)UmcRu.js((Object)qryBo, UmcUserTagRelPo.class);
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        UmcUserTagRelDos umcUserTagRelDos = new UmcUserTagRelDos();
        umcUserTagRelDos.setRows(UmcRu.jsl(umcUserTagRelPoList, UmcUserTagRel.class));
        return umcUserTagRelDos;
    }

    public UmcUserRoleRelListBo getUserRoleRel(UmcUserRoleRelQryBo qryBo) {
        UmcUserRoleRelPo umcUserRoleRelPo = (UmcUserRoleRelPo)UmcRu.js((Object)qryBo, UmcUserRoleRelPo.class);
        List<UmcUserRoleRelPo> umcUserRoleRelPoList = this.umcUserRoleRelMapper.getList(umcUserRoleRelPo);
        UmcUserRoleRelListBo umcUserRoleRelListBo = new UmcUserRoleRelListBo();
        umcUserRoleRelListBo.setRows(UmcRu.jsl(umcUserRoleRelPoList, UmcUserRoleRel.class));
        return umcUserRoleRelListBo;
    }

    public UmcUserInfoQryRspBo getUserInfoList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(umcUserInfoPo);
        List rows = new ArrayList(umcUserInfoPoList.size());
        if (!CollectionUtils.isEmpty(umcUserInfoPoList)) {
            rows = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
            List<Long> custIdList = umcUserInfoPoList.stream().map(UmcUserInfoPo::getCustId).distinct().collect(Collectors.toList());
            Map custMap = new HashMap();
            UmcCustInfoPo umcCustInfoPo = new UmcCustInfoPo();
            umcCustInfoPo.setCustIdList(custIdList);
            List<UmcCustInfoPo> umcCustInfoPoList = this.umcCustInfoMapper.getList(umcCustInfoPo);
            if (!CollectionUtils.isEmpty(umcCustInfoPoList)) {
                custMap = umcCustInfoPoList.stream().collect(Collectors.toConcurrentMap(UmcCustInfoPo::getCustId, o -> o));
            }
            for (UmcUserInfoQryBo row : rows) {
                UmcCustInfoPo umcCustInfoPo1 = (UmcCustInfoPo)custMap.get(row.getCustId());
                if (null == umcCustInfoPo1) continue;
                row.setCustInfo((UmcCustInfo)UmcRu.js((Object)umcCustInfoPo1, UmcCustInfo.class));
            }
        }
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(rows);
        return umcUserInfoQryRspBo;
    }

    public UmcUserInfoQryRspBo getUserInfoWithoutCustList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(umcUserInfoPo);
        List rows = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(rows);
        return umcUserInfoQryRspBo;
    }

    public UmcMemberQryListPageRspBo qryMemberListPage(UmcMemberQryListPageQryBo qryBo) {
        UmcMemberQryListPageRspBo rspBo = new UmcMemberQryListPageRspBo();
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcMemberPo> list = this.umcUserInfoMapper.qryMemberListPage((UmcMemberQryListPageQryPo)((Object)UmcRu.js((Object)qryBo, UmcMemberQryListPageQryPo.class)), (Page<UmcMemberPo>)page);
        if (CollectionUtils.isEmpty(list)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        rspBo.setRows(UmcRu.jsl(list, UmcMember.class));
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRespCode("0000");
        rspBo.setPageNo(qryBo.getPageNo());
        return rspBo;
    }

    public UmcUserInfoDo getCheckCustInfo(UmcCustInfoQryBo umcCustInfoQryBo) {
        UmcCustInfoPo umcCustInfoPo = (UmcCustInfoPo)UmcRu.js((Object)umcCustInfoQryBo, UmcCustInfoPo.class);
        if (null == umcCustInfoQryBo.getNotCustId() && null != umcCustInfoQryBo.getUserId()) {
            UmcUserInfoPo umcUserInfoPo = this.umcUserInfoMapper.getCustIdByUserId(umcCustInfoQryBo.getUserId());
            if (null == umcUserInfoPo || null == umcUserInfoPo.getCustId()) {
                throw new BaseBusinessException("8888", "\u67e5\u8be2\u5ba2\u6237ID\u4e3a\u7a7a");
            }
            umcCustInfoPo.setNotCustId(umcUserInfoPo.getCustId());
        }
        int checkBy = this.umcCustInfoMapper.getCheckBy(umcCustInfoPo);
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        umcUserInfoDo.setCheck(Integer.valueOf(checkBy));
        return umcUserInfoDo;
    }

    public UmcUserTagRel addUserTagRel(UmcUserTagRel userTagRel) {
        if (null == userTagRel.getRelId()) {
            userTagRel.setRelId(Long.valueOf(IdUtil.nextId()));
        }
        UmcUserTagRelPo umcUserTagRelPo = (UmcUserTagRelPo)UmcRu.js((Object)userTagRel, UmcUserTagRelPo.class);
        this.umcUserTagRelMapper.insert(umcUserTagRelPo);
        return userTagRel;
    }

    public UmcUserTagRel updateUserTagRel(UmcUserTagRel set) {
        UmcUserTagRelPo setPo = (UmcUserTagRelPo)UmcRu.js((Object)set, UmcUserTagRelPo.class);
        UmcUserTagRelPo wherePo = new UmcUserTagRelPo();
        wherePo.setRelId(set.getRelId());
        wherePo.setUserId(set.getUserId());
        wherePo.setTagId(set.getTagId());
        this.umcUserTagRelMapper.updateBy(setPo, wherePo);
        return set;
    }

    public UmcUserInfoDos qryOrgUserByUserTag(UmcUserInfoQryBo qryBo) {
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.qryOrgUserByUserTag(qryBo);
        UmcUserInfoDos umcUserInfoDos = new UmcUserInfoDos();
        umcUserInfoDos.setRows(UmcRu.jsl(umcUserInfoPoList, UmcUserInfoDo.class));
        return umcUserInfoDos;
    }

    public void addCustInfoSyncTemp(UmcUserInfoDo umcUserInfoDo) {
        List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = umcUserInfoDo.getUmcCustInfoSyncTemps().stream().map(umcCustInfoSyncTemp -> {
            UmcCustInfoSyncTempPO umcCustInfoSyncTempPO = (UmcCustInfoSyncTempPO)UmcRu.js((Object)umcCustInfoSyncTemp, UmcCustInfoSyncTempPO.class);
            umcCustInfoSyncTempPO.setId(Sequence.getInstance().nextId());
            umcCustInfoSyncTempPO.setSyncTime(new Date());
            if (null == umcCustInfoSyncTemp.getDealResult()) {
                umcCustInfoSyncTempPO.setDealResult(UmcStatusConstant.SyncDealResult.TO_DEAL);
            }
            if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getUmcSyncExtBoList())) {
                umcCustInfoSyncTempPO.setExtField(JSONObject.toJSONString((Object)umcCustInfoSyncTemp.getUmcSyncExtBoList()));
            }
            if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getUmcUserSyncRoleBos())) {
                umcCustInfoSyncTempPO.setRoleJson(JSONObject.toJSONString((Object)umcCustInfoSyncTemp.getUmcUserSyncRoleBos()));
            }
            return umcCustInfoSyncTempPO;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(umcCustInfoSyncTempPOS)) {
            this.umcCustInfoSyncTempMapper.insertBatch(umcCustInfoSyncTempPOS);
        }
    }

    public UmcCustInfoSyncListQryRspBo qryCustInfoTempList(UmcCustInfoSyncListQryReqBo umcCustInfoSyncListQryReqBo) {
        Page poPag = new Page(umcCustInfoSyncListQryReqBo.getPageNo().intValue(), umcCustInfoSyncListQryReqBo.getPageSize().intValue());
        UmcCustInfoSyncTempPO umcCustInfoSyncTempPO = (UmcCustInfoSyncTempPO)UmcRu.js((Object)umcCustInfoSyncListQryReqBo, UmcCustInfoSyncTempPO.class);
        List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = this.umcCustInfoSyncTempMapper.getListPageTemp(umcCustInfoSyncTempPO, (Page<UmcCustInfoSyncTempPO>)poPag);
        UmcCustInfoSyncListQryRspBo umcCustInfoSyncListQryRspBo = new UmcCustInfoSyncListQryRspBo();
        umcCustInfoSyncListQryRspBo.setRows(UmcRu.jsl(umcCustInfoSyncTempPOS, UmcCustInfoSyncTemp.class));
        umcCustInfoSyncListQryRspBo.setPageNo(umcCustInfoSyncListQryReqBo.getPageNo().intValue());
        umcCustInfoSyncListQryRspBo.setTotal(poPag.getTotalPages());
        umcCustInfoSyncListQryRspBo.setRecordsTotal(poPag.getTotalCount());
        return umcCustInfoSyncListQryRspBo;
    }

    public void updateCustSyncInfoTempState(UmcUserInfoDo umcUserInfoDo) {
        UmcCustInfoSyncTemp umcCustInfoSyncTemp = umcUserInfoDo.getUmcCustInfoSyncTemp();
        if (!CollectionUtils.isEmpty((Collection)umcCustInfoSyncTemp.getIds())) {
            UmcCustInfoSyncTempPO set = new UmcCustInfoSyncTempPO();
            set.setDealResult(umcCustInfoSyncTemp.getDealResult());
            UmcCustInfoSyncTempPO where = new UmcCustInfoSyncTempPO();
            where.setIds(umcCustInfoSyncTemp.getIds());
            this.umcCustInfoSyncTempMapper.updateBy(set, where);
        }
    }

    public void updateCustSyncInfoTemp(UmcUserInfoDo umcUserInfoDo) {
        if (null != umcUserInfoDo.getUmcCustInfoSyncTemp().getDealResult()) {
            this.umcCustInfoSyncTempMapper.updateByDealResoult(umcUserInfoDo.getUmcCustInfoSyncTemp().getDealResult());
        }
    }

    public void delUserRoleByUserId(UmcUserRoleRel umcUserRoleRel) {
        if (null != umcUserRoleRel && null != umcUserRoleRel.getUserId()) {
            UmcUserRoleRelPo set = new UmcUserRoleRelPo();
            UmcUserRoleRelPo where = new UmcUserRoleRelPo();
            set.setDelFlag(umcUserRoleRel.getDelFlag());
            where.setUserId(umcUserRoleRel.getUserId());
            this.umcUserRoleRelMapper.updateBy(set, where);
        }
    }

    public void addUser(UmcBatchAddUser umcBatchAddUser) {
        if (null != umcBatchAddUser) {
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserInfoDoList())) {
                this.umcUserInfoMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserInfoDoList(), UmcUserInfoPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getCustInfoList())) {
                this.umcCustInfoMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getCustInfoList(), UmcCustInfoPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserRoleRelList())) {
                this.umcUserRoleRelMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserRoleRelList(), UmcUserRoleRelPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserTagRelList())) {
                this.umcUserTagRelMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserTagRelList(), UmcUserTagRelPo.class));
            }
            if (!CollectionUtils.isEmpty((Collection)umcBatchAddUser.getUserExtMapList())) {
                this.umcUserExtMapMapper.insertBatch(UmcRu.jsl((List)umcBatchAddUser.getUserExtMapList(), UmcUserExtMapPo.class));
            }
        }
    }

    public void deleteOrgInfoSyncTempState(UmcUserInfoDo userInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)userInfoDo.getUmcCustInfoSyncTemp().getIds())) {
            UmcCustInfoSyncTempPO set = new UmcCustInfoSyncTempPO();
            set.setIds(userInfoDo.getUmcCustInfoSyncTemp().getIds());
            this.umcCustInfoSyncTempMapper.deleteBy(set);
        }
    }

    public void addCustPartJobSyncTemp(UmcUserInfoDo umcUserInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)umcUserInfoDo.getUmcCustPartJobTempList())) {
            this.umcUserPartJobSyncTempMapper.insertBatch(UmcRu.jsl((List)umcUserInfoDo.getUmcCustPartJobTempList(), UmcUserPartJobSyncTempPo.class));
        }
    }

    public void addCustPartJobSyncTempLog(UmcUserInfoDo umcUserInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)umcUserInfoDo.getUmcCustPartJobTempList())) {
            this.umcUserPartJobSyncTempLogMapper.insertBatch(UmcRu.jsl((List)umcUserInfoDo.getUmcCustPartJobTempList(), UmcUserPartJobSyncTempLogPo.class));
        }
    }

    public UmcGetCustPartJobTempListRspBo getCustPartJobTempList(UmcGetCustPartJobTempListReqBo reqBo) {
        Page pageBatch = new Page(1, 1);
        UmcUserPartJobBatchPo umcUserPartJobBatchPo = new UmcUserPartJobBatchPo();
        umcUserPartJobBatchPo.setBatchId(reqBo.getBatchId());
        umcUserPartJobBatchPo.setOrderBy("batchId,syncTime");
        umcUserPartJobBatchPo.setDealResult(0);
        List<UmcUserPartJobBatchPo> umcUserPartJobBatchPoList = this.umcUserPartJobBatchMapper.getListPage(umcUserPartJobBatchPo, (Page<UmcUserPartJobBatchPo>)pageBatch);
        if (CollectionUtils.isEmpty(umcUserPartJobBatchPoList)) {
            return (UmcGetCustPartJobTempListRspBo)UmcRu.success(UmcGetCustPartJobTempListRspBo.class);
        }
        String batchId = umcUserPartJobBatchPoList.get(0).getBatchId();
        UmcUserPartJobSyncTempPo umcUserPartJobSyncTempPo = new UmcUserPartJobSyncTempPo();
        umcUserPartJobSyncTempPo.setDealResult(UmcCommConstant.PartJobDealResult.WAIT);
        umcUserPartJobSyncTempPo.setBatchId(batchId);
        umcUserPartJobSyncTempPo.setSHARDING_PARAMETER(reqBo.getSHARDING_PARAMETER());
        umcUserPartJobSyncTempPo.setSHARDING_SHARDNUM(reqBo.getSHARDING_SHARDNUM());
        umcUserPartJobSyncTempPo.setOrderBy("id");
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<UmcUserPartJobSyncTempPo> umcUserPartJobSyncTempPoList = this.umcUserPartJobSyncTempMapper.getExtCustId(umcUserPartJobSyncTempPo, (Page<UmcUserPartJobSyncTempPo>)page);
        UmcGetCustPartJobTempListRspBo rspBo = (UmcGetCustPartJobTempListRspBo)UmcRu.success(UmcGetCustPartJobTempListRspBo.class);
        if (CollectionUtils.isEmpty(umcUserPartJobSyncTempPoList)) {
            UmcUserPartJobSyncTempPo checkPartJobPo = new UmcUserPartJobSyncTempPo();
            checkPartJobPo.setBatchId(batchId);
            int checkCount = this.umcUserPartJobSyncTempMapper.getCheckBy(checkPartJobPo);
            if (checkCount == 0) {
                UmcUserPartJobBatchPo umcUserPartJobBatchPo1 = new UmcUserPartJobBatchPo();
                umcUserPartJobBatchPo1.setBatchId(batchId);
                umcUserPartJobBatchPo1.setDealResult(1);
                this.umcUserPartJobBatchMapper.updateByBatchId(umcUserPartJobBatchPo1);
            }
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        UmcUserPartJobSyncTempPo userPartJobPo = new UmcUserPartJobSyncTempPo();
        userPartJobPo.setExtCustIds(umcUserPartJobSyncTempPoList.stream().map(UmcUserPartJobSyncTempPo::getExtCustId).collect(Collectors.toList()));
        userPartJobPo.setBatchId(batchId);
        List<UmcUserPartJobSyncTempPo> userPartJobSyncTempPoList = this.umcUserPartJobSyncTempMapper.getList(userPartJobPo);
        rspBo.setRows(UmcRu.jsl(userPartJobSyncTempPoList, UmcCustPartJobTempBo.class));
        return rspBo;
    }

    public void updateCustPartJobResult(UmcCustPartJobTempResultUpdateReqBo reqBo) {
        UmcUserPartJobSyncTempPo where;
        UmcUserPartJobSyncTempPo set;
        Date now = new Date();
        if (UmcCommConstant.PartJobDealResult.DEALING.equals(reqBo.getDealResult())) {
            set = new UmcUserPartJobSyncTempPo();
            set.setDealResult(reqBo.getDealResult());
            set.setDealTime(now);
            where = new UmcUserPartJobSyncTempPo();
            where.setIds(reqBo.getIds());
            this.umcUserPartJobSyncTempMapper.updateTimesBy(set, where);
        }
        if (UmcCommConstant.PartJobDealResult.SUCCESS.equals(reqBo.getDealResult()) || UmcCommConstant.PartJobDealResult.FAIL.equals(reqBo.getDealResult())) {
            UmcUserPartJobSyncTempPo umcUserPartJobSyncTempPo = new UmcUserPartJobSyncTempPo();
            umcUserPartJobSyncTempPo.setIds(reqBo.getIds());
            List<UmcUserPartJobSyncTempPo> umcUserPartJobSyncTempPoList = this.umcUserPartJobSyncTempMapper.getList(umcUserPartJobSyncTempPo);
            if (!CollectionUtils.isEmpty(umcUserPartJobSyncTempPoList)) {
                ArrayList<UmcUserPartJobSyncTempLogPo> umcUserPartJobSyncTempLogPos = new ArrayList<UmcUserPartJobSyncTempLogPo>();
                for (UmcUserPartJobSyncTempPo userPartJobSyncTempPo : umcUserPartJobSyncTempPoList) {
                    UmcUserPartJobSyncTempLogPo umcUserPartJobSyncTempLogPo = (UmcUserPartJobSyncTempLogPo)UmcRu.js((Object)userPartJobSyncTempPo, UmcUserPartJobSyncTempLogPo.class);
                    umcUserPartJobSyncTempLogPo.setLogId(IdUtil.nextId());
                    umcUserPartJobSyncTempLogPo.setDealTime(now);
                    umcUserPartJobSyncTempLogPo.setDealResultDesc(reqBo.getDealResultDesc());
                    umcUserPartJobSyncTempLogPo.setDealResult(reqBo.getDealResult());
                    if (StringUtils.isBlank((CharSequence)reqBo.getDealResultDesc())) {
                        umcUserPartJobSyncTempLogPo.setDealResultDesc("\u6210\u529f");
                    }
                    umcUserPartJobSyncTempLogPos.add(umcUserPartJobSyncTempLogPo);
                }
                this.umcUserPartJobSyncTempLogMapper.insertBatch(umcUserPartJobSyncTempLogPos);
                this.umcUserPartJobSyncTempMapper.del(reqBo.getIds());
            }
        }
        if (UmcCommConstant.PartJobDealResult.WAIT.equals(reqBo.getDealResult())) {
            set = new UmcUserPartJobSyncTempPo();
            set.setDealResult(reqBo.getDealResult());
            set.setDealResultDesc(reqBo.getDealResultDesc());
            where = new UmcUserPartJobSyncTempPo();
            where.setIds(reqBo.getIds());
            this.umcUserPartJobSyncTempMapper.updateWaitByIds(set, where);
        }
    }

    public UmcCustPartJobTempDealRspBo dealCustPartJob(UmcCustPartJobTempDealReqBo reqBo) {
        UmcCustPartJobTempDealRspBo rspBo = new UmcCustPartJobTempDealRspBo();
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        umcOrgInfoPo.setExtOrgIds(reqBo.getUmcCustPartJobTempBoList().stream().map(UmcCustPartJobTempBo::getExtOrgId).collect(Collectors.toList()));
        List<UmcOrgInfoPo> umcOrgInfoPoList = this.umcOrgInfoMapper.getList(umcOrgInfoPo);
        if (CollectionUtils.isEmpty(umcOrgInfoPoList)) {
            this.dealFail(reqBo.getUmcCustPartJobTempBoList(), "\u6240\u5c5e\u673a\u6784\u6570\u636e\u672a\u540c\u6b65\u5230\u4e3b\u8868");
            return rspBo;
        }
        List<String> extCustIdList = reqBo.getUmcCustPartJobTempBoList().stream().map(UmcCustPartJobTempBo::getExtCustId).collect(Collectors.toList());
        UmcUserInfoPo qryByExtCustIdPo = new UmcUserInfoPo();
        qryByExtCustIdPo.setExtCustIdList(extCustIdList);
        List<UmcUserInfoPo> mainUserInfoList = this.umcUserInfoMapper.getMainPartJobUserList(qryByExtCustIdPo);
        if (CollectionUtils.isEmpty(mainUserInfoList)) {
            this.dealFail(reqBo.getUmcCustPartJobTempBoList(), "\u4e3b\u804c\u7528\u6237\u672a\u540c\u6b65\u5230\u4e3b\u8868");
            return rspBo;
        }
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setCustIdList(mainUserInfoList.stream().map(UmcUserInfoPo::getCustId).collect(Collectors.toList()));
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getPartJobUserList(umcUserInfoPo);
        this.compare(reqBo, rspBo, umcOrgInfoPoList, mainUserInfoList, umcUserInfoPoList);
        return rspBo;
    }

    private void compare(UmcCustPartJobTempDealReqBo reqBo, UmcCustPartJobTempDealRspBo rspBo, List<UmcOrgInfoPo> umcOrgInfoPoList, List<UmcUserInfoPo> mainUserInfoList, List<UmcUserInfoPo> umcUserInfoPoList) {
        ConcurrentMap<Object, Object> extCustOrgIdMap = new ConcurrentHashMap();
        if (!CollectionUtils.isEmpty(umcUserInfoPoList)) {
            extCustOrgIdMap = umcUserInfoPoList.stream().collect(Collectors.toConcurrentMap(o -> o.getExtCustId() + "-" + o.getExtOrgId(), o -> o, (old, cur) -> old));
        }
        ConcurrentMap<String, UmcUserInfoPo> extCustIdMap = mainUserInfoList.stream().collect(Collectors.toConcurrentMap(UmcUserInfoPo::getExtCustId, o -> o, (old, cur) -> old));
        ConcurrentMap<String, UmcOrgInfoPo> extOrgIdMap = umcOrgInfoPoList.stream().collect(Collectors.toConcurrentMap(UmcOrgInfoPo::getExtOrgId, o -> o, (old, cur) -> old));
        ConcurrentMap<String, UmcCustPartJobTempBo> reqExtCustOrgIdMap = reqBo.getUmcCustPartJobTempBoList().stream().collect(Collectors.toConcurrentMap(o -> o.getExtCustId() + "-" + o.getExtOrgId(), o -> o, (old, cur) -> old));
        ArrayList<UmcUserInfoPo> addPartJobUserList = new ArrayList<UmcUserInfoPo>();
        ArrayList<UmcUserInfoPo> deleteUserPos = new ArrayList<UmcUserInfoPo>();
        ArrayList<String> deletePartInfoStrList = new ArrayList<String>();
        ArrayList<UmcCustPartJobTempBo> failOrgPartJobUser = new ArrayList<UmcCustPartJobTempBo>();
        ArrayList<UmcCustPartJobTempBo> failMainCustPartJobUser = new ArrayList<UmcCustPartJobTempBo>();
        ArrayList<UmcCustPartJobTempBo> noChangePartJobUser = new ArrayList<UmcCustPartJobTempBo>();
        ConcurrentMap<Object, Object> finalExtCustOrgIdMap = extCustOrgIdMap;
        reqExtCustOrgIdMap.forEach((reqExtCustOrgId, umcCustPartJobTempBo) -> {
            UmcUserInfoPo userInfoPo = (UmcUserInfoPo)finalExtCustOrgIdMap.get(reqExtCustOrgId);
            if (null == userInfoPo) {
                UmcOrgInfoPo orgInfoPo = (UmcOrgInfoPo)extOrgIdMap.get(umcCustPartJobTempBo.getExtOrgId());
                if (null == orgInfoPo) {
                    failOrgPartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
                } else {
                    UmcUserInfoPo mainUserInfoPo = (UmcUserInfoPo)extCustIdMap.get(umcCustPartJobTempBo.getExtCustId());
                    if (null == mainUserInfoPo) {
                        failMainCustPartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
                    } else if (umcCustPartJobTempBo.getExtOrgId().equals(mainUserInfoPo.getExtOrgId())) {
                        noChangePartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
                    } else {
                        UmcUserInfoPo addUser = new UmcUserInfoPo();
                        addUser.setCustId(mainUserInfoPo.getCustId());
                        addUser.setExtCustId(mainUserInfoPo.getExtCustId());
                        addUser.setOrgId(orgInfoPo.getOrgId());
                        addUser.setCompanyId(orgInfoPo.getCompanyId());
                        addUser.setOrgTreePath(orgInfoPo.getOrgTreePath());
                        addUser.setExtOrgId(orgInfoPo.getExtOrgId());
                        addUser.setUserId(IdUtil.nextId());
                        addPartJobUserList.add(addUser);
                    }
                }
            } else {
                umcCustPartJobTempBo.setId(umcCustPartJobTempBo.getId());
                noChangePartJobUser.add((UmcCustPartJobTempBo)umcCustPartJobTempBo);
            }
        });
        extCustOrgIdMap.forEach((extCustOrgId, userInfo) -> {
            UmcCustPartJobTempBo umcCustPartJobTempBo = (UmcCustPartJobTempBo)reqExtCustOrgIdMap.get(extCustOrgId);
            if (null == umcCustPartJobTempBo) {
                deleteUserPos.add((UmcUserInfoPo)userInfo);
                deletePartInfoStrList.add((String)extCustOrgId);
            }
        });
        if (!CollectionUtils.isEmpty(failOrgPartJobUser)) {
            this.dealFail(failOrgPartJobUser, "\u6240\u5c5e\u673a\u6784\u6570\u636e\u672a\u540c\u6b65\u5230\u4e3b\u8868");
        }
        if (!CollectionUtils.isEmpty(failMainCustPartJobUser)) {
            this.dealFail(failMainCustPartJobUser, "\u4e3b\u804c\u7528\u6237\u672a\u540c\u6b65\u5230\u4e3b\u8868");
        }
        if (!CollectionUtils.isEmpty(noChangePartJobUser)) {
            this.dealSuccess(noChangePartJobUser, "\u7528\u6237\u5df2\u5728\u5546\u57ce\u517c\u804c\uff0c\u65e0\u9700\u5904\u7406\u8be5\u6570\u636e");
        }
        List<Long> deleteUserList = this.dealDeleteUsers(reqBo, deleteUserPos, deletePartInfoStrList);
        ArrayList<UmcPartJobUserInfoBo> sysPartJobUserInfoBoList = new ArrayList<UmcPartJobUserInfoBo>();
        ArrayList<UmcPartJobUserTagRelBo> sysPartJobUserTagRelBoList = new ArrayList<UmcPartJobUserTagRelBo>();
        ArrayList<UmcPartJobUserRoleBo> sysPartJobUserRoleBoList = new ArrayList<UmcPartJobUserRoleBo>();
        if (!CollectionUtils.isEmpty(addPartJobUserList)) {
            this.batchCreatePartJobUser(addPartJobUserList, sysPartJobUserInfoBoList, sysPartJobUserTagRelBoList, sysPartJobUserRoleBoList);
            ArrayList<UmcCustPartJobTempBo> successBo = new ArrayList<UmcCustPartJobTempBo>();
            for (UmcUserInfoPo userPo : addPartJobUserList) {
                UmcCustPartJobTempBo tempBo = (UmcCustPartJobTempBo)reqExtCustOrgIdMap.get(userPo.getExtCustId() + "-" + userPo.getExtOrgId());
                if (null == tempBo) continue;
                successBo.add(tempBo);
            }
            this.dealSuccess(successBo, "\u7528\u6237\u517c\u804c\u6210\u529f");
        }
        UmcAddCustPartJobBo umcAddCustPartJobBo = new UmcAddCustPartJobBo();
        umcAddCustPartJobBo.setSysPartJobUserInfoBoList(sysPartJobUserInfoBoList);
        umcAddCustPartJobBo.setSysPartJobUserTagRelBoList(sysPartJobUserTagRelBoList);
        umcAddCustPartJobBo.setSysPartJobUserRoleBoList(sysPartJobUserRoleBoList);
        rspBo.setAddCustPartJobBo(umcAddCustPartJobBo);
        rspBo.setDeleteUserIds(deleteUserList);
    }

    private List<Long> dealDeleteUsers(UmcCustPartJobTempDealReqBo reqBo, List<UmcUserInfoPo> deleteUserPos, List<String> deletePartInfoStrList) {
        List<Long> deleteUserList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(deleteUserPos)) {
            String batchId = ((UmcCustPartJobTempBo)reqBo.getUmcCustPartJobTempBoList().get(0)).getBatchId();
            List<UmcUserPartJobSyncTempPo> umcUserPartJobSyncTempPos = deletePartInfoStrList.stream().map(str -> {
                String[] split = str.split("-");
                UmcUserPartJobSyncTempPo umcUserPartJobSyncTempPo = new UmcUserPartJobSyncTempPo();
                umcUserPartJobSyncTempPo.setBatchId(batchId);
                umcUserPartJobSyncTempPo.setExtCustId(split[0]);
                umcUserPartJobSyncTempPo.setExtOrgId(split[1]);
                return umcUserPartJobSyncTempPo;
            }).collect(Collectors.toList());
            List<UmcUserPartJobSyncTempPo> umcUserPartJobSyncTempPoList = this.umcUserPartJobSyncTempMapper.getTempList(umcUserPartJobSyncTempPos);
            List<UmcUserPartJobSyncTempLogPo> umcUserPartJobSyncTempLogPos = umcUserPartJobSyncTempPos.stream().map(e -> {
                UmcUserPartJobSyncTempLogPo umcUserPartJobSyncTempLogPo = new UmcUserPartJobSyncTempLogPo();
                umcUserPartJobSyncTempLogPo.setBatchId(batchId);
                umcUserPartJobSyncTempLogPo.setExtCustId(e.getExtCustId());
                umcUserPartJobSyncTempLogPo.setExtOrgId(e.getExtOrgId());
                return umcUserPartJobSyncTempLogPo;
            }).collect(Collectors.toList());
            List<UmcUserPartJobSyncTempLogPo> umcUserPartJobSyncTempLogPoList = this.umcUserPartJobSyncTempLogMapper.getTempLogList(umcUserPartJobSyncTempLogPos);
            if (CollectionUtils.isEmpty(umcUserPartJobSyncTempPoList) && CollectionUtils.isEmpty(umcUserPartJobSyncTempLogPoList)) {
                return deleteUserList;
            }
            ConcurrentMap<Object, Object> extCustOrgIdMap = new ConcurrentHashMap();
            if (!CollectionUtils.isEmpty(umcUserPartJobSyncTempPoList)) {
                extCustOrgIdMap = umcUserPartJobSyncTempPoList.stream().collect(Collectors.toConcurrentMap(o -> o.getExtCustId() + "-" + o.getExtOrgId(), o -> o, (old, cur) -> old));
            }
            Set extCustOrgIdSet = extCustOrgIdMap.keySet();
            ConcurrentMap<Object, Object> extCustOrgLogIdMap = new ConcurrentHashMap();
            if (!CollectionUtils.isEmpty(umcUserPartJobSyncTempLogPoList)) {
                extCustOrgLogIdMap = umcUserPartJobSyncTempLogPoList.stream().collect(Collectors.toConcurrentMap(o -> o.getExtCustId() + "-" + o.getExtOrgId(), o -> o, (old, cur) -> old));
            }
            Set extCustOrgIdLogSet = extCustOrgLogIdMap.keySet();
            List toDeleteList = deleteUserPos.stream().filter(e -> !extCustOrgIdSet.contains(e.getExtCustId() + "-" + e.getExtOrgId()) && !extCustOrgIdLogSet.contains(e.getExtCustId() + "-" + e.getExtOrgId())).collect(Collectors.toList());
            deleteUserList = toDeleteList.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
            List<Long> delUserIds = toDeleteList.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(delUserIds)) {
                this.umcUserInfoMapper.deleteUser(delUserIds);
                this.umcUserRoleRelMapper.deleteUser(delUserIds);
                this.umcUserTagRelMapper.deleteUser(delUserIds);
            }
        }
        return deleteUserList;
    }

    private void batchCreatePartJobUser(List<UmcUserInfoPo> addPartJobUserList, List<UmcPartJobUserInfoBo> sysPartJobUserInfoBoList, List<UmcPartJobUserTagRelBo> sysPartJobUserTagRelBoList, List<UmcPartJobUserRoleBo> sysPartJobUserRoleBoList) {
        List<Long> custIds = addPartJobUserList.stream().map(UmcUserInfoPo::getCustId).collect(Collectors.toList());
        ConcurrentHashMap<Long, List<UmcUserTagRelPo>> userIdTagMap = new ConcurrentHashMap();
        ConcurrentHashMap<Long, List<UmcUserExtMapPo>> userIdExtMap = new ConcurrentHashMap();
        ConcurrentHashMap<Long, UmcUserInfoPo> custIdMap = new ConcurrentHashMap();
        UmcUserInfoPo userInfoPo = new UmcUserInfoPo();
        userInfoPo.setCustIdList(custIds);
        userInfoPo.setIsMain("1");
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getList(userInfoPo);
        if (!CollectionUtils.isEmpty(umcUserInfoPoList)) {
            custIdMap = umcUserInfoPoList.stream().collect(Collectors.toConcurrentMap(UmcUserInfoPo::getCustId, o -> o, (o1, o2) -> o2));
        }
        List<Long> userIds = umcUserInfoPoList.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserIds(userIds);
        List<UmcUserTagRelPo> umcUserTagRelPoList = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        if (!CollectionUtils.isEmpty(umcUserTagRelPoList)) {
            userIdTagMap = umcUserTagRelPoList.stream().collect(Collectors.groupingByConcurrent(UmcUserTagRelPo::getUserId));
        }
        UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
        umcUserExtMapPo.setUserIds(userIds);
        List<UmcUserExtMapPo> umcUserExtMapPoList = this.umcUserExtMapMapper.getList(umcUserExtMapPo);
        if (!CollectionUtils.isEmpty(umcUserExtMapPoList)) {
            userIdExtMap = umcUserExtMapPoList.stream().collect(Collectors.groupingByConcurrent(UmcUserExtMapPo::getUserId));
        }
        ArrayList<UmcUserInfoPo> addUserInfoList = new ArrayList<UmcUserInfoPo>();
        ArrayList<UmcUserTagRelPo> addUserTagList = new ArrayList<UmcUserTagRelPo>();
        ArrayList<UmcUserRoleRelPo> addUserRoleList = new ArrayList<UmcUserRoleRelPo>();
        ArrayList<UmcUserExtMapPo> addUserExtMapList = new ArrayList<UmcUserExtMapPo>();
        Date now = new Date();
        for (UmcUserInfoPo umcUserInfoPo : addPartJobUserList) {
            this.setUser(custIdMap, addUserInfoList, now, umcUserInfoPo, sysPartJobUserInfoBoList);
            this.setUserTag(custIdMap, userIdTagMap, addUserTagList, now, umcUserInfoPo, sysPartJobUserTagRelBoList);
            this.setUserRole(addUserRoleList, now, umcUserInfoPo, sysPartJobUserRoleBoList);
            this.setUserExt(custIdMap, userIdExtMap, addUserExtMapList, now, umcUserInfoPo);
        }
        this.umcUserInfoMapper.insertBatch(addUserInfoList);
        if (ObjectUtil.isNotEmpty(addUserTagList)) {
            this.umcUserTagRelMapper.insertBatch(addUserTagList);
        }
        if (ObjectUtil.isNotEmpty(addUserRoleList)) {
            this.umcUserRoleRelMapper.insertBatch(addUserRoleList);
        }
        if (ObjectUtil.isNotEmpty(addUserExtMapList)) {
            this.umcUserExtMapMapper.insertBatch(addUserExtMapList);
        }
    }

    private void setUserExt(ConcurrentMap<Long, UmcUserInfoPo> custIdMap, ConcurrentMap<Long, List<UmcUserExtMapPo>> userIdExtMap, List<UmcUserExtMapPo> addUserExtMapList, Date now, UmcUserInfoPo umcUserInfoPo) {
        List umcUserExtMapPos;
        UmcUserInfoPo mainUserPo = (UmcUserInfoPo)custIdMap.get(umcUserInfoPo.getCustId());
        if (null != mainUserPo && !CollectionUtils.isEmpty((Collection)(umcUserExtMapPos = (List)userIdExtMap.get(mainUserPo.getUserId())))) {
            for (UmcUserExtMapPo userExtMapPo : umcUserExtMapPos) {
                UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
                BeanUtils.copyProperties((Object)userExtMapPo, (Object)umcUserExtMapPo);
                umcUserExtMapPo.setExtId(IdUtil.nextId());
                umcUserExtMapPo.setUserId(umcUserInfoPo.getUserId());
                umcUserExtMapPo.setCreateTime(now);
                umcUserExtMapPo.setCreateOperId(UmcCommConstant.System.ID);
                umcUserExtMapPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserExtMapPo.setUpdateTime(now);
                umcUserExtMapPo.setUpdateOperId(UmcCommConstant.System.ID);
                umcUserExtMapPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserExtMapPo.setDelFlag("0");
                addUserExtMapList.add(umcUserExtMapPo);
            }
        }
    }

    private void setUserRole(List<UmcUserRoleRelPo> addUserRoleList, Date now, UmcUserInfoPo umcUserInfoPo, List<UmcPartJobUserRoleBo> sysPartJobUserRoleBoList) {
        if (!StringUtils.isBlank((CharSequence)this.defaultRoleIds)) {
            List<Object> roleIds = new ArrayList<String>();
            if (this.defaultRoleIds.contains(",")) {
                roleIds = Arrays.asList(this.defaultRoleIds.split(","));
            } else {
                roleIds.add(this.defaultRoleIds);
            }
            for (String string : roleIds) {
                UmcUserRoleRelPo umcUserRoleRelPo = new UmcUserRoleRelPo();
                umcUserRoleRelPo.setRelId(IdUtil.nextId());
                umcUserRoleRelPo.setUserId(umcUserInfoPo.getUserId());
                umcUserRoleRelPo.setRoleId(Convert.toLong((Object)string));
                umcUserRoleRelPo.setTenantId(UmcCommConstant.System.TENANT_ID);
                umcUserRoleRelPo.setCreateTime(now);
                umcUserRoleRelPo.setCreateOperId(UmcCommConstant.System.ID);
                umcUserRoleRelPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserRoleRelPo.setUpdateTime(now);
                umcUserRoleRelPo.setUpdateOperId(UmcCommConstant.System.ID);
                umcUserRoleRelPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserRoleRelPo.setDelFlag("0");
                addUserRoleList.add(umcUserRoleRelPo);
                UmcPartJobUserRoleBo umcPartJobUserRoleBo = (UmcPartJobUserRoleBo)UmcRu.js((Object)umcUserRoleRelPo, UmcPartJobUserRoleBo.class);
                umcPartJobUserRoleBo.setAuthId(umcUserRoleRelPo.getRelId());
                umcPartJobUserRoleBo.setDisAgFlag(Integer.valueOf(1));
                umcPartJobUserRoleBo.setDisFlag(Integer.valueOf(1));
                umcPartJobUserRoleBo.setOrgId(umcUserInfoPo.getOrgId());
                umcPartJobUserRoleBo.setOrgTreePath(umcUserInfoPo.getOrgTreePath());
                umcPartJobUserRoleBo.setManageLevel(Integer.valueOf(40));
                sysPartJobUserRoleBoList.add(umcPartJobUserRoleBo);
            }
        }
    }

    private void setUserTag(ConcurrentMap<Long, UmcUserInfoPo> custIdMap, ConcurrentMap<Long, List<UmcUserTagRelPo>> userIdTagMap, List<UmcUserTagRelPo> addUserTagList, Date now, UmcUserInfoPo umcUserInfoPo, List<UmcPartJobUserTagRelBo> sysPartJobUserTagRelBoList) {
        List addUserTags;
        UmcUserInfoPo mainUserPo = (UmcUserInfoPo)custIdMap.get(umcUserInfoPo.getCustId());
        if (null != mainUserPo && !CollectionUtils.isEmpty((Collection)(addUserTags = (List)userIdTagMap.get(mainUserPo.getUserId())))) {
            for (UmcUserTagRelPo addUserTag : addUserTags) {
                UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
                BeanUtils.copyProperties((Object)addUserTag, (Object)umcUserTagRelPo);
                umcUserTagRelPo.setRelId(IdUtil.nextId());
                umcUserTagRelPo.setUserId(umcUserInfoPo.getUserId());
                umcUserTagRelPo.setCreateTime(now);
                umcUserTagRelPo.setCreateOperId(UmcCommConstant.System.ID);
                umcUserTagRelPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserTagRelPo.setUpdateTime(now);
                umcUserTagRelPo.setUpdateOperId(UmcCommConstant.System.ID);
                umcUserTagRelPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcUserTagRelPo.setDelFlag("0");
                addUserTagList.add(umcUserTagRelPo);
                sysPartJobUserTagRelBoList.add((UmcPartJobUserTagRelBo)UmcRu.js((Object)umcUserTagRelPo, UmcPartJobUserTagRelBo.class));
            }
        }
    }

    private void setUser(ConcurrentMap<Long, UmcUserInfoPo> custIdMap, List<UmcUserInfoPo> addUserInfoList, Date now, UmcUserInfoPo umcUserInfoPo, List<UmcPartJobUserInfoBo> sysPartJobUserInfoBoList) {
        UmcUserInfoPo mainUserPo = (UmcUserInfoPo)custIdMap.get(umcUserInfoPo.getCustId());
        if (null != mainUserPo) {
            UmcUserInfoPo addUserPo = (UmcUserInfoPo)UmcRu.js((Object)mainUserPo, UmcUserInfoPo.class);
            addUserPo.setUserId(umcUserInfoPo.getUserId());
            addUserPo.setOrgId(umcUserInfoPo.getOrgId());
            addUserPo.setCustId(umcUserInfoPo.getCustId());
            addUserPo.setMainCustId(umcUserInfoPo.getCustId());
            addUserPo.setOrgTreePath(umcUserInfoPo.getOrgTreePath());
            addUserPo.setCompanyId(umcUserInfoPo.getCompanyId());
            addUserPo.setIsMain("0");
            addUserPo.setStopStatus("01");
            addUserPo.setCreateTime(now);
            addUserPo.setCreateOperId(UmcCommConstant.System.ID);
            addUserPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            addUserPo.setUpdateTime(now);
            addUserPo.setUpdateOperId(UmcCommConstant.System.ID);
            addUserPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            addUserPo.setDelFlag("0");
            addUserInfoList.add(addUserPo);
            UmcPartJobUserInfoBo umcPartJobUserInfoBo = (UmcPartJobUserInfoBo)UmcRu.js((Object)addUserPo, UmcPartJobUserInfoBo.class);
            umcPartJobUserInfoBo.setUserStatus("1");
            sysPartJobUserInfoBoList.add(umcPartJobUserInfoBo);
        }
    }

    private void dealSuccess(List<UmcCustPartJobTempBo> umcCustPartJobTempBoList, String desc) {
        UmcCustPartJobTempResultUpdateReqBo umcCustPartJobTempResultUpdateReqBo = new UmcCustPartJobTempResultUpdateReqBo();
        umcCustPartJobTempResultUpdateReqBo.setDealResult(UmcCommConstant.PartJobDealResult.SUCCESS);
        umcCustPartJobTempResultUpdateReqBo.setDealResultDesc(desc);
        umcCustPartJobTempResultUpdateReqBo.setIds(umcCustPartJobTempBoList.stream().map(UmcCustPartJobTempBo::getId).collect(Collectors.toList()));
        this.updateCustPartJobResult(umcCustPartJobTempResultUpdateReqBo);
    }

    private void dealFail(List<UmcCustPartJobTempBo> umcCustPartJobTempBoList, String desc) {
        UmcCustPartJobTempResultUpdateReqBo umcCustPartJobTempResultUpdateReqBo;
        ArrayList<Long> failIds = new ArrayList<Long>();
        ArrayList<Long> todoIds = new ArrayList<Long>();
        for (UmcCustPartJobTempBo umcCustPartJobTempBo : umcCustPartJobTempBoList) {
            if (umcCustPartJobTempBo.getDealCount() >= this.partJobFailTimes) {
                failIds.add(umcCustPartJobTempBo.getId());
                continue;
            }
            todoIds.add(umcCustPartJobTempBo.getId());
        }
        if (!CollectionUtils.isEmpty(failIds)) {
            umcCustPartJobTempResultUpdateReqBo = new UmcCustPartJobTempResultUpdateReqBo();
            umcCustPartJobTempResultUpdateReqBo.setDealResult(UmcCommConstant.PartJobDealResult.FAIL);
            umcCustPartJobTempResultUpdateReqBo.setDealResultDesc(desc);
            umcCustPartJobTempResultUpdateReqBo.setIds(failIds);
            this.updateCustPartJobResult(umcCustPartJobTempResultUpdateReqBo);
        }
        if (!CollectionUtils.isEmpty(todoIds)) {
            umcCustPartJobTempResultUpdateReqBo = new UmcCustPartJobTempResultUpdateReqBo();
            umcCustPartJobTempResultUpdateReqBo.setDealResult(UmcCommConstant.PartJobDealResult.WAIT);
            umcCustPartJobTempResultUpdateReqBo.setDealResultDesc(desc);
            umcCustPartJobTempResultUpdateReqBo.setIds(todoIds);
            this.updateCustPartJobResult(umcCustPartJobTempResultUpdateReqBo);
        }
    }

    public void finishSyncPartJobUser(UmcCustPartJobSyncBatchFinishReqBo reqBo) {
        if (FINISH.equals(reqBo.getDealResult())) {
            UmcUserPartJobSyncTempPo umcUserPartJobSyncTempPo = new UmcUserPartJobSyncTempPo();
            umcUserPartJobSyncTempPo.setBatchId(reqBo.getBatchId());
            int count = this.umcUserPartJobSyncTempMapper.getCheckBy(umcUserPartJobSyncTempPo);
            if (count == 0) {
                UmcUserPartJobBatchPo umcUserPartJobBatchPo = new UmcUserPartJobBatchPo();
                umcUserPartJobBatchPo.setBatchId(reqBo.getBatchId());
                umcUserPartJobBatchPo.setDealResult(FINISH);
                this.umcUserPartJobBatchMapper.updateByBatchId(umcUserPartJobBatchPo);
            }
        } else {
            UmcUserPartJobBatchPo umcUserPartJobBatchPo = new UmcUserPartJobBatchPo();
            umcUserPartJobBatchPo.setBatchId(reqBo.getBatchId());
            umcUserPartJobBatchPo.setId(IdUtil.nextId());
            umcUserPartJobBatchPo.setDealResult(0);
            umcUserPartJobBatchPo.setSyncTime(new Date());
            this.umcUserPartJobBatchMapper.insert(umcUserPartJobBatchPo);
        }
    }

    public UmcUserInfoDo getUserInfoByExt(UmcUserInfoQryBo umcUserInfoQryBo) {
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setExtCustId(umcUserInfoQryBo.getExtCustId());
        umcUserInfoPo.setExtOrgId(umcUserInfoQryBo.getExtOrgId());
        umcUserInfoPo = this.umcUserInfoMapper.getUserInfnByExt(umcUserInfoPo);
        if (null != umcUserInfoPo) {
            umcUserInfoDo.setUserId(umcUserInfoPo.getUserId());
            umcUserInfoDo.setCustId(umcUserInfoPo.getCustId());
        }
        return umcUserInfoDo;
    }

    public UmcUserInfoQryRspBo getUserOrgBaseInfoList(UmcUserInfoQryBo umcUserInfoQryBo) {
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setUserId(umcUserInfoQryBo.getUserId());
        umcUserInfoPo.setUserIdList(umcUserInfoQryBo.getUserIdList());
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getUserOrgBaseInfoList(umcUserInfoPo);
        List umcUserInfoQryBoList = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoQryBo.class);
        UmcUserInfoQryRspBo umcUserInfoQryRspBo = new UmcUserInfoQryRspBo();
        umcUserInfoQryRspBo.setRows(umcUserInfoQryBoList);
        return umcUserInfoQryRspBo;
    }

    public UmcUserInfoDo getUserInfoExtCustIdForLogin(UmcUserInfoQryBo umcUserInfoQryBo) {
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setExtCustId(umcUserInfoQryBo.getExtCustId());
        UmcUserInfoPo umcUserInfoPo1 = this.umcUserInfoMapper.getUserInfoExtCustIdForLogin(umcUserInfoPo);
        if (null == umcUserInfoPo1) {
            return null;
        }
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserId(umcUserInfoPo1.getUserId());
        umcUserTagRelPo.setIsDefalt("1");
        List<UmcUserTagRelPo> umcUserTagRelPo1 = this.umcUserTagRelMapper.getList(umcUserTagRelPo);
        UmcUserInfoDo umcUserInfoDo = (UmcUserInfoDo)UmcRu.js((Object)umcUserInfoPo1, UmcUserInfoDo.class);
        umcUserInfoDo.setUserTagRel("" + umcUserTagRelPo1.get(0).getTagId());
        return umcUserInfoDo;
    }

    public UmcUserInfoDos getExtIdByIds(UmcUserInfoQryBo umcUserInfoQryBo) {
        List<UmcUserInfoPo> umcUserInfoPoList = this.umcUserInfoMapper.getExtIdByIds(umcUserInfoQryBo.getUserIdList(), umcUserInfoQryBo.getExtCustIdList());
        List umcUserInfoDoList = UmcRu.jsl(umcUserInfoPoList, UmcUserInfoDo.class);
        UmcUserInfoDos umcUserInfoDos = new UmcUserInfoDos();
        umcUserInfoDos.setRows(umcUserInfoDoList);
        if (!CollectionUtils.isEmpty((Collection)umcUserInfoDoList)) {
            List<Long> userIds = umcUserInfoDoList.stream().map(UmcUserInfoDo::getUserId).distinct().collect(Collectors.toList());
            UmcUserExtMapPo umcUserExtMapPo = new UmcUserExtMapPo();
            umcUserExtMapPo.setUserIds(userIds);
            List<UmcUserExtMapPo> umcUserExtMapPoList = this.umcUserExtMapMapper.getList(umcUserExtMapPo);
            ConcurrentMap<Long, List<UmcUserExtMapPo>> userIdListMap = umcUserExtMapPoList.stream().collect(Collectors.groupingByConcurrent(UmcUserExtMapPo::getUserId));
            ArrayList orgIds = new ArrayList();
            umcUserInfoDoList.forEach(umcUserInfoDo -> {
                orgIds.add(umcUserInfoDo.getOrgId());
                orgIds.add(umcUserInfoDo.getCompanyId());
            });
            UmcOrgInfoPo orgInfoPo = new UmcOrgInfoPo();
            orgInfoPo.setOrgIds(orgIds.stream().distinct().collect(Collectors.toList()));
            List<UmcOrgInfoPo> umcOrgInfoPoList = this.umcOrgInfoMapper.getList(orgInfoPo);
            ConcurrentMap<Object, Object> orgMap = new ConcurrentHashMap();
            if (!CollectionUtils.isEmpty(umcOrgInfoPoList)) {
                orgMap = umcOrgInfoPoList.stream().collect(Collectors.toConcurrentMap(UmcOrgInfoPo::getOrgId, o -> o));
            }
            if (!CollectionUtils.isEmpty(userIdListMap)) {
                for (UmcUserInfoDo umcUserInfoDo2 : umcUserInfoDoList) {
                    UmcOrgInfoPo companyInfo;
                    List umcUserExtMapPos = (List)userIdListMap.get(umcUserInfoDo2.getUserId());
                    if (CollectionUtils.isEmpty((Collection)umcUserExtMapPos)) continue;
                    umcUserInfoDo2.setUserExtMapList(UmcRu.jsl((List)umcUserExtMapPos, UmcUserExtMap.class));
                    UmcOrgInfoPo orgInfo = (UmcOrgInfoPo)orgMap.get(umcUserInfoDo2.getOrgId());
                    if (null != orgInfo) {
                        umcUserInfoDo2.setOrgName(orgInfo.getOrgName());
                    }
                    if (null == (companyInfo = (UmcOrgInfoPo)orgMap.get(umcUserInfoDo2.getCompanyId()))) continue;
                    umcUserInfoDo2.setCompanyName(companyInfo.getOrgName());
                }
            }
        }
        return umcUserInfoDos;
    }

    public synchronized void insertUserExtMap(List<UmcUserExtMap> insertUserExtMapList) {
        List<Long> userIds;
        if (!CollectionUtils.isEmpty(insertUserExtMapList) && !CollectionUtils.isEmpty(userIds = insertUserExtMapList.stream().map(UmcUserExtMap::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
            UmcUserExtMapPo set = new UmcUserExtMapPo();
            set.setDelFlag("1");
            UmcUserExtMapPo where = new UmcUserExtMapPo();
            where.setDelFlag("0");
            where.setUserIds(userIds);
            this.umcUserExtMapMapper.updateBy(set, where);
            List umcUserExtMapPos = UmcRu.jsl(insertUserExtMapList, UmcUserExtMapPo.class);
            umcUserExtMapPos.forEach(e -> e.setExtId(IdUtil.nextId()));
            this.umcUserExtMapMapper.insertBatch(umcUserExtMapPos);
        }
    }

    public UmcUserInfoDo modifyUserInfo(UmcUserInfoDo reqDo) {
        UmcUserInfoPo UmcUserInfoPo2 = (UmcUserInfoPo)AuthRu.js((Object)reqDo, UmcUserInfoPo.class);
        UmcUserInfoPo wherePo = new UmcUserInfoPo();
        wherePo.setUserId(reqDo.getUserId());
        StrUtil.noNullStringAttr((Object)UmcUserInfoPo2);
        StrUtil.noNullStringAttr((Object)wherePo);
        this.umcUserInfoMapper.updateBy(UmcUserInfoPo2, wherePo);
        if (reqDo.getCustInfo() != null) {
            UmcCustInfoPo UmcCustInfoPo2 = (UmcCustInfoPo)AuthRu.js((Object)reqDo.getCustInfo(), UmcCustInfoPo.class);
            StrUtil.noNullStringAttr((Object)UmcCustInfoPo2);
            this.umcCustInfoMapper.updateById(UmcCustInfoPo2);
        }
        return reqDo;
    }

    public UmcUserInfoListRspBo getUserPageList(UmcUserInfoQryBo qryBo) {
        return null;
    }

    public UmcUserInfoListRspBo getUserList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo wherePo = (UmcUserInfoPo)AuthRu.js((Object)qryBo, UmcUserInfoPo.class);
        List<UmcUserInfoPo> list = this.umcUserInfoMapper.getList(wherePo);
        UmcUserInfoListRspBo sysUserInfoListRspBo = new UmcUserInfoListRspBo();
        List rspBo = AuthRu.jsl(list, UmcUserInfoDo.class);
        sysUserInfoListRspBo.setRows(rspBo);
        return sysUserInfoListRspBo;
    }

    public UmcUserInfoDo getUserInfoDetails(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo wherePo = (UmcUserInfoPo)AuthRu.js((Object)qryBo, UmcUserInfoPo.class);
        UmcUserInfoPo modelBy = this.umcUserInfoMapper.getModelBy(wherePo);
        UmcUserInfoDo rspDo = (UmcUserInfoDo)AuthRu.js((Object)modelBy, UmcUserInfoDo.class);
        if (modelBy != null && modelBy.getCustId() != null) {
            UmcCustInfoPo custWherePo = new UmcCustInfoPo();
            custWherePo.setCustId(modelBy.getCustId());
            UmcCustInfoPo custInfoPo = this.umcCustInfoMapper.getModelBy(custWherePo);
            UmcCustInfo custSubDo = (UmcCustInfo)AuthRu.js((Object)custInfoPo, UmcCustInfo.class);
            rspDo.setCustInfo(custSubDo);
            UmcCustExtMapPo extQryPo = new UmcCustExtMapPo();
            extQryPo.setCustId(custSubDo.getCustId());
            List<UmcCustExtMapPo> custExtMapPoList = this.umcCustExtMapMapper.getList(extQryPo);
            List custExtMapSubDoList = UmcRu.jsl(custExtMapPoList, UmcCustExtMapSubDo.class);
            rspDo.setCustExtMapList(custExtMapSubDoList);
            UmcUserTagRelPo tagPo = new UmcUserTagRelPo();
            tagPo.setUserId(modelBy.getUserId());
            List<UmcUserTagRelPo> tagList = this.umcUserTagRelMapper.getList(tagPo);
            rspDo.setUserTagRelList(AuthRu.jsl(tagList, UmcUserTagRel.class));
            SysLoginLogPo sysLoginLogPo = new SysLoginLogPo();
            sysLoginLogPo.setUserId(modelBy.getUserId());
            sysLoginLogPo = this.sysLoginLogMapper.getLastLoginTime(sysLoginLogPo);
            if (null != sysLoginLogPo) {
                rspDo.setLastLoginTime(sysLoginLogPo.getLoginTime());
            }
            SysLoginLogPo loginLogPo = new SysLoginLogPo();
            loginLogPo.setUserId(modelBy.getUserId());
            loginLogPo = this.sysLoginLogMapper.getCurrentLoginIp(loginLogPo);
            if (null != loginLogPo) {
                rspDo.setHost(loginLogPo.getHost());
            }
        }
        return rspDo;
    }

    public UmcUserInfoDo getUserTagList(UmcUserTagRelQryBo qryBo) {
        UmcUserTagRelPo wherePo = (UmcUserTagRelPo)AuthRu.js((Object)qryBo, UmcUserTagRelPo.class);
        List<UmcUserTagRelPo> list = this.umcUserTagRelMapper.getList(wherePo);
        List rspBo = AuthRu.jsl(list, UmcUserTagRel.class);
        UmcUserInfoDo sysUserInfoDo = new UmcUserInfoDo();
        sysUserInfoDo.setUserTagRelList(rspBo);
        return sysUserInfoDo;
    }

    public UmcUserInfoDo addUserRoleList(UmcUserInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getAuthDistributeList())) {
            List addPo = AuthRu.jsl((List)reqDo.getAuthDistributeList(), SysAuthDistributePo.class);
            this.sysAuthDistributeMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public UmcUserInfoDo updateUserRoleList(UmcUserInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getAuthDistributeList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getAuthDistributeList(), SysAuthDistributePo.class);
            for (SysAuthDistributePo po : updatePo) {
                SysAuthDistributePo setPo = new SysAuthDistributePo();
                setPo.setDelFlag("1");
                SysAuthDistributePo wherePo = new SysAuthDistributePo();
                wherePo.setRoleId(po.getRoleId());
                wherePo.setUserId(po.getUserId());
                wherePo.setAuthId(po.getAuthId());
                this.sysAuthDistributeMapper.updateBy(setPo, wherePo);
            }
        }
        return reqDo;
    }

    public UmcUserInfoDo getRoleInfoListByUser(UmcUserInfoQryBo qryBo) {
        UmcUserInfoDo rspDo = new UmcUserInfoDo();
        SysAuthDistributePo roleListwherePo = new SysAuthDistributePo();
        ArrayList rspList = new ArrayList();
        roleListwherePo.setUserId(qryBo.getUserId());
        roleListwherePo.setTagIdList(qryBo.getTagIdList());
        roleListwherePo.setDisAgFLagList(qryBo.getDisAgFLagList());
        roleListwherePo.setRoleStatus(qryBo.getRoleStatus());
        roleListwherePo.setIsTimeRange(qryBo.getIsTimeRange());
        roleListwherePo.setUserIds(qryBo.getUserIds());
        List<SysAuthRoleInfoPo> orgRoleList = this.sysAuthDistributeMapper.getRoleListBy(roleListwherePo);
        if (!CollectionUtils.isEmpty(orgRoleList)) {
            rspList.addAll(AuthRu.jsl(orgRoleList, SysRoleInfoSubDo.class));
        }
        rspDo.setUserRoleList(rspList);
        return rspDo;
    }

    public UmcUserInfoDo getLoginCustInfoList(UmcCustInfoQryBo qryBo) {
        UmcCustInfoPo wherePo = (UmcCustInfoPo)AuthRu.js((Object)qryBo, UmcCustInfoPo.class);
        List<UmcCustInfoPo> list = this.umcCustInfoMapper.getLoginList(wherePo);
        List rspBo = AuthRu.jsl(list, UmcCustInfoSubDo.class);
        if (!CollectionUtils.isEmpty(list)) {
            Map<Long, UmcCustInfoPo> custMap = list.stream().collect(Collectors.toMap(UmcCustInfoPo::getCustId, o -> o, (o1, o2) -> o1));
            rspBo.forEach(umcCustInfoSubDo -> {
                UmcCustInfoPo custInfoPo = (UmcCustInfoPo)custMap.get(umcCustInfoSubDo.getCustId());
                if (null != custInfoPo) {
                    umcCustInfoSubDo.setLoginName(custInfoPo.getRegAccount());
                    umcCustInfoSubDo.setCellPhone(custInfoPo.getRegMobile());
                }
            });
        }
        UmcUserInfoDo sysUserInfoDo = new UmcUserInfoDo();
        sysUserInfoDo.setSysCustInfoSubDos(rspBo);
        return sysUserInfoDo;
    }

    public SysThirdBindSubDo addThirdBind(SysThirdBindSubDo reqDo) {
        SysThirdBindPo sysThirdBindPo = (SysThirdBindPo)AuthRu.js((Object)reqDo, SysThirdBindPo.class);
        this.sysThirdBindMapper.insert(sysThirdBindPo);
        return reqDo;
    }

    public SysThirdBindSubDo updateThirdBind(SysThirdBindSubDo reqDo) {
        SysThirdBindPo sysThirdBindPo = (SysThirdBindPo)AuthRu.js((Object)reqDo, SysThirdBindPo.class);
        this.sysThirdBindMapper.updateById(sysThirdBindPo);
        return reqDo;
    }

    public UmcUserInfoDo getThirdBindList(SysThirdBindQryBo qryBo) {
        SysThirdBindPo sysThirdBindPo = (SysThirdBindPo)AuthRu.js((Object)qryBo, SysThirdBindPo.class);
        List<SysThirdBindPo> sysThirdBindPoList = this.sysThirdBindMapper.getList(sysThirdBindPo);
        List rspDo = AuthRu.jsl(sysThirdBindPoList, SysThirdBindSubDo.class);
        UmcUserInfoDo sysUserInfoDo = new UmcUserInfoDo();
        sysUserInfoDo.setSysThirdBindSubDos(rspDo);
        return sysUserInfoDo;
    }

    public SysUserChngLogSubDo addUserChngLog(SysUserChngLogSubDo reqDo) {
        SysUserChngLogPo sysThirdBindPo = (SysUserChngLogPo)AuthRu.js((Object)reqDo, SysUserChngLogPo.class);
        this.sysUserChngLogMapper.insert(sysThirdBindPo);
        return reqDo;
    }

    public SysUserChngLogSubListRspBo getUserChngLogList(SysUserChngLogQryBo qryBo) {
        SysUserChngLogPo SysUserChngLogPo2 = (SysUserChngLogPo)AuthRu.js((Object)qryBo, SysUserChngLogPo.class);
        Page page = new Page();
        page.setPageSize(qryBo.getPageSize());
        page.setPageNo(qryBo.getPageNo());
        List<SysUserChngLogPo> listPage = this.sysUserChngLogMapper.getListPage(SysUserChngLogPo2, (Page<SysUserChngLogPo>)page);
        SysUserChngLogSubListRspBo rspDo = new SysUserChngLogSubListRspBo();
        rspDo.setPageNo(page.getPageNo());
        rspDo.setTotal(page.getTotalPages());
        rspDo.setRecordsTotal(page.getTotalCount());
        rspDo.setRows(AuthRu.jsl(listPage, SysUserChngLogSubDo.class));
        return rspDo;
    }

    public UmcUserInfoDo addCustExtMapList(UmcUserInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getCustExtMapList())) {
            List addPo = AuthRu.jsl((List)reqDo.getCustExtMapList(), UmcCustExtMapPo.class);
            this.umcCustExtMapMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public UmcUserInfoDo updateCustExtMapList(UmcUserInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getCustExtMapList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getCustExtMapList(), UmcCustExtMapPo.class);
            for (UmcCustExtMapPo po : updatePo) {
                this.umcCustExtMapMapper.updateById(po);
            }
        }
        return reqDo;
    }

    public UmcUserInfoDo getCustExtMapList(UmcCustExtMapQryBo qryBo) {
        UmcCustExtMapPo qryPo = (UmcCustExtMapPo)UmcRu.js((Object)qryBo, UmcCustExtMapPo.class);
        List<UmcCustExtMapPo> sysCustExtMapPoList = this.umcCustExtMapMapper.getList(qryPo);
        List rspDo = AuthRu.jsl(sysCustExtMapPoList, UmcCustExtMapSubDo.class);
        UmcUserInfoDo sysUserInfoDo = new UmcUserInfoDo();
        sysUserInfoDo.setCustExtMapList(rspDo);
        return sysUserInfoDo;
    }

    public UmcAdmUserSubRspBo getAdmOrgList(UmcAdmUserQryBo qryBo) {
        SysAdmOrgRelPo qryPo = (SysAdmOrgRelPo)AuthRu.js((Object)qryBo, SysAdmOrgRelPo.class);
        List<SysAdmOrgRelPo> sysAdmOrgRelPoList = this.sysAdmOrgRelMapper.getList(qryPo);
        List rspDo = AuthRu.jsl(sysAdmOrgRelPoList, UmcAdmUserSubDo.class);
        UmcAdmUserSubRspBo rspBo = new UmcAdmUserSubRspBo();
        rspBo.setRows(rspDo);
        return rspBo;
    }

    public UmcCustUserSubListRspDo getCustUserList(UmcCustUserQryBo qryBo) {
        List<UmcCustUserPo> rspDo = this.umcUserInfoMapper.getCustUserList(qryBo);
        List subDoList = AuthRu.jsl(rspDo, UmcCustUserSubDo.class);
        UmcCustUserSubListRspDo listRspDo = new UmcCustUserSubListRspDo();
        listRspDo.setRows(subDoList);
        return listRspDo;
    }

    public AuthUserRoleStationListRspDO userRoleStationList(AuthUserRoleStationListQryBO qryBO) {
        AuthUserRoleStationListRspDO rspBO = new AuthUserRoleStationListRspDO();
        rspBO.setRespCode("0000");
        Page page = new Page(qryBO.getPageNo(), qryBO.getPageSize());
        List<UmcCustUserSubPo> userOrgPath = this.umcUserInfoMapper.getUserOrgPath(qryBO.getUserNameRel(), qryBO.getOrgIdRel(), qryBO.getQueryType(), qryBO.getStopStatus(), qryBO.getOrgStatus(), (Page<UmcCustUserSubPo>)page);
        if (CollectionUtils.isEmpty(userOrgPath)) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRows(AuthRu.jsl(userOrgPath, AuthUserRoleStationListDo.class));
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(qryBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    public UmcCustUserSubListRspDo getCustInfoByRoleAndOrg(UmcUserByRoleAndOrgQryBo qryBo) {
        UmcCustUserSubListRspDo rspBo = new UmcCustUserSubListRspDo();
        if (!CollectionUtils.isEmpty((Collection)qryBo.getRoleCodes())) {
            List<SysRoleInfoPo> sysRoleInfoPoList = this.sysRoleInfoMapper.getRoleIdByCodes(qryBo.getRoleCodes());
            if (CollectionUtils.isEmpty(sysRoleInfoPoList)) {
                return rspBo;
            }
            qryBo.setRoleCodes(null);
            qryBo.setRoleIds(sysRoleInfoPoList.stream().map(SysRoleInfoPo::getRoleId).distinct().collect(Collectors.toList()));
        }
        if (null != qryBo.getLvOrgId()) {
            if (CollectionUtils.isEmpty((Collection)qryBo.getLvOrgIdList())) {
                qryBo.setLvOrgIdList(Collections.singletonList(qryBo.getLvOrgId()));
            } else {
                qryBo.getLvOrgIdList().add(qryBo.getLvOrgId());
            }
            qryBo.setLvOrgId(null);
        }
        if (null != qryBo.getOrgIdWeb()) {
            if (CollectionUtils.isEmpty((Collection)qryBo.getLvOrgIdList())) {
                qryBo.setLvOrgIdList(Collections.singletonList(qryBo.getOrgIdWeb()));
            } else {
                qryBo.getLvOrgIdList().add(qryBo.getOrgIdWeb());
            }
            qryBo.setOrgIdWeb(null);
        }
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcCustUserPo> sysCustInfoSubDo = this.umcUserInfoMapper.getCustInfoByRoleAndOrg(qryBo, (Page<UmcCustUserSubDo>)page);
        rspBo.setRows(AuthRu.jsl(sysCustInfoSubDo, UmcCustUserSubDo.class));
        rspBo.setPageNo(qryBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        return rspBo;
    }

    public void updateCustInfoClearInitialPassword(UmcCustInfoSubDo custSubDo) {
        if (custSubDo.getCustId() != null) {
            UmcCustInfoPo custInfoPo = (UmcCustInfoPo)AuthRu.js((Object)custSubDo, UmcCustInfoPo.class);
            this.umcCustInfoMapper.clearInitialPasswordById(custInfoPo);
        }
    }

    public UmcCustInfoSubListRspBo queryRoleUser(UmcCustInfoQryBo sysCustInfoQryBo) {
        UmcCustInfoPo UmcCustInfoPo2 = new UmcCustInfoPo();
        UmcCustInfoPo2.setCompanyId(sysCustInfoQryBo.getCompanyId());
        UmcCustInfoPo2.setRoleIds(sysCustInfoQryBo.getRoleIds());
        UmcCustInfoPo2.setLoginName(sysCustInfoQryBo.getLoginName());
        UmcCustInfoPo2.setCustName(sysCustInfoQryBo.getCustName());
        UmcCustInfoPo2.setOrgName(sysCustInfoQryBo.getOrgName());
        Page page = new Page(sysCustInfoQryBo.getPageNo(), sysCustInfoQryBo.getPageSize());
        List<UmcCustInfoPo> UmcCustInfoPos = this.umcCustInfoMapper.queryRoleUser(UmcCustInfoPo2, (Page<UmcCustInfoPo>)page);
        UmcCustInfoSubListRspBo rspBo = new UmcCustInfoSubListRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(AuthRu.jsl(UmcCustInfoPos, UmcCustInfoSubDo.class));
        return rspBo;
    }

    public UmcUserListAdmSubListRspBo getUserListToAdm(UmcUserListAdmQryBo qryBo) {
        List<Long> userIds;
        Page page = new Page();
        page.setPageSize(qryBo.getPageSize());
        page.setPageNo(qryBo.getPageNo());
        List<UmcUserListAdmSubDo> userListToAdm = this.umcUserInfoMapper.getUserListToAdm(qryBo, (Page<UmcUserListAdmQryBo>)page);
        UmcUserListAdmSubListRspBo rspBo = new UmcUserListAdmSubListRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(AuthRu.jsl(userListToAdm, UmcUserListAdmSubDo.class));
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && !CollectionUtils.isEmpty(userIds = rspBo.getRows().stream().map(UmcUserListAdmSubDo::getUserId).distinct().collect(Collectors.toList()))) {
            SysAdmOrgRelPo sysAdmOrgRelPo = new SysAdmOrgRelPo();
            sysAdmOrgRelPo.setUserIdList(userIds);
            List<SysAdmOrgRelPo> sysAdmOrgRelPoList = this.sysAdmOrgRelMapper.getList(sysAdmOrgRelPo);
            if (!CollectionUtils.isEmpty(sysAdmOrgRelPoList)) {
                Map<Long, SysAdmOrgRelPo> admUserMap = sysAdmOrgRelPoList.stream().collect(Collectors.toMap(SysAdmOrgRelPo::getUserId, o -> o, (o1, o2) -> o2));
                for (UmcUserListAdmSubDo row : rspBo.getRows()) {
                    SysAdmOrgRelPo admOrgRelPo = admUserMap.get(row.getUserId());
                    if (null == admOrgRelPo) continue;
                    row.setAdmOrgId(admOrgRelPo.getAdmOrgId());
                    row.setAdmOrgTreePath(admOrgRelPo.getAdmOrgTreePath());
                }
            }
        }
        return rspBo;
    }

    public UmcCustUserSubListRspDo getHasCustUserList(UmcCustUserQryBo qryBo) {
        List<UmcCustUserPo> rspDo = this.umcUserInfoMapper.getHsaCustUserList(qryBo);
        List subDoList = AuthRu.jsl(rspDo, UmcCustUserSubDo.class);
        UmcCustUserSubListRspDo listRspDo = new UmcCustUserSubListRspDo();
        listRspDo.setRows(subDoList);
        return listRspDo;
    }

    public AuthQryUserByOrgAndRoleRspBo qryUserListByOrgAndRole(AuthQryUserByOrgAndRoleReqBo authQryUserByOrgAndRoleReqBo) {
        Page page = new Page(authQryUserByOrgAndRoleReqBo.getPageNo().intValue(), authQryUserByOrgAndRoleReqBo.getPageSize().intValue());
        UmcUserInfoPo UmcUserInfoPo2 = new UmcUserInfoPo();
        UmcUserInfoPo2.setOrgId(authQryUserByOrgAndRoleReqBo.getOrgId());
        UmcUserInfoPo2.setRoleId(authQryUserByOrgAndRoleReqBo.getRoleId());
        UmcUserInfoPo2.setCellPhone(authQryUserByOrgAndRoleReqBo.getPhoneNumberWeb());
        UmcUserInfoPo2.setCustName(authQryUserByOrgAndRoleReqBo.getUserNameWeb());
        List<UmcUserInfoPo> UmcUserInfoPos = this.umcUserInfoMapper.qryUserListByOrgAndRole(UmcUserInfoPo2, (Page<UmcUserInfoPo>)page);
        AuthQryUserByOrgAndRoleRspBo authQryUserByOrgAndRoleRspBo = new AuthQryUserByOrgAndRoleRspBo();
        authQryUserByOrgAndRoleRspBo.setRows(AuthRu.jsl(UmcUserInfoPos, AuthQryUserByOrgAndRoleBo.class));
        authQryUserByOrgAndRoleRspBo.setPageNo(authQryUserByOrgAndRoleReqBo.getPageNo().intValue());
        authQryUserByOrgAndRoleRspBo.setRecordsTotal(page.getTotalCount());
        authQryUserByOrgAndRoleRspBo.setTotal(page.getTotalPages());
        return authQryUserByOrgAndRoleRspBo;
    }

    public UmcCustUserSubListRspDo getHasOrNotCustUserList(UmcCustUserQryBo qryBo) {
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcCustUserSubPo> subPoList = null;
        subPoList = "0".equals(qryBo.getAssignFlag()) ? this.umcUserInfoMapper.getNotHasCustUserPageList(qryBo, (Page<UmcCustInfoPo>)page) : ("1".equals(qryBo.getAssignFlag()) ? this.umcUserInfoMapper.getHasCustUserPageList(qryBo, (Page<UmcCustInfoPo>)page) : ("10".equals(qryBo.getAssignFlag()) ? this.umcUserInfoMapper.getNotHasCustUserJustPersonPageList(qryBo, (Page<UmcCustInfoPo>)page) : ("11".equals(qryBo.getAssignFlag()) ? this.umcUserInfoMapper.getHasCustUserJustPersonPageList(qryBo, (Page<UmcCustInfoPo>)page) : this.umcUserInfoMapper.getAllCustUserPageList(qryBo, (Page<UmcCustInfoPo>)page))));
        UmcCustUserSubListRspDo rspDo = new UmcCustUserSubListRspDo();
        rspDo.setRecordsTotal(page.getTotalCount());
        rspDo.setPageNo(page.getPageNo());
        rspDo.setTotal(page.getTotalPages());
        rspDo.setRows(ObjectUtil.isNotEmpty(subPoList) ? AuthRu.jsl(subPoList, UmcCustUserSubDo.class) : new ArrayList());
        rspDo.setRespCode("0000");
        rspDo.setRespDesc("\u6210\u529f");
        return rspDo;
    }
}

