/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocApplyBiddingFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocApplyBiddingFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocApplyBiddingFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocApplyBiddingRespBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycUocApplyBiddingFunctionImpl
implements DycUocApplyBiddingFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocApplyBiddingFunctionImpl.class);
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;

    @Override
    public DycUocApplyBiddingFuncRspBO applyBatchBidding(DycUocApplyBiddingFuncReqBO reqBO) {
        String callUrl = null;
        callUrl = DycPropertiesUtil.getProperty("ESB_APPLY_BIDDING_URL");
        String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u8bf7\u6c42hsn:{}", (Object)hsn);
        Date callTime = new Date();
        String result = DycEsbUtil.doPostReuest(callUrl, JSON.toJSONString((Object)reqBO), hsn);
        Date retTime = new Date();
        this.intsertInterLog(reqBO.getBargainingId(), Long.valueOf(reqBO.getThirdApplyId()), callTime, retTime, hsn, callUrl, JSON.toJSONString((Object)reqBO), result);
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u51fa\u53c2: " + result);
        return this.resolveRsp(result);
    }

    private void verifyParam(DycUocApplyBiddingFuncReqBO reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getThirdApplyId())) {
            throw new ZTBusinessException("\u7b2c\u4e09\u65b9\u7533\u8bf7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBiddingName())) {
            throw new ZTBusinessException("\u5546\u673a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getQuotationDeadLine())) {
            throw new ZTBusinessException("\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSubmitter())) {
            throw new ZTBusinessException("\u63d0\u62a5\u4eba\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getBiddingAddressInfo())) {
            throw new ZTBusinessException("\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getBiddingAddressInfo().getAddressDesc())) {
            throw new ZTBusinessException("\u6536\u83b7\u5730\u5740\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBo.getBiddingDemandList())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u9700\u6c42\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getBiddingDemandList().forEach(obj -> {
            if (ObjectUtil.isEmpty((Object)obj.getPurchaseNum())) {
                throw new ZTBusinessException("\u5546\u54c1\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (obj.getPurchaseNum() == 0L) {
                throw new ZTBusinessException("\u5546\u54c1\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a0");
            }
            if (ObjectUtil.isEmpty((Object)obj.getThirdSkuUid())) {
                throw new ZTBusinessException("\u884c\u53f7ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getSkuId())) {
                throw new ZTBusinessException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getSkuName())) {
                throw new ZTBusinessException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }

    private DycUocApplyBiddingFuncRspBO resolveRsp(String returnString) {
        DycUocApplyBiddingFuncRspBO submitOrderRsp = new DycUocApplyBiddingFuncRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            DycUocApplyBiddingRespBO applyBiddingFuncRspBO = (DycUocApplyBiddingRespBO)JSON.parseObject((String)jsonObject.toJSONString(), DycUocApplyBiddingRespBO.class);
            submitOrderRsp.setResult(applyBiddingFuncRspBO);
            submitOrderRsp.setRespCode("0000");
            submitOrderRsp.setRespDesc("\u6210\u529f");
            return submitOrderRsp;
        }
        submitOrderRsp.setRespCode(rspJsonObject.getString("resultCode"));
        submitOrderRsp.setRespDesc(rspJsonObject.getString("resultMessage"));
        return submitOrderRsp;
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(1));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

