/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.member.shoppingcart.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.common.member.shoppingcart.api.DycUmcAddShoppingCartFunction;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycMallImportRecordFunctionBO;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycShoppingCartImportSkuFunctionBO;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionBo;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionReqBo;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionRspBo;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyBO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyReqBO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyRspBO;
import com.tydic.dyc.pro.dmc.service.purchaseAuth.api.DycProCommPurchaseAuthByBuyService;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrScopeJudgeQryService;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommShoppingCartGoodsQryService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeQryReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeQryRspBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsInfoBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsQryReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsQryRspBO;
import com.tydic.dyc.umc.service.shoppingcart.UmcAddShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.UmcGetShoppingCartPageListService;
import com.tydic.dyc.umc.service.shoppingcart.UmcUpdateSoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartRspBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListRspBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcUpdateSoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcUpdateSoppingCartRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycUmcAddShoppingCartFunctionImpl
implements DycUmcAddShoppingCartFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUmcAddShoppingCartFunctionImpl.class);
    @Autowired
    private UmcGetShoppingCartPageListService umcGetShoppingCartPageListService;
    @Autowired
    private UmcAddShoppingCartService umcAddShoppingCartService;
    @Autowired
    private UmcUpdateSoppingCartService umcUpdateSoppingCartService;
    @Autowired
    private DycProCommShoppingCartGoodsQryService dycProCommShoppingCartGoodsQryService;
    @Value(value="${maxProductAmount:1000000}")
    private int maxProductAmount;
    @Value(value="${maxCartNum:100}")
    private int maxCartNum;
    @Autowired
    private DycProCommAgrScopeJudgeQryService dycProCommAgrScopeJudgeQryService;
    @Autowired
    private DycProCommPurchaseAuthByBuyService dycProCommPurchaseAuthByBuyService;
    @Value(value="${staff.welfare.pay.config.enable:true}")
    private Boolean staffWelfarePayConfigEnable;

    @Override
    public DycUmcAddShoppingCartFunctionRspBo addShoppingCart(DycUmcAddShoppingCartFunctionReqBo reqBo) {
        Map<String, DycUmcAddShoppingCartFunctionBo> mapUniqueKeyBoMap = this.validParam(reqBo);
        ArrayList<DycMallImportRecordFunctionBO> uscImportRecordBOSuccess = new ArrayList<DycMallImportRecordFunctionBO>();
        ArrayList<DycMallImportRecordFunctionBO> uscImportRecordBOfail = new ArrayList<DycMallImportRecordFunctionBO>();
        ArrayList<DycShoppingCartImportSkuFunctionBO> uscImportSkuBOFail = new ArrayList<DycShoppingCartImportSkuFunctionBO>();
        DycUmcAddShoppingCartFunctionRspBo busiRspBO = new DycUmcAddShoppingCartFunctionRspBo();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u52a0\u8d2d\u6210\u529f");
        List<DycUmcAddShoppingCartFunctionBo> uscParmGoddsInfoBOList = reqBo.getUscAddGoddsInfoBOList();
        List<DycUmcAddShoppingCartFunctionBo> uscAddGoddsInfoBOList = new ArrayList<DycUmcAddShoppingCartFunctionBo>(uscParmGoddsInfoBOList);
        List<DycUmcAddShoppingCartFunctionBo> uscUpdateGoddsInfoBOList = new ArrayList<DycUmcAddShoppingCartFunctionBo>();
        ArrayList<Long> numErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> statusErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> availableSaleErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> areaLimitErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> stockStateErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> availableCatalogErrorSkuId = new ArrayList<Long>();
        ArrayList<Long> buyErrorSkuId = new ArrayList<Long>();
        ArrayList<Long> agrScopeErrorSkuId = new ArrayList<Long>();
        ArrayList<Long> totalErrorSkuIds = new ArrayList<Long>();
        String errorMsg1 = "";
        this.validShopCart(reqBo, uscImportRecordBOfail, mapUniqueKeyBoMap, uscAddGoddsInfoBOList, uscUpdateGoddsInfoBOList, numErrorSkuIds, totalErrorSkuIds);
        this.validSku(reqBo, uscImportRecordBOfail, uscImportSkuBOFail, uscParmGoddsInfoBOList, statusErrorSkuIds, availableSaleErrorSkuIds, areaLimitErrorSkuIds, stockStateErrorSkuIds, totalErrorSkuIds, availableCatalogErrorSkuId, buyErrorSkuId, agrScopeErrorSkuId);
        if (!CollectionUtils.isEmpty(uscAddGoddsInfoBOList)) {
            uscAddGoddsInfoBOList = uscAddGoddsInfoBOList.stream().filter(e -> !totalErrorSkuIds.contains(e.getSkuId())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(uscUpdateGoddsInfoBOList)) {
            uscUpdateGoddsInfoBOList = uscUpdateGoddsInfoBOList.stream().filter(e -> !totalErrorSkuIds.contains(e.getSkuId())).collect(Collectors.toList());
        }
        this.addAndUpdateCart(reqBo, uscAddGoddsInfoBOList, uscUpdateGoddsInfoBOList);
        List<Object> failIds = new ArrayList();
        if (!CollectionUtils.isEmpty(uscImportRecordBOfail)) {
            failIds = uscImportSkuBOFail.stream().map(DycShoppingCartImportSkuFunctionBO::getSkuId).collect(Collectors.toList());
        }
        for (DycUmcAddShoppingCartFunctionBo bo : reqBo.getUscAddGoddsInfoBOList()) {
            if (failIds.contains(bo.getSkuId())) continue;
            DycMallImportRecordFunctionBO successBo = new DycMallImportRecordFunctionBO();
            successBo.setSkuId(bo.getSkuId());
            successBo.setProductAmount(bo.getProductAmount());
            successBo.setSpId(bo.getSpId());
            uscImportRecordBOSuccess.add(successBo);
        }
        busiRspBO.setUscImportRecordBOfail(uscImportRecordBOfail);
        busiRspBO.setUscImportRecordBOSuccess(uscImportRecordBOSuccess);
        busiRspBO.setUscImportSkuBOfail(uscImportSkuBOFail);
        return busiRspBO;
    }

    private void addAndUpdateCart(DycUmcAddShoppingCartFunctionReqBo reqBo, List<DycUmcAddShoppingCartFunctionBo> uscAddGoddsInfoBOList, List<DycUmcAddShoppingCartFunctionBo> uscUpdateGoddsInfoBOList) {
        String joinPrice;
        UmcAddShoppingCartBo shoppingCartBo;
        ArrayList<UmcAddShoppingCartBo> umcAddShoppingCartBos;
        if (uscUpdateGoddsInfoBOList.size() > 0) {
            UmcUpdateSoppingCartReqBo updateSoppingCartReqBo = new UmcUpdateSoppingCartReqBo();
            updateSoppingCartReqBo.setLoginSource(reqBo.getLoginSourceIn());
            updateSoppingCartReqBo.setUserId(reqBo.getUserIdIn());
            updateSoppingCartReqBo.setTenantId(reqBo.getTenantIdIn());
            updateSoppingCartReqBo.setUserName(reqBo.getRegAccountIn());
            umcAddShoppingCartBos = new ArrayList<UmcAddShoppingCartBo>();
            for (DycUmcAddShoppingCartFunctionBo bo : uscUpdateGoddsInfoBOList) {
                shoppingCartBo = new UmcAddShoppingCartBo();
                joinPrice = bo.getJoinPrice();
                bo.setJoinPrice(null);
                shoppingCartBo = (UmcAddShoppingCartBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), UmcAddShoppingCartBo.class);
                shoppingCartBo.setProductAmount(new BigDecimal(bo.getProductAmount()));
                if (!StringUtils.isEmpty((Object)joinPrice)) {
                    try {
                        shoppingCartBo.setJoinPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(joinPrice)));
                    }
                    catch (Exception e) {
                        log.error("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                        throw new ZTBusinessException(e.getMessage());
                    }
                } else {
                    shoppingCartBo.setJoinPrice(Long.valueOf(0L));
                }
                umcAddShoppingCartBos.add(shoppingCartBo);
            }
            updateSoppingCartReqBo.setUmcAddShoppingCartBos(umcAddShoppingCartBos);
            UmcUpdateSoppingCartRspBo umcUpdateSoppingCartRspBo = this.umcUpdateSoppingCartService.updateSoppingCart(updateSoppingCartReqBo);
            if (!"0000".equals(umcUpdateSoppingCartRspBo.getRespCode())) {
                throw new ZTBusinessException(umcUpdateSoppingCartRspBo.getRespDesc());
            }
        }
        if (uscAddGoddsInfoBOList.size() > 0) {
            UmcAddShoppingCartReqBo addShoppingCartReqBo = new UmcAddShoppingCartReqBo();
            addShoppingCartReqBo.setLoginSource(reqBo.getLoginSourceIn());
            addShoppingCartReqBo.setUserId(reqBo.getUserIdIn());
            addShoppingCartReqBo.setTenantId(reqBo.getTenantIdIn());
            addShoppingCartReqBo.setUserName(reqBo.getRegAccountIn());
            umcAddShoppingCartBos = new ArrayList();
            for (DycUmcAddShoppingCartFunctionBo bo : uscAddGoddsInfoBOList) {
                shoppingCartBo = new UmcAddShoppingCartBo();
                joinPrice = bo.getJoinPrice();
                bo.setJoinPrice(null);
                shoppingCartBo = (UmcAddShoppingCartBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), UmcAddShoppingCartBo.class);
                if (!StringUtils.isEmpty((Object)joinPrice)) {
                    try {
                        shoppingCartBo.setJoinPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(joinPrice)));
                    }
                    catch (Exception e) {
                        log.error("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                        throw new ZTBusinessException("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                    }
                } else {
                    shoppingCartBo.setJoinPrice(Long.valueOf(0L));
                }
                shoppingCartBo.setProductAmount(new BigDecimal(bo.getProductAmount()));
                umcAddShoppingCartBos.add(shoppingCartBo);
            }
            addShoppingCartReqBo.setUmcAddShoppingCartBos(umcAddShoppingCartBos);
            UmcAddShoppingCartRspBo umcAddShoppingCartRspBo = this.umcAddShoppingCartService.addShoppingCart(addShoppingCartReqBo);
            if (!"0000".equals(umcAddShoppingCartRspBo.getRespCode())) {
                throw new ZTBusinessException(umcAddShoppingCartRspBo.getRespDesc());
            }
        }
    }

    private void validSku(DycUmcAddShoppingCartFunctionReqBo reqBo, List<DycMallImportRecordFunctionBO> uscImportRecordBOfail, List<DycShoppingCartImportSkuFunctionBO> uscImportSkuBOFail, List<DycUmcAddShoppingCartFunctionBo> uscParmGoddsInfoBOList, List<Long> statusErrorSkuIds, List<Long> availableSaleErrorSkuIds, List<Long> areaLimitErrorSkuIds, List<Long> stockStateErrorSkuIds, List<Long> totalErrorSkuIds, List<Long> scopeErrorSkuId, List<Long> buyErrorSkuId, List<Long> agrScopeErrorSkuId) {
        if (0 != reqBo.getIsCheck()) {
            DycProCommShoppingCartGoodsQryReqBO dycProCommShoppingCartGoodsQryReqBO = new DycProCommShoppingCartGoodsQryReqBO();
            dycProCommShoppingCartGoodsQryReqBO.setCity(Convert.toLong((Object)reqBo.getCity()));
            dycProCommShoppingCartGoodsQryReqBO.setProvince(Convert.toLong((Object)reqBo.getProvince()));
            dycProCommShoppingCartGoodsQryReqBO.setCounty(Convert.toLong((Object)reqBo.getCounty()));
            dycProCommShoppingCartGoodsQryReqBO.setTown(Convert.toLong((Object)reqBo.getTown()));
            dycProCommShoppingCartGoodsQryReqBO.setReturnType(Integer.valueOf(1));
            ArrayList<DycProCommShoppingCartGoodsBO> dycProCommShoppingCartGoodsBOS = new ArrayList<DycProCommShoppingCartGoodsBO>();
            for (DycUmcAddShoppingCartFunctionBo dycUmcAddShoppingCartFunctionBo : uscParmGoddsInfoBOList) {
                DycProCommShoppingCartGoodsBO dycProCommShoppingCartGoodsBO = new DycProCommShoppingCartGoodsBO();
                dycProCommShoppingCartGoodsBO.setSkuId(dycUmcAddShoppingCartFunctionBo.getSkuId());
                dycProCommShoppingCartGoodsBO.setSpId(dycUmcAddShoppingCartFunctionBo.getSpId());
                dycProCommShoppingCartGoodsBO.setNum(new BigDecimal(dycUmcAddShoppingCartFunctionBo.getProductAmount()));
                String key = reqBo.getUserId() + "_" + dycUmcAddShoppingCartFunctionBo.getPurchaseModId() + "_" + dycUmcAddShoppingCartFunctionBo.getSkuId();
                dycProCommShoppingCartGoodsBO.setKey(key);
                dycProCommShoppingCartGoodsBOS.add(dycProCommShoppingCartGoodsBO);
            }
            dycProCommShoppingCartGoodsQryReqBO.setSkuList(dycProCommShoppingCartGoodsBOS);
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProCommShoppingCartGoodsQryReqBO));
            DycProCommShoppingCartGoodsQryRspBO dycProCommShoppingCartGoodsQryRspBO = this.dycProCommShoppingCartGoodsQryService.qryShoppingCartGoods(dycProCommShoppingCartGoodsQryReqBO);
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProCommShoppingCartGoodsQryRspBO));
            if (!"0000".equals(dycProCommShoppingCartGoodsQryRspBO.getRespCode())) {
                throw new ZTBusinessException(dycProCommShoppingCartGoodsQryRspBO.getRespDesc());
            }
            Map<String, DycProCommShoppingCartGoodsInfoBO> spSkuMap = dycProCommShoppingCartGoodsQryRspBO.getSkuInfoList().stream().collect(Collectors.toMap(DycProCommShoppingCartGoodsInfoBO::getKey, o -> o, (o1, o2) -> o1));
            List skuIds = dycProCommShoppingCartGoodsQryRspBO.getSkuInfoList().stream().map(DycProCommShoppingCartGoodsInfoBO::getSkuId).collect(Collectors.toList());
            DycProCommAgrScopeJudgeQryReqBO dycProCommAgrScopeJudgeQryReqBO = new DycProCommAgrScopeJudgeQryReqBO();
            dycProCommAgrScopeJudgeQryReqBO.setSkuIds(skuIds);
            dycProCommAgrScopeJudgeQryReqBO.setCompanyId(reqBo.getCompanyId());
            dycProCommAgrScopeJudgeQryReqBO.setOrgPath(reqBo.getOrgPath());
            DycProCommAgrScopeJudgeQryRspBO dycProCommAgrScopeJudgeQryRspBO = this.dycProCommAgrScopeJudgeQryService.qryAgrScopeJudge(dycProCommAgrScopeJudgeQryReqBO);
            if (!"0000".equals(dycProCommAgrScopeJudgeQryRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u534f\u8bae\u5e94\u7528\u8303\u56f4\u5931\u8d25:" + dycProCommAgrScopeJudgeQryRspBO.getRespDesc());
            }
            DycProCommPurchaseAuthByBuyReqBO dycProCommPurchaseAuthByBuyReqBO = new DycProCommPurchaseAuthByBuyReqBO();
            dycProCommPurchaseAuthByBuyReqBO.setSkuIds(skuIds);
            dycProCommPurchaseAuthByBuyReqBO.setOrgPath(reqBo.getOrgPath());
            DycProCommPurchaseAuthByBuyRspBO dycProCommPurchaseAuthByBuyRspBO = this.dycProCommPurchaseAuthByBuyService.qryPurchaseByBuy(dycProCommPurchaseAuthByBuyReqBO);
            if (!"0000".equals(dycProCommPurchaseAuthByBuyRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u91c7\u4e70\u6743\u9650\u5931\u8d25:" + dycProCommPurchaseAuthByBuyRspBO.getRespDesc());
            }
            Map<Object, Object> notBuySkuMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)dycProCommPurchaseAuthByBuyRspBO.getRows())) {
                notBuySkuMap = dycProCommPurchaseAuthByBuyRspBO.getRows().stream().collect(Collectors.toMap(DycProCommPurchaseAuthByBuyBO::getSkuId, DycProCommPurchaseAuthByBuyBO::isBuyFlag));
            }
            Map<Long, DycProCommAgrScopeJudgeBO> skuAgrScopeMap = dycProCommAgrScopeJudgeQryRspBO.getSkuAgrScopeList().stream().collect(Collectors.toMap(DycProCommAgrScopeJudgeBO::getSkuId, o -> o, (o1, o2) -> o1));
            for (DycUmcAddShoppingCartFunctionBo addShoppingCartBo : uscParmGoddsInfoBOList) {
                DycProCommAgrScopeJudgeBO dycProCommAgrScopeJudgeBO;
                DycShoppingCartImportSkuFunctionBO uscImportSkuBO;
                DycMallImportRecordFunctionBO uscImportRecordBO;
                String key = reqBo.getUserId() + "_" + addShoppingCartBo.getPurchaseModId() + "_" + addShoppingCartBo.getSkuId();
                DycProCommShoppingCartGoodsInfoBO uscBatchShopQryMsgRspBO = spSkuMap.get(key);
                if (uscBatchShopQryMsgRspBO == null) continue;
                if (DycFuncCommonConstants.goodsStatus.DOWN.equals(uscBatchShopQryMsgRspBO.getSkuState()) || !uscBatchShopQryMsgRspBO.getSkuStatus().equals(2)) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    statusErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u5df2\u4e0b\u67b6\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setStatusStr("\u5546\u54c1\u5df2\u4e0b\u67b6");
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u5df2\u4e0b\u67b6\uff01");
                    if (null == uscBatchShopQryMsgRspBO.getPicInfo()) continue;
                    uscImportSkuBO.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    continue;
                }
                if (uscBatchShopQryMsgRspBO.getSkuSource().equals(2) && (uscBatchShopQryMsgRspBO.getAvailableSale() == null || !DycFuncCommonConstants.availableSale.SALE.equals(uscBatchShopQryMsgRspBO.getAvailableSale()))) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    availableSaleErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u4e0d\u53ef\u552e\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setStatusStr("\u4e0d\u53ef\u552e");
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u4e0d\u53ef\u552e\uff01");
                    if (null != uscBatchShopQryMsgRspBO.getPicInfo()) {
                        uscImportSkuBO.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    }
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (skuAgrScopeMap.containsKey(uscBatchShopQryMsgRspBO.getSkuId()) && null != (dycProCommAgrScopeJudgeBO = skuAgrScopeMap.get(uscBatchShopQryMsgRspBO.getSkuId())) && !dycProCommAgrScopeJudgeBO.getPurFlag().booleanValue()) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    agrScopeErrorSkuId.add(uscBatchShopQryMsgRspBO.getSkuId());
                    DycMallImportRecordFunctionBO uscImportRecordBO2 = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO2.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO2.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO2.setFailedReason("\u5546\u54c1\u4e0d\u5728\u534f\u8bae\u53ef\u4e70\u8303\u56f4\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO2);
                    DycShoppingCartImportSkuFunctionBO uscImportSkuBO2 = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO2);
                    uscImportSkuBO2.setStatusStr("\u5546\u54c1\u4e0d\u5728\u534f\u8bae\u53ef\u4e70\u8303\u56f4");
                    uscImportSkuBO2.setFailedReason("\u5546\u54c1\u4e0d\u5728\u534f\u8bae\u53ef\u4e70\u8303\u56f4\uff01");
                    if (null != uscBatchShopQryMsgRspBO.getPicInfo()) {
                        uscImportSkuBO2.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    }
                    uscImportSkuBOFail.add(uscImportSkuBO2);
                    continue;
                }
                if (uscBatchShopQryMsgRspBO.getSkuSource().equals(2) && (uscBatchShopQryMsgRspBO.getAreaLimit() == null || DycFuncCommonConstants.areaLimit.NO_SALE.equals(uscBatchShopQryMsgRspBO.getAreaLimit()))) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    areaLimitErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u533a\u57df\u9650\u5236\u5185\u4e0d\u53ef\u552e\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u533a\u57df\u9650\u5236\u5185\u4e0d\u53ef\u552e");
                    if (null != uscBatchShopQryMsgRspBO.getPicInfo()) {
                        uscImportSkuBO.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    }
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (uscBatchShopQryMsgRspBO.getSkuSource().equals(2) && (uscBatchShopQryMsgRspBO.getStockStateId() == null || DycFuncCommonConstants.stockStateId.NO_STOCK.equals(uscBatchShopQryMsgRspBO.getStockStateId())) || DycFuncCommonConstants.stockStateId.WU_HUO.equals(uscBatchShopQryMsgRspBO.getStockStateId())) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    stockStateErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                    if (null != uscBatchShopQryMsgRspBO.getPicInfo()) {
                        uscImportSkuBO.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    }
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (uscBatchShopQryMsgRspBO.getSkuSource().equals(3) && uscBatchShopQryMsgRspBO.getStockInfo().getUnsaleNum().compareTo(uscBatchShopQryMsgRspBO.getNum()) < 0) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    stockStateErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                    if (null != uscBatchShopQryMsgRspBO.getPicInfo()) {
                        uscImportSkuBO.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    }
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (uscBatchShopQryMsgRspBO.getBansFlag().equals(1)) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    scopeErrorSkuId.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u5df2\u7981\u552e\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u5df2\u7981\u552e");
                    if (null != uscBatchShopQryMsgRspBO.getPicInfo()) {
                        uscImportSkuBO.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    }
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (notBuySkuMap.containsKey(uscBatchShopQryMsgRspBO.getSkuId())) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    buyErrorSkuId.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u91c7\u4e70\u6743\u9650\u4e3a\u4e0d\u53ef\u4e70\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u91c7\u4e70\u6743\u9650\u4e3a\u4e0d\u53ef\u4e70");
                    if (null != uscBatchShopQryMsgRspBO.getPicInfo()) {
                        uscImportSkuBO.setImage(uscBatchShopQryMsgRspBO.getPicInfo().getPicUrl());
                    }
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (!reqBo.getIsImport().booleanValue()) continue;
                addShoppingCartBo.setSupplierId(uscBatchShopQryMsgRspBO.getSupplierId());
            }
        }
    }

    private void validShopCart(DycUmcAddShoppingCartFunctionReqBo reqBo, List<DycMallImportRecordFunctionBO> uscImportRecordBOfail, Map<String, DycUmcAddShoppingCartFunctionBo> mapUniqueKeyBoMap, List<DycUmcAddShoppingCartFunctionBo> uscAddGoddsInfoBOList, List<DycUmcAddShoppingCartFunctionBo> uscUpdateGoddsInfoBOList, List<Long> numErrorSkuIds, List<Long> totalErrorSkuIds) {
        UmcGetShoppingCartPageListReqBo umcGetShoppingCartPageListReqBo = new UmcGetShoppingCartPageListReqBo();
        umcGetShoppingCartPageListReqBo.setUserId(reqBo.getUserIdIn());
        umcGetShoppingCartPageListReqBo.setPageSize(-1);
        UmcGetShoppingCartPageListRspBo umcGetShoppingCartPageListRspBo = this.umcGetShoppingCartPageListService.getShoppingCartPageList(umcGetShoppingCartPageListReqBo);
        if (!"0000".equals(umcGetShoppingCartPageListRspBo.getRespCode())) {
            throw new ZTBusinessException(umcGetShoppingCartPageListRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)umcGetShoppingCartPageListRspBo.getRows())) {
            HashMap<Integer, Integer> shopOrderSourceNum = new HashMap<Integer, Integer>();
            for (UmcAddShoppingCartBo bo : umcGetShoppingCartPageListRspBo.getRows()) {
                DycUmcAddShoppingCartFunctionBo updateGoodsInfoBO = mapUniqueKeyBoMap.get(bo.getUniqueKey());
                if (updateGoodsInfoBO != null) {
                    BigDecimal productAmount = bo.getProductAmount() == null ? new BigDecimal(0) : bo.getProductAmount();
                    BigDecimal joinAmount = new BigDecimal(updateGoodsInfoBO.getProductAmount()).add(productAmount);
                    if (joinAmount.compareTo(new BigDecimal(this.maxProductAmount)) > 0) {
                        totalErrorSkuIds.add(bo.getSkuId());
                        numErrorSkuIds.add(bo.getSkuId());
                        DycMallImportRecordFunctionBO uscImportRecordBO = new DycMallImportRecordFunctionBO();
                        uscImportRecordBO.setSkuId(bo.getSkuId());
                        uscImportRecordBO.setProductAmount(updateGoodsInfoBO.getProductAmount());
                        uscImportRecordBO.setFailedReason("\u65b0\u52a0\u5165\u6570\u91cf\u4e0e\u5df2\u6709\u6570\u91cf\u4e4b\u548c>" + this.maxProductAmount + "!");
                        uscImportRecordBOfail.add(uscImportRecordBO);
                        continue;
                    }
                    updateGoodsInfoBO.setProductAmount(joinAmount.toString());
                    updateGoodsInfoBO.setSpId(bo.getSpId());
                    uscUpdateGoddsInfoBOList.add(updateGoodsInfoBO);
                }
                if (shopOrderSourceNum.containsKey(bo.getOrderSource())) {
                    shopOrderSourceNum.put(bo.getOrderSource(), (Integer)shopOrderSourceNum.get(bo.getOrderSource()) + 1);
                    continue;
                }
                shopOrderSourceNum.put(bo.getOrderSource(), 1);
            }
            uscAddGoddsInfoBOList.removeAll(uscUpdateGoddsInfoBOList);
            if (uscAddGoddsInfoBOList.size() > 0) {
                HashMap<Integer, Integer> addOrderSourceNum = new HashMap<Integer, Integer>();
                for (DycUmcAddShoppingCartFunctionBo addGoddsInfoBO : uscAddGoddsInfoBOList) {
                    if (addOrderSourceNum.containsKey(addGoddsInfoBO.getOrderSource())) {
                        addOrderSourceNum.put(addGoddsInfoBO.getOrderSource(), (Integer)addOrderSourceNum.get(addGoddsInfoBO.getOrderSource()) + 1);
                        continue;
                    }
                    addOrderSourceNum.put(addGoddsInfoBO.getOrderSource(), 1);
                }
                for (Integer orderSource : addOrderSourceNum.keySet()) {
                    Integer origin;
                    Integer add = (Integer)addOrderSourceNum.get(orderSource);
                    Integer n = origin = shopOrderSourceNum.get(orderSource) == null ? Integer.valueOf(0) : (Integer)shopOrderSourceNum.get(orderSource);
                    if (add + origin <= this.maxCartNum) continue;
                    if (orderSource == 2) {
                        throw new ZTBusinessException("\u7b2c\u4e09\u65b9\u7535\u5546\u5546\u54c1-\u8d2d\u7269\u8f66\u5df2\u6ee1,\u9700\u8981\u7528\u6237\u8fdb\u5165\u8d2d\u7269\u8f66\u5220\u9664\u90e8\u5206\u5546\u54c1\uff01");
                    }
                    if (orderSource != 3) continue;
                    throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1-\u5546\u54c1\u8d2d\u7269\u8f66\u5df2\u6ee1,\u9700\u8981\u7528\u6237\u8fdb\u5165\u8d2d\u7269\u8f66\u5220\u9664\u90e8\u5206\u5546\u54c1\uff01");
                }
            }
        }
    }

    private Map<String, DycUmcAddShoppingCartFunctionBo> validParam(DycUmcAddShoppingCartFunctionReqBo abilityReqBO) {
        if (null == abilityReqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a!");
        }
        if (abilityReqBO.getUserId() == null) {
            throw new ZTBusinessException("\u4f1a\u5458Id\u4e3a\u7a7a!");
        }
        if (null == abilityReqBO.getProvince()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010province\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getCity()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010city\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getCounty()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010county\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getTown()) {
            abilityReqBO.setTown(0);
        }
        if (StringUtils.isEmpty(abilityReqBO.getUscAddGoddsInfoBOList())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010uscAddGoddsInfoBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (abilityReqBO.getUscAddGoddsInfoBOList().size() > this.maxCartNum) {
            throw new ZTBusinessException("\u8d2d\u7269\u8f66\u5df2\u6ee1,\u9700\u8981\u7528\u6237\u8fdb\u5165\u8d2d\u7269\u8f66\u5220\u9664\u90e8\u5206\u5546\u54c1\uff01");
        }
        if (abilityReqBO.getIsCheck() == null) {
            abilityReqBO.setIsCheck(1);
        }
        HashMap<String, String> skuPurchaseModIdMap = new HashMap<String, String>();
        HashMap<String, DycUmcAddShoppingCartFunctionBo> mapUniqueKeyBoMap = new HashMap<String, DycUmcAddShoppingCartFunctionBo>();
        Long activeId = null;
        for (DycUmcAddShoppingCartFunctionBo bo : abilityReqBO.getUscAddGoddsInfoBOList()) {
            if (StringUtils.isEmpty((Object)bo.getSpDesc())) {
                bo.setSpDesc("0");
            }
            if ("1".equals(bo.getSpDesc())) {
                if (bo.getSpuId() == null) {
                    throw new ZTBusinessException("\u3010spuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                activeId = bo.getSpuId();
                bo.setPurchaseModId(bo.getSpuId().toString());
                bo.setPurchaseModName("\u5458\u5de5\u798f\u5229");
            } else {
                if (StringUtils.isEmpty((Object)bo.getPurchaseModId())) {
                    throw new ZTBusinessException("\u3010purchaseModId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if ("1".equals(bo.getPurchaseModId())) {
                    bo.setPurchaseModName("\u8ba1\u5212");
                } else {
                    bo.setPurchaseModName("\u975e\u8ba1\u5212");
                }
            }
            String purchaseModId = (String)skuPurchaseModIdMap.get(bo.getSkuId().toString());
            if (purchaseModId != null && purchaseModId.equals(bo.getPurchaseModId())) {
                throw new ZTBusinessException("\u540c\u4e00\u4e2a\u91c7\u8d2d\u6a21\u5f0f\u4e0b\u7684\u5355\u54c1\u7f16\u7801[SkuId]\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            skuPurchaseModIdMap.put(bo.getSkuId().toString(), bo.getPurchaseModId());
            if (StringUtils.isEmpty((Object)bo.getSkuId())) {
                throw new ZTBusinessException("\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)bo.getSupplierShopId())) {
                throw new ZTBusinessException("\u3010SupplierShopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getOrderSource()) {
                throw new ZTBusinessException("\u3010orderSource\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)bo.getProductAmount())) {
                bo.setProductAmount("1");
            }
            if (!StringUtils.isEmpty((Object)bo.getProductAmount()) && new BigDecimal(bo.getProductAmount()).compareTo(new BigDecimal(this.maxProductAmount)) > 0) {
                throw new ZTBusinessException("\u3010JoinAmount\u3011\u6700\u5927\u4e0d\u80fd\u8d85\u8fc7" + this.maxProductAmount);
            }
            if (null == bo.getSupplierId()) {
                throw new ZTBusinessException("\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            bo.setUniqueKey(abilityReqBO.getUserId() + "_" + bo.getPurchaseModId() + "_" + bo.getSkuId());
            mapUniqueKeyBoMap.put(bo.getUniqueKey(), bo);
        }
        return mapUniqueKeyBoMap;
    }
}

