/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreCancelSaleOrderFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCancelSaleOrderFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCancelSaleOrderFuncRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreCancelSaleOrderFunctionImpl
implements DycUocEstoreCancelSaleOrderFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreCancelSaleOrderFunctionImpl.class);
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;

    @Override
    public DycUocEstoreCancelSaleOrderFuncRspBO cancelSaleOrder(DycUocEstoreCancelSaleOrderFuncReqBO reqBO) {
        DycUocEstoreCancelSaleOrderFuncRspBO rspBO = new DycUocEstoreCancelSaleOrderFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.validateArg(reqBO);
        JSONObject json = new JSONObject();
        json.put("orgId", (Object)reqBO.getOrgId());
        if (reqBO.getSupplierNo().equals(DycPropertiesUtil.getProperty("SUPPLIER_JD_ID"))) {
            json.put("jdOrderId", (Object)reqBO.getOutOrderId());
        } else {
            json.put("orderId", (Object)reqBO.getOutOrderId());
        }
        json.put("cancelReason", (Object)reqBO.getCancelReason());
        String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBO.getSupplierNo());
        try {
            String resultCode;
            log.info("\u53d6\u6d88\u8ba2\u5355\u5165\u53c2: {}", (Object)json.toJSONString());
            Date callTime = new Date();
            String httpRspStr = DycEsbUtil.doPostReuest(DycPropertiesUtil.getProperty("ESB_CANCEL_ORDER_URL"), json.toJSONString(), hsn);
            Date retTime = new Date();
            this.intsertInterLog(reqBO.getOrderId(), reqBO.getObjId(), callTime, retTime, hsn, DycPropertiesUtil.getProperty("ESB_CANCEL_ORDER_URL"), json.toJSONString(), httpRspStr);
            log.info("httpRspStr: {}", (Object)httpRspStr);
            if (!("true".equalsIgnoreCase(JSONObject.parseObject((String)httpRspStr).getString("success")) || "0000".equals(resultCode = JSONObject.parseObject((String)httpRspStr).getString("resultCode")) || "0002".equals(resultCode))) {
                throw new ZTBusinessException(JSONObject.parseObject((String)httpRspStr).getString("resultMessage"));
            }
        }
        catch (ZTBusinessException e) {
            log.error("\u8c03\u7528\u7535\u5546\u63a5\u53e3\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    public void validateArg(DycUocEstoreCancelSaleOrderFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO))) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOutOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u5916\u90e8\u7535\u5546ID[outOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSupplierNo())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u4f9b\u5e94\u5546\u7f16\u7801[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(2));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

