/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.config.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.dyc.config.api.CfcCommonUniteParamPlatformBreachQryListPageService;
import com.tydic.dyc.config.bo.CfcCommonUniteParamBO;
import com.tydic.dyc.config.bo.CfcCommonUniteParamPlatformBreachQryListPageReqBO;
import com.tydic.dyc.config.bo.CfcCommonUniteParamPlatformBreachQryListPageRspBO;
import com.tydic.dyc.config.bo.PlatformBreachBO;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.config.api.CfcCommonUniteParamPlatformBreachQryListPageService"})
public class CfcCommonUniteParamPlatformBreachQryListPageServiceImpl
implements CfcCommonUniteParamPlatformBreachQryListPageService {
    private static final Logger log = LoggerFactory.getLogger(CfcCommonUniteParamPlatformBreachQryListPageServiceImpl.class);
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;

    @Override
    @PostMapping(value={"qryPlatformBreachListPage"})
    public CfcCommonUniteParamPlatformBreachQryListPageRspBO qryPlatformBreachListPage(@RequestBody CfcCommonUniteParamPlatformBreachQryListPageReqBO reqBO) {
        CfcUniteParamQryListPageAbilityReqBO abilityReqBO = new CfcUniteParamQryListPageAbilityReqBO();
        abilityReqBO.setCenter("FSC");
        abilityReqBO.setGroupCode("PLATFORM_BREACH");
        abilityReqBO.setPageNo(reqBO.getPageNo());
        abilityReqBO.setPageSize(reqBO.getPageSize());
        CfcUniteParamQryListPageAbilityRspBO abilityRspBO = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        CfcCommonUniteParamPlatformBreachQryListPageRspBO rspBO = new CfcCommonUniteParamPlatformBreachQryListPageRspBO();
        Map<String, List<FscDicDictionaryBO>> dealNotPayCreditMap = this.getDicMap("FSC_PLATFORM_USE_FEE_CREDIT");
        Map<String, List<FscDicDictionaryBO>> dealRuleCreditMap = this.getDicMap("FSC_PLATFORM_USE_FEE_RULE_CREDIT");
        rspBO.setPageNo(abilityRspBO.getPageNo());
        rspBO.setRecordsTotal(abilityRspBO.getRecordsTotal());
        rspBO.setTotal(abilityRspBO.getTotal());
        ArrayList<PlatformBreachBO> platformBreachBOS = new ArrayList<PlatformBreachBO>();
        if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            log.info("---------\u5f00\u59cb\u5bf9\u67e5\u8be2\u5230\u7684\u6570\u636e\u8fdb\u884c\u904d\u5386\uff0c\u8f6c\u8bd1\uff1a{}", (Object)abilityRspBO);
            for (JSONObject json : abilityRspBO.getRows()) {
                PlatformBreachBO platformBreachBO = (PlatformBreachBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), PlatformBreachBO.class);
                if (!CollectionUtils.isEmpty((Collection)dealNotPayCreditMap.get(platformBreachBO.getBreachCondition()))) {
                    platformBreachBO.setBreachConditionStr(dealNotPayCreditMap.get(platformBreachBO.getBreachCondition()).get(0).getTitle());
                    log.info("---------\u8fdd\u7ea6\u6761\u4ef6\u8f6c\u8bd1\u7ed3\u675f");
                }
                for (String breachLimit : platformBreachBO.getBreachLimit()) {
                    if (CollectionUtils.isEmpty((Collection)dealRuleCreditMap.get(breachLimit))) continue;
                    if (StringUtils.isEmpty((Object)platformBreachBO.getBreachLimitStr())) {
                        platformBreachBO.setBreachLimitStr(dealRuleCreditMap.get(breachLimit).get(0).getTitle());
                        log.info("---------\u9650\u5236\u6761\u4ef6\u8f6c\u8bd1\u7ed3\u675f");
                        continue;
                    }
                    platformBreachBO.setBreachLimitStr(platformBreachBO.getBreachLimitStr() + "," + dealRuleCreditMap.get(breachLimit).get(0).getTitle());
                }
                platformBreachBOS.add(platformBreachBO);
            }
        }
        platformBreachBOS.stream().sorted(Comparator.comparing(CfcCommonUniteParamBO::getExceptionMainId));
        rspBO.setRows(platformBreachBOS);
        return rspBO;
    }

    private Map<String, List<FscDicDictionaryBO>> getDicMap(String pCode) {
        Map<String, List<FscDicDictionaryBO>> extSysMap = new HashMap<String, List<FscDicDictionaryBO>>();
        FscQueryDictionaryAbilityReqBO fscQueryDictionaryAbilityReqBO = new FscQueryDictionaryAbilityReqBO();
        fscQueryDictionaryAbilityReqBO.setPcode(pCode);
        FscRspPageBaseBO qryRspBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(fscQueryDictionaryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            extSysMap = qryRspBO.getRows().stream().collect(Collectors.groupingBy(FscDicDictionaryBO::getCode));
        }
        return extSysMap;
    }
}

