/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.estore.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccEcommerceSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEcommerceSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEcommerceSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.mall.ability.api.UccMallReplacementPriceAbilityService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.base.constants.MoneyUtils;
import com.tydic.dyc.estore.commodity.api.DycUccEstoreSkuListQryService;
import com.tydic.dyc.estore.commodity.bo.DycEstoreSkuListQryBO;
import com.tydic.dyc.estore.commodity.bo.DycUccEstoreSkuListQryAbilityReqBO;
import com.tydic.dyc.estore.commodity.bo.DycUccEstoreSkuListQryAbilityRspBO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.estore.commodity.api.DycUccEstoreSkuListQryService"})
public class DycUccEstoreSkuListQryServiceImpl
implements DycUccEstoreSkuListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUccEstoreSkuListQryServiceImpl.class);
    @Autowired
    private UccEcommerceSkuListQryAbilityService uccEstoreSkuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Autowired
    private UccMallReplacementPriceAbilityService uccMallReplacementPriceAbilityService;

    @Override
    @PostMapping(value={"getEstoreSkuManagementListQry"})
    public DycUccEstoreSkuListQryAbilityRspBO getEstoreSkuManagementListQry(@RequestBody DycUccEstoreSkuListQryAbilityReqBO reqBO) {
        String strReq = JSONObject.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccEcommerceSkuListQryAbilityReqBO abilityReqBO = (UccEcommerceSkuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccEcommerceSkuListQryAbilityReqBO.class);
        this.setReqAuth(strReq, abilityReqBO);
        UccEcommerceSkuListQryAbilityRspBO abilityRspBO = this.uccEstoreSkuListQryAbilityService.getEstoreSkuListQry(abilityReqBO);
        DycUccEstoreSkuListQryAbilityRspBO rspBO = new DycUccEstoreSkuListQryAbilityRspBO();
        if ("0000".equals(abilityRspBO.getRespCode())) {
            String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
            rspBO = (DycUccEstoreSkuListQryAbilityRspBO)((Object)JSONObject.parseObject((String)rspStr, DycUccEstoreSkuListQryAbilityRspBO.class));
            if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                List result = JSONObject.parseArray((String)JSONObject.toJSONString((Object)abilityRspBO.getRows()), UccSkuManagementListQryBO.class);
                Map mapList = result.stream().collect(Collectors.toMap(UccSkuManagementListQryBO::getSkuId, Function.identity()));
                int i = 1;
                UccMallReplacementPriceReqBo uccMallReplacementPriceReqBo = new UccMallReplacementPriceReqBo();
                ArrayList<ReplacePriceInfoBO> replacePriceInfoBOList = new ArrayList<ReplacePriceInfoBO>();
                for (DycEstoreSkuListQryBO each : rspBO.getRows()) {
                    DecimalFormat decimalFormat = new DecimalFormat("#,###.00");
                    if (each.getMarketPrice() != null) {
                        each.setMarketPriceFormat(each.getMarketPrice().compareTo(BigDecimal.ONE) > 0 ? decimalFormat.format(each.getMarketPrice()) : "0" + decimalFormat.format(each.getMarketPrice()));
                    }
                    if (each.getAgreementPrice() != null) {
                        each.setAgreementPriceFormat(each.getAgreementPrice().compareTo(BigDecimal.ONE) > 0 ? decimalFormat.format(each.getAgreementPrice()) : "0" + decimalFormat.format(each.getAgreementPrice()));
                    }
                    if (each.getSalePrice() != null) {
                        each.setSalePriceFormat(each.getSalePrice().compareTo(BigDecimal.ONE) > 0 ? decimalFormat.format(each.getSalePrice()) : "0" + decimalFormat.format(each.getSalePrice()));
                    }
                    each.setSerialNumber(i++);
                    if (mapList.containsKey(each.getSkuId()) && null != ((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand()) {
                        each.setSkuExpand1(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand1());
                        each.setSkuExpand2(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand2());
                        each.setSkuExpand3(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand3());
                        each.setSkuExpand4(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand4());
                        each.setSkuExpand5(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand5());
                        each.setSkuExpand6(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand6());
                        each.setSkuExpand7(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand7());
                        each.setSkuExpand8(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand8());
                        each.setSkuExpand9(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand9());
                        each.setSkuExpand10(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getSkuExpand().getExpand10());
                    }
                    ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                    replacePriceInfoBO.setCommodityTypeId(each.getCommodityTypeId());
                    replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getAgreementPrice())));
                    replacePriceInfoBO.setSkuSource(each.getSkuSource());
                    replacePriceInfoBO.setSupplierShopId(each.getSupplierShopId());
                    replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getSalePrice())));
                    replacePriceInfoBO.setSkuId(each.getSkuId());
                    replacePriceInfoBO.setCommodityId(each.getCommodityId());
                    replacePriceInfoBO.setVendorId(each.getVendorId());
                    replacePriceInfoBOList.add(replacePriceInfoBO);
                }
                uccMallReplacementPriceReqBo.setIsprofess(reqBO.getIsprofess());
                uccMallReplacementPriceReqBo.setCompanyId(reqBO.getCompanyId());
                uccMallReplacementPriceReqBo.setUserTypeIn(reqBO.getUserTypeIn());
                uccMallReplacementPriceReqBo.setReplacePriceInfo(replacePriceInfoBOList);
                UccMallReplacementPriceRspBo uccMallReplacementPriceRspBo = this.uccMallReplacementPriceAbilityService.replacePrice(uccMallReplacementPriceReqBo);
                if ("0000".equals(uccMallReplacementPriceRspBo.getRespCode())) {
                    if (!CollectionUtils.isEmpty((Collection)uccMallReplacementPriceRspBo.getRows())) {
                        Map<Long, Long> replacePriceMap = uccMallReplacementPriceRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, ReplacePriceInfoBO::getSalePrice));
                        for (DycEstoreSkuListQryBO each : rspBO.getRows()) {
                            if (!replacePriceMap.containsKey(each.getSkuId())) continue;
                            each.setSalePrice(MoneyUtils.haoToYuan((Long)replacePriceMap.get(each.getSkuId())));
                            BigDecimal discount = each.getSalePrice().divide(each.getMarketPrice(), 4, 4).multiply(new BigDecimal(100)).setScale(2);
                            each.setDiscount(discount);
                        }
                    }
                } else {
                    log.error("\u4ef7\u683c\u66ff\u6362\u5f02\u5e38\uff1a" + uccMallReplacementPriceRspBo.getRespDesc());
                }
            }
        } else {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private void setReqAuth(String strReq, UccEcommerceSkuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
            abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
            abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
            abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
            abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
            abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
        }
    }
}

