/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.pay.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.pay.api.DycFscBillOrderBundlCheckService;
import com.tydic.dyc.fsc.pay.api.DycPebExtOrderListQryForFscNewAbilityService;
import com.tydic.dyc.fsc.pay.bo.DycFscBillOrderBundlCheckReqBO;
import com.tydic.dyc.fsc.pay.bo.DycFscBillOrderBundlCheckRspBO;
import com.tydic.dyc.fsc.pay.bo.DycFscInspectionDetailsListBO;
import com.tydic.dyc.fsc.pay.bo.DycFscUocQryAcceptOrderListReqBO;
import com.tydic.dyc.fsc.pay.bo.DycPebExtOrderListQryForFscRspBO;
import com.tydic.dyc.fsc.pay.bo.DycrelOrderBO;
import com.tydic.dyc.fsc.pay.bo.PayAccountDayRuleBO;
import com.tydic.dyc.fsc.pay.bo.PayNodeRuleBO;
import com.tydic.dyc.fsc.pay.bo.PayRuleBO;
import com.tydic.dyc.fsc.pay.bo.PayTypeBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.fsc.pay.api.DycFscBillOrderBundlCheckService"})
public class DycFscBillOrderBundlCheckServiceImpl
implements DycFscBillOrderBundlCheckService {
    private static final Logger log = LoggerFactory.getLogger(DycFscBillOrderBundlCheckServiceImpl.class);
    private static final Integer BUND = 1;
    private static final Integer NOT_BUND = 0;
    private static final Integer TAB_ID = 80013;
    private static final Map<Integer, String> PAY_RULE = new HashMap<Integer, String>(4);
    private static final Map<Integer, String> PAY_ACCOUNT_RULE = new HashMap<Integer, String>(4);
    private static final Map<Integer, String> PAY_NODE_RULE = new HashMap<Integer, String>(4);
    public static final String OPERATE = "0";
    @Autowired
    private DycPebExtOrderListQryForFscNewAbilityService dycPebExtOrderListQryForFscNewAbilityService;

    @Override
    @PostMapping(value={"dealBundlCheck"})
    public DycFscBillOrderBundlCheckRspBO dealBundlCheck(@RequestBody DycFscBillOrderBundlCheckReqBO reqBO) {
        if (reqBO.getRelOrderList().size() == 1) {
            DycFscBillOrderBundlCheckRspBO dycFscBillOrderBundlCheckRspBO = new DycFscBillOrderBundlCheckRspBO();
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(BUND);
            return dycFscBillOrderBundlCheckRspBO;
        }
        this.val(reqBO);
        Map<Long, DycrelOrderBO> longDycRelOrderBoMap = this.getInspectionMap(reqBO);
        Map<Long, String> longStringMap = this.checkOrderParam(longDycRelOrderBoMap, reqBO);
        return this.assembleRsp(longStringMap, longDycRelOrderBoMap);
    }

    Map<Long, DycrelOrderBO> getInspectionMap(DycFscBillOrderBundlCheckReqBO reqBO) {
        HashMap<Long, DycrelOrderBO> longDycRelOrderBoMap = new HashMap();
        List<DycrelOrderBO> relOrderList = reqBO.getRelOrderList();
        List<Long> acceptIdList = relOrderList.stream().map(DycrelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        DycFscUocQryAcceptOrderListReqBO dycFscUocQryAcceptOrderListReqBO = new DycFscUocQryAcceptOrderListReqBO();
        dycFscUocQryAcceptOrderListReqBO.setInspOrderIdList(acceptIdList);
        dycFscUocQryAcceptOrderListReqBO.setPageSize(reqBO.getRelOrderList().size());
        dycFscUocQryAcceptOrderListReqBO.setPageNo(1);
        dycFscUocQryAcceptOrderListReqBO.setIsprofess(reqBO.getIsprofess());
        dycFscUocQryAcceptOrderListReqBO.setProProxyCreateSettleFlag(reqBO.getProProxyCreateSettleFlag());
        log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)this.dycPebExtOrderListQryForFscNewAbilityService));
        DycPebExtOrderListQryForFscRspBO inspectionDetailsList = this.dycPebExtOrderListQryForFscNewAbilityService.getOrderListByUocPro(dycFscUocQryAcceptOrderListReqBO);
        log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)inspectionDetailsList)));
        List uocInspectionDetailsListBos = inspectionDetailsList.getRows();
        if (CollectionUtils.isEmpty((Collection)uocInspectionDetailsListBos)) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u8fd4\u56de\u9a8c\u6536\u5355\u5217\u8868\u4e3a\u7a7a");
        }
        longDycRelOrderBoMap = this.assembleMapNew(uocInspectionDetailsListBos, reqBO);
        return longDycRelOrderBoMap;
    }

    private DycFscBillOrderBundlCheckRspBO assembleRsp(Map<Long, String> longStringMap, Map<Long, DycrelOrderBO> longDycRelOrderBoMap) {
        DycFscBillOrderBundlCheckRspBO dycFscBillOrderBundlCheckRspBO = new DycFscBillOrderBundlCheckRspBO();
        if (CollectionUtils.isEmpty(longStringMap)) {
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(BUND);
        } else {
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(NOT_BUND);
        }
        HashSet payAccountDaySet = new HashSet();
        HashSet payNodeAccountDaysSet = new HashSet();
        HashMap payTypeBoSet = new HashMap();
        HashMap payRuleBoSet = new HashMap();
        HashMap payAccountDayRuleBoSet = new HashMap();
        HashMap payNodeRuleBoSet = new HashMap();
        longDycRelOrderBoMap.values().forEach(dycrelOrderBO -> {
            if (dycrelOrderBO.getPayAccountDay() != null) {
                payAccountDaySet.add(dycrelOrderBO.getPayAccountDay());
            }
            if (dycrelOrderBO.getPayNodeAccountDays() != null) {
                payNodeAccountDaysSet.add(dycrelOrderBO.getPayNodeAccountDays());
            }
            if (dycrelOrderBO.getPayType() != null) {
                PayTypeBO payTypeBO = new PayTypeBO();
                payTypeBO.setPayType(dycrelOrderBO.getPayType());
                payTypeBO.setPayTypeStr(dycrelOrderBO.getPayTypeStr());
                payTypeBoSet.put(payTypeBO.getPayType(), payTypeBO);
            }
            if (dycrelOrderBO.getPayRule() != null) {
                PayRuleBO payRuleBO = new PayRuleBO();
                payRuleBO.setPayRule(dycrelOrderBO.getPayRule());
                payRuleBO.setPayRuleStr(dycrelOrderBO.getPayRuleStr());
                payRuleBoSet.put(payRuleBO.getPayRule(), payRuleBO);
            }
            if (dycrelOrderBO.getPayAccountDayRule() != null) {
                PayAccountDayRuleBO payAccountDayRuleBo = new PayAccountDayRuleBO();
                payAccountDayRuleBo.setPayAccountDayRule(dycrelOrderBO.getPayAccountDayRule());
                payAccountDayRuleBo.setPayAccountDayRuleStr(dycrelOrderBO.getPayAccountDayRuleStr());
                payAccountDayRuleBoSet.put(payAccountDayRuleBo.getPayAccountDayRule(), payAccountDayRuleBo);
            }
            if (dycrelOrderBO.getPayNodeRule() != null) {
                PayNodeRuleBO payNodeRuleBo = new PayNodeRuleBO();
                payNodeRuleBo.setPayNodeRule(dycrelOrderBO.getPayNodeRule());
                payNodeRuleBo.setPayNodeRuleStr(dycrelOrderBO.getPayNodeRuleStr());
                payNodeRuleBoSet.put(payNodeRuleBo.getPayNodeRule(), payNodeRuleBo);
            }
        });
        dycFscBillOrderBundlCheckRspBO.setPayTypes(new ArrayList<PayTypeBO>(payTypeBoSet.values()));
        dycFscBillOrderBundlCheckRspBO.setPayAccountDayRules(new ArrayList<PayAccountDayRuleBO>(payAccountDayRuleBoSet.values()));
        dycFscBillOrderBundlCheckRspBO.setPayAccountDays(new ArrayList<Integer>(payAccountDaySet));
        dycFscBillOrderBundlCheckRspBO.setPayNodeAccountDayList(new ArrayList<Integer>(payNodeAccountDaysSet));
        dycFscBillOrderBundlCheckRspBO.setPayRules(new ArrayList<PayRuleBO>(payRuleBoSet.values()));
        dycFscBillOrderBundlCheckRspBO.setPayNodeRules(new ArrayList<PayNodeRuleBO>(payNodeRuleBoSet.values()));
        return dycFscBillOrderBundlCheckRspBO;
    }

    private Map<Long, String> checkOrderParam(Map<Long, DycrelOrderBO> longDycRelOrderBOMap, DycFscBillOrderBundlCheckReqBO reqBO) {
        DycrelOrderBO dycrelOrderBO = longDycRelOrderBOMap.get(reqBO.getRelOrderList().get(0).getAcceptOrderId());
        if (null == dycrelOrderBO) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + reqBO.getRelOrderList().get(0).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap<Long, String> acceptIdMap = new HashMap<Long, String>(16);
        for (Map.Entry<Long, DycrelOrderBO> longDycRelOrderBoEntry : longDycRelOrderBOMap.entrySet()) {
            if (!dycrelOrderBO.getPayType().equals(longDycRelOrderBoEntry.getValue().getPayType())) {
                acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                continue;
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(longDycRelOrderBoEntry.getValue().getPayType())) {
                if (null == dycrelOrderBO.getPayRule() || null == longDycRelOrderBoEntry.getValue().getPayRule()) {
                    throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u8fd4\u56de\u4e3a\u7a7a");
                }
                if (!dycrelOrderBO.getPayRule().equals(longDycRelOrderBoEntry.getValue().getPayRule())) {
                    acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    continue;
                }
                if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(dycrelOrderBO.getPayRule())) {
                    if (null == dycrelOrderBO.getPayNodeRule() || null == longDycRelOrderBoEntry.getValue().getPayNodeRule()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e3a\u7a7a");
                    }
                    if (!dycrelOrderBO.getPayNodeRule().equals(longDycRelOrderBoEntry.getValue().getPayNodeRule())) {
                        acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                        continue;
                    }
                    if (null == dycrelOrderBO.getPayNodeAccountDays() || null == longDycRelOrderBoEntry.getValue().getPayNodeAccountDays()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
                    }
                    if (!dycrelOrderBO.getPayNodeAccountDays().equals(longDycRelOrderBoEntry.getValue().getPayNodeAccountDays())) {
                        acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                        continue;
                    }
                } else if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(dycrelOrderBO.getPayRule())) {
                    if (null == dycrelOrderBO.getPayAccountDayRule() || null == longDycRelOrderBoEntry.getValue().getPayAccountDayRule()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e3a\u7a7a");
                    }
                    if (!dycrelOrderBO.getPayAccountDayRule().equals(longDycRelOrderBoEntry.getValue().getPayAccountDayRule())) {
                        acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                        continue;
                    }
                    if (null == dycrelOrderBO.getPayAccountDay() || null == longDycRelOrderBoEntry.getValue().getPayAccountDay()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
                    }
                    if (!dycrelOrderBO.getPayAccountDay().equals(longDycRelOrderBoEntry.getValue().getPayAccountDay())) {
                        acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                        continue;
                    }
                } else {
                    String orderNo = longDycRelOrderBoEntry.getValue().getPurchaseOrderNo();
                    if (FscConstants.FscBusiModel.MATCHING.equals(longDycRelOrderBoEntry.getValue().getTradeMode())) {
                        orderNo = longDycRelOrderBoEntry.getValue().getSaleOrderNo();
                    }
                    acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u3010" + orderNo + "\u3011\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u3010" + dycrelOrderBO.getPayRule() + "\u3011\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968");
                    continue;
                }
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !dycrelOrderBO.getPurchaserCode().equals(longDycRelOrderBoEntry.getValue().getPurchaserCode())) {
                acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355");
                continue;
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || dycrelOrderBO.getSupplierCode().equals(longDycRelOrderBoEntry.getValue().getSupplierCode())) continue;
            acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u5f00\u7968\u65b9\u4e3a\u8fd0\u8425\u65b9\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u4f9b\u5e94\u5546\u7684\u8ba2\u5355");
        }
        log.info("acceptIdMap:{}", (Object)JSON.toJSONString(acceptIdMap));
        return acceptIdMap;
    }

    private Map<Long, DycrelOrderBO> assembleMapNew(List<DycFscInspectionDetailsListBO> uocInspectionDetailsListBos, DycFscBillOrderBundlCheckReqBO reqBO) {
        HashMap<Long, DycrelOrderBO> dycRelOrderBoHashMap = new HashMap<Long, DycrelOrderBO>(16);
        for (DycFscInspectionDetailsListBO row : uocInspectionDetailsListBos) {
            DycrelOrderBO dycrelOrderBo = new DycrelOrderBO();
            dycrelOrderBo.setAcceptOrderId(Long.parseLong(row.getInspectionVoucherId()));
            dycrelOrderBo.setOrderId(row.getOrderId());
            dycrelOrderBo.setPayAccountDay(row.getPayAccountDay());
            dycrelOrderBo.setPayType(row.getPayType());
            dycrelOrderBo.setPayTypeStr(row.getPayTypeStr());
            dycrelOrderBo.setPayRule(row.getPayRule());
            dycrelOrderBo.setPayRuleStr(PAY_RULE.get(row.getPayRule()));
            dycrelOrderBo.setPayAccountDayRule(row.getPayAccountDayRule());
            dycrelOrderBo.setPayAccountDayRuleStr(PAY_ACCOUNT_RULE.get(row.getPayAccountDayRule()));
            dycrelOrderBo.setPayNodeRule(row.getPayNodeRule());
            dycrelOrderBo.setPayNodeRuleStr(PAY_NODE_RULE.get(row.getPayNodeRule()));
            dycrelOrderBo.setSupplierCode(row.getSupNo());
            dycrelOrderBo.setPurchaserCode(row.getPurNo());
            dycrelOrderBo.setPurchaseOrderNo(row.getPurchaseVoucherNo());
            dycrelOrderBo.setSaleOrderNo(row.getSaleVoucherNo());
            dycrelOrderBo.setTradeMode(row.getTradeMode());
            dycrelOrderBo.setPayNodeAccountDays(row.getPaymentDays());
            dycrelOrderBo.setPayAccountDay(row.getPayAccountDay());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getSaleVoucherNo());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getPurchaseVoucherNo());
            }
            dycRelOrderBoHashMap.put(dycrelOrderBo.getAcceptOrderId(), dycrelOrderBo);
        }
        return dycRelOrderBoHashMap;
    }

    private void val(DycFscBillOrderBundlCheckReqBO reqBO) {
        if (null == reqBO.getMakeType()) {
            throw new ZTBusinessException("\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new ZTBusinessException("\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getRelOrderList())) {
            throw new ZTBusinessException("\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
    }

    static {
        PAY_RULE.put(1, "\u6307\u5b9a\u8d26\u671f\u65e5");
        PAY_RULE.put(2, "\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9+\u8d26\u671f\u5929\u6570");
        PAY_ACCOUNT_RULE.put(1, "\u7b7e\u6536\u53d1\u7968");
        PAY_ACCOUNT_RULE.put(2, "\u8ba2\u5355\u9a8c\u6536");
        PAY_ACCOUNT_RULE.put(3, "\u8ba2\u5355\u5230\u8d27");
        PAY_NODE_RULE.put(1, "\u7b7e\u6536\u53d1\u7968\u5f00\u59cb\u8ba1\u7b97");
        PAY_NODE_RULE.put(2, "\u8ba2\u5355\u9a8c\u6536\u5f00\u59cb\u8ba1\u7b97");
        PAY_NODE_RULE.put(3, "\u8ba2\u5355\u5230\u8d27\u5f00\u59cb\u8ba1\u7b97");
    }
}

