/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.commodity.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallSpuOrderListQueryAbilityService;
import com.tydic.dyc.mall.commodity.api.DycUccMallCompareSkuPriceService;
import com.tydic.dyc.mall.commodity.bo.DycUccMallCheckSkuPriceBo;
import com.tydic.dyc.mall.commodity.bo.DycUccMallCompareSkuPriceReqBo;
import com.tydic.dyc.mall.commodity.bo.DycUccMallCompareSkuPriceRspBo;
import com.tydic.dyc.mall.commodity.bo.DycUccMallSkuOrderBO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommShoppingCartGoodsQryService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsInfoBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsQryReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsQryRspBO;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.commodity.api.DycUccMallCompareSkuPriceService"})
public class DycUccMallCompareSkuPriceServiceImpl
implements DycUccMallCompareSkuPriceService {
    private static final Logger log = LoggerFactory.getLogger(DycUccMallCompareSkuPriceServiceImpl.class);
    @Autowired
    private UccMallSpuOrderListQueryAbilityService uccMallSpuOrderListQueryAbilityService;
    @Autowired
    private DycProCommShoppingCartGoodsQryService dycProCommShoppingCartGoodsQryService;
    @Value(value="${sku.compare.price.enable:false}")
    private boolean comparePriceEnable;

    @Override
    @PostMapping(value={"compareSkuPrice"})
    public DycUccMallCompareSkuPriceRspBo compareSkuPrice(@RequestBody DycUccMallCompareSkuPriceReqBo reqBo) {
        if (!this.comparePriceEnable) {
            return new DycUccMallCompareSkuPriceRspBo();
        }
        DycProCommShoppingCartGoodsQryReqBO dycProCommShoppingCartGoodsQryReqBO = new DycProCommShoppingCartGoodsQryReqBO();
        dycProCommShoppingCartGoodsQryReqBO.setCity(Convert.toLong((Object)reqBo.getCity()));
        dycProCommShoppingCartGoodsQryReqBO.setProvince(Convert.toLong((Object)reqBo.getProvince()));
        dycProCommShoppingCartGoodsQryReqBO.setCounty(Convert.toLong((Object)reqBo.getCounty()));
        dycProCommShoppingCartGoodsQryReqBO.setTown(Convert.toLong((Object)reqBo.getTown()));
        dycProCommShoppingCartGoodsQryReqBO.setReturnType(Integer.valueOf(1));
        ArrayList<DycProCommShoppingCartGoodsBO> dycProCommShoppingCartGoodsBOS = new ArrayList<DycProCommShoppingCartGoodsBO>();
        for (DycUccMallSkuOrderBO dycUccMallSkuOrderBO : reqBo.getSkuOrderList()) {
            DycProCommShoppingCartGoodsBO dycProCommShoppingCartGoodsBO = new DycProCommShoppingCartGoodsBO();
            dycProCommShoppingCartGoodsBO.setSkuId(dycUccMallSkuOrderBO.getSkuId());
            dycProCommShoppingCartGoodsBO.setNum(dycUccMallSkuOrderBO.getNum());
            dycProCommShoppingCartGoodsBO.setSpId(dycUccMallSkuOrderBO.getSpId());
            dycProCommShoppingCartGoodsBOS.add(dycProCommShoppingCartGoodsBO);
        }
        dycProCommShoppingCartGoodsQryReqBO.setSkuList(dycProCommShoppingCartGoodsBOS);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProCommShoppingCartGoodsQryReqBO));
        DycProCommShoppingCartGoodsQryRspBO dycProCommShoppingCartGoodsQryRspBO = this.dycProCommShoppingCartGoodsQryService.qryShoppingCartGoods(dycProCommShoppingCartGoodsQryReqBO);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProCommShoppingCartGoodsQryRspBO));
        if (!"0000".equals(dycProCommShoppingCartGoodsQryRspBO.getRespCode())) {
            throw new ZTBusinessException(dycProCommShoppingCartGoodsQryRspBO.getRespDesc());
        }
        int skuCount = dycProCommShoppingCartGoodsQryRspBO.getSkuInfoList().size();
        if (reqBo.getSkuOrderList().size() == skuCount) {
            DycUccMallCompareSkuPriceRspBo rspBo = new DycUccMallCompareSkuPriceRspBo();
            Map<Long, DycProCommShoppingCartGoodsInfoBO> skuMap = dycProCommShoppingCartGoodsQryRspBO.getSkuInfoList().stream().collect(Collectors.toMap(DycProCommShoppingCartGoodsInfoBO::getSpId, o -> o));
            ArrayList<DycUccMallCheckSkuPriceBo> dycUccMallCheckSkuPriceBos = new ArrayList<DycUccMallCheckSkuPriceBo>();
            for (DycUccMallSkuOrderBO dycUccMallSkuOrderBO : reqBo.getSkuOrderList()) {
                DycProCommShoppingCartGoodsInfoBO dycProCommShoppingCartGoodsInfoBO;
                if (!skuMap.containsKey(dycUccMallSkuOrderBO.getSpId()) || null == (dycProCommShoppingCartGoodsInfoBO = skuMap.get(dycUccMallSkuOrderBO.getSpId())) || null == dycProCommShoppingCartGoodsInfoBO.getPriceInfo() || dycUccMallSkuOrderBO.getSalePrice().compareTo(dycProCommShoppingCartGoodsInfoBO.getPriceInfo().getSalePrice()) == 0) continue;
                DycUccMallCheckSkuPriceBo dycUccMallCheckSkuPriceBo = new DycUccMallCheckSkuPriceBo();
                dycUccMallCheckSkuPriceBo.setSkuId(dycUccMallSkuOrderBO.getSkuId());
                dycUccMallCheckSkuPriceBo.setNewPrice(dycProCommShoppingCartGoodsInfoBO.getPriceInfo().getSalePrice());
                dycUccMallCheckSkuPriceBo.setOldPrice(dycUccMallSkuOrderBO.getSalePrice());
                dycUccMallCheckSkuPriceBo.setSpId(dycUccMallSkuOrderBO.getSpId());
                dycUccMallCheckSkuPriceBos.add(dycUccMallCheckSkuPriceBo);
            }
            rspBo.setDycUccMallCheckSkuPriceBos(dycUccMallCheckSkuPriceBos);
            return rspBo;
        }
        throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5546\u57ce\u5546\u54c1\u6570\u636e\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
    }
}

