/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.agrchange.AgrCheckAgrChngItemSaveService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCheckAgrChngItemSaveReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCheckAgrChngItemSaveRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.procinst.AgrGetTaskInstService;
import com.tydic.dyc.agr.service.procinst.AgrTaskDealService;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstReqBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstRspBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskInfoBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocOrderTaskInstBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.atom.zone.agr.api.DycAgrChngSaveAndSubmitFunction;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrChngSaveAndSubmitFunctionReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrChngSaveAndSubmitFunctionRspBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.zone.agr.api.DycAgrAgrChngSubmitService;
import com.tydic.dyc.zone.agr.api.DycAgrSetScopeOrgPathService;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrChngSubmitReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrChngSubmitRspBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAppScopeBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAppScopeChngBO;
import com.tydic.dyc.zone.agr.bo.DycAgrSetScopeOrgPathReqBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrAgrChngSubmitService"})
public class DycAgrAgrChngSubmitServiceImpl
implements DycAgrAgrChngSubmitService {
    @Autowired
    private DycAgrChngSaveAndSubmitFunction dycAgrChngSaveAndSubmitFunction;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private AgrGetTaskInstService agrGetTaskInstService;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    private final Integer submitFlag = 1;
    @Autowired
    private AgrTaskDealService agrTaskDealService;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    private static final Integer operType_submit = 2;
    @Autowired
    private AgrCheckAgrChngItemSaveService agrCheckAgrChngItemSaveService;
    @Value(value="${agr.app.topOrgId:1}")
    private String topOrgId;
    @Autowired
    private DycAgrSetScopeOrgPathService dycAgrSetScopeOrgPathService;

    @Override
    @PostMapping(value={"dealAgrChngSubmit"})
    public DycAgrAgrChngSubmitRspBO dealAgrChngSubmit(@RequestBody DycAgrAgrChngSubmitReqBO reqBO) {
        this.validParam(reqBO);
        if (reqBO.getChngType().equals(AgrCommConstant.AgreementChangeType.SUPPLEMENT)) {
            this.checkAgrChngItem(reqBO);
        }
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.getAgrMain(reqBO);
        if (AgrCommConstant.AgreementChangeType.OTHER.equals(reqBO.getChngType())) {
            this.setScopeOrgPath(reqBO);
        }
        this.invokeSaveAndSubmitFunction(reqBO);
        AgrUocOrderTaskInstBo agrUocOrderTaskInstBo = this.getTaskInst(reqBO);
        if (agrUocOrderTaskInstBo == null || StringUtils.isEmpty((Object)agrUocOrderTaskInstBo.getTaskInstId())) {
            this.startBusiProcess(agrGetAgrMainRspBo, reqBO);
        } else {
            this.flowBusiProcess(reqBO, agrUocOrderTaskInstBo.getTaskInstId());
            this.submitCenterTask(agrUocOrderTaskInstBo, reqBO);
        }
        return new DycAgrAgrChngSubmitRspBO();
    }

    private void checkAgrChngItem(DycAgrAgrChngSubmitReqBO reqBO) {
        AgrCheckAgrChngItemSaveReqBO agrCheckAgrChngItemSaveReqBO = new AgrCheckAgrChngItemSaveReqBO();
        agrCheckAgrChngItemSaveReqBO.setAgrId(reqBO.getAgrId());
        agrCheckAgrChngItemSaveReqBO.setChngApplyId(reqBO.getChngApplyId());
        AgrCheckAgrChngItemSaveRspBO agrCheckAgrChngItemSaveRspBO = this.agrCheckAgrChngItemSaveService.checkAgrChngItemSave(agrCheckAgrChngItemSaveReqBO);
        if (!"0000".equals(agrCheckAgrChngItemSaveRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5f53\u524d\u7269\u6599\u660e\u7ec6\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u8bf7\u6838\u5b9e\u5b8c\u5584\u540e\u518d\u63d0\u4ea4\uff01");
        }
    }

    private void submitCenterTask(AgrUocOrderTaskInstBo agrUocOrderTaskInstBo, DycAgrAgrChngSubmitReqBO reqBO) {
        AgrTaskDealReqBO agrTaskDealReqBO = new AgrTaskDealReqBO();
        agrTaskDealReqBO.setOrderId(agrUocOrderTaskInstBo.getOrderId());
        agrTaskDealReqBO.setUserId(reqBO.getUserId());
        agrTaskDealReqBO.setUsername(reqBO.getUsername());
        ArrayList<AgrTaskInfoBO> agrTaskInfoBOS = new ArrayList<AgrTaskInfoBO>();
        AgrTaskInfoBO agrTaskInfoBO = new AgrTaskInfoBO();
        agrTaskInfoBO.setBusiObjId(agrUocOrderTaskInstBo.getObjId());
        agrTaskInfoBO.setBusiObjType(agrUocOrderTaskInstBo.getObjType());
        agrTaskInfoBO.setDealResult(this.submitFlag);
        agrTaskInfoBO.setTaskId(agrUocOrderTaskInstBo.getTaskInstId());
        agrTaskInfoBOS.add(agrTaskInfoBO);
        agrTaskDealReqBO.setCompleteTaskInfos(agrTaskInfoBOS);
        this.agrTaskDealService.dealTask(agrTaskDealReqBO);
    }

    private AgrGetAgrMainRspBo getAgrMain(DycAgrAgrChngSubmitReqBO reqBO) {
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setAgrId(reqBO.getAgrId());
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        if (!"0000".equals(agrGetAgrMainRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u67e5\u8be2\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + agrGetAgrMainRspBo.getRespCode() + "\u3011," + agrGetAgrMainRspBo.getRespDesc());
        }
        if (agrGetAgrMainRspBo == null || agrGetAgrMainRspBo.getAgrId() == null) {
            throw new ZTBusinessException("\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return agrGetAgrMainRspBo;
    }

    private void flowBusiProcess(DycAgrAgrChngSubmitReqBO reqBO, String taskInstId) {
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(taskInstId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("submitFlag", this.submitFlag);
        variables.put("userId", reqBO.getUserId());
        variables.put("userName", reqBO.getName());
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u53d8\u66f4\u63d0\u4ea4\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private void startBusiProcess(AgrGetAgrMainRspBo agrGetAgrMainRspBo, DycAgrAgrChngSubmitReqBO reqBO) {
        DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
        if (agrGetAgrMainRspBo.getAgrMode().equals(1)) {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_plat_agr_chng_busi_process");
        } else {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_danwei_agr_chng_busi_process");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("chngApplyId", reqBO.getChngApplyId());
        variables.put("orderId", agrGetAgrMainRspBo.getAgrId());
        variables.put("agrId", agrGetAgrMainRspBo.getAgrId());
        variables.put("auditObjId", reqBO.getChngApplyId());
        variables.put("auditObjType", AgrCommConstant.ObjType.CHANGE);
        variables.put("auditObjCode", agrGetAgrMainRspBo.getAgrCode());
        variables.put("auditStartFlag", "1");
        variables.put("auditFinishFlag", "1");
        variables.put("orgId", reqBO.getOrgId());
        variables.put("orgName", reqBO.getOrgName());
        variables.put("userId", reqBO.getUserId());
        variables.put("userName", reqBO.getName());
        variables.put("todoOrderNo", reqBO.getChngApplyNo());
        variables.put("createOperId", reqBO.getUserId());
        variables.put("loginTagIn", reqBO.getLoginTagIn());
        variables.put("agrCode", reqBO.getAgrCode());
        variables.put("agrType", agrGetAgrMainRspBo.getAgrType());
        variables.put("agrTypeStr", agrGetAgrMainRspBo.getAgrTypeStr());
        dycBusiProcessStartFuncReqBO.setVariables(variables);
        dycBusiProcessStartFuncReqBO.setSysCode(this.SYS_CODE);
        dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(agrGetAgrMainRspBo.getAgrId()));
        DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
        if (!"0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u53d8\u66f4\u63d0\u4ea4\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
        }
    }

    private void validParam(DycAgrAgrChngSubmitReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2[reqBO]\u4e3a\u7a7a");
        }
        if (reqBO.getChngApplyId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[chngApplyId]\u4e3a\u7a7a");
        }
        if (reqBO.getAgrId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[agrId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAgrCode())) {
            throw new ZTBusinessException("\u5165\u53c2[agrCode]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAgrVersion())) {
            throw new ZTBusinessException("\u5165\u53c2[agrVersion]\u4e3a\u7a7a");
        }
        if (reqBO.getAgrMainChng() != null) {
            if (reqBO.getAgrMainChng().getVendorMode() != null) {
                if (reqBO.getAgrMainChng().getVendorMode().equals(AgrCommConstant.SupplierMode.SUPPLIER_DELIVERY)) {
                    reqBO.getAgrMainChng().setManagementOrgId(reqBO.getAgrMainChng().getSupplierId().toString());
                    reqBO.getAgrMainChng().setManagementOrgName(reqBO.getAgrMainChng().getSupplierName());
                } else if (reqBO.getAgrMainChng().getVendorMode().equals(AgrCommConstant.SupplierMode.CREATE_AND_SUP)) {
                    reqBO.getAgrMainChng().setManagementOrgId(reqBO.getAgrMainChng().getSupplierId() + "," + reqBO.getCompanyId());
                    reqBO.getAgrMainChng().setManagementOrgName(reqBO.getAgrMainChng().getSupplierName() + "," + reqBO.getCompanyName());
                } else {
                    reqBO.getAgrMainChng().setManagementOrgId(reqBO.getCompanyId().toString());
                    reqBO.getAgrMainChng().setManagementOrgName(reqBO.getCompanyName());
                }
            } else {
                reqBO.getAgrMainChng().setManagementOrgId(null);
                reqBO.getAgrMainChng().setManagementOrgName(null);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getAgrAppScopeChng())) {
            for (DycAgrAppScopeChngBO item : reqBO.getAgrAppScopeChng()) {
                if (ObjectUtil.isEmpty((Object)item.getScopeCode())) {
                    throw new ZTBusinessException("\u5e94\u7528\u8303\u56f4\u4fe1\u606f[\u5e94\u7528\u8303\u56f4\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Long.valueOf(AgrCommConstant.ScopeTypeEnum.SCOPE_TYPE_ALL.getValue().intValue()).equals(item.getScopeCode())) {
                    item.setScopeName(AgrCommConstant.ScopeTypeEnum.SCOPE_TYPE_ALL.getName());
                }
                if (!ObjectUtil.isEmpty((Object)item.getScopeName())) continue;
                throw new ZTBusinessException("\u5e94\u7528\u8303\u56f4\u4fe1\u606f[\u5e94\u7528\u8303\u56f4\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private AgrUocOrderTaskInstBo getTaskInst(DycAgrAgrChngSubmitReqBO reqBO) {
        AgrGetTaskInstReqBo agrGetTaskInstReqBo = new AgrGetTaskInstReqBo();
        agrGetTaskInstReqBo.setOrderId(reqBO.getAgrId());
        agrGetTaskInstReqBo.setObjId(reqBO.getChngApplyId());
        agrGetTaskInstReqBo.setFinishTag(Integer.valueOf(0));
        AgrGetTaskInstRspBo agrGetTaskInstRspBo = this.agrGetTaskInstService.getTaskInstList(agrGetTaskInstReqBo);
        if (!"0000".equals(agrGetTaskInstRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4efb\u52a1\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrGetTaskInstRspBo.getRespCode() + "\u3011," + agrGetTaskInstRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)agrGetTaskInstRspBo.getRows())) {
            return (AgrUocOrderTaskInstBo)agrGetTaskInstRspBo.getRows().get(0);
        }
        return null;
    }

    private void invokeSaveAndSubmitFunction(DycAgrAgrChngSubmitReqBO reqBO) {
        DycAgrChngSaveAndSubmitFunctionReqBO dycAgrChngSaveAndSubmitFunctionReqBO = (DycAgrChngSaveAndSubmitFunctionReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), DycAgrChngSaveAndSubmitFunctionReqBO.class);
        dycAgrChngSaveAndSubmitFunctionReqBO.setOperType(operType_submit);
        DycAgrChngSaveAndSubmitFunctionRspBO dycAgrChngSaveAndSubmitFunctionRspBO = this.dycAgrChngSaveAndSubmitFunction.dealAgrSaveAndSubmit(dycAgrChngSaveAndSubmitFunctionReqBO);
        if (!"0000".equals(dycAgrChngSaveAndSubmitFunctionRspBO.getRespCode())) {
            throw new ZTBusinessException(dycAgrChngSaveAndSubmitFunctionRspBO.getRespDesc());
        }
    }

    private void setScopeOrgPath(DycAgrAgrChngSubmitReqBO reqBO) {
        List<DycAgrAppScopeChngBO> agrAppScopeChngBOS;
        if (AgrCommConstant.ScopeType.ALL.equals(reqBO.getAgrMainChng().getScopeType())) {
            List<DycAgrAppScopeChngBO> dycAgrAppScopeChngBOS = Arrays.stream(this.topOrgId.split(",")).map(e -> {
                DycAgrAppScopeChngBO dycAgrAppScopeChngBO = new DycAgrAppScopeChngBO();
                if (e.contains("->")) {
                    String[] temp = e.split("->");
                    dycAgrAppScopeChngBO.setScopeCode(Long.valueOf(temp[0]));
                    dycAgrAppScopeChngBO.setScopeName(temp[1]);
                } else {
                    dycAgrAppScopeChngBO.setScopeCode(Long.valueOf(e));
                }
                dycAgrAppScopeChngBO.setScopeType(reqBO.getAgrMainChng().getScopeType());
                return dycAgrAppScopeChngBO;
            }).collect(Collectors.toList());
            reqBO.setAgrAppScopeChng(dycAgrAppScopeChngBOS);
        }
        if (CollectionUtil.isNotEmpty(agrAppScopeChngBOS = reqBO.getAgrAppScopeChng())) {
            DycAgrSetScopeOrgPathReqBO dycAgrSetScopeOrgPathReqBO = new DycAgrSetScopeOrgPathReqBO();
            dycAgrSetScopeOrgPathReqBO.setAgrAppScopeBOs(JUtil.jsl(agrAppScopeChngBOS, DycAgrAppScopeBO.class));
            this.dycAgrSetScopeOrgPathService.setScopeOrgPath(dycAgrSetScopeOrgPathReqBO);
            reqBO.setAgrAppScopeChng(JUtil.jsl(dycAgrSetScopeOrgPathReqBO.getAgrAppScopeBOs(), DycAgrAppScopeChngBO.class));
        }
    }
}

