/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrAgrInvalidService;
import com.tydic.dyc.agr.service.agr.AgrChangeSynService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrChangeSynReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrChangeSynRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrInvalidReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrInvalidRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainReqBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrSyncUccService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.agr.service.procinst.AgrGetProcInstListService;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstListReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstListRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstRspBO;
import com.tydic.dyc.base.constants.AgrConstant;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.zone.agr.api.DycAgrChangeSynService;
import com.tydic.dyc.zone.agr.bo.DycAgrChangeSynReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrChangeSynRspBO;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleReqBO;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleRespBO;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrChangeSynService"})
public class DycAgrChangeSynServiceImpl
implements DycAgrChangeSynService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrChangeSynServiceImpl.class);
    @Autowired
    private AgrChangeSynService agrChangeSynService;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Autowired
    private AgrAgrInvalidService agrAgrInvalidService;
    @Autowired
    private AgrUpdateAgrMainService agrUpdateAgrMainService;
    @Autowired
    private AgrGetProcInstListService agrGetProcInstListService;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private AgrSyncUccService agrSyncUccService;

    @Override
    @PostMapping(value={"dealChangeSyn"})
    public DycAgrChangeSynRspBO dealChangeSyn(@RequestBody DycAgrChangeSynReqBO agrChangeSynReqBO) {
        this.check(agrChangeSynReqBO);
        DycAgrChangeSynRspBO rspBO = new DycAgrChangeSynRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setRelCode(agrChangeSynReqBO.getOldRelCode());
        agrGetAgrMainReqBo.setAgrType(AgrCommConstant.AgrType.AGR);
        AgrGetAgrMainRspBo agrMain = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        if (ObjectUtil.isNull((Object)agrMain)) {
            throw new ZTBusinessException("\u6839\u636e\u65e7\u534f\u8bae\u7f16\u53f7\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (AgrConstant.ChngType.INVALID.equals(agrChangeSynReqBO.getChngType())) {
            AgrInvalidReqBO agrInvalidReqBO = new AgrInvalidReqBO();
            agrInvalidReqBO.setAgrId(agrMain.getAgrId());
            AgrInvalidRspBO agrInvalidRspBO = this.agrAgrInvalidService.dealAgrInvalid(agrInvalidReqBO);
            AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO = new AgrUpdateAgrMainReqBO();
            agrUpdateAgrMainReqBO.setAgrId(agrMain.getAgrId());
            agrUpdateAgrMainReqBO.setAgrStatus(AgrCommConstant.AgreementStatus.TERMINATION);
            this.agrUpdateAgrMainService.updateAgrMain(agrUpdateAgrMainReqBO);
            List<Long> agrIdList = new ArrayList<Long>();
            if (CollectionUtil.isNotEmpty((Collection)agrInvalidRspBO.getAgrMainList())) {
                agrIdList = agrInvalidRspBO.getAgrMainList().stream().map(AgrMainListBo::getAgrId).collect(Collectors.toList());
            }
            this.syncUcc(agrMain.getAgrId(), null, AgrCommConstant.SyncType.FROZEN, agrIdList, ObjectUtil.isNull((Object)agrMain.getUpdateLoginId()) ? null : agrMain.getUpdateLoginId().toString(), agrMain.getUpdateUsername());
            AgrGetProcInstListRspBO procInstListRspBO = this.getProcInstListRspBO(agrMain.getAgrId(), Arrays.asList(AgrCommConstant.ObjType.AGREEMENT, AgrCommConstant.ObjType.CHANGE, AgrCommConstant.ObjType.APPROVE));
            if (CollectionUtil.isNotEmpty((Collection)procInstListRspBO.getProcInstList())) {
                List<String> auditProcInstIdList = procInstListRspBO.getProcInstList().stream().filter(e -> AgrCommConstant.ObjType.APPROVE.equals(e.getObjType())).map(AgrGetProcInstRspBO::getProcInstId).collect(Collectors.toList());
                log.info("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u5ba1\u6279\u6d41id\u96c6\u5408\u4e3a: {}", (Object)JSON.toJSONString(auditProcInstIdList));
                if (CollectionUtil.isNotEmpty(auditProcInstIdList)) {
                    this.suspensionApprove(auditProcInstIdList);
                }
                List<String> bussiProcInstIdList = procInstListRspBO.getProcInstList().stream().filter(e -> !AgrCommConstant.ObjType.APPROVE.equals(e.getObjType())).map(AgrGetProcInstRspBO::getProcInstId).collect(Collectors.toList());
                log.info("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u4e1a\u52a1\u6d41id\u96c6\u5408\u4e3a: {}", (Object)JSON.toJSONString(bussiProcInstIdList));
                if (CollectionUtil.isNotEmpty(bussiProcInstIdList)) {
                    this.deleteProcInstSingle(bussiProcInstIdList);
                }
            }
            if (!"0000".equals(agrInvalidRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u53d8\u66f4\u670d\u52a1\u5931\u8d25: " + agrInvalidRspBO.getMessage());
            }
            return rspBO;
        }
        agrChangeSynReqBO.setAgrId(agrMain.getAgrId());
        AgrChangeSynReqBO changeSynReqBO = (AgrChangeSynReqBO)JUtil.js((Object)((Object)agrChangeSynReqBO), AgrChangeSynReqBO.class);
        changeSynReqBO.setRelCode(agrChangeSynReqBO.getNewRelCode());
        AgrChangeSynRspBO agrChangeSynRspBO = this.agrChangeSynService.dealChangeSyn(changeSynReqBO);
        if (!"0000".equals(agrChangeSynRspBO.getRespCode())) {
            throw new ZTBusinessException(agrChangeSynRspBO.getMessage());
        }
        return rspBO;
    }

    private void check(DycAgrChangeSynReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getOldRelCode())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u65e7\u5408\u540c\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getNewRelCode())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u65b0\u5408\u540c\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getChngType())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d8\u66f4\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private AgrGetProcInstListRspBO getProcInstListRspBO(Long orderId, List<Integer> objTypeList) {
        AgrGetProcInstListReqBO agrGetProcInstListReqBO = new AgrGetProcInstListReqBO();
        agrGetProcInstListReqBO.setOrderId(orderId);
        agrGetProcInstListReqBO.setFinishTag(AgrCommConstant.taskFinishFLag.NOT_FINISH);
        agrGetProcInstListReqBO.setObjTypeList(objTypeList);
        log.info("\u53d8\u66f4\u540c\u6b65\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)agrGetProcInstListReqBO));
        AgrGetProcInstListRspBO procInstListRspBO = this.agrGetProcInstListService.getProcInstList(agrGetProcInstListReqBO);
        log.info("\u53d8\u66f4\u540c\u6b65\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)procInstListRspBO));
        return procInstListRspBO;
    }

    private void suspensionApprove(List<String> auditProcInstIdList) {
        for (String auditProcInstId : auditProcInstIdList) {
            EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
            eacRuInstAbilityReqBO.setApproveInstId(auditProcInstId);
            log.info("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u5ba1\u6279\u6d41\u7ec8\u6b62\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacRuInstAbilityReqBO));
            EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
            log.info("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u5ba1\u6279\u6d41\u7ec8\u6b62\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacRuInstAbilityRspBO));
            if ("0000".equals(eacRuInstAbilityRspBO.getRespCode())) continue;
            throw new ZTBusinessException("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u5ba1\u6279\u6d41\u7ec8\u6b62\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacRuInstAbilityRspBO.getRespCode() + "\u3011," + eacRuInstAbilityRspBO.getRespDesc());
        }
    }

    private void deleteProcInstSingle(List<String> bussiProcInstIdList) {
        for (String bussiProcInstId : bussiProcInstIdList) {
            DeleteProcInstSingleReqBO deleteProcInstSingleReqBO = new DeleteProcInstSingleReqBO();
            deleteProcInstSingleReqBO.setProcInstId(bussiProcInstId);
            log.info("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u4e1a\u52a1\u6d41\u7ec8\u6b62\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)deleteProcInstSingleReqBO));
            DeleteProcInstSingleRespBO deleteProcInstSingleRespBO = this.osworkflowRuntimeProcInstHandleAbilityService.deleteProcInstSingle(deleteProcInstSingleReqBO);
            log.info("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u4e1a\u52a1\u6d41\u7ec8\u6b62\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)deleteProcInstSingleRespBO));
            if ("0000".equals(deleteProcInstSingleRespBO.getRespCode())) continue;
            throw new ZTBusinessException("\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u4e1a\u52a1\u6d41\u7ec8\u6b62\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + deleteProcInstSingleRespBO.getRespCode() + "\u3011," + deleteProcInstSingleRespBO.getRespDesc());
        }
    }

    private void syncUcc(Long agrId, Long chngApplyId, Integer syncType, List<Long> agrIdList, String operId, String operName) {
        AgrSyncUccReqBO agrSyncUccReqBO = new AgrSyncUccReqBO();
        agrSyncUccReqBO.setAgrId(agrId);
        agrSyncUccReqBO.setSyncType(syncType);
        agrSyncUccReqBO.setChngApplyId(chngApplyId);
        agrSyncUccReqBO.setOperId(operId);
        agrSyncUccReqBO.setOperName(operName);
        agrSyncUccReqBO.setAgrIds(agrIdList);
        this.agrSyncUccService.dealAgrSyncUcc(agrSyncUccReqBO);
    }
}

