/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoListPageService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListPageReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListPageRspBo;
import com.tydic.dyc.zone.agr.api.DycAgrSetScopeOrgPathService;
import com.tydic.dyc.zone.agr.bo.DycAgrAppScopeBO;
import com.tydic.dyc.zone.agr.bo.DycAgrSetScopeOrgPathReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrSetScopeOrgPathRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycAgrSetScopeOrgPathServiceImpl
implements DycAgrSetScopeOrgPathService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrSetScopeOrgPathServiceImpl.class);
    @Autowired
    private UmcQryOrgInfoListPageService umcQryOrgInfoListPageService;

    @Override
    public DycAgrSetScopeOrgPathRspBO setScopeOrgPath(DycAgrSetScopeOrgPathReqBO reqBO) {
        List<DycAgrAppScopeBO> agrAppScopeBOs = reqBO.getAgrAppScopeBOs();
        UmcQryOrgInfoListPageReqBo umcQryOrgInfoListPageReqBo = new UmcQryOrgInfoListPageReqBo();
        umcQryOrgInfoListPageReqBo.setOrgIds(agrAppScopeBOs.stream().map(DycAgrAppScopeBO::getScopeCode).collect(Collectors.toList()));
        umcQryOrgInfoListPageReqBo.setPageNo(-1);
        umcQryOrgInfoListPageReqBo.setPageSize(-1);
        log.info("DycAgrSetScopeOrgPathService\u67e5\u8be2\u7ec4\u7ec7\u96c6\u5408\u4fe1\u606f\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)umcQryOrgInfoListPageReqBo));
        UmcQryOrgInfoListPageRspBo umcQryOrgInfoListPageRspBo = this.umcQryOrgInfoListPageService.qryOrgInfoListPage(umcQryOrgInfoListPageReqBo);
        log.info("DycAgrSetScopeOrgPathService\u67e5\u8be2\u7ec4\u7ec7\u96c6\u5408\u4fe1\u606f\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)umcQryOrgInfoListPageRspBo));
        List rows = umcQryOrgInfoListPageRspBo.getRows();
        if (CollectionUtil.isNotEmpty((Collection)rows)) {
            Map orgIdAndOrgInfoMap = rows.stream().collect(Collectors.toMap(UmcOrgInfoBo::getOrgId, Function.identity(), (a, b) -> a));
            agrAppScopeBOs.forEach(e -> {
                UmcOrgInfoBo umcOrgInfoBo = (UmcOrgInfoBo)orgIdAndOrgInfoMap.get(e.getScopeCode());
                if (umcOrgInfoBo != null) {
                    e.setScopeOrgPath(umcOrgInfoBo.getOrgTreePath());
                    if (StringUtils.isEmpty((Object)e.getScopeName())) {
                        e.setScopeName(umcOrgInfoBo.getOrgName());
                    }
                }
            });
        }
        return new DycAgrSetScopeOrgPathRspBO();
    }
}

