/*
 * Decompiled with CFR 0.152.
 */
package share.config;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MyTemplateEngine
extends AbstractTemplateEngine {
    private Configuration configuration;

    public MyTemplateEngine init(ConfigBuilder configBuilder) {
        super.init(configBuilder);
        this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.configuration.setDefaultEncoding(ConstVal.UTF8);
        this.configuration.setClassForTemplateLoading(FreemarkerTemplateEngine.class, "/");
        return this;
    }

    public AbstractTemplateEngine batchOutput() {
        try {
            List tableInfoList = this.getConfigBuilder().getTableInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                String controllerFile;
                String implFile;
                String serviceFile;
                String xmlFile;
                String mapperFile;
                String entityFile;
                String entityName;
                Map objectMap = this.getObjectMap(tableInfo);
                Map pathInfo = this.getConfigBuilder().getPathInfo();
                TemplateConfig template = this.getConfigBuilder().getTemplate();
                InjectionConfig injectionConfig = this.getConfigBuilder().getInjectionConfig();
                if (null != injectionConfig) {
                    injectionConfig.initTableMap(tableInfo);
                    objectMap.put("cfg", injectionConfig.getMap());
                    List focList = injectionConfig.getFileOutConfigList();
                    if (CollectionUtils.isNotEmpty((Collection)focList)) {
                        for (FileOutConfig foc : focList) {
                            if (!this.isCreate(FileType.OTHER, foc.outputFile(tableInfo))) continue;
                            this.writer(objectMap, foc.getTemplatePath(), foc.outputFile(tableInfo));
                        }
                    }
                }
                if (null != (entityName = tableInfo.getEntityName()) && null != pathInfo.get("entity_path") && this.isCreate(FileType.ENTITY, entityFile = String.format((String)pathInfo.get("entity_path") + File.separator + "%s" + this.suffixJavaOrKt(), entityName))) {
                    this.writer(objectMap, this.templateFilePath(template.getEntity(this.getConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
                }
                if (null != tableInfo.getMapperName() && null != pathInfo.get("mapper_path") && this.isCreate(FileType.MAPPER, mapperFile = String.format((String)pathInfo.get("mapper_path") + File.separator + tableInfo.getMapperName() + this.suffixJavaOrKt(), entityName))) {
                    this.writer(objectMap, this.templateFilePath(template.getMapper()), mapperFile);
                }
                if (null != tableInfo.getXmlName() && null != pathInfo.get("xml_path") && this.isCreate(FileType.XML, xmlFile = String.format((String)pathInfo.get("xml_path") + File.separator + tableInfo.getXmlName() + ".xml", entityName))) {
                    this.writer(objectMap, this.templateFilePath(template.getXml()), xmlFile);
                }
                if (null != tableInfo.getServiceName() && null != pathInfo.get("service_path") && this.isCreate(FileType.SERVICE, serviceFile = String.format((String)pathInfo.get("service_path") + File.separator + tableInfo.getServiceName() + this.suffixJavaOrKt(), entityName))) {
                    this.writer(objectMap, this.templateFilePath(template.getService()), serviceFile);
                }
                if (null != tableInfo.getServiceImplName() && null != pathInfo.get("service_impl_path") && this.isCreate(FileType.SERVICE_IMPL, implFile = String.format((String)pathInfo.get("service_impl_path") + File.separator + tableInfo.getServiceImplName() + this.suffixJavaOrKt(), entityName))) {
                    this.writer(objectMap, this.templateFilePath(template.getServiceImpl()), implFile);
                }
                if (null != tableInfo.getControllerName() && null != pathInfo.get("controller_path") && this.isCreate(FileType.CONTROLLER, controllerFile = String.format((String)pathInfo.get("controller_path") + File.separator + tableInfo.getControllerName() + this.suffixJavaOrKt(), entityName))) {
                    this.writer(objectMap, this.templateFilePath(template.getController()), controllerFile);
                }
                String requestFile = String.format(((String)pathInfo.get("controller_path")).replace("controller", "\\pojo\\request") + File.separator + tableInfo.getControllerName().replace("Controller", "Request") + this.suffixJavaOrKt(), entityName + "Request");
                this.writer(objectMap, this.templateFilePath("/templates/request.java"), requestFile);
                String responseFile = String.format(((String)pathInfo.get("controller_path")).replace("controller", "\\pojo\\response") + File.separator + tableInfo.getControllerName().replace("Controller", "Response") + this.suffixJavaOrKt(), entityName + "Response");
                this.writer(objectMap, this.templateFilePath("/templates/response.java"), responseFile);
            }
        }
        catch (Exception e) {
            System.out.println("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        Template template = this.configuration.getTemplate(templatePath);
        File file = new File(outputFile);
        boolean exist = file.exists();
        if (!exist) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        template.process(objectMap, (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, ConstVal.UTF8));
    }

    public String templateFilePath(String filePath) {
        return filePath + ".ftl";
    }
}

