/*
 * Decompiled with CFR 0.152.
 */
package share.generator;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.util.ArrayList;
import java.util.HashMap;
import share.config.MyPackageConfig;
import share.generator.GenParams;

public class ComplexGenerator {
    public static void main(String[] args) {
        GenParams generateParams = new GenParams();
        generateParams.setJdbcUrl("jdbc:mysql://10.40.93.131:3306/dyc_fund?autoReconnect=true&useUnicode=true&characterEncoding=utf8&zeroDateTimeBehavior=convertToNull&useSSL=false&serverTimezone=Asia/Shanghai&allowMultiQueries=true");
        generateParams.setJdbcPassword("HFDhhjgrh7264");
        generateParams.setRemoveTablePrefix(new String[]{"sys_"});
        generateParams.setIncludeTables(new String[]{"sys_email_send"});
        generateParams.setParentPackage("com.tydic.fund");
        generateParams.setAuthor("lp");
        generateParams.setGeneratorInterface(true);
        generateParams.setOutputDirectory("D:\\111");
        generateParams.setAble(false);
        generateParams.setHandCommit(false);
        generateParams.setAutoCommit(false);
        generateParams.setHaveQuery(false);
        generateParams.setHaveFile(false);
        ComplexGenerator.doGeneration(generateParams);
    }

    public static void doGeneration(final GenParams generateParams) {
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(generateParams.getOutputDirectory());
        gc.setFileOverride(true);
        gc.setActiveRecord(false);
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(true);
        gc.setEnableCache(false);
        gc.setOpen(false);
        gc.setAuthor(generateParams.getAuthor());
        if (generateParams.getGeneratorInterface().booleanValue()) {
            gc.setServiceName("%sService");
            gc.setServiceImplName("%sServiceImpl");
        } else {
            gc.setServiceName("%sService");
            gc.setServiceImplName("%sService");
        }
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(DbType.MYSQL);
        dsc.setDriverName(generateParams.getJdbcDriver());
        dsc.setUrl(generateParams.getJdbcUrl());
        dsc.setUsername(generateParams.getJdbcUserName());
        dsc.setPassword(generateParams.getJdbcPassword());
        dsc.setTypeConvert((ITypeConvert)new MySqlTypeConvert(){

            public DbColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                if (fieldType.toLowerCase().contains("datetime") || fieldType.toLowerCase().contains("date")) {
                    return DbColumnType.DATE;
                }
                return (DbColumnType)super.processTypeConvert(globalConfig, fieldType);
            }
        });
        StrategyConfig strategy = new StrategyConfig();
        strategy.setCapitalMode(false);
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setRestControllerStyle(true);
        strategy.setEntityColumnConstant(false);
        strategy.setTablePrefix(generateParams.getRemoveTablePrefix());
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setInclude(generateParams.getIncludeTables());
        ArrayList<TableFill> tableFills = new ArrayList<TableFill>();
        tableFills.add(new TableFill("CREATE_TIME", FieldFill.INSERT));
        tableFills.add(new TableFill("CREATE_DATE", FieldFill.INSERT));
        tableFills.add(new TableFill("CREATE_USER", FieldFill.INSERT));
        tableFills.add(new TableFill("UPDATE_TIME", FieldFill.UPDATE));
        tableFills.add(new TableFill("UPDATE_DATE", FieldFill.UPDATE));
        tableFills.add(new TableFill("UPDATE_USER", FieldFill.UPDATE));
        tableFills.add(new TableFill("DEL_FLAG", FieldFill.INSERT));
        strategy.setTableFillList(tableFills);
        TemplateConfig tc = new TemplateConfig();
        if (!generateParams.getHaveFile().booleanValue()) {
            tc.setController("/templates/controller.java");
        }
        tc.setEntity("/templates/Entity.java");
        tc.setXml("/templates/mapper.xml");
        if (!generateParams.getGeneratorInterface().booleanValue()) {
            tc.setService("/templates/service.java");
            tc.setServiceImpl("/templates/NoneInterfaceServiceImpl.java");
        }
        MyPackageConfig pc = new MyPackageConfig();
        pc.setParent(generateParams.getParentPackage());
        pc.setModuleName(generateParams.getModuleName());
        pc.setXml("mapper.mapping");
        if (generateParams.getGeneratorInterface().booleanValue()) {
            pc.setServiceImpl("service.impl");
            pc.setService("service");
        } else {
            pc.setServiceImpl("service");
            pc.setService("service");
        }
        InjectionConfig injectionConfig = new InjectionConfig(){

            public void initMap() {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put("able", generateParams.getAble());
                map.put("handCommit", generateParams.getHandCommit());
                map.put("autoCommit", generateParams.getAutoCommit());
                map.put("haveQuery", generateParams.getHaveQuery());
                map.put("haveFile", generateParams.getHaveFile());
                this.setMap(map);
            }
        };
        final String allPath = generateParams.getOutputDirectory() + "\\" + generateParams.getParentPackage().replace(".", "\\");
        ArrayList<FileOutConfig> focList = new ArrayList<FileOutConfig>();
        focList.add(new FileOutConfig("/templates/request.java.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return allPath + "\\bo\\" + tableInfo.getEntityName() + "ReqBO.java";
            }
        });
        focList.add(new FileOutConfig("/templates/response.java.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return allPath + "\\bo\\" + tableInfo.getEntityName() + "RspBO.java";
            }
        });
        injectionConfig.setFileOutConfigList(focList);
        AutoGenerator mpg = new AutoGenerator();
        mpg.setGlobalConfig(gc);
        mpg.setDataSource(dsc);
        mpg.setStrategy(strategy);
        mpg.setTemplate(tc);
        mpg.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        mpg.setCfg(injectionConfig);
        mpg.setPackageInfo((PackageConfig)pc);
        mpg.execute();
    }
}

