package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

/**
 * 标题：DycProBaseCallEsbUtilConfirmAfsOrderForJdReqBO
 * 描述：确认售后完成入参（京东）
 */
@Data
public class DycProBaseCallEsbUtilQueryDoPaReqBO extends DycProBaseCallEsbReqBaseBO {

    private static final long serialVersionUID = -829283779931556082L;

    /**
     * 供应商识别编码
     */
    private String hsn;

    /**
     * 调用地址
     */
    private String url;

    /**
     * 快递公司编码
     */
    private String com;

    /**
     * 快递单号
     */
    private String num;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 出发地
     */
    private String from;

    /**
     * 目的地
     */
    private String to;

    /**
     * 是否开通行政区域解析功能 " +
     * "空：关闭（默认） " +
     * "1：开通行政区域解析功能以及物流轨迹增加物流状态名称 " +
     * "4: 开通行政解析功能以及物流轨迹增加物流高级状态名称、状态值并且返回出发、目的及当前城市信息"
     */
    private Integer resultv2 = 4;

    /**
     * 返回格式：0：json格式（默认），1：xml，2：html，3：text
     */
    private String show;

    /**
     * 返回结果排序:desc降序（默认）,asc 升序
     */
    private String order;

}
