package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：DycProBaseCallEsbUtilDeleteContractForTyBO
 * 描述：回写售后服务退货（糖业）BO
 */
@Data
public class DycProBaseCallEsbUtilDeleteContractForTyBO implements Serializable {

    private static final long serialVersionUID = 1924382932427438146L;

    /**
     * 退货单ID（售后单id）
     */
    private Long id;

    /**
     * 商品名称（skuName）
     */
    private String GoodsName;

    /**
     * 商品数量
     */
    private BigDecimal GoodsNum;

    /**
     * 商品SKU（skuCode?）
     */
    private String sku;

    /**
     * 订单来源 0 京东；2 苏宁；3 西域；…..
     */
    private Integer SourceType;

    /**
     * 一采通订单号
     * 商城无此数据，不会返回？
     */
    private String YctOrderCode;

    /**
     * 售后服务单号
     */
    private String ServiceCode;

    /**
     * 创建时间
     */
    private Date CreateDate;

    /**
     * 时间戳 对应 TimeStamp
     */
    private Long TimeStamp;

    /**
     * 物料类型
     * 商城无此数据，不会返回？
     */
    private Integer MaterialType;

    /**
     * 物料编码（m码？）
     */
    private String MaterialCode;

}
