/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agrchng.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrChngApplyChngApplyStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrChngApplyChngType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAdjustPriceType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrSrc;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrVersionFormWay;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgreementVariety;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainPurScopeType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainQuaprotectUnit;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainVendorMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.EnableFlag;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicProcInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrApplicationScopeChngDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainQryDTO;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngDetailQryService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrApplicationScopeChngBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngDetailQryReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngDetailQryRspBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrCooperationChngCatalogBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngDetailQryService"})
public class DycProAgrChngDetailQryServiceImpl
implements DycProAgrChngDetailQryService {
    @Autowired
    private DycProAgrChngRepository agrChngRepository;
    @Autowired
    private DycProAgrRepository agrMainRepository;
    @Autowired
    private DycProPublicProcInstRepository dycProPublicProcInstRepository;

    @Override
    @PostMapping(value={"qryAgrChngDetail"})
    public DycProAgrChngDetailQryRspBO qryAgrChngDetail(@RequestBody DycProAgrChngDetailQryReqBO reqBO) {
        this.validateParam(reqBO);
        DycProAgrChngDetailQryRspBO rspBO = this.setAgrChngDetailRsp(reqBO);
        DycProAgrMainDTO agrDetail = this.qryAgrDetail(rspBO);
        this.buildCannotChangeData(rspBO, agrDetail);
        this.buildData(rspBO, agrDetail);
        return rspBO;
    }

    private DycProAgrMainDTO qryAgrDetail(DycProAgrChngDetailQryRspBO rspBO) {
        DycProAgrMainQryDTO qryDTO = new DycProAgrMainQryDTO();
        qryDTO.setAgrObjPrimaryId(rspBO.getAgrObjPrimaryId());
        qryDTO.setAgrId(rspBO.getAgrId());
        qryDTO.setAgrCode(rspBO.getAgrCode());
        return this.agrMainRepository.getAgrDetail(qryDTO);
    }

    private void validateParam(DycProAgrChngDetailQryReqBO reqBO) {
        if (null == reqBO.getChngApplyId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrObjPrimaryId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private DycProAgrChngDetailQryRspBO setAgrChngDetailRsp(DycProAgrChngDetailQryReqBO reqBO) {
        DycProAgrChngDetailQryRspBO rspBO = new DycProAgrChngDetailQryRspBO();
        DycProAgrChngMainDTO qryDTO = new DycProAgrChngMainDTO();
        qryDTO.setChngApplyId(reqBO.getChngApplyId());
        DycProAgrChngMainDTO agrChngDetail = this.agrChngRepository.getAgrChngDetailInfo(qryDTO);
        rspBO = (DycProAgrChngDetailQryRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)agrChngDetail), DycProAgrChngDetailQryRspBO.class));
        rspBO.setAgrCooperationChngCatalogList(JSON.parseArray((String)JSON.toJSONString((Object)agrChngDetail.getAgrCooperationChngCatalogBOList()), DycProAgrCooperationChngCatalogBO.class));
        if (!CollectionUtils.isEmpty((Collection)agrChngDetail.getAgrApplicationScopeChngList())) {
            ArrayList<DycProAgrApplicationScopeChngBO> purList = new ArrayList<DycProAgrApplicationScopeChngBO>();
            ArrayList<DycProAgrApplicationScopeChngBO> viewList = new ArrayList<DycProAgrApplicationScopeChngBO>();
            for (DycProAgrApplicationScopeChngDTO scope : agrChngDetail.getAgrApplicationScopeChngList()) {
                if (scope.getApplicationType() == null) continue;
                if (scope.getApplicationType().equals(DycProAgrConstants.AgrScopeApplicationType.PUR_SCOPE)) {
                    purList.add((DycProAgrApplicationScopeChngBO)JSON.parseObject((String)JSON.toJSONString((Object)scope), DycProAgrApplicationScopeChngBO.class));
                    continue;
                }
                if (!scope.getApplicationType().equals(DycProAgrConstants.AgrScopeApplicationType.VIEW_SCOPE)) continue;
                viewList.add((DycProAgrApplicationScopeChngBO)JSON.parseObject((String)JSON.toJSONString((Object)scope), DycProAgrApplicationScopeChngBO.class));
            }
            rspBO.setPurChngScopeList(purList);
            rspBO.setViewChngScopeList(viewList);
        }
        DycProPublicProcInstDTO flowProcInstDto = new DycProPublicProcInstDTO();
        flowProcInstDto.setObjId(agrChngDetail.getChngApplyId());
        flowProcInstDto.setObjType("AgrChngApply");
        DycProPublicProcInstDTO dycProPublicProcInstDTO = this.dycProPublicProcInstRepository.queryFlowMainByObjLastOne(flowProcInstDto);
        if (dycProPublicProcInstDTO != null) {
            rspBO.setProcInstId(dycProPublicProcInstDTO.getProcInstId());
        }
        if (rspBO.getWhetherManageCatalog() != null && BooleanFlag.YES.getCode().equals(rspBO.getWhetherManageCatalog().toString()) && !CollectionUtils.isEmpty(rspBO.getAgrCooperationChngCatalogList())) {
            rspBO.setLastLevelCount(this.getLastLevelCount(rspBO.getAgrCooperationChngCatalogList()));
            rspBO.getAgrCooperationChngCatalogList().forEach(e -> {
                if (e.getEnableFlag() != null) {
                    e.setEnableFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)EnableFlag.class.getSimpleName(), (String)e.getEnableFlag().toString()));
                }
            });
            rspBO.setAgrCooperationChngCatalogList(this.buildCatalogTree(rspBO.getAgrCooperationChngCatalogList()));
        }
        return rspBO;
    }

    public List<DycProAgrCooperationChngCatalogBO> buildCatalogTree(List<DycProAgrCooperationChngCatalogBO> flatList) {
        ArrayList<DycProAgrCooperationChngCatalogBO> result = new ArrayList<DycProAgrCooperationChngCatalogBO>();
        HashMap<Long, DycProAgrCooperationChngCatalogBO> nodeMap = new HashMap<Long, DycProAgrCooperationChngCatalogBO>();
        for (DycProAgrCooperationChngCatalogBO node : flatList) {
            node.setChildren(new ArrayList<DycProAgrCooperationChngCatalogBO>());
            nodeMap.put(node.getManageCatalogId(), node);
        }
        for (DycProAgrCooperationChngCatalogBO node : flatList) {
            Long parentId = node.getManageCatalogParentId();
            if (parentId != null && parentId > 0L) {
                DycProAgrCooperationChngCatalogBO parent = (DycProAgrCooperationChngCatalogBO)nodeMap.get(parentId);
                if (parent == null) continue;
                parent.getChildren().add(node);
                continue;
            }
            result.add(node);
        }
        return result;
    }

    public long getLastLevelCount(List<DycProAgrCooperationChngCatalogBO> catalogBOList) {
        List manageCatalogParentIds = catalogBOList.stream().map(DycProAgrCooperationChngCatalogBO::getManageCatalogParentId).collect(Collectors.toList());
        return catalogBOList.stream().filter(e -> !manageCatalogParentIds.contains(e.getManageCatalogId())).count();
    }

    public void buildCannotChangeData(DycProAgrChngDetailQryRspBO rspBO, DycProAgrMainDTO agrDetail) {
        if (agrDetail.getSupplierId() != null) {
            rspBO.setSupplierId(agrDetail.getSupplierId());
        }
        if (agrDetail.getSupplierName() != null) {
            rspBO.setSupplierName(agrDetail.getSupplierName());
        }
        if (agrDetail.getAgrType() != null) {
            rspBO.setAgrType(agrDetail.getAgrType());
            rspBO.setAgrTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrType.class.getSimpleName(), (String)rspBO.getAgrType().toString()));
        }
        if (agrDetail.getAgrSrc() != null) {
            rspBO.setAgrSrc(agrDetail.getAgrSrc());
            rspBO.setAgrSrcStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrSrc.class.getSimpleName(), (String)rspBO.getAgrSrc().toString()));
        }
        if (agrDetail.getAgrStatus() != null) {
            rspBO.setAgrStatus(agrDetail.getAgrStatus());
            rspBO.setAgrStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrStatus.class.getSimpleName(), (String)rspBO.getAgrStatus().toString()));
        }
        if (agrDetail.getTradeMode() != null) {
            rspBO.setTradeMode(agrDetail.getTradeMode());
            rspBO.setTradeModeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainTradeMode.class.getSimpleName(), (String)rspBO.getTradeMode().toString()));
        }
        if (agrDetail.getAgreementVariety() != null) {
            rspBO.setAgreementVariety(agrDetail.getAgreementVariety());
            rspBO.setAgreementVarietyStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgreementVariety.class.getSimpleName(), (String)rspBO.getAgreementVariety().toString()));
        }
        if (agrDetail.getWhetherHaveItem() != null) {
            rspBO.setWhetherHaveItem(agrDetail.getWhetherHaveItem());
            rspBO.setWhetherHaveItemStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)rspBO.getWhetherHaveItem().toString()));
        }
        if (agrDetail.getWhetherStorePlan() != null) {
            rspBO.setWhetherStorePlan(agrDetail.getWhetherStorePlan());
            rspBO.setWhetherStorePlanStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)rspBO.getWhetherStorePlan().toString()));
        }
        if (agrDetail.getAgrVersionFormWay() != null) {
            rspBO.setAgrVersionFormWay(agrDetail.getAgrVersionFormWay());
            rspBO.setAgrVersionFormWayStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrVersionFormWay.class.getSimpleName(), (String)rspBO.getAgrVersionFormWay().toString()));
        }
    }

    public void buildData(DycProAgrChngDetailQryRspBO rspBO, DycProAgrMainDTO agrDetail) {
        if (rspBO.getAdjustPriceType() == null) {
            rspBO.setAdjustPriceType(agrDetail.getAdjustPriceType());
        }
        rspBO.setAdjustPriceTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAdjustPriceType.class.getSimpleName(), (String)rspBO.getAdjustPriceType().toString()));
        if (rspBO.getWhetherManageCatalog() != null) {
            rspBO.setWhetherManageCatalogStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)rspBO.getWhetherManageCatalog().toString()));
        }
        if (rspBO.getVendorMode() == null) {
            rspBO.setVendorMode(agrDetail.getVendorMode());
        }
        if (rspBO.getVendorMode() != null) {
            rspBO.setVendorModeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainVendorMode.class.getSimpleName(), (String)rspBO.getVendorMode().toString()));
        }
        if (rspBO.getQuaprotectCount() == null) {
            rspBO.setQuaprotectCount(agrDetail.getQuaprotectCount());
        }
        if (StringUtils.isBlank((CharSequence)rspBO.getSupplierContact())) {
            rspBO.setSupplierContact(agrDetail.getSupplierContact());
        }
        if (StringUtils.isBlank((CharSequence)rspBO.getSupplierPhone())) {
            rspBO.setSupplierPhone(agrDetail.getSupplierPhone());
        }
        if (rspBO.getQuaprotectUnit() == null) {
            rspBO.setQuaprotectUnit(agrDetail.getQuaprotectUnit());
        }
        rspBO.setQuaprotectUnitStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainQuaprotectUnit.class.getSimpleName(), (String)rspBO.getQuaprotectUnit().toString()));
        if (rspBO.getPurScopeType() != null) {
            rspBO.setPurScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainPurScopeType.class.getSimpleName(), (String)rspBO.getPurScopeType().toString()));
        }
        if (rspBO.getViewScopeType() != null) {
            rspBO.setViewScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainPurScopeType.class.getSimpleName(), (String)rspBO.getViewScopeType().toString()));
        }
        if (rspBO.getChngType() != null) {
            rspBO.setChngTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrChngApplyChngType.class.getSimpleName(), (String)rspBO.getChngType().toString()));
        }
        if (rspBO.getChngApplyStatus() != null) {
            rspBO.setChngApplyStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrChngApplyChngApplyStatus.class.getSimpleName(), (String)rspBO.getChngApplyStatus().toString()));
        }
    }
}

