/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrItemTaxRate;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemImportJudgeDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainQryDTO;
import com.tydic.dyc.pro.dmc.service.api.DycProAgrItemImportService;
import com.tydic.dyc.pro.dmc.service.bo.DycProAgrImportReasonBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProAgrItemImportInfoBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProAgrItemImportReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProAgrItemImportRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.api.DycProAgrItemImportService"})
public class DycProAgrItemImportServiceImpl
implements DycProAgrItemImportService {
    @Autowired
    private DycProAgrRepository agrRepository;

    @Override
    @PostMapping(value={"dealAgrItemImport"})
    public DycProAgrItemImportRspBO dealAgrItemImport(@RequestBody DycProAgrItemImportReqBO reqBO) {
        ArrayList<DycProAgrItemImportInfoBO> importItemBOS = new ArrayList<DycProAgrItemImportInfoBO>();
        ArrayList<DycProAgrImportReasonBO> failReasonList = new ArrayList<DycProAgrImportReasonBO>();
        ArrayList<DycProAgrImportReasonBO> successReasonList = new ArrayList<DycProAgrImportReasonBO>();
        DycProAgrItemImportRspBO rspBO = new DycProAgrItemImportRspBO();
        rspBO.setFailReasonList(failReasonList);
        rspBO.setSuccessReasonList(successReasonList);
        this.judge(reqBO, importItemBOS, failReasonList);
        if (CollectionUtils.isEmpty(importItemBOS)) {
            return rspBO;
        }
        this.importAgrItem(reqBO, importItemBOS, failReasonList, successReasonList);
        return rspBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importAgrItem(DycProAgrItemImportReqBO reqBO, List<DycProAgrItemImportInfoBO> importItemBOS, List<DycProAgrImportReasonBO> failReasonList, List<DycProAgrImportReasonBO> successReasonList) {
        BigDecimal agrItemNumber;
        DycProAgrItemDTO dycProAgrItemDTO;
        DycProAgrMainQryDTO resultList;
        DycProAgrMainQryDTO qryDTO;
        importItemBOS.sort(Comparator.comparing(DycProAgrItemImportInfoBO::getNumber).reversed());
        ArrayList<DycProAgrItemDTO> createItemDTOS = new ArrayList<DycProAgrItemDTO>();
        if (reqBO.getAgrItemMode().equals(Integer.parseInt(BooleanFlag.YES.getCode()))) {
            qryDTO = new DycProAgrMainQryDTO();
            qryDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
            qryDTO.setWhetherManageCatalog(reqBO.getWhetherManageCatalog());
            qryDTO.setAgrItemImportJudgeList(JSON.parseArray((String)JSON.toJSONString(importItemBOS), DycProAgrItemImportJudgeDTO.class));
            resultList = this.agrRepository.qryAgrItemImportJudgeInfoMaterialMode(qryDTO);
            if (CollectionUtils.isEmpty((Collection)resultList.getAgrItemImportJudgeList())) throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u540e\u53f0\u7c7b\u76ee\u4fe1\u606f");
            Map materialCodeMap = resultList.getAgrItemImportJudgeList().stream().collect(Collectors.toMap(DycProAgrItemImportJudgeDTO::getMaterialCode, Function.identity(), (o1, o2) -> o1));
            for (DycProAgrItemImportInfoBO each : importItemBOS) {
                if (!materialCodeMap.containsKey(each.getMaterialCode())) {
                    failReasonList.add(this.setFailReason("\u3010\u7269\u6599\u7f16\u7801\u3011\u672a\u67e5\u8be2\u5230\uff0c\u6216\u672a\u5173\u8054\u540e\u53f0\u7ba1\u7406\u7c7b\u76ee", each.getGluttonLineNum()));
                    continue;
                }
                dycProAgrItemDTO = (DycProAgrItemDTO)JSON.parseObject((String)JSON.toJSONString((Object)each), DycProAgrItemDTO.class);
                DycProAgrItemImportJudgeDTO materialInfo = (DycProAgrItemImportJudgeDTO)materialCodeMap.get(each.getMaterialCode());
                if (!ObjectUtils.isEmpty((Object)materialInfo.getFailReason())) {
                    failReasonList.add(this.setFailReason(materialInfo.getFailReason(), each.getGluttonLineNum()));
                    continue;
                }
                agrItemNumber = dycProAgrItemDTO.getAgrItemNumber().setScale((int)materialInfo.getDecimalLimit(), 4);
                if (dycProAgrItemDTO.getAgrItemNumber().compareTo(agrItemNumber) != 0) {
                    failReasonList.add(this.setFailReason("\u3010\u6570\u91cf\u3011\u4e0d\u7b26\u5408\u8ba1\u91cf\u5355\u4f4d\u5c0f\u6570\u4f4d\u9650\u5236", each.getGluttonLineNum()));
                    continue;
                }
                dycProAgrItemDTO.setMaterialClassifyId(materialInfo.getMaterialClassifyId());
                dycProAgrItemDTO.setMaterialClassifyName(materialInfo.getMaterialClassifyName());
                dycProAgrItemDTO.setMaterialId(materialInfo.getMaterialId());
                dycProAgrItemDTO.setMaterialCode(materialInfo.getMaterialCode());
                dycProAgrItemDTO.setMaterialName(materialInfo.getMaterialName());
                dycProAgrItemDTO.setManageCatalogId(materialInfo.getManageCatalogId());
                dycProAgrItemDTO.setManageCatalogPath(materialInfo.getManageCatalogPath());
                dycProAgrItemDTO.setManageCatalogPathName(materialInfo.getManageCatalogPathName());
                dycProAgrItemDTO.setManageCatalogName(materialInfo.getManageCatalogName());
                dycProAgrItemDTO.setModel(materialInfo.getModel());
                dycProAgrItemDTO.setSpec(materialInfo.getSpec());
                dycProAgrItemDTO.setBrandName(materialInfo.getBrandName());
                dycProAgrItemDTO.setMeasureId(materialInfo.getMeasureId());
                dycProAgrItemDTO.setMeasureName(materialInfo.getMeasureName());
                createItemDTOS.add(dycProAgrItemDTO);
                DycProAgrImportReasonBO reasonBO = new DycProAgrImportReasonBO();
                reasonBO.setLineNum(each.getGluttonLineNum());
                reasonBO.setSuccessReason("\u6210\u529f");
                successReasonList.add(reasonBO);
            }
        } else {
            qryDTO = new DycProAgrMainQryDTO();
            qryDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
            qryDTO.setWhetherManageCatalog(reqBO.getWhetherManageCatalog());
            qryDTO.setAgrItemImportJudgeList(JSON.parseArray((String)JSON.toJSONString(importItemBOS), DycProAgrItemImportJudgeDTO.class));
            resultList = this.agrRepository.qryAgrItemImportJudgeInfoCommodityMode(qryDTO);
            if (CollectionUtils.isEmpty((Collection)resultList.getAgrItemImportJudgeList())) throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u540e\u53f0\u7c7b\u76ee\u4fe1\u606f");
            Map manageCatalogCodeMap = resultList.getAgrItemImportJudgeList().stream().collect(Collectors.toMap(DycProAgrItemImportJudgeDTO::getGluttonLineNum, Function.identity()));
            for (DycProAgrItemImportInfoBO each : importItemBOS) {
                if (!manageCatalogCodeMap.containsKey(each.getGluttonLineNum())) {
                    failReasonList.add(this.setFailReason("\u3010\u540e\u53f0\u7ba1\u7406\u7c7b\u76ee\u3011\u672a\u67e5\u8be2\u5230", each.getGluttonLineNum()));
                    continue;
                }
                dycProAgrItemDTO = (DycProAgrItemDTO)JSON.parseObject((String)JSON.toJSONString((Object)each), DycProAgrItemDTO.class);
                DycProAgrItemImportJudgeDTO manageCatalogCodeInfo = (DycProAgrItemImportJudgeDTO)manageCatalogCodeMap.get(each.getGluttonLineNum());
                if (!ObjectUtils.isEmpty((Object)manageCatalogCodeInfo.getFailReason())) {
                    failReasonList.add(this.setFailReason(manageCatalogCodeInfo.getFailReason(), each.getGluttonLineNum()));
                    continue;
                }
                agrItemNumber = dycProAgrItemDTO.getAgrItemNumber().setScale((int)manageCatalogCodeInfo.getDecimalLimit(), 4);
                if (dycProAgrItemDTO.getAgrItemNumber().compareTo(agrItemNumber) != 0) {
                    failReasonList.add(this.setFailReason("\u3010\u6570\u91cf\u3011\u4e0d\u7b26\u5408\u8ba1\u91cf\u5355\u4f4d\u5c0f\u6570\u4f4d\u9650\u5236", each.getGluttonLineNum()));
                    continue;
                }
                dycProAgrItemDTO.setManageCatalogId(manageCatalogCodeInfo.getManageCatalogId());
                dycProAgrItemDTO.setManageCatalogPath(manageCatalogCodeInfo.getManageCatalogPath());
                dycProAgrItemDTO.setManageCatalogPathName(manageCatalogCodeInfo.getManageCatalogPathName());
                dycProAgrItemDTO.setManageCatalogName(manageCatalogCodeInfo.getManageCatalogName());
                dycProAgrItemDTO.setMeasureId(manageCatalogCodeInfo.getMeasureId());
                dycProAgrItemDTO.setMeasureName(manageCatalogCodeInfo.getMeasureName());
                createItemDTOS.add(dycProAgrItemDTO);
            }
        }
        if (CollectionUtils.isEmpty(createItemDTOS)) return;
        for (DycProAgrItemDTO each : createItemDTOS) {
            each.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
            each.setAgrId(reqBO.getAgrId());
        }
        this.agrRepository.saveAgrItems(createItemDTOS);
    }

    private void judge(DycProAgrItemImportReqBO reqBO, List<DycProAgrItemImportInfoBO> importItemBOS, List<DycProAgrImportReasonBO> failReasonList) {
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrObjPrimaryId())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrId())) {
            throw new ZTBusinessException("\u3010\u534f\u8baeID\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getWhetherManageCatalog())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u7ba1\u7406\u5408\u4f5c\u7c7b\u76ee\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrItemMode())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u660e\u7ec6\u662f\u5426\u8d70\u7269\u6599\u7ef4\u5ea6\u3011\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getAgrItemImportList())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6570\u636e\u884c\u3011\u4e3a\u7a7a");
        }
        List taxRateList = Arrays.stream(DmcAgrItemTaxRate.values()).map(e -> new BigDecimal(e.getCode())).collect(Collectors.toList());
        for (DycProAgrItemImportInfoBO each : reqBO.getAgrItemImportList()) {
            if (ObjectUtils.isEmpty((Object)each.getGluttonLineNum())) {
                throw new ZTBusinessException("\u3010\u5bfc\u5165\u4e2d\u5fc3\u884c\u53f7\u3011\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)each.getNumber())) {
                failReasonList.add(this.setFailReason("\u3010\u660e\u7ec6\u5e8f\u53f7\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                continue;
            }
            if (reqBO.getAgrItemMode().equals(Integer.parseInt(BooleanFlag.NO.getCode()))) {
                if (ObjectUtils.isEmpty((Object)each.getManageCatalogCode())) {
                    failReasonList.add(this.setFailReason("\u3010\u540e\u53f0\u7ba1\u7406\u7c7b\u76ee\u7f16\u7801\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)each.getSpec())) {
                    failReasonList.add(this.setFailReason("\u3010\u89c4\u683c\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)each.getModel())) {
                    failReasonList.add(this.setFailReason("\u3010\u578b\u53f7\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)each.getMeasureName())) {
                    failReasonList.add(this.setFailReason("\u3010\u8ba1\u91cf\u5355\u4f4d\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)each.getCommodityName())) {
                    failReasonList.add(this.setFailReason("\u3010\u5546\u54c1\u540d\u79f0\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                    continue;
                }
            } else if (ObjectUtils.isEmpty((Object)each.getMaterialCode())) {
                failReasonList.add(this.setFailReason("\u3010\u7269\u6599\u7f16\u7801\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                continue;
            }
            if (ObjectUtils.isEmpty((Object)each.getBrandName())) {
                failReasonList.add(this.setFailReason("\u3010\u54c1\u724c\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                continue;
            }
            if (ObjectUtils.isEmpty((Object)each.getAgrItemNumber())) {
                failReasonList.add(this.setFailReason("\u3010\u6570\u91cf\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                continue;
            }
            if (ObjectUtils.isEmpty((Object)each.getSupplyPrice())) {
                failReasonList.add(this.setFailReason("\u3010\u4f9b\u8d27\u4ef7\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                continue;
            }
            if (ObjectUtils.isEmpty((Object)each.getSupplyCycle())) {
                failReasonList.add(this.setFailReason("\u3010\u4f9b\u8d27\u5468\u671f\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                continue;
            }
            if (ObjectUtils.isEmpty((Object)each.getTaxRate())) {
                failReasonList.add(this.setFailReason("\u3010\u7a0e\u7387\u3011\u4e3a\u7a7a", each.getGluttonLineNum()));
                continue;
            }
            if (!taxRateList.contains(each.getTaxRate())) {
                failReasonList.add(this.setFailReason("\u3010\u7a0e\u7387\u3011\u4e0d\u5c5e\u4e8e\u89c4\u5b9a\u8303\u56f4", each.getGluttonLineNum()));
                continue;
            }
            importItemBOS.add(each);
        }
    }

    private DycProAgrImportReasonBO setFailReason(String failReason, Integer lineNum) {
        DycProAgrImportReasonBO failReasonBO = new DycProAgrImportReasonBO();
        failReasonBO.setFailReason(failReason);
        failReasonBO.setLineNum(lineNum);
        return failReasonBO;
    }
}

