/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuEsScopeType;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrScopeJudgeQryService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeQryReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeQryRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrScopeJudgeQryService"})
public class DycProCommAgrScopeJudgeQryServiceImpl
implements DycProCommAgrScopeJudgeQryService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;

    @PostMapping(value={"qryAgrScopeJudge"})
    public DycProCommAgrScopeJudgeQryRspBO qryAgrScopeJudge(@RequestBody DycProCommAgrScopeJudgeQryReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds()) && CollectionUtils.isEmpty((Collection)reqBO.getAgrIds())) {
            throw new ZTBusinessException("\u3010skuIds\u3011\u6216\u3010agrIds\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getCompanyId())) {
            throw new ZTBusinessException("\u3010companyId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getOrgPath())) {
            throw new ZTBusinessException("\u3010orgPath\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List agrIds = reqBO.getAgrIds();
        List skuMainListByCondition = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            DycProCommSkuHandleDTO qrySkuDTO = new DycProCommSkuHandleDTO();
            qrySkuDTO.setSkuIdList(reqBO.getSkuIds());
            skuMainListByCondition = this.dycProCommSkuRepository.getSkuMainListByCondition(qrySkuDTO);
            agrIds = skuMainListByCondition.stream().map(DycProCommSkuDTO::getAgrId).filter(Objects::nonNull).collect(Collectors.toList());
        }
        DycProCommSkuQryDTO dycProCommSkuQryDTO = new DycProCommSkuQryDTO();
        if (!CollectionUtils.isEmpty((Collection)agrIds)) {
            DycProCommSkuQryDTO qryDTO = new DycProCommSkuQryDTO();
            qryDTO.setAgrIds(agrIds);
            dycProCommSkuQryDTO = this.dycProCommSkuRepository.qrySkuAgrScope(qryDTO);
        }
        ArrayList<String> userScopeList = new ArrayList<String>();
        userScopeList.add(DmcCommSkuEsScopeType.ALL.getCode());
        String orgPath = reqBO.getOrgPath();
        if (orgPath.endsWith("-")) {
            orgPath = orgPath.substring(0, orgPath.length() - 1);
        }
        String[] orgList = orgPath.split("-");
        StringBuilder currentPath = new StringBuilder();
        for (int i = 0; i < orgList.length; ++i) {
            if (i > 0) {
                currentPath.append("-");
            }
            currentPath.append(orgList[i]);
            userScopeList.add(DmcCommSkuEsScopeType.COMPANY_PATH.getCode() + new String(currentPath));
        }
        userScopeList.add(DmcCommSkuEsScopeType.COMPANY_ID.getCode() + reqBO.getCompanyId());
        ArrayList<DycProCommAgrScopeJudgeBO> skuAgrScopeList = new ArrayList<DycProCommAgrScopeJudgeBO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            for (DycProCommSkuDTO sku : skuMainListByCondition) {
                DycProCommAgrScopeJudgeBO judgeBO = new DycProCommAgrScopeJudgeBO();
                if (DycProCommConstants.SkuSource.AGR_SKU.equals(sku.getSkuSource())) {
                    if (dycProCommSkuQryDTO.getAgrIdViewScopeMap().containsKey(sku.getAgrId())) {
                        for (String userScope : userScopeList) {
                            if (((List)dycProCommSkuQryDTO.getAgrIdViewScopeMap().get(sku.getAgrId())).contains(userScope)) {
                                judgeBO.setViewFlag(Boolean.valueOf(true));
                            }
                            if (!((List)dycProCommSkuQryDTO.getAgrIdPurScopeMap().get(sku.getAgrId())).contains(userScope)) continue;
                            judgeBO.setPurFlag(Boolean.valueOf(true));
                        }
                    }
                } else if (DycProCommConstants.SkuSource.E_SKU.equals(sku.getSkuSource())) {
                    judgeBO.setViewFlag(Boolean.valueOf(true));
                    judgeBO.setPurFlag(Boolean.valueOf(true));
                }
                judgeBO.setSkuId(sku.getSkuId());
                judgeBO.setAgrId(sku.getAgrId());
                skuAgrScopeList.add(judgeBO);
            }
        } else {
            for (Long agrId : reqBO.getAgrIds()) {
                DycProCommAgrScopeJudgeBO judgeBO = new DycProCommAgrScopeJudgeBO();
                if (dycProCommSkuQryDTO.getAgrIdViewScopeMap().containsKey(agrId)) {
                    for (String userScope : userScopeList) {
                        if (((List)dycProCommSkuQryDTO.getAgrIdViewScopeMap().get(agrId)).contains(userScope)) {
                            judgeBO.setViewFlag(Boolean.valueOf(true));
                        }
                        if (!((List)dycProCommSkuQryDTO.getAgrIdPurScopeMap().get(agrId)).contains(userScope)) continue;
                        judgeBO.setPurFlag(Boolean.valueOf(true));
                    }
                }
                judgeBO.setAgrId(agrId);
                skuAgrScopeList.add(judgeBO);
            }
        }
        DycProCommAgrScopeJudgeQryRspBO rspBO = new DycProCommAgrScopeJudgeQryRspBO();
        rspBO.setSkuAgrScopeList(skuAgrScopeList);
        return rspBO;
    }
}

