/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.stock.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuStockInfoRecordsChangeType;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuVolumeInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.api.DycProCommSkuStockInfoRepository;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoRecordsDTO;
import com.tydic.dyc.pro.dmc.service.stock.api.DycProCommSkuStockDeductService;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductReqBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductRspBO;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.stock.api.DycProCommSkuStockDeductService"})
public class DycProCommSkuStockDeductServiceImpl
implements DycProCommSkuStockDeductService {
    @Autowired
    private DycProCommSkuStockInfoRepository commSkuStockInfoRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;

    @PostMapping(value={"dealSkuStockDeduct"})
    public DycProCommSkuStockDeductRspBO dealSkuStockDeduct(@RequestBody DycProCommSkuStockDeductReqBO reqBO) {
        DycProCommSkuStockDeductRspBO rspBO = new DycProCommSkuStockDeductRspBO();
        this.validateParam(reqBO);
        for (DycProCommSkuStockDeductBO sku : reqBO.getDeductBOList()) {
            DycProCommSkuDTO qrySkuDTO = new DycProCommSkuDTO();
            qrySkuDTO.setSkuId(sku.getSkuId());
            DycProCommSkuDTO skuDTO = this.dycProCommSkuRepository.getSkuMainInfoByCondition(qrySkuDTO);
            if (null == skuDTO) {
                throw new ZTBusinessException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            }
            if (Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.ORDER_REDUCE.getCode()).equals(reqBO.getChangeType())) {
                this.updateSaleVolume(sku);
            }
            if (!DycProCommConstants.SkuSource.AGR_SKU.equals(skuDTO.getSkuSource())) continue;
            DycProCommSkuStockInfoDTO qryDTO = new DycProCommSkuStockInfoDTO();
            qryDTO.setSkuId(sku.getSkuId());
            DycProCommSkuStockInfoDTO stockInfo = this.commSkuStockInfoRepository.getStockInfoById(qryDTO);
            if (null == stockInfo) {
                throw new ZTBusinessException("\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            }
            DycProCommSkuStockInfoDTO updateStockInfo = new DycProCommSkuStockInfoDTO();
            BeanUtils.copyProperties((Object)reqBO, (Object)updateStockInfo);
            updateStockInfo.setStockId(stockInfo.getStockId());
            if (Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.ORDER_REDUCE.getCode()).equals(reqBO.getChangeType())) {
                updateStockInfo.setSaledNum(stockInfo.getSaledNum().add(sku.getDeductAmount()));
                updateStockInfo.setUnsaleNum(stockInfo.getUnsaleNum().subtract(sku.getDeductAmount()));
            }
            if (Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.ORDER_BACK.getCode()).equals(reqBO.getChangeType())) {
                updateStockInfo.setSaledNum(stockInfo.getSaledNum().subtract(sku.getDeductAmount()));
                updateStockInfo.setUnsaleNum(stockInfo.getUnsaleNum().add(sku.getDeductAmount()));
            }
            ArrayList<DycProCommSkuStockInfoRecordsDTO> skuStockInfoRecordsList = new ArrayList<DycProCommSkuStockInfoRecordsDTO>();
            DycProCommSkuStockInfoRecordsDTO dycProCommSkuStockInfoRecordsDTO = new DycProCommSkuStockInfoRecordsDTO();
            dycProCommSkuStockInfoRecordsDTO.setChangeType(reqBO.getChangeType());
            dycProCommSkuStockInfoRecordsDTO.setChangeNum(sku.getDeductAmount());
            dycProCommSkuStockInfoRecordsDTO.setBeforeTotalNum(stockInfo.getTotalNum());
            dycProCommSkuStockInfoRecordsDTO.setAfterTotalNum(stockInfo.getTotalNum());
            dycProCommSkuStockInfoRecordsDTO.setBeforeUnsaleNum(stockInfo.getUnsaleNum());
            dycProCommSkuStockInfoRecordsDTO.setAfterUnsaleNum(updateStockInfo.getUnsaleNum());
            skuStockInfoRecordsList.add(dycProCommSkuStockInfoRecordsDTO);
            updateStockInfo.setSkuStockInfoRecordsList(skuStockInfoRecordsList);
            this.commSkuStockInfoRepository.updateSkuStock(updateStockInfo);
        }
        return rspBO;
    }

    private void updateSaleVolume(DycProCommSkuStockDeductBO sku) {
        DycProCommSkuVolumeInfoDTO dycProCommSkuVolumeInfoDTO = new DycProCommSkuVolumeInfoDTO();
        dycProCommSkuVolumeInfoDTO.setSkuId(sku.getSkuId());
        dycProCommSkuVolumeInfoDTO.setOrderAmount(sku.getDeductAmount());
        this.dycProCommSkuRepository.updateSkuVolumeInfoAndSyncNosql(dycProCommSkuVolumeInfoDTO);
    }

    private void validateParam(DycProCommSkuStockDeductReqBO reqBO) {
        if (null == reqBO.getChangeType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010changeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDeductBOList())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010deductBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (DycProCommSkuStockDeductBO bo : reqBO.getDeductBOList()) {
            if (null == bo.getSkuId()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != bo.getDeductAmount()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u3010deductAmount\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

