/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.checkrule.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckExecActionEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckResultEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuInfoExamineStatus;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.bansrecord.api.DycProCommBansRecordRepository;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRecordRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckObjCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommAuditCheckObjCheckRecordService;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommAuditCheckObjCheckRecordReqBO;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommAuditCheckObjCheckRecordRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommAuditCheckObjCheckRecordService"})
public class DycProCommAuditCheckObjCheckRecordServiceImpl
implements DycProCommAuditCheckObjCheckRecordService {
    @Autowired
    private DycProCommCheckRecordRepository dycProCommCheckRecordRepository;
    @Autowired
    private DycProCommBansRecordRepository dycProCommBansRecordRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;

    @Override
    @PostMapping(value={"auditCheckObjCheckRecord"})
    public DycProCommAuditCheckObjCheckRecordRspBO auditCheckObjCheckRecord(@RequestBody DycProCommAuditCheckObjCheckRecordReqBO reqBO) {
        this.validParam(reqBO);
        DycProCommCheckObjCheckRecordDTO qryDTO = new DycProCommCheckObjCheckRecordDTO();
        qryDTO.setCheckSnId(reqBO.getCheckSnId());
        DycProCommCheckObjCheckRecordDTO detailDto = this.dycProCommCheckRecordRepository.queryCheckObjCheckRecordByConditon(qryDTO);
        if (detailDto == null) {
            throw new ZTBusinessException("\u5165\u53c2\u68c0\u6d4b\u8bb0\u5f55\u6d41\u6c34\u3010" + reqBO.getCheckSnId() + "\u3011\u4e0d\u5b58\u5728");
        }
        DycProCommCheckObjCheckRecordDTO ObjCheckRecordDTO = new DycProCommCheckObjCheckRecordDTO();
        ObjCheckRecordDTO.setItemIds(reqBO.getItemIds());
        ObjCheckRecordDTO.setCheckSnId(reqBO.getCheckSnId());
        if ("normal".equals(reqBO.getType())) {
            ObjCheckRecordDTO.setPersonAuditCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            ObjCheckRecordDTO.setClearExceptionFlag(DycProCommConstants.YesOrNo.YES);
        } else {
            ObjCheckRecordDTO.setPersonAuditCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
        }
        ObjCheckRecordDTO.setAuditOpinion(reqBO.getAuditOpinion());
        ObjCheckRecordDTO.setAuditTime(new Date());
        ObjCheckRecordDTO.setAuditUserId(reqBO.getUserId());
        ObjCheckRecordDTO.setAuditUserName(reqBO.getName());
        ObjCheckRecordDTO.setAuditUserAccount(reqBO.getUserName());
        ObjCheckRecordDTO.setAuditOrgId(reqBO.getOrgId());
        ObjCheckRecordDTO.setAuditOrgName(reqBO.getOrgName());
        ObjCheckRecordDTO.setAuditCompanyId(reqBO.getCompanyId());
        ObjCheckRecordDTO.setAuditCompanyName(reqBO.getCompanyName());
        ObjCheckRecordDTO.setCheckStatus(DycProCommConstants.checkRuleCheckStatus.FINISH);
        this.dycProCommCheckRecordRepository.updatePersonAuditCheckResultByCheckSnId(ObjCheckRecordDTO);
        if ("normal".equals(reqBO.getType())) {
            DycProCommBansRecordInfoDTO dycProCommBansRecordInfoDTO = new DycProCommBansRecordInfoDTO();
            dycProCommBansRecordInfoDTO.setSkuId(detailDto.getCheckObjId());
            dycProCommBansRecordInfoDTO.setBansType(DycProCommConstants.bansRuleType.PIC_TEXT_DETECTION);
            this.dycProCommBansRecordRepository.deleteBansRecord(dycProCommBansRecordInfoDTO);
            this.dycProCommBansRecordRepository.syncNosql(detailDto.getCheckObjId());
        } else {
            DycProCommCheckRecordDTO recordDTO;
            DycProCommCheckRecordQryDTO recordQryDTO = new DycProCommCheckRecordQryDTO();
            recordQryDTO.setCheckSnId(detailDto.getCheckSnId());
            List recordDTOS = this.dycProCommCheckRecordRepository.queryCheckRecordInfoList(recordQryDTO);
            if (recordDTOS != null && !recordDTOS.isEmpty() && !(recordDTO = (DycProCommCheckRecordDTO)recordDTOS.get(0)).getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode()))) {
                DycProCommCheckRuleInfoQryDTO dycProCommCheckRuleInfoQryDTO = new DycProCommCheckRuleInfoQryDTO();
                dycProCommCheckRuleInfoQryDTO.setCheckRuleType(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode())));
                dycProCommCheckRuleInfoQryDTO.setCheckSceneCode(detailDto.getCheckSceneCode());
                dycProCommCheckRuleInfoQryDTO.setCheckObjType(detailDto.getCheckObjType());
                List dycProCommCheckRuleInfoDTOs = this.dycProCommCheckRuleInfoRepository.querySkuEffectCheckRule(dycProCommCheckRuleInfoQryDTO);
                if (dycProCommCheckRuleInfoDTOs != null && !dycProCommCheckRuleInfoDTOs.isEmpty()) {
                    dycProCommCheckRuleInfoDTOs.forEach(dycProCommCheckRuleInfoDTO -> {
                        if (dycProCommCheckRuleInfoDTO.getCheckResultCode().equals(DmcCommCheckResultEnum.CONFIRM.getCode())) {
                            DycProCommCheckRecordDTO set = (DycProCommCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleInfoDTO), DycProCommCheckRecordDTO.class);
                            set.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                            DycProCommCheckRecordDTO where = new DycProCommCheckRecordDTO();
                            where.setCheckRecordId(recordDTO.getCheckRecordId());
                            this.dycProCommCheckRecordRepository.updateCheckRecordByConditon(set, where);
                            if (dycProCommCheckRuleInfoDTO.getCheckExecActionCode().equals(DmcCommCheckExecActionEnum.BANS.getCode())) {
                                DycProCommBansRecordInfoDTO dycProCommBansRecordInfoDTO = new DycProCommBansRecordInfoDTO();
                                dycProCommBansRecordInfoDTO.setSkuId(recordDTO.getCheckObjId());
                                dycProCommBansRecordInfoDTO.setBansType(DycProCommConstants.bansRuleType.PIC_TEXT_DETECTION);
                                this.dycProCommBansRecordRepository.deleteBansRecord(dycProCommBansRecordInfoDTO);
                                DycProCommBansRecordInfoDTO recordInfoDTO = new DycProCommBansRecordInfoDTO();
                                recordInfoDTO.setSkuId(recordDTO.getCheckObjId());
                                recordInfoDTO.setBansType(DycProCommConstants.bansRuleType.PIC_TEXT_DETECTION);
                                recordInfoDTO.setBansReason("\u56fe\u6587\u5f02\u5e38");
                                recordInfoDTO.setBansRuleId(dycProCommCheckRuleInfoDTO.getCheckRuleId());
                                recordInfoDTO.setBansStartDate(new Date());
                                recordInfoDTO.setBansEndDate(DateUtils.strToDateLong((String)"2099-12-12 23:23:59"));
                                recordInfoDTO.setCreateTime(new Date());
                                ArrayList<DycProCommBansRecordInfoDTO> dtoList = new ArrayList<DycProCommBansRecordInfoDTO>();
                                dtoList.add(recordInfoDTO);
                                this.dycProCommBansRecordRepository.addBansRecord(dtoList);
                                this.dycProCommBansRecordRepository.syncNosql(recordDTO.getCheckObjId());
                                DycProCommCheckObjCheckRecordDTO set1 = new DycProCommCheckObjCheckRecordDTO();
                                set1.setCheckExecActionNameList(DmcCommCheckExecActionEnum.BANS.getValue());
                                DycProCommCheckObjCheckRecordDTO where1 = new DycProCommCheckObjCheckRecordDTO();
                                where1.setCheckSnId(reqBO.getCheckSnId());
                                this.dycProCommCheckRecordRepository.updateCheckObjCheckRecordByConditon(set1, where1);
                            }
                        }
                    });
                }
            }
        }
        DycProCommCheckRecordQryDTO recordQryDTO1 = new DycProCommCheckRecordQryDTO();
        recordQryDTO1.setCheckObjId(detailDto.getCheckObjId());
        recordQryDTO1.setIsLastFlag(DycProCommConstants.YesOrNo.YES);
        recordQryDTO1.setClearExceptionFlag(DycProCommConstants.YesOrNo.NO);
        List checkObjCheckRecordDTOs = this.dycProCommCheckRecordRepository.selectCheckObjCheckRecordList(recordQryDTO1);
        boolean updateSkuEsFlag = true;
        ArrayList<String> actionCodes = new ArrayList<String>();
        if (!checkObjCheckRecordDTOs.isEmpty()) {
            for (DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO : checkObjCheckRecordDTOs) {
                if (checkObjCheckRecordDTO.getCheckStatus().equals(DycProCommConstants.checkRuleCheckStatus.CHECKIING)) {
                    updateSkuEsFlag = false;
                    break;
                }
                if (checkObjCheckRecordDTO.getPersonAuditCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()))) continue;
                actionCodes.add(checkObjCheckRecordDTO.getCheckExecActionNameList());
            }
        }
        if (updateSkuEsFlag) {
            ArrayList<DycProCommSkuDTO> dycProCommSkuDTOS = new ArrayList<DycProCommSkuDTO>();
            DycProCommSkuDTO dycProCommSkuDTO = new DycProCommSkuDTO();
            dycProCommSkuDTOS.add(dycProCommSkuDTO);
            dycProCommSkuDTO.setSkuId(detailDto.getCheckObjId());
            String actionNames = ((Object)actionCodes).toString();
            if (actionNames.contains(DmcCommCheckExecActionEnum.BANS.getValue())) {
                dycProCommSkuDTO.setExamineStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECK_REJECT.getCode())));
            } else if (actionNames.contains(DmcCommCheckExecActionEnum.WARN.getValue())) {
                dycProCommSkuDTO.setExamineStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECK_WORN_PASS.getCode())));
            } else {
                dycProCommSkuDTO.setExamineStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECK_PASS.getCode())));
            }
            this.dycProCommSkuRepository.updateSkuMainInfoBatchAndSyncNosql(dycProCommSkuDTOS);
        }
        return new DycProCommAuditCheckObjCheckRecordRspBO();
    }

    private void validParam(DycProCommAuditCheckObjCheckRecordReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getType())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010type\u3011\u4e3a\u7a7a");
        }
    }
}

