/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.pricerule.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.repository.upc.api.DycProCommUpcRepository;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcInfoDTO;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcPriceChangeRecordDTO;
import com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommQueryUpcPriceChangeRecordListService;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommQueryUpcPriceChangeRecordListReqBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommQueryUpcPriceChangeRecordListRspBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommUpcPriceChangeRecordBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommUpcRelSkuInfoBO;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommQueryUpcPriceChangeRecordListService"})
public class DycProCommQueryUpcPriceChangeRecordListServiceImpl
implements DycProCommQueryUpcPriceChangeRecordListService {
    @Autowired
    private DycProCommUpcRepository dycProCommUpcRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;

    @Override
    @PostMapping(value={"queryUpcReferencePriceChngRecordList"})
    public DycProCommQueryUpcPriceChangeRecordListRspBO queryUpcReferencePriceChngRecordList(@RequestBody DycProCommQueryUpcPriceChangeRecordListReqBO reqBO) {
        DycProCommQueryUpcPriceChangeRecordListRspBO rspBO = new DycProCommQueryUpcPriceChangeRecordListRspBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getUpcId())) {
            return rspBO;
        }
        DycProCommUpcInfoDTO dycProCommUpcInfoDTO = new DycProCommUpcInfoDTO();
        dycProCommUpcInfoDTO.setUpcId(reqBO.getUpcId());
        DycProCommUpcInfoDTO upcInfoDTO = this.dycProCommUpcRepository.getUpcMainInfoOneByCondition(dycProCommUpcInfoDTO);
        if (upcInfoDTO == null) {
            return rspBO;
        }
        DycProCommUpcPriceChangeRecordDTO dycProCommUpcPriceChangeRecordDTO = new DycProCommUpcPriceChangeRecordDTO();
        dycProCommUpcPriceChangeRecordDTO.setUpcId(reqBO.getUpcId());
        List dtoList = this.dycProCommUpcRepository.getUpcPriceChangeRecordList(dycProCommUpcPriceChangeRecordDTO);
        if (!ObjectUtils.isEmpty((Object)dtoList)) {
            List rows = JSON.parseArray((String)JSON.toJSONString((Object)dtoList), DycProCommUpcPriceChangeRecordBO.class);
            if (reqBO.getLatestRecordsByDateFlag().booleanValue()) {
                this.deduplicateByDate(rows);
            }
            HashSet skuIds = new HashSet();
            rows.forEach(item -> {
                List skuInfoBOList = JSON.parseArray((String)item.getRelSkuPriceJson(), DycProCommUpcRelSkuInfoBO.class);
                for (DycProCommUpcRelSkuInfoBO dycProCommUpcRelSkuInfoBO : skuInfoBOList) {
                    skuIds.add(dycProCommUpcRelSkuInfoBO.getSkuId());
                }
                item.setSkuInfoBOList(skuInfoBOList);
                item.setUpcCode(upcInfoDTO.getUpcCode());
                item.setUpcName(upcInfoDTO.getUpcName());
                item.setMCode(upcInfoDTO.getMCode());
                item.setMName(upcInfoDTO.getMName());
            });
            DycProCommSkuHandleDTO dycProCommSkuHandleDTO = new DycProCommSkuHandleDTO();
            dycProCommSkuHandleDTO.setSkuIdList(new ArrayList(skuIds));
            List skuDTOList = this.dycProCommSkuRepository.getSkuMainListByCondition(dycProCommSkuHandleDTO);
            if (!ObjectUtils.isEmpty((Object)skuDTOList)) {
                HashMap map = new HashMap();
                skuDTOList.forEach(dycProCommSkuDTO -> map.put(dycProCommSkuDTO.getSkuId(), dycProCommSkuDTO));
                rows.forEach(item -> item.getSkuInfoBOList().forEach(dycProCommUpcRelSkuInfoBO -> {
                    DycProCommSkuDTO dto = (DycProCommSkuDTO)map.get(dycProCommUpcRelSkuInfoBO.getSkuId());
                    dycProCommUpcRelSkuInfoBO.setSkuCode(dto.getSkuCode());
                    dycProCommUpcRelSkuInfoBO.setSkuName(dto.getSkuName());
                    dycProCommUpcRelSkuInfoBO.setExtSkuId(dto.getExtSkuId());
                    dycProCommUpcRelSkuInfoBO.setSupplierId(dto.getSupplierId());
                    dycProCommUpcRelSkuInfoBO.setSupplierName(dto.getSupplierName());
                }));
            }
            DycProCommUpcPriceChangeRecordBO maxRecord = rows.stream().max(Comparator.comparing(DycProCommUpcPriceChangeRecordBO::getCreateTime)).get();
            if (rows.size() == 1 || !DycProCommQueryUpcPriceChangeRecordListServiceImpl.isSameDay(maxRecord.getCreateTime(), new Date())) {
                DycProCommUpcPriceChangeRecordBO mockRecord = new DycProCommUpcPriceChangeRecordBO();
                BeanUtils.copyProperties((Object)maxRecord, (Object)mockRecord);
                mockRecord.setIsMockRecord(true);
                mockRecord.setCreateTime(new Date());
                rows.add(mockRecord);
            }
            rspBO.setRows(rows);
        }
        return rspBO;
    }

    private void deduplicateByDate(List<DycProCommUpcPriceChangeRecordBO> records) {
        Map<LocalDate, DycProCommUpcPriceChangeRecordBO> latestRecordsByDate = records.stream().collect(Collectors.toMap(this::getLocalDate, record -> record, (existing, replacement) -> existing.getCreateTime().after(replacement.getCreateTime()) ? existing : replacement));
        ArrayList<DycProCommUpcPriceChangeRecordBO> result = new ArrayList<DycProCommUpcPriceChangeRecordBO>(latestRecordsByDate.values());
        result.sort(Comparator.comparing(DycProCommUpcPriceChangeRecordBO::getCreateTime));
    }

    private LocalDate getLocalDate(DycProCommUpcPriceChangeRecordBO record) {
        return record.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        LocalDate localDate1 = date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate1.isEqual(localDate2);
    }
}

