/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.channel.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldRsqBO;
import com.ohaotian.plugin.nosql.constant.NosqlQueryValueType;
import com.ohaotian.plugin.nosql.impl.NosqlCreateBuilder;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dictionary.enums.EnableFlag;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.core.flow.repository.constants.DycProCommonFlowConstant;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommChannelCatalogRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommChannelInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommChannelPoolRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommGuideCatalogInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommGuideCatalogManageRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommGuideCatalogPropertyTemplateRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommManageCatalogInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPoolCommodityRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommPoolInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPoolManageCatalogRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommPropertyTemplateInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommChannelCatalogRelPO;
import com.tydic.dyc.pro.dmc.po.CommChannelInfoPO;
import com.tydic.dyc.pro.dmc.po.CommChannelPoolRelPO;
import com.tydic.dyc.pro.dmc.po.CommGuideCatalogInfoPO;
import com.tydic.dyc.pro.dmc.po.CommGuideCatalogManageRelPO;
import com.tydic.dyc.pro.dmc.po.CommGuideCatalogPropertyTemplateRelPO;
import com.tydic.dyc.pro.dmc.po.CommManageCatalogInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPoolCommodityRelPO;
import com.tydic.dyc.pro.dmc.po.CommPoolInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPoolManageCatalogRelPO;
import com.tydic.dyc.pro.dmc.po.CommPropertyTemplateInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoPO;
import com.tydic.dyc.pro.dmc.repository.channel.api.DycProCommChannelRepository;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommChannelCatalogRelDTO;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommChannelGuideCatalogInfoDTO;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommChannelInfoDTO;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommChannelPoolRelDTO;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommChannelQryDTO;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommGuideCatalogManageRelDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommManageCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.pool.dto.DycProCommPoolInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycProCommChannelRepositoryImpl
extends ServiceImpl<CommChannelInfoMapper, CommChannelInfoPO>
implements DycProCommChannelRepository {
    @Autowired
    private CommChannelPoolRelMapper commChannelObjRelMapper;
    @Autowired
    private CommPoolInfoMapper commPoolInfoMapper;
    @Autowired
    private CommPoolCommodityRelMapper commPoolCommodityRelMapper;
    @Autowired
    private CommGuideCatalogInfoMapper commChannelGuideCatalogInfoMapper;
    @Autowired
    private CommChannelCatalogRelMapper commChannelCatalogMapper;
    @Autowired
    private CommGuideCatalogManageRelMapper commGuideCatalogManageRelMapper;
    @Autowired
    private CommManageCatalogInfoMapper commManageCatalogInfoMapper;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommPropertyTemplateInfoMapper commPropertyTemplateInfoMapper;
    @Autowired
    private CommGuideCatalogPropertyTemplateRelMapper commGuideCatalogPropertyTemplateRelMapper;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Autowired
    private CommPoolManageCatalogRelMapper commPoolManageCatalogRelMapper;
    @Autowired
    private CommChannelInfoMapper commChannelInfoMapper;
    @Autowired
    private NosqlClient nosqlClient;
    @Value(value="${ucc.es.index}")
    private String skuIndexName;

    @Override
    public RspPage<DycProCommChannelInfoDTO> queryChannelListPage(DycProCommChannelQryDTO qryDTO) {
        QueryWrapper<CommChannelInfoPO> queryWrapper;
        RspPage rspPage = new RspPage();
        Page pg = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        Page result = (Page)this.page((IPage)pg, (Wrapper)(queryWrapper = this.getQueryWrapper(qryDTO)));
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProCommChannelInfoDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    private QueryWrapper<CommChannelInfoPO> getQueryWrapper(DycProCommChannelQryDTO qryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!ObjectUtils.isEmpty((Object)qryDTO.getCreateTimeStart())) {
            queryWrapper.lambda().ge(CommChannelInfoPO::getCreateTime, (Object)qryDTO.getCreateTimeStart());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getCreateTimeEnd())) {
            queryWrapper.lambda().le(CommChannelInfoPO::getCreateTime, (Object)qryDTO.getCreateTimeEnd());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getUpdateTimeStart())) {
            queryWrapper.lambda().ge(CommChannelInfoPO::getUpdateTime, (Object)qryDTO.getUpdateTimeStart());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getUpdateTimeEnd())) {
            queryWrapper.lambda().le(CommChannelInfoPO::getUpdateTime, (Object)qryDTO.getUpdateTimeEnd());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getChannelId())) {
            queryWrapper.lambda().eq(CommChannelInfoPO::getChannelId, (Object)qryDTO.getChannelId());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getChannelCode())) {
            queryWrapper.lambda().like(CommChannelInfoPO::getChannelCode, (Object)qryDTO.getChannelCode());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getChannelName())) {
            queryWrapper.lambda().like(CommChannelInfoPO::getChannelName, (Object)qryDTO.getChannelName());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getCreateUserName())) {
            queryWrapper.lambda().like(CommChannelInfoPO::getCreateUserName, (Object)qryDTO.getCreateUserName());
        }
        if (!ObjectUtils.isEmpty((Object)qryDTO.getUpdateUserName())) {
            queryWrapper.lambda().like(CommChannelInfoPO::getUpdateUserName, (Object)qryDTO.getUpdateUserName());
        }
        if (!ObjectUtils.isEmpty(qryDTO.getChannelDispalyFlags())) {
            queryWrapper.lambda().in(CommChannelInfoPO::getChannelDispalyFlag, qryDTO.getChannelDispalyFlags());
        }
        queryWrapper.lambda().orderByAsc(CommChannelInfoPO::getChannelOrder);
        return queryWrapper;
    }

    @Override
    public void addChannel(DycProCommChannelInfoDTO channelDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CommChannelInfoPO::getChannelName, (Object)channelDTO.getChannelName());
        CommChannelInfoPO commChannelInfoPO = (CommChannelInfoPO)((CommChannelInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (!ObjectUtils.isEmpty((Object)commChannelInfoPO)) {
            throw new ZTBusinessException("\u9891\u9053\u540d\u79f0\u5df2\u5b58\u5728");
        }
        commChannelInfoPO = (CommChannelInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)channelDTO), CommChannelInfoPO.class);
        ((CommChannelInfoMapper)this.baseMapper).update((Object)new CommChannelInfoPO(), (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().ge(CommChannelInfoPO::getChannelOrder, (Object)channelDTO.getChannelOrder())).setSql("channel_order = channel_order + 1"));
        commChannelInfoPO.setChannelOrder(channelDTO.getChannelOrder());
        ((CommChannelInfoMapper)this.baseMapper).insert((Object)commChannelInfoPO);
    }

    @Override
    public void updateChannel(DycProCommChannelInfoDTO channelDTO) {
        CommChannelInfoPO channelInfoPOById = new CommChannelInfoPO();
        channelInfoPOById.setChannelId(channelDTO.getChannelId());
        CommChannelInfoPO channelDetailById = this.getChannelDetailByEntity(channelInfoPOById);
        if (ObjectUtils.isEmpty((Object)channelDetailById)) {
            throw new ZTBusinessException("\u9891\u9053\u4e0d\u5b58\u5728");
        }
        if (ObjectUtils.isEmpty((Object)channelDTO.getCmsTemplateId()) && !ObjectUtils.isEmpty((Object)channelDTO.getChannelName())) {
            CommChannelInfoPO channelInfoPOByChannelName = new CommChannelInfoPO();
            channelInfoPOByChannelName.setChannelName(channelDTO.getChannelName());
            CommChannelInfoPO channelDetailByEntity = this.getChannelDetailByEntity(channelInfoPOByChannelName);
            if (!ObjectUtils.isEmpty((Object)channelDetailByEntity) && !channelInfoPOById.getChannelId().equals(channelDetailByEntity.getChannelId())) {
                throw new ZTBusinessException("\u9891\u9053\u540d\u79f0\u5df2\u5b58\u5728");
            }
            if (!channelDTO.getGuideCatalogCreate().equals(channelDetailById.getGuideCatalogCreate()) || !channelDTO.getChannelRelatedType().equals(channelDetailById.getChannelRelatedType())) {
                ArrayList<DycProCommChannelPoolRelDTO> objList = new ArrayList<DycProCommChannelPoolRelDTO>();
                DycProCommChannelPoolRelDTO DycProCommChannelObjRelDTO = new DycProCommChannelPoolRelDTO();
                DycProCommChannelObjRelDTO.setChannelId(channelDTO.getChannelId());
                objList.add(DycProCommChannelObjRelDTO);
                this.deleteChannelRelatedPool(objList);
                DycProCommChannelGuideCatalogInfoDTO deleteChannelRelatedGuideCatalog = new DycProCommChannelGuideCatalogInfoDTO();
                deleteChannelRelatedGuideCatalog.setChannelId(channelDTO.getChannelId());
                this.deleteChannelRelatedGuideCatalogByChannelId(deleteChannelRelatedGuideCatalog);
                DycProCommChannelCatalogRelDTO deleteChannelRelatedCatalog = new DycProCommChannelCatalogRelDTO();
                deleteChannelRelatedCatalog.setChannelId(channelDTO.getChannelId());
                this.deleteChannelRelatedCatalog(deleteChannelRelatedCatalog);
            }
            if (channelDetailById.getChannelOrder() < channelDTO.getChannelOrder()) {
                ((CommChannelInfoMapper)this.baseMapper).update((Object)new CommChannelInfoPO(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().lt(CommChannelInfoPO::getChannelOrder, (Object)channelDTO.getChannelOrder())).ge(CommChannelInfoPO::getChannelOrder, (Object)channelDetailById.getChannelOrder())).setSql("CHANNEL_ORDER = CHANNEL_ORDER - 1"));
                channelDTO.setChannelOrder(channelDTO.getChannelOrder() - 1);
            } else if (channelDetailById.getChannelOrder() > channelDTO.getChannelOrder()) {
                ((CommChannelInfoMapper)this.baseMapper).update((Object)new CommChannelInfoPO(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().ge(CommChannelInfoPO::getChannelOrder, (Object)channelDTO.getChannelOrder())).le(CommChannelInfoPO::getChannelOrder, (Object)channelDetailById.getChannelOrder())).setSql("CHANNEL_ORDER = CHANNEL_ORDER + 1"));
            }
        }
        CommChannelInfoPO channelInfoPO = (CommChannelInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)channelDTO), CommChannelInfoPO.class);
        ((CommChannelInfoMapper)this.baseMapper).updateById((Object)channelInfoPO);
    }

    @Override
    public void updateEsChannelInfo(Long channelId, List<Long> addManageCatalogIds, List<Long> addPoolIds) {
        NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO;
        HashMap<String, String> maps;
        NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
        nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
        NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
        ArrayList<NosqlQueryBO> nosqlQueryList = new ArrayList<NosqlQueryBO>();
        NosqlQueryBO nosqlQueryBO = new NosqlQueryBO("channelList.channelId", channelId.toString(), NosqlQueryValueType.ACCURATE);
        nosqlQueryList.add(nosqlQueryBO);
        nosqlCreateBuilder.queryGroup(nosqlQueryList);
        nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlCreateBuilder.build());
        String arrayFieldName = "channelList";
        String idFieldName = "channelId";
        String idValue = channelId.toString();
        nosqlUpdateArrayFieldReqBO.setArrayFieldName(arrayFieldName);
        nosqlUpdateArrayFieldReqBO.setIdFieldName(idFieldName);
        nosqlUpdateArrayFieldReqBO.setIdValue(idValue);
        nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(true));
        this.log.debug("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65es\u5165\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
        NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO2 = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
        this.log.debug("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65es\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO2));
        if (!"0000".equals(nosqlUpdateArrayFieldRsqBO2.getRespCode())) {
            throw new ZTBusinessException("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateArrayFieldRsqBO2.getRespDesc());
        }
        if (!CollectionUtils.isEmpty(addManageCatalogIds)) {
            nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
            nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
            nosqlCreateBuilder = new NosqlCreateBuilder();
            nosqlQueryList = new ArrayList();
            nosqlQueryBO = new NosqlQueryBO("manageCatalogList.manageCatalogId", addManageCatalogIds.stream().map(Object::toString).distinct().collect(Collectors.toList()), NosqlQueryValueType.ACCURATE);
            nosqlQueryList.add(nosqlQueryBO);
            nosqlCreateBuilder.queryGroup(nosqlQueryList);
            nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlCreateBuilder.build());
            arrayFieldName = "channelList";
            idFieldName = "channelId";
            idValue = channelId.toString();
            maps = new HashMap<String, String>();
            maps.put("channelId", idValue);
            nosqlUpdateArrayFieldReqBO.setMaps(maps);
            nosqlUpdateArrayFieldReqBO.setArrayFieldName(arrayFieldName);
            nosqlUpdateArrayFieldReqBO.setIdFieldName(idFieldName);
            nosqlUpdateArrayFieldReqBO.setIdValue(idValue);
            nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
            this.log.debug("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65es\u5165\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
            nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
            this.log.debug("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65es\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
            if (!"0000".equals(nosqlUpdateArrayFieldRsqBO.getRespCode())) {
                throw new ZTBusinessException("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateArrayFieldRsqBO.getRespDesc());
            }
        }
        if (!CollectionUtils.isEmpty(addPoolIds)) {
            nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
            nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
            nosqlCreateBuilder = new NosqlCreateBuilder();
            nosqlQueryList = new ArrayList();
            nosqlQueryBO = new NosqlQueryBO("poolList.poolId", addPoolIds.stream().map(Object::toString).distinct().collect(Collectors.toList()), NosqlQueryValueType.ACCURATE);
            nosqlQueryList.add(nosqlQueryBO);
            nosqlCreateBuilder.queryGroup(nosqlQueryList);
            nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlCreateBuilder.build());
            arrayFieldName = "channelList";
            idFieldName = "channelId";
            idValue = channelId.toString();
            maps = new HashMap();
            maps.put("channelId", idValue);
            nosqlUpdateArrayFieldReqBO.setMaps(maps);
            nosqlUpdateArrayFieldReqBO.setArrayFieldName(arrayFieldName);
            nosqlUpdateArrayFieldReqBO.setIdFieldName(idFieldName);
            nosqlUpdateArrayFieldReqBO.setIdValue(idValue);
            nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
            this.log.debug("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65es\u5165\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
            nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
            this.log.debug("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65es\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
            if (!"0000".equals(nosqlUpdateArrayFieldRsqBO.getRespCode())) {
                throw new ZTBusinessException("sku\u9891\u9053\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateArrayFieldRsqBO.getRespDesc());
            }
        }
    }

    @Override
    public void checkCatalogNameExist(DycProCommChannelGuideCatalogInfoDTO channelGuideCatalogInfoDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CommGuideCatalogInfoPO::getGuideCatalogUpperId, (Object)channelGuideCatalogInfoDTO.getGuideCatalogUpperId())).eq(CommGuideCatalogInfoPO::getChannelId, (Object)channelGuideCatalogInfoDTO.getChannelId())).eq(CommGuideCatalogInfoPO::getGuideCatalogName, (Object)channelGuideCatalogInfoDTO.getGuideCatalogName())).eq(CommGuideCatalogInfoPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
        Long catalogNameCount = this.commChannelGuideCatalogInfoMapper.selectCount((Wrapper)queryWrapper);
        if (catalogNameCount > 0L) {
            throw new ZTBusinessException("\u7c7b\u76ee\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    @Override
    public void deleteChannel(DycProCommChannelInfoDTO channelDTO) {
        CommChannelInfoPO channelInfoPO = new CommChannelInfoPO();
        channelInfoPO.setChannelId(channelDTO.getChannelId());
        channelInfoPO = this.getChannelDetailByEntity(channelInfoPO);
        if (ObjectUtils.isEmpty((Object)channelInfoPO)) {
            throw new ZTBusinessException("\u9891\u9053\u4e0d\u5b58\u5728");
        }
        ((CommChannelInfoMapper)this.baseMapper).update((Object)new CommChannelInfoPO(), (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().gt(CommChannelInfoPO::getChannelOrder, (Object)channelInfoPO.getChannelOrder())).setSql("CHANNEL_ORDER = CHANNEL_ORDER - 1"));
        ((CommChannelInfoMapper)this.baseMapper).deleteById((Serializable)channelInfoPO.getChannelId());
    }

    private CommChannelInfoPO getChannelDetailByEntity(CommChannelInfoPO channelPO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntity((Object)channelPO);
        CommChannelInfoPO commChannelInfoPO = (CommChannelInfoPO)((CommChannelInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return commChannelInfoPO;
    }

    @Override
    public DycProCommChannelInfoDTO getChannelDetail(DycProCommChannelInfoDTO channelDTO) {
        CommChannelInfoPO channelInfoPO = (CommChannelInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)channelDTO), CommChannelInfoPO.class);
        channelInfoPO = this.getChannelDetailByEntity(channelInfoPO);
        return (DycProCommChannelInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)channelInfoPO), DycProCommChannelInfoDTO.class);
    }

    @Override
    public void deleteChannelRelatedPool(List<DycProCommChannelPoolRelDTO> objList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        List poolIds = objList.stream().map(DycProCommChannelPoolRelDTO::getPoolId).collect(Collectors.toList());
        Long channelId = objList.get(0).getChannelId();
        if (!CollectionUtils.isEmpty(poolIds) && !ObjectUtils.isEmpty(poolIds.get(0))) {
            queryWrapper.lambda().in(CommChannelPoolRelPO::getPoolId, poolIds);
        }
        queryWrapper.lambda().eq(CommChannelPoolRelPO::getChannelId, (Object)channelId);
        this.commChannelObjRelMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public void addChannelRelatedPool(List<DycProCommChannelPoolRelDTO> objList) {
        List CommChannelPoolRelPOS = JSON.parseArray((String)JSON.toJSONString(objList), CommChannelPoolRelPO.class);
        this.commChannelObjRelMapper.insertBatch((Collection)CommChannelPoolRelPOS);
    }

    @Override
    public RspPage<DycProCommPoolInfoDTO> queryChannelPoolListPage(DycProCommChannelQryDTO qryDTO) {
        RspPage pageRspDTO = new RspPage();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CommChannelPoolRelPO::getChannelId, (Object)qryDTO.getChannelId());
        List commChannelPoolRelPOS = this.commChannelObjRelMapper.selectList((Wrapper)queryWrapper);
        List<Object> poolIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)commChannelPoolRelPOS)) {
            poolIds = commChannelPoolRelPOS.stream().map(CommChannelPoolRelPO::getPoolId).collect(Collectors.toList());
        }
        QueryWrapper commPoolInfoPOQueryWrapper = new QueryWrapper();
        if (DycProCommConstants.ChannelRelPoolRelObjType.CHANNEL_RELATED_TYPE_NO.equals(qryDTO.getSelectType())) {
            if (null != qryDTO.getPoolEnableFlag()) {
                commPoolInfoPOQueryWrapper.lambda().eq(CommPoolInfoPO::getEnableFlag, (Object)qryDTO.getPoolEnableFlag());
            }
            if (!ObjectUtils.isEmpty((Object)qryDTO.getPoolCode())) {
                commPoolInfoPOQueryWrapper.lambda().like(CommPoolInfoPO::getPoolCode, (Object)qryDTO.getPoolCode());
            }
            if (!ObjectUtils.isEmpty((Object)qryDTO.getPoolName())) {
                commPoolInfoPOQueryWrapper.lambda().like(CommPoolInfoPO::getPoolName, (Object)qryDTO.getPoolName());
            }
            if (!CollectionUtils.isEmpty(poolIds)) {
                commPoolInfoPOQueryWrapper.lambda().notIn(CommPoolInfoPO::getPoolId, poolIds);
            }
        } else {
            if (CollectionUtils.isEmpty(poolIds)) {
                pageRspDTO.setRows(new ArrayList());
                pageRspDTO.setTotal(0);
                pageRspDTO.setPageNo(qryDTO.getPageNo().intValue());
                pageRspDTO.setRecordsTotal(0);
                return pageRspDTO;
            }
            commPoolInfoPOQueryWrapper.lambda().in(CommPoolInfoPO::getPoolId, poolIds);
            if (null != qryDTO.getPoolEnableFlag()) {
                commPoolInfoPOQueryWrapper.lambda().eq(CommPoolInfoPO::getEnableFlag, (Object)qryDTO.getPoolEnableFlag());
            }
        }
        Page pg = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        if (null != qryDTO.getDelFlag()) {
            commPoolInfoPOQueryWrapper.lambda().eq(CommPoolInfoPO::getDelFlag, (Object)qryDTO.getDelFlag());
        }
        Page result = (Page)this.commPoolInfoMapper.selectPage((IPage)pg, (Wrapper)commPoolInfoPOQueryWrapper);
        List DycProCommPoolInfoDTOS = JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProCommPoolInfoDTO.class);
        pageRspDTO.setRows(DycProCommPoolInfoDTOS);
        pageRspDTO.setPageNo((int)result.getCurrent());
        pageRspDTO.setTotal((int)result.getPages());
        pageRspDTO.setRecordsTotal((int)result.getTotal());
        return pageRspDTO;
    }

    @Override
    public void addChannelGuideCatalog(DycProCommChannelGuideCatalogInfoDTO channelGuideCatalogInfoDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CommGuideCatalogInfoPO::getGuideCatalogUpperId, (Object)channelGuideCatalogInfoDTO.getGuideCatalogUpperId())).eq(CommGuideCatalogInfoPO::getChannelId, (Object)channelGuideCatalogInfoDTO.getChannelId())).eq(CommGuideCatalogInfoPO::getGuideCatalogName, (Object)channelGuideCatalogInfoDTO.getGuideCatalogName())).eq(CommGuideCatalogInfoPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
        Long catalogNameCount = this.commChannelGuideCatalogInfoMapper.selectCount((Wrapper)queryWrapper);
        if (catalogNameCount > 0L) {
            throw new ZTBusinessException("\u7c7b\u76ee\u540d\u79f0\u5df2\u5b58\u5728");
        }
        CommGuideCatalogInfoPO guideCatalogInfoPO = (CommGuideCatalogInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)channelGuideCatalogInfoDTO), CommGuideCatalogInfoPO.class);
        this.commChannelGuideCatalogInfoMapper.insert((Object)guideCatalogInfoPO);
    }

    @Override
    public void deleteChannelRelatedGuideCatalog(DycProCommChannelGuideCatalogInfoDTO channelGuideCatalogInfoDTO) {
        CommGuideCatalogInfoPO commGuideCatalogInfoPO = (CommGuideCatalogInfoPO)this.commChannelGuideCatalogInfoMapper.selectById((Serializable)channelGuideCatalogInfoDTO.getGuideCatalogId());
        if (ObjectUtils.isEmpty((Object)commGuideCatalogInfoPO)) {
            throw new ZTBusinessException("\u5bfc\u8d2d\u7c7b\u76ee\u4e0d\u5b58\u5728");
        }
        int guideCatalogLevel = commGuideCatalogInfoPO.getGuideCatalogLevel();
        ArrayList<Long> guideCatalogIds = new ArrayList<Long>();
        guideCatalogIds.add(commGuideCatalogInfoPO.getGuideCatalogId());
        if (DycProCommConstants.GuideCatalogLevel.FIRST.equals(guideCatalogLevel)) {
            QueryWrapper queryLeve2Wrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryLeve2Wrapper.lambda().eq(CommGuideCatalogInfoPO::getGuideCatalogUpperId, (Object)commGuideCatalogInfoPO.getGuideCatalogId())).eq(CommGuideCatalogInfoPO::getDelFlag, (Object)0);
            List commGuideCatalogInfoLeve2POS = this.commChannelGuideCatalogInfoMapper.selectList((Wrapper)queryLeve2Wrapper);
            if (CollectionUtils.isEmpty((Collection)commGuideCatalogInfoLeve2POS)) {
                List guideCatalogLeve2Ids = commGuideCatalogInfoLeve2POS.stream().map(CommGuideCatalogInfoPO::getGuideCatalogId).collect(Collectors.toList());
                guideCatalogIds.addAll(guideCatalogLeve2Ids);
            }
        }
        QueryWrapper queryLeve3Wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryLeve3Wrapper.lambda().in(CommGuideCatalogInfoPO::getGuideCatalogUpperId, guideCatalogIds)).eq(CommGuideCatalogInfoPO::getDelFlag, (Object)0);
        List commGuideCatalogInfoLeve3POS = this.commChannelGuideCatalogInfoMapper.selectList((Wrapper)queryLeve3Wrapper);
        List guideCatalogLeve3Ids = commGuideCatalogInfoLeve3POS.stream().map(CommGuideCatalogInfoPO::getGuideCatalogId).collect(Collectors.toList());
        guideCatalogIds.addAll(guideCatalogLeve3Ids);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        CommGuideCatalogInfoPO updatePO = (CommGuideCatalogInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)channelGuideCatalogInfoDTO), CommGuideCatalogInfoPO.class);
        updateWrapper.lambda().set(CommGuideCatalogInfoPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_DEL);
        if (guideCatalogIds.size() == 1) {
            updateWrapper.lambda().eq(CommGuideCatalogInfoPO::getGuideCatalogId, guideCatalogIds.get(0));
        } else {
            updateWrapper.lambda().in(CommGuideCatalogInfoPO::getGuideCatalogId, guideCatalogIds);
        }
        this.commChannelGuideCatalogInfoMapper.update((Object)updatePO, (Wrapper)updateWrapper);
        QueryWrapper manageRelPODeleteWrapper = new QueryWrapper();
        manageRelPODeleteWrapper.lambda().in(CommGuideCatalogManageRelPO::getGuideCatalogId, guideCatalogIds);
        this.commGuideCatalogManageRelMapper.delete((Wrapper)manageRelPODeleteWrapper);
        List delCommGuideCatalogPropertyTemplateRelPOList = this.commGuideCatalogPropertyTemplateRelMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommGuideCatalogPropertyTemplateRelPO::getGuideCatalogId, guideCatalogIds));
        if (!CollectionUtils.isEmpty((Collection)delCommGuideCatalogPropertyTemplateRelPOList)) {
            QueryWrapper commGuideCatalogPropertyTemplateRelPOWrapper = new QueryWrapper();
            commGuideCatalogPropertyTemplateRelPOWrapper.lambda().in(CommGuideCatalogPropertyTemplateRelPO::getGuideCatalogId, guideCatalogIds);
            this.commGuideCatalogPropertyTemplateRelMapper.delete((Wrapper)commGuideCatalogPropertyTemplateRelPOWrapper);
        }
        this.commChannelGuideCatalogInfoMapper.update((Object)new CommGuideCatalogInfoPO(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(CommGuideCatalogInfoPO::getGuideCatalogUpperId, (Object)commGuideCatalogInfoPO.getGuideCatalogUpperId())).gt(CommGuideCatalogInfoPO::getGuideCatalogOrder, (Object)commGuideCatalogInfoPO.getGuideCatalogOrder())).setSql("GUIDE_CATALOG_ORDER = GUIDE_CATALOG_ORDER - 1"));
    }

    @Override
    public void deleteChannelRelatedGuideCatalogByChannelId(DycProCommChannelGuideCatalogInfoDTO channelGuideCatalogInfoDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CommGuideCatalogInfoPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
        queryWrapper.lambda().eq(CommGuideCatalogInfoPO::getChannelId, (Object)channelGuideCatalogInfoDTO.getChannelId());
        List commGuideCatalogInfoPOS = this.commChannelGuideCatalogInfoMapper.selectList((Wrapper)queryWrapper);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(CommGuideCatalogInfoPO::getChannelId, (Object)channelGuideCatalogInfoDTO.getChannelId());
        updateWrapper.lambda().eq(CommGuideCatalogInfoPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
        updateWrapper.lambda().set(CommGuideCatalogInfoPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_DEL);
        this.commChannelGuideCatalogInfoMapper.update(null, (Wrapper)updateWrapper);
        List guideCatalogIds = commGuideCatalogInfoPOS.stream().map(CommGuideCatalogInfoPO::getGuideCatalogId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(guideCatalogIds) && !ObjectUtils.isEmpty(guideCatalogIds.get(0))) {
            QueryWrapper manageRelPODeleteWrapper = new QueryWrapper();
            manageRelPODeleteWrapper.lambda().in(CommGuideCatalogManageRelPO::getGuideCatalogId, guideCatalogIds);
            this.commGuideCatalogManageRelMapper.delete((Wrapper)manageRelPODeleteWrapper);
            List delCommGuideCatalogPropertyTemplateRelPOList = this.commGuideCatalogPropertyTemplateRelMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommGuideCatalogPropertyTemplateRelPO::getGuideCatalogId, guideCatalogIds));
            if (!CollectionUtils.isEmpty((Collection)delCommGuideCatalogPropertyTemplateRelPOList)) {
                QueryWrapper commGuideCatalogPropertyTemplateRelPOWrapper = new QueryWrapper();
                commGuideCatalogPropertyTemplateRelPOWrapper.lambda().in(CommGuideCatalogPropertyTemplateRelPO::getGuideCatalogId, guideCatalogIds);
                this.commGuideCatalogPropertyTemplateRelMapper.delete((Wrapper)commGuideCatalogPropertyTemplateRelPOWrapper);
            }
        }
    }

    @Override
    public void updateChannelRelatedGuideCatalog(List<DycProCommChannelGuideCatalogInfoDTO> channelGuideCatalogInfoListDTO) {
        List commGuideCatalogInfoPOS = JSON.parseArray((String)JSON.toJSONString(channelGuideCatalogInfoListDTO), CommGuideCatalogInfoPO.class);
        this.commChannelGuideCatalogInfoMapper.updateBatchByIds((Collection)commGuideCatalogInfoPOS);
    }

    @Override
    public void deleteChannelRelatedCatalog(DycProCommChannelCatalogRelDTO channelCatalogRelDTO) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        CommChannelCatalogRelPO deletePO = (CommChannelCatalogRelPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)channelCatalogRelDTO)), CommChannelCatalogRelPO.class);
        deleteWrapper.setEntity((Object)deletePO);
        this.commChannelCatalogMapper.delete((Wrapper)deleteWrapper);
    }

    @Override
    public List<DycProCommChannelGuideCatalogInfoDTO> queryChannelRelatedGuideCatalog(DycProCommChannelGuideCatalogInfoDTO channelGuideCatalogInfoDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eq(CommGuideCatalogInfoPO::getChannelId, (Object)channelGuideCatalogInfoDTO.getChannelId());
        queryWrapper.eq(CommGuideCatalogInfoPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
        queryWrapper.eqIfPresent(CommGuideCatalogInfoPO::getGuideCatalogUpperId, (Object)channelGuideCatalogInfoDTO.getGuideCatalogUpperId());
        queryWrapper.eqIfPresent(CommGuideCatalogInfoPO::getGuideCatalogOrder, (Object)channelGuideCatalogInfoDTO.getGuideCatalogOrder());
        List commGuideCatalogInfoPOS = this.commChannelGuideCatalogInfoMapper.selectList((Wrapper)queryWrapper);
        List DycProCommChannelGuideCatalogInfoDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commGuideCatalogInfoPOS), DycProCommChannelGuideCatalogInfoDTO.class);
        return DycProCommChannelGuideCatalogInfoDTOS;
    }

    @Override
    public List<DycProCommGuideCatalogManageRelDTO> selectGuideCatalogRelatedCatalog(List<DycProCommGuideCatalogManageRelDTO> guideCatalogManageRel) {
        List guideCatalogIdS = guideCatalogManageRel.stream().map(DycProCommGuideCatalogManageRelDTO::getGuideCatalogId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(CommGuideCatalogManageRelPO::getGuideCatalogId, guideCatalogIdS);
        List commGuideCatalogManageRelPOS = this.commGuideCatalogManageRelMapper.selectList((Wrapper)queryWrapper);
        return JSON.parseArray((String)JSON.toJSONString((Object)commGuideCatalogManageRelPOS), DycProCommGuideCatalogManageRelDTO.class);
    }

    @Override
    public List<DycProCommManageCatalogDTO> queryGuideCatalogRelatedCatalog(DycProCommGuideCatalogManageRelDTO guideCatalogManageRel) {
        List allManageCatalogInfoPOS = this.commManageCatalogInfoMapper.selectList(null);
        if (CollectionUtils.isEmpty((Collection)allManageCatalogInfoPOS)) {
            return Collections.emptyList();
        }
        ArrayList<DycProCommGuideCatalogManageRelDTO> guideCatalogRelatedCatalog = new ArrayList<DycProCommGuideCatalogManageRelDTO>();
        DycProCommGuideCatalogManageRelDTO dycProCommGuideCatalogManageRelDTO = new DycProCommGuideCatalogManageRelDTO();
        dycProCommGuideCatalogManageRelDTO.setGuideCatalogId(guideCatalogManageRel.getGuideCatalogId());
        guideCatalogRelatedCatalog.add(dycProCommGuideCatalogManageRelDTO);
        List<DycProCommGuideCatalogManageRelDTO> dycProCommGuideCatalogManageRelDTOS = this.selectGuideCatalogRelatedCatalog(guideCatalogRelatedCatalog);
        List manageCatalogIdS = dycProCommGuideCatalogManageRelDTOS.stream().map(DycProCommGuideCatalogManageRelDTO::getManageCatalogId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(manageCatalogIdS)) {
            return Collections.emptyList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(CommManageCatalogInfoPO::getManageCatalogId, manageCatalogIdS);
        List filterManageCatalogInfoPO = this.commManageCatalogInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)filterManageCatalogInfoPO)) {
            return Collections.emptyList();
        }
        return this.convertList(filterManageCatalogInfoPO, allManageCatalogInfoPOS);
    }

    @Override
    public List<Long> addGuideCatalogRelManageCatalog(List<DycProCommGuideCatalogManageRelDTO> guideCatalogManageRelList) {
        List commGuideCatalogManageRelPOS = JSON.parseArray((String)JSON.toJSONString(guideCatalogManageRelList), CommGuideCatalogManageRelPO.class);
        this.commGuideCatalogManageRelMapper.insertBatch((Collection)commGuideCatalogManageRelPOS);
        List<Long> manageCatalogIds = guideCatalogManageRelList.stream().map(DycProCommGuideCatalogManageRelDTO::getManageCatalogId).collect(Collectors.toList());
        List templateInfoPOList = this.commPropertyTemplateInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommPropertyTemplateInfoPO::getManageCatalogId, manageCatalogIds));
        if (!ObjectUtils.isEmpty((Object)templateInfoPOList)) {
            List insertTemplateRelList = templateInfoPOList.stream().map(bo -> {
                CommGuideCatalogPropertyTemplateRelPO commGuideCatalogPropertyTemplateRelPO = new CommGuideCatalogPropertyTemplateRelPO();
                commGuideCatalogPropertyTemplateRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                commGuideCatalogPropertyTemplateRelPO.setPropertyTemplateId(bo.getPropertyTemplateId());
                commGuideCatalogPropertyTemplateRelPO.setGuideCatalogId(((DycProCommGuideCatalogManageRelDTO)guideCatalogManageRelList.get(0)).getGuideCatalogId());
                return commGuideCatalogPropertyTemplateRelPO;
            }).collect(Collectors.toList());
            this.commGuideCatalogPropertyTemplateRelMapper.insertBatch(insertTemplateRelList);
        }
        return manageCatalogIds;
    }

    @Override
    public void deleteGuideCatalogRelManageCatalog(List<DycProCommGuideCatalogManageRelDTO> guideCatalogManageRelList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        List manageCatalogIds = guideCatalogManageRelList.stream().map(DycProCommGuideCatalogManageRelDTO::getManageCatalogId).collect(Collectors.toList());
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CommGuideCatalogManageRelPO::getGuideCatalogId, (Object)guideCatalogManageRelList.get(0).getGuideCatalogId())).in(CommGuideCatalogManageRelPO::getManageCatalogId, manageCatalogIds);
        this.commGuideCatalogManageRelMapper.delete((Wrapper)queryWrapper);
        List templateInfoPOList = this.commPropertyTemplateInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommPropertyTemplateInfoPO::getManageCatalogId, manageCatalogIds));
        if (!ObjectUtils.isEmpty((Object)templateInfoPOList)) {
            this.commGuideCatalogPropertyTemplateRelMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CommGuideCatalogPropertyTemplateRelPO::getGuideCatalogId, (Object)guideCatalogManageRelList.get(0).getGuideCatalogId())).in(CommGuideCatalogPropertyTemplateRelPO::getPropertyTemplateId, (Collection)templateInfoPOList.stream().map(CommPropertyTemplateInfoPO::getPropertyTemplateId).collect(Collectors.toList())));
        }
    }

    @Override
    public Map<Long, Integer> queryChannelPoolCommoditNum(List<DycProCommChannelPoolRelDTO> objList) {
        List templateInfoPOList;
        List poolIds = objList.stream().map(DycProCommChannelPoolRelDTO::getPoolId).collect(Collectors.toList());
        ArrayList skuNumMap = new ArrayList();
        List agrCountMap = ((CommChannelInfoMapper)this.baseMapper).countCommodityNumByPoolIds(poolIds, DycProCommConstants.ChannelRelPoolRelObjType.CHANNEL_RELATED_TYPE_AGR);
        List supplierCountMap = ((CommChannelInfoMapper)this.baseMapper).countCommodityNumByPoolIds(poolIds, DycProCommConstants.ChannelRelPoolRelObjType.CHANNEL_RELATED_TYPE_SUPPLIER);
        List skuCountMap = ((CommChannelInfoMapper)this.baseMapper).countCommodityNumByPoolIds(poolIds, DycProCommConstants.ChannelRelPoolRelObjType.CHANNEL_RELATED_TYPE_SKU);
        List spuCountMap = ((CommChannelInfoMapper)this.baseMapper).countCommodityNumByPoolIds(poolIds, DycProCommConstants.ChannelRelPoolRelObjType.CHANNEL_RELATED_TYPE_SPU);
        if (!CollectionUtils.isEmpty((Collection)agrCountMap)) {
            skuNumMap.addAll(agrCountMap);
        }
        if (!CollectionUtils.isEmpty((Collection)supplierCountMap)) {
            skuNumMap.addAll(supplierCountMap);
        }
        if (!CollectionUtils.isEmpty((Collection)spuCountMap)) {
            skuNumMap.addAll(spuCountMap);
        }
        if (!CollectionUtils.isEmpty((Collection)skuCountMap)) {
            skuNumMap.addAll(skuCountMap);
        }
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        List commPoolManageCatalogRelPOList = this.commPoolManageCatalogRelMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommPoolManageCatalogRelPO::getPoolId, poolIds)).eq(CommPoolManageCatalogRelPO::getLastLevelFlag, (Object)DycProCommConstants.ManageCatalogLastLevelFlag.YES));
        if (!CollectionUtils.isEmpty((Collection)commPoolManageCatalogRelPOList) && !CollectionUtils.isEmpty((Collection)(templateInfoPOList = this.commPropertyTemplateInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommPropertyTemplateInfoPO::getManageCatalogId, (Collection)commPoolManageCatalogRelPOList.stream().map(CommPoolManageCatalogRelPO::getManageCatalogId).collect(Collectors.toList())))))) {
            List commSkuInfoPOList = this.commSkuInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommSkuInfoPO::getPropertyTemplateId, (Collection)templateInfoPOList.stream().map(CommPropertyTemplateInfoPO::getPropertyTemplateId).collect(Collectors.toList())));
            Map<Long, List<CommPropertyTemplateInfoPO>> catalogTemplatMap = templateInfoPOList.stream().collect(Collectors.groupingBy(CommPropertyTemplateInfoPO::getManageCatalogId));
            Map<Long, List<CommSkuInfoPO>> templatSkuMap = commSkuInfoPOList.stream().collect(Collectors.groupingBy(CommSkuInfoPO::getPropertyTemplateId));
            for (CommPoolManageCatalogRelPO commPoolManageCatalogRelPO : commPoolManageCatalogRelPOList) {
                List<CommPropertyTemplateInfoPO> flterTepmlateList = catalogTemplatMap.get(commPoolManageCatalogRelPO.getManageCatalogId());
                if (CollectionUtils.isEmpty(flterTepmlateList)) continue;
                List skuCounts = flterTepmlateList.stream().map(key -> (List)templatSkuMap.get(key.getPropertyTemplateId())).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                resultMap.put(commPoolManageCatalogRelPO.getPoolId(), resultMap.getOrDefault(commPoolManageCatalogRelPO.getPoolId(), 0) + Optional.of(skuCounts).orElseGet(Collections::emptyList).size());
            }
        }
        for (Map row : skuNumMap) {
            Long poolId = (Long)row.get("POOL_ID");
            Integer skuCount = ((Number)row.get("SKU_COUNT")).intValue();
            resultMap.put(poolId, resultMap.getOrDefault(poolId, 0) + skuCount);
        }
        return resultMap;
    }

    @Override
    public List<Long> createGuideCatalogInPool(DycProCommChannelInfoDTO channelDTO) {
        List poolIds = this.commChannelObjRelMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(CommChannelPoolRelPO::getChannelId, (Object)channelDTO.getChannelId()));
        if (CollectionUtils.isEmpty((Collection)poolIds)) {
            return new ArrayList<Long>();
        }
        List poolInfoPOS = this.commPoolInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommPoolInfoPO::getPoolId, (Collection)poolIds.stream().map(CommChannelPoolRelPO::getPoolId).collect(Collectors.toList())));
        if (CollectionUtils.isEmpty((Collection)poolInfoPOS)) {
            throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u6c60\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (CommPoolInfoPO poolInfoPO : poolInfoPOS) {
            if (Integer.valueOf(EnableFlag.STOP_USE.getCode()).equals(poolInfoPO.getEnableFlag())) {
                throw new ZTBusinessException("\u5546\u54c1\u6c60" + poolInfoPO.getPoolName() + "\u5df2\u7ecf\u505c\u7528\uff0c\u8bf7\u5148\u89e3\u9664\u5173\u8054");
            }
            if (!DycProCommConstants.DelFlag.YES.equals(poolInfoPO.getDelFlag())) continue;
            throw new ZTBusinessException("\u5546\u54c1\u6c60" + poolInfoPO.getPoolName() + "\u5df2\u7ecf\u5220\u9664\uff0c\u8bf7\u5148\u89e3\u9664\u5173\u8054");
        }
        List<DycProCommManageCatalogDTO> allManageCataLogList = this.queryAllLastLevelManageCatalog(poolIds);
        if (ObjectUtils.isEmpty(allManageCataLogList)) {
            throw new ZTBusinessException("\u65e0\u53ef\u7528\u7684\u7ba1\u7406\u7c7b\u76ee");
        }
        Map<Long, List<DycProCommManageCatalogDTO>> nodeMap = allManageCataLogList.stream().collect(Collectors.groupingBy(DycProCommManageCatalogDTO::getManageCatalogParentId));
        List<DycProCommManageCatalogDTO> managetCatalogTree = nodeMap.values().stream().flatMap(Collection::stream).filter(dto -> dto.getManageCatalogLevel() == 1).collect(Collectors.toList());
        for (DycProCommManageCatalogDTO node : managetCatalogTree) {
            this.buildManageCatalogTree(node, nodeMap);
        }
        ArrayList<CommGuideCatalogInfoPO> guideCatalogInfoPOList = new ArrayList<CommGuideCatalogInfoPO>();
        ArrayList<CommGuideCatalogManageRelPO> guideCatalogManageRelPOList = new ArrayList<CommGuideCatalogManageRelPO>();
        ArrayList<CommGuideCatalogPropertyTemplateRelPO> guideCatalogPropertyTemplateRelPOList = new ArrayList<CommGuideCatalogPropertyTemplateRelPO>();
        this.initAddSkuPoolRelData(managetCatalogTree, guideCatalogInfoPOList, guideCatalogManageRelPOList, channelDTO.getChannelId(), 0L, "0");
        if (!ObjectUtils.isEmpty(guideCatalogManageRelPOList)) {
            List manageCatalogIds = guideCatalogManageRelPOList.stream().map(CommGuideCatalogManageRelPO::getManageCatalogId).collect(Collectors.toList());
            List templateInfoPOList = this.commPropertyTemplateInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommPropertyTemplateInfoPO::getManageCatalogId, manageCatalogIds));
            if (!ObjectUtils.isEmpty((Object)templateInfoPOList)) {
                Map<Long, List<CommPropertyTemplateInfoPO>> temppalteInfoMap = templateInfoPOList.stream().collect(Collectors.groupingBy(CommPropertyTemplateInfoPO::getManageCatalogId));
                for (CommGuideCatalogManageRelPO item : guideCatalogManageRelPOList) {
                    List<CommPropertyTemplateInfoPO> fileterTempalteInfos = temppalteInfoMap.get(item.getManageCatalogId());
                    if (ObjectUtils.isEmpty(fileterTempalteInfos)) continue;
                    for (CommPropertyTemplateInfoPO item2 : fileterTempalteInfos) {
                        CommGuideCatalogPropertyTemplateRelPO commGuideCatalogPropertyTemplateRelPO = new CommGuideCatalogPropertyTemplateRelPO();
                        commGuideCatalogPropertyTemplateRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                        commGuideCatalogPropertyTemplateRelPO.setGuideCatalogId(item.getGuideCatalogId());
                        commGuideCatalogPropertyTemplateRelPO.setPropertyTemplateId(item2.getPropertyTemplateId());
                        guideCatalogPropertyTemplateRelPOList.add(commGuideCatalogPropertyTemplateRelPO);
                    }
                }
            }
        }
        for (CommGuideCatalogInfoPO item : guideCatalogInfoPOList) {
            item.setCreateUserId(channelDTO.getCreateUserId());
            item.setCreateUserName(channelDTO.getCreateUserName());
            item.setCreateOrgId(channelDTO.getCreateOrgId());
            item.setCreateOrgName(channelDTO.getCreateOrgName());
            item.setCreateCompanyId(channelDTO.getCreateCompanyId());
            item.setCreateCompanyName(channelDTO.getCreateCompanyName());
            item.setCreateOrgPath(channelDTO.getCreateOrgPath());
            item.setCreateTime(new Date());
        }
        this.commChannelGuideCatalogInfoMapper.insertBatch(guideCatalogInfoPOList);
        if (!ObjectUtils.isEmpty(guideCatalogManageRelPOList)) {
            this.commGuideCatalogManageRelMapper.insertBatch(guideCatalogManageRelPOList);
        }
        if (!ObjectUtils.isEmpty(guideCatalogPropertyTemplateRelPOList)) {
            this.commGuideCatalogPropertyTemplateRelMapper.insertBatch(guideCatalogPropertyTemplateRelPOList);
        }
        return poolIds.stream().map(CommChannelPoolRelPO::getPoolId).collect(Collectors.toList());
    }

    private void buildManageCatalogTree(DycProCommManageCatalogDTO node, Map<Long, List<DycProCommManageCatalogDTO>> nodeMap) {
        List<DycProCommManageCatalogDTO> children = nodeMap.get(node.getManageCatalogId());
        node.setChildren(children);
        if (!CollectionUtils.isEmpty(children)) {
            for (DycProCommManageCatalogDTO child : children) {
                this.buildManageCatalogTree(child, nodeMap);
            }
        }
    }

    private void initAddSkuPoolRelData(List<DycProCommManageCatalogDTO> managetCatalogTree, List<CommGuideCatalogInfoPO> guideCatalogInfoPOList, List<CommGuideCatalogManageRelPO> guideCatalogManageRelPOList, Long channelId, Long guideCatalogUpperId, String guideCatalogPath) {
        managetCatalogTree.sort(Comparator.comparing(DycProCommManageCatalogDTO::getManageCatalogOrder));
        Integer guideCatalogOrder = 1;
        for (DycProCommManageCatalogDTO item : managetCatalogTree) {
            Long guideCatalogId = Sequence.getInstance().nextId();
            CommGuideCatalogInfoPO commGuideCatalogInfoPO = new CommGuideCatalogInfoPO();
            BeanUtils.copyProperties((Object)item, (Object)commGuideCatalogInfoPO);
            commGuideCatalogInfoPO.setGuideCatalogId(guideCatalogId);
            commGuideCatalogInfoPO.setChannelId(channelId);
            commGuideCatalogInfoPO.setGuideCatalogUpperId(guideCatalogUpperId);
            DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
            encodeSerialReqBO.setCenterCode("UCC");
            encodeSerialReqBO.setEncodeRuleCode("COMM_GUIDE_CATALOG_INFO_CODE");
            encodeSerialReqBO.setNum(Long.valueOf(1L));
            DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
            commGuideCatalogInfoPO.setGuideCatalogCode((String)encode.getSerialNoList().get(0));
            commGuideCatalogInfoPO.setGuideCatalogName(item.getManageCatalogName());
            commGuideCatalogInfoPO.setGuideCatalogLevel(item.getManageCatalogLevel());
            Integer n = guideCatalogOrder;
            Integer n2 = guideCatalogOrder = Integer.valueOf(guideCatalogOrder + 1);
            commGuideCatalogInfoPO.setGuideCatalogOrder(n);
            commGuideCatalogInfoPO.setGuideCatalogPath(guideCatalogPath + "-" + guideCatalogId);
            commGuideCatalogInfoPO.setEnableFlag(Integer.valueOf(Integer.parseInt(EnableFlag.USE.getCode())));
            commGuideCatalogInfoPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
            guideCatalogInfoPOList.add(commGuideCatalogInfoPO);
            if (ObjectUtils.isEmpty(item.getChildren())) {
                if (DycProCommConstants.GuideCatalogLevel.THIRD > commGuideCatalogInfoPO.getGuideCatalogLevel()) {
                    if (DycProCommConstants.GuideCatalogLevel.FIRST.equals(commGuideCatalogInfoPO.getGuideCatalogLevel())) {
                        Long guideCatalogIdSecond = Sequence.getInstance().nextId();
                        CommGuideCatalogInfoPO commGuideCatalogInfoPOSecond = new CommGuideCatalogInfoPO();
                        BeanUtils.copyProperties((Object)commGuideCatalogInfoPO, (Object)commGuideCatalogInfoPOSecond);
                        commGuideCatalogInfoPOSecond.setGuideCatalogId(guideCatalogIdSecond);
                        commGuideCatalogInfoPOSecond.setGuideCatalogUpperId(commGuideCatalogInfoPO.getGuideCatalogId());
                        DycProEncodeSerialRspBO encodeSecond = this.encodeSerialService.getEncode(encodeSerialReqBO);
                        commGuideCatalogInfoPOSecond.setGuideCatalogCode((String)encodeSecond.getSerialNoList().get(0));
                        commGuideCatalogInfoPOSecond.setGuideCatalogLevel(DycProCommConstants.GuideCatalogLevel.SECOND);
                        commGuideCatalogInfoPOSecond.setGuideCatalogOrder(Integer.valueOf(0));
                        commGuideCatalogInfoPOSecond.setGuideCatalogPath(commGuideCatalogInfoPO.getGuideCatalogPath() + "-" + guideCatalogIdSecond);
                        guideCatalogInfoPOList.add(commGuideCatalogInfoPOSecond);
                        Long guideCatalogIdThird = Sequence.getInstance().nextId();
                        CommGuideCatalogInfoPO commGuideCatalogInfoPOThird = new CommGuideCatalogInfoPO();
                        BeanUtils.copyProperties((Object)commGuideCatalogInfoPO, (Object)commGuideCatalogInfoPOThird);
                        commGuideCatalogInfoPOThird.setGuideCatalogId(guideCatalogIdThird);
                        commGuideCatalogInfoPOThird.setGuideCatalogUpperId(commGuideCatalogInfoPOSecond.getGuideCatalogId());
                        DycProEncodeSerialRspBO encodeThird = this.encodeSerialService.getEncode(encodeSerialReqBO);
                        commGuideCatalogInfoPOThird.setGuideCatalogCode((String)encodeThird.getSerialNoList().get(0));
                        commGuideCatalogInfoPOThird.setGuideCatalogLevel(DycProCommConstants.GuideCatalogLevel.THIRD);
                        commGuideCatalogInfoPOThird.setGuideCatalogOrder(Integer.valueOf(0));
                        commGuideCatalogInfoPOThird.setGuideCatalogPath(commGuideCatalogInfoPOSecond.getGuideCatalogPath() + "-" + guideCatalogIdThird);
                        guideCatalogInfoPOList.add(commGuideCatalogInfoPOThird);
                        CommGuideCatalogManageRelPO commGuideCatalogManageRelPO = new CommGuideCatalogManageRelPO();
                        commGuideCatalogManageRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                        commGuideCatalogManageRelPO.setGuideCatalogId(guideCatalogIdThird);
                        commGuideCatalogManageRelPO.setManageCatalogId(item.getManageCatalogId());
                        guideCatalogManageRelPOList.add(commGuideCatalogManageRelPO);
                    }
                    if (!DycProCommConstants.GuideCatalogLevel.SECOND.equals(commGuideCatalogInfoPO.getGuideCatalogLevel())) continue;
                    Long guideCatalogIdThird = Sequence.getInstance().nextId();
                    CommGuideCatalogInfoPO commGuideCatalogInfoPOThird = new CommGuideCatalogInfoPO();
                    BeanUtils.copyProperties((Object)commGuideCatalogInfoPO, (Object)commGuideCatalogInfoPOThird);
                    commGuideCatalogInfoPOThird.setGuideCatalogId(guideCatalogIdThird);
                    commGuideCatalogInfoPOThird.setGuideCatalogUpperId(commGuideCatalogInfoPO.getGuideCatalogId());
                    DycProEncodeSerialRspBO encodeThird = this.encodeSerialService.getEncode(encodeSerialReqBO);
                    commGuideCatalogInfoPOThird.setGuideCatalogCode((String)encodeThird.getSerialNoList().get(0));
                    commGuideCatalogInfoPOThird.setGuideCatalogLevel(DycProCommConstants.GuideCatalogLevel.THIRD);
                    commGuideCatalogInfoPOThird.setGuideCatalogOrder(Integer.valueOf(0));
                    commGuideCatalogInfoPOThird.setGuideCatalogPath(commGuideCatalogInfoPO.getGuideCatalogPath() + "-" + guideCatalogIdThird);
                    guideCatalogInfoPOList.add(commGuideCatalogInfoPOThird);
                    CommGuideCatalogManageRelPO commGuideCatalogManageRelPO = new CommGuideCatalogManageRelPO();
                    commGuideCatalogManageRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                    commGuideCatalogManageRelPO.setGuideCatalogId(guideCatalogIdThird);
                    commGuideCatalogManageRelPO.setManageCatalogId(item.getManageCatalogId());
                    guideCatalogManageRelPOList.add(commGuideCatalogManageRelPO);
                    continue;
                }
                CommGuideCatalogManageRelPO commGuideCatalogManageRelPO = new CommGuideCatalogManageRelPO();
                commGuideCatalogManageRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                commGuideCatalogManageRelPO.setGuideCatalogId(guideCatalogId);
                commGuideCatalogManageRelPO.setManageCatalogId(item.getManageCatalogId());
                guideCatalogManageRelPOList.add(commGuideCatalogManageRelPO);
                continue;
            }
            this.initAddSkuPoolRelData(item.getChildren(), guideCatalogInfoPOList, guideCatalogManageRelPOList, channelId, guideCatalogId, commGuideCatalogInfoPO.getGuideCatalogPath());
        }
    }

    private List<DycProCommManageCatalogDTO> queryAllLastLevelManageCatalog(List<CommChannelPoolRelPO> poolIds) {
        List poolManageCatalogRelFilterPOS;
        ArrayList allLastLeveLManageCataLogList = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(CommPoolCommodityRelPO::getPoolId, (Collection)poolIds.stream().map(CommChannelPoolRelPO::getPoolId).collect(Collectors.toList()));
        List commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)commPoolCommodityRelPOS)) {
            List skuObjIds = commPoolCommodityRelPOS.stream().filter(bo -> DycProCommConstants.CommPoolCommodityRelObjType.SKU.equals(bo.getObjType())).map(CommPoolCommodityRelPO::getObjId).collect(Collectors.toList());
            List spuObjIds = commPoolCommodityRelPOS.stream().filter(bo -> DycProCommConstants.CommPoolCommodityRelObjType.SPU.equals(bo.getObjType())).map(CommPoolCommodityRelPO::getObjId).collect(Collectors.toList());
            List agrObjIds = commPoolCommodityRelPOS.stream().filter(bo -> DycProCommConstants.CommPoolCommodityRelObjType.AGR.equals(bo.getObjType())).map(CommPoolCommodityRelPO::getObjId).collect(Collectors.toList());
            List supObjIds = commPoolCommodityRelPOS.stream().filter(bo -> DycProCommConstants.CommPoolCommodityRelObjType.SUPPLIER.equals(bo.getObjType())).map(CommPoolCommodityRelPO::getObjId).collect(Collectors.toList());
            QueryWrapper skuQueryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)skuQueryWrapper.lambda().eq(CommSkuInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO)).and(wrapper -> {
                if (!ObjectUtils.isEmpty((Object)skuObjIds)) {
                    ((LambdaQueryWrapper)wrapper.or()).in(CommSkuInfoPO::getSkuId, (Collection)skuObjIds);
                }
                if (!ObjectUtils.isEmpty((Object)spuObjIds)) {
                    ((LambdaQueryWrapper)wrapper.or()).in(CommSkuInfoPO::getSpuId, (Collection)spuObjIds);
                }
                if (!ObjectUtils.isEmpty((Object)agrObjIds)) {
                    ((LambdaQueryWrapper)wrapper.or()).in(CommSkuInfoPO::getAgrId, (Collection)agrObjIds);
                }
                if (!ObjectUtils.isEmpty((Object)supObjIds)) {
                    ((LambdaQueryWrapper)wrapper.or()).in(CommSkuInfoPO::getSupplierId, (Collection)supObjIds);
                }
            });
            List commSkuInfoPOS = this.commSkuInfoMapper.selectList((Wrapper)skuQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)commSkuInfoPOS)) {
                throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0b\u6ca1\u6709\u5173\u8054\u7684\u5546\u54c1");
            }
            List propertyTemplateIds = commSkuInfoPOS.stream().map(CommSkuInfoPO::getPropertyTemplateId).collect(Collectors.toList());
            QueryWrapper templateQueryWrapper = new QueryWrapper();
            templateQueryWrapper.lambda().in(CommPropertyTemplateInfoPO::getPropertyTemplateId, propertyTemplateIds);
            List commPropertyTemplateInfoPOS = this.commPropertyTemplateInfoMapper.selectList((Wrapper)templateQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)commPropertyTemplateInfoPOS)) {
                throw new ZTBusinessException("\u5546\u54c1\u4e0b\u6ca1\u6709\u5173\u8054\u7684\u5c5e\u6027\u6a21\u7248");
            }
            List manageCatalogIds = commPropertyTemplateInfoPOS.stream().map(CommPropertyTemplateInfoPO::getManageCatalogId).collect(Collectors.toList());
            QueryWrapper manageCatalogQueryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)manageCatalogQueryWrapper.lambda().in(CommManageCatalogInfoPO::getManageCatalogId, manageCatalogIds)).eq(CommManageCatalogInfoPO::getLastLevelFlag, (Object)DycProCommConstants.ManageCatalogLastLevelFlag.YES);
            List manageCatalogInfoFilterPOS = this.commManageCatalogInfoMapper.selectList((Wrapper)manageCatalogQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)manageCatalogInfoFilterPOS) || manageCatalogInfoFilterPOS.size() != manageCatalogIds.size()) {
                throw new ZTBusinessException("\u5c5e\u6027\u6a21\u7248\u4e0b\u6ca1\u6709\u5173\u8054\u7684\u7ba1\u7406\u7c7b\u76ee");
            }
            allLastLeveLManageCataLogList.addAll(manageCatalogInfoFilterPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(poolManageCatalogRelFilterPOS = this.commPoolManageCatalogRelMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommPoolManageCatalogRelPO::getPoolId, (Collection)poolIds.stream().map(CommChannelPoolRelPO::getPoolId).collect(Collectors.toList()))).eq(CommPoolManageCatalogRelPO::getLastLevelFlag, (Object)DycProCommConstants.ManageCatalogLastLevelFlag.YES))))) {
            List secondManageCatalogIds = poolManageCatalogRelFilterPOS.stream().map(CommPoolManageCatalogRelPO::getManageCatalogId).collect(Collectors.toList());
            List secondManageCatalogInfoFilterPOS = this.commManageCatalogInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommManageCatalogInfoPO::getManageCatalogId, secondManageCatalogIds)).eq(CommManageCatalogInfoPO::getLastLevelFlag, (Object)DycProCommConstants.ManageCatalogLastLevelFlag.YES));
            if (CollectionUtils.isEmpty((Collection)secondManageCatalogInfoFilterPOS) || secondManageCatalogInfoFilterPOS.size() != secondManageCatalogIds.size()) {
                throw new ZTBusinessException("\u5c5e\u6027\u6a21\u7248\u4e0b\u6ca1\u6709\u5173\u8054\u7684\u7ba1\u7406\u7c7b\u76ee");
            }
            allLastLeveLManageCataLogList.addAll(secondManageCatalogInfoFilterPOS);
        }
        List uniqueManageIdList = allLastLeveLManageCataLogList.stream().filter(po -> !ObjectUtils.isEmpty((Object)po.getManageCatalogPath())).flatMap(po -> Arrays.stream(po.getManageCatalogPath().split("-"))).map(Long::parseLong).collect(Collectors.toList());
        List allManageCatalogInfoList = this.commManageCatalogInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommManageCatalogInfoPO::getManageCatalogId, uniqueManageIdList));
        if (CollectionUtils.isEmpty((Collection)allManageCatalogInfoList)) {
            return null;
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)allManageCatalogInfoList), DycProCommManageCatalogDTO.class);
    }

    @Override
    public List<Long> addChannelManageCatalogRel(List<DycProCommChannelCatalogRelDTO> dycProCommChannelCatalogRelDTOs) {
        DycProCommChannelCatalogRelDTO channelId = dycProCommChannelCatalogRelDTOs.get(0);
        ArrayList<CommChannelCatalogRelPO> commChannelCatalogRelPOList = new ArrayList<CommChannelCatalogRelPO>();
        ArrayList<CommGuideCatalogInfoPO> guideCatalogInfoPOList = new ArrayList<CommGuideCatalogInfoPO>();
        ArrayList<CommGuideCatalogManageRelPO> guideCatalogManageRelPOList = new ArrayList<CommGuideCatalogManageRelPO>();
        ArrayList<CommGuideCatalogPropertyTemplateRelPO> guideCatalogPropertyTemplateRelPOList = new ArrayList<CommGuideCatalogPropertyTemplateRelPO>();
        this.initAddChannelManageCatalogRelData(dycProCommChannelCatalogRelDTOs, commChannelCatalogRelPOList, guideCatalogInfoPOList, guideCatalogManageRelPOList, channelId.getChannelId(), 0L, "0");
        ArrayList<Long> manageCatalogIds = new ArrayList();
        if (!ObjectUtils.isEmpty(guideCatalogManageRelPOList)) {
            manageCatalogIds = guideCatalogManageRelPOList.stream().map(CommGuideCatalogManageRelPO::getManageCatalogId).collect(Collectors.toList());
            List templateInfoPOList = this.commPropertyTemplateInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommPropertyTemplateInfoPO::getManageCatalogId, manageCatalogIds));
            if (!ObjectUtils.isEmpty((Object)templateInfoPOList)) {
                Map<Long, List<CommPropertyTemplateInfoPO>> temppalteInfoMap = templateInfoPOList.stream().collect(Collectors.groupingBy(CommPropertyTemplateInfoPO::getManageCatalogId));
                for (CommGuideCatalogManageRelPO item : guideCatalogManageRelPOList) {
                    List<CommPropertyTemplateInfoPO> fileterTempalteInfos = temppalteInfoMap.get(item.getManageCatalogId());
                    if (ObjectUtils.isEmpty(fileterTempalteInfos)) continue;
                    for (CommPropertyTemplateInfoPO item2 : fileterTempalteInfos) {
                        CommGuideCatalogPropertyTemplateRelPO commGuideCatalogPropertyTemplateRelPO = new CommGuideCatalogPropertyTemplateRelPO();
                        commGuideCatalogPropertyTemplateRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                        commGuideCatalogPropertyTemplateRelPO.setGuideCatalogId(item.getGuideCatalogId());
                        commGuideCatalogPropertyTemplateRelPO.setPropertyTemplateId(item2.getPropertyTemplateId());
                        guideCatalogPropertyTemplateRelPOList.add(commGuideCatalogPropertyTemplateRelPO);
                    }
                }
            }
        }
        for (CommGuideCatalogInfoPO item : guideCatalogInfoPOList) {
            item.setCreateUserId(channelId.getUserId());
            item.setCreateUserName(channelId.getUserName());
            item.setCreateOrgId(channelId.getOrgId());
            item.setCreateOrgName(channelId.getOrgName());
            item.setCreateCompanyId(channelId.getCompanyId());
            item.setCreateCompanyName(channelId.getCompanyName());
            item.setCreateOrgPath(channelId.getOrgPath());
            item.setCreateTime(new Date());
        }
        this.commChannelCatalogMapper.insertBatch(commChannelCatalogRelPOList);
        this.commChannelGuideCatalogInfoMapper.insertBatch(guideCatalogInfoPOList);
        if (!ObjectUtils.isEmpty(guideCatalogManageRelPOList)) {
            this.commGuideCatalogManageRelMapper.insertBatch(guideCatalogManageRelPOList);
        }
        if (!ObjectUtils.isEmpty(guideCatalogPropertyTemplateRelPOList)) {
            this.commGuideCatalogPropertyTemplateRelMapper.insertBatch(guideCatalogPropertyTemplateRelPOList);
        }
        return manageCatalogIds;
    }

    @Override
    public List<DycProCommChannelCatalogRelDTO> getChannelRelatedCatalogList(DycProCommChannelCatalogRelDTO dycProCommChannelCatalogRelDTO) {
        List result = this.commChannelCatalogMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(CommChannelCatalogRelPO::getChannelId, (Object)dycProCommChannelCatalogRelDTO.getChannelId()));
        if (ObjectUtils.isEmpty((Object)result)) {
            return Collections.emptyList();
        }
        List relDTOList = JSON.parseArray((String)JSON.toJSONString((Object)result), DycProCommChannelCatalogRelDTO.class);
        return relDTOList;
    }

    private void initAddChannelManageCatalogRelData(List<DycProCommChannelCatalogRelDTO> dycProCommChannelCatalogRelDTOs, List<CommChannelCatalogRelPO> commChannelCatalogRelPOList, List<CommGuideCatalogInfoPO> guideCatalogInfoPOList, List<CommGuideCatalogManageRelPO> guideCatalogManageRelPOList, Long channelId, Long guideCatalogUpperId, String guideCatalogPath) {
        dycProCommChannelCatalogRelDTOs.sort(Comparator.comparing(DycProCommChannelCatalogRelDTO::getManageCatalogOrder));
        Integer guideCatalogOrder = 1;
        for (DycProCommChannelCatalogRelDTO item : dycProCommChannelCatalogRelDTOs) {
            Long guideCatalogId = Sequence.getInstance().nextId();
            CommChannelCatalogRelPO commChannelCatalogRelPO = new CommChannelCatalogRelPO();
            BeanUtils.copyProperties((Object)((Object)item), (Object)commChannelCatalogRelPO);
            commChannelCatalogRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
            commChannelCatalogRelPO.setChannelId(channelId);
            commChannelCatalogRelPOList.add(commChannelCatalogRelPO);
            CommGuideCatalogInfoPO commGuideCatalogInfoPO = new CommGuideCatalogInfoPO();
            BeanUtils.copyProperties((Object)((Object)item), (Object)commGuideCatalogInfoPO);
            commGuideCatalogInfoPO.setGuideCatalogId(guideCatalogId);
            commGuideCatalogInfoPO.setChannelId(channelId);
            commGuideCatalogInfoPO.setGuideCatalogUpperId(guideCatalogUpperId);
            DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
            encodeSerialReqBO.setCenterCode("UCC");
            encodeSerialReqBO.setEncodeRuleCode("COMM_GUIDE_CATALOG_INFO_CODE");
            encodeSerialReqBO.setNum(Long.valueOf(1L));
            DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
            commGuideCatalogInfoPO.setGuideCatalogCode((String)encode.getSerialNoList().get(0));
            commGuideCatalogInfoPO.setGuideCatalogName(item.getManageCatalogName());
            commGuideCatalogInfoPO.setGuideCatalogLevel(item.getManageCatalogLevel());
            Integer n = guideCatalogOrder;
            Integer n2 = guideCatalogOrder = Integer.valueOf(guideCatalogOrder + 1);
            commGuideCatalogInfoPO.setGuideCatalogOrder(n);
            commGuideCatalogInfoPO.setGuideCatalogPath(guideCatalogPath + "-" + guideCatalogId);
            commGuideCatalogInfoPO.setEnableFlag(Integer.valueOf(Integer.parseInt(EnableFlag.USE.getCode())));
            commGuideCatalogInfoPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
            guideCatalogInfoPOList.add(commGuideCatalogInfoPO);
            if (ObjectUtils.isEmpty(item.getChildren())) {
                if (DycProCommConstants.GuideCatalogLevel.THIRD > commGuideCatalogInfoPO.getGuideCatalogLevel()) {
                    if (DycProCommConstants.GuideCatalogLevel.FIRST.equals(commGuideCatalogInfoPO.getGuideCatalogLevel())) {
                        Long guideCatalogIdSecond = Sequence.getInstance().nextId();
                        CommGuideCatalogInfoPO commGuideCatalogInfoPOSecond = new CommGuideCatalogInfoPO();
                        BeanUtils.copyProperties((Object)commGuideCatalogInfoPO, (Object)commGuideCatalogInfoPOSecond);
                        commGuideCatalogInfoPOSecond.setGuideCatalogId(guideCatalogIdSecond);
                        commGuideCatalogInfoPOSecond.setGuideCatalogUpperId(commGuideCatalogInfoPO.getGuideCatalogId());
                        DycProEncodeSerialRspBO encodeSecond = this.encodeSerialService.getEncode(encodeSerialReqBO);
                        commGuideCatalogInfoPOSecond.setGuideCatalogCode((String)encodeSecond.getSerialNoList().get(0));
                        commGuideCatalogInfoPOSecond.setGuideCatalogLevel(DycProCommConstants.GuideCatalogLevel.SECOND);
                        commGuideCatalogInfoPOSecond.setGuideCatalogOrder(Integer.valueOf(0));
                        commGuideCatalogInfoPOSecond.setGuideCatalogPath(commGuideCatalogInfoPO.getGuideCatalogPath() + "-" + guideCatalogIdSecond);
                        guideCatalogInfoPOList.add(commGuideCatalogInfoPOSecond);
                        Long guideCatalogIdThird = Sequence.getInstance().nextId();
                        CommGuideCatalogInfoPO commGuideCatalogInfoPOThird = new CommGuideCatalogInfoPO();
                        BeanUtils.copyProperties((Object)commGuideCatalogInfoPO, (Object)commGuideCatalogInfoPOThird);
                        commGuideCatalogInfoPOThird.setGuideCatalogId(guideCatalogIdThird);
                        commGuideCatalogInfoPOThird.setGuideCatalogUpperId(commGuideCatalogInfoPOSecond.getGuideCatalogId());
                        DycProEncodeSerialRspBO encodeThird = this.encodeSerialService.getEncode(encodeSerialReqBO);
                        commGuideCatalogInfoPOThird.setGuideCatalogCode((String)encodeThird.getSerialNoList().get(0));
                        commGuideCatalogInfoPOThird.setGuideCatalogLevel(DycProCommConstants.GuideCatalogLevel.THIRD);
                        commGuideCatalogInfoPOThird.setGuideCatalogOrder(Integer.valueOf(0));
                        commGuideCatalogInfoPOThird.setGuideCatalogPath(commGuideCatalogInfoPOSecond.getGuideCatalogPath() + "-" + guideCatalogIdThird);
                        guideCatalogInfoPOList.add(commGuideCatalogInfoPOThird);
                        CommGuideCatalogManageRelPO commGuideCatalogManageRelPO = new CommGuideCatalogManageRelPO();
                        commGuideCatalogManageRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                        commGuideCatalogManageRelPO.setGuideCatalogId(guideCatalogIdThird);
                        commGuideCatalogManageRelPO.setManageCatalogId(item.getManageCatalogId());
                        guideCatalogManageRelPOList.add(commGuideCatalogManageRelPO);
                    }
                    if (!DycProCommConstants.GuideCatalogLevel.SECOND.equals(commGuideCatalogInfoPO.getGuideCatalogLevel())) continue;
                    Long guideCatalogIdThird = Sequence.getInstance().nextId();
                    CommGuideCatalogInfoPO commGuideCatalogInfoPOThird = new CommGuideCatalogInfoPO();
                    BeanUtils.copyProperties((Object)commGuideCatalogInfoPO, (Object)commGuideCatalogInfoPOThird);
                    commGuideCatalogInfoPOThird.setGuideCatalogId(guideCatalogIdThird);
                    commGuideCatalogInfoPOThird.setGuideCatalogUpperId(commGuideCatalogInfoPO.getGuideCatalogId());
                    DycProEncodeSerialRspBO encodeThird = this.encodeSerialService.getEncode(encodeSerialReqBO);
                    commGuideCatalogInfoPOThird.setGuideCatalogCode((String)encodeThird.getSerialNoList().get(0));
                    commGuideCatalogInfoPOThird.setGuideCatalogLevel(DycProCommConstants.GuideCatalogLevel.THIRD);
                    commGuideCatalogInfoPOThird.setGuideCatalogOrder(Integer.valueOf(0));
                    commGuideCatalogInfoPOThird.setGuideCatalogPath(commGuideCatalogInfoPO.getGuideCatalogPath() + "-" + guideCatalogIdThird);
                    guideCatalogInfoPOList.add(commGuideCatalogInfoPOThird);
                    CommGuideCatalogManageRelPO commGuideCatalogManageRelPO = new CommGuideCatalogManageRelPO();
                    commGuideCatalogManageRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                    commGuideCatalogManageRelPO.setGuideCatalogId(guideCatalogIdThird);
                    commGuideCatalogManageRelPO.setManageCatalogId(item.getManageCatalogId());
                    guideCatalogManageRelPOList.add(commGuideCatalogManageRelPO);
                    continue;
                }
                CommGuideCatalogManageRelPO commGuideCatalogManageRelPO = new CommGuideCatalogManageRelPO();
                commGuideCatalogManageRelPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                commGuideCatalogManageRelPO.setGuideCatalogId(guideCatalogId);
                commGuideCatalogManageRelPO.setManageCatalogId(item.getManageCatalogId());
                guideCatalogManageRelPOList.add(commGuideCatalogManageRelPO);
                continue;
            }
            this.initAddChannelManageCatalogRelData(item.getChildren(), commChannelCatalogRelPOList, guideCatalogInfoPOList, guideCatalogManageRelPOList, channelId, guideCatalogId, commGuideCatalogInfoPO.getGuideCatalogPath());
        }
    }

    private void checkAndAddParentCategories(CommManageCatalogInfoPO commManageCatalogInfoPO, Map<Long, CommManageCatalogInfoPO> parentMap, Map<Long, CommManageCatalogInfoPO> manageCatalogInfoMap) {
        CommManageCatalogInfoPO parentCatalog;
        Long currentParentId = commManageCatalogInfoPO.getManageCatalogParentId();
        while (currentParentId != null && currentParentId != 0L && ObjectUtils.isEmpty((Object)parentMap.get(currentParentId)) && (parentCatalog = manageCatalogInfoMap.get(currentParentId)) != null) {
            parentMap.put(currentParentId, parentCatalog);
            currentParentId = parentCatalog.getManageCatalogParentId();
        }
    }

    private List<DycProCommManageCatalogDTO> convertList(List<CommManageCatalogInfoPO> filterList, List<CommManageCatalogInfoPO> queryAllCatalog) {
        ArrayList<DycProCommManageCatalogDTO> rows = new ArrayList<DycProCommManageCatalogDTO>();
        Map<Long, CommManageCatalogInfoPO> catalogMap = queryAllCatalog.stream().collect(Collectors.toMap(CommManageCatalogInfoPO::getManageCatalogId, catalog -> catalog));
        for (CommManageCatalogInfoPO catalogPO : filterList) {
            CommManageCatalogInfoPO parentCatalog;
            DycProCommManageCatalogDTO uccChannelCatalogRelQryDO = new DycProCommManageCatalogDTO();
            uccChannelCatalogRelQryDO.setManageCatalogId(catalogPO.getManageCatalogId());
            uccChannelCatalogRelQryDO.setManageCatalogCode(catalogPO.getManageCatalogCode());
            StringBuilder catalogNameBuilder = new StringBuilder(catalogPO.getManageCatalogName());
            Long currentParentId = catalogPO.getManageCatalogParentId();
            for (int currentLevel = catalogPO.getManageCatalogLevel().intValue(); currentParentId != null && currentLevel > 0 && (parentCatalog = catalogMap.get(currentParentId)) != null; --currentLevel) {
                catalogNameBuilder.insert(0, parentCatalog.getManageCatalogName() + "/");
                currentParentId = parentCatalog.getManageCatalogParentId();
            }
            uccChannelCatalogRelQryDO.setManageCatalogName(catalogNameBuilder.toString());
            uccChannelCatalogRelQryDO.setManageCatalogLevel(catalogPO.getManageCatalogLevel());
            uccChannelCatalogRelQryDO.setManageCatalogParentId(catalogPO.getManageCatalogParentId());
            rows.add(uccChannelCatalogRelQryDO);
        }
        return rows;
    }
}

