/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.checkrule.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlMapBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckResultEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleStatusEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuInfoExamineStatus;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.AgrCooperationCatalogMapper;
import com.tydic.dyc.pro.dmc.dao.AgrMainMapper;
import com.tydic.dyc.pro.dmc.dao.CommBansRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommCheckObjCheckRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommCheckRecordItemMapper;
import com.tydic.dyc.pro.dmc.dao.CommCheckRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommCheckRuleInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommCheckRuleItemInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommManageCatalogInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPropertyTemplateInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPriceChngRecordMapper;
import com.tydic.dyc.pro.dmc.po.AgrCooperationCatalogPO;
import com.tydic.dyc.pro.dmc.po.AgrMainPO;
import com.tydic.dyc.pro.dmc.po.CommBansRecordPO;
import com.tydic.dyc.pro.dmc.po.CommCheckObjCheckRecordPO;
import com.tydic.dyc.pro.dmc.po.CommCheckRecordItemPO;
import com.tydic.dyc.pro.dmc.po.CommCheckRecordPO;
import com.tydic.dyc.pro.dmc.po.CommCheckRuleAndSkuRangePO;
import com.tydic.dyc.pro.dmc.po.CommCheckRuleInfoPO;
import com.tydic.dyc.pro.dmc.po.CommCheckRuleItemInfoPO;
import com.tydic.dyc.pro.dmc.po.CommManageCatalogInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPropertyTemplateInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuPriceChngRecordPO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRecordRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckObjCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordItemDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommExecCheckRuleDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommPriceCheckRuleParamQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommPriceCheckRuleVerifyValueDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycProCommCheckRecordRepositoryImpl
implements DycProCommCheckRecordRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProCommCheckRecordRepositoryImpl.class);
    @Value(value="${comm.checkrule.topic}")
    private String commCheckRuleTopic;
    @Value(value="${comm.checkrule.tag}")
    private String commCheckRuleTag;
    @Resource(name="dycProCmmCheckRuleMqServiceProvider")
    private ProxyMessageProducer dycProCmmCheckRuleMqServiceProvider;
    @Autowired
    private CommCheckObjCheckRecordMapper commCheckObjCheckRecordMapper;
    @Autowired
    private CommCheckRecordItemMapper commCheckRecordItemMapper;
    @Autowired
    private CommCheckRecordMapper commCheckRecordMapper;
    @Autowired
    private CommCheckRuleInfoMapper commCheckRuleInfoMapper;
    @Autowired
    private CommCheckRuleItemInfoMapper commCheckRuleItemInfoMapper;
    @Autowired
    private CommBansRecordMapper commBansRecordMapper;
    @Value(value="${ucc.es.index}")
    private String skuIndexName;
    @Autowired
    private NosqlClient nosqlClient;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommManageCatalogInfoMapper commManageCatalogInfoMapper;
    @Autowired
    private CommPropertyTemplateInfoMapper commPropertyTemplateInfoMapper;
    @Autowired
    private AgrCooperationCatalogMapper agrCooperationCatalogMapper;
    @Autowired
    private AgrMainMapper agrMainMapper;
    @Autowired
    private CommSkuPriceChngRecordMapper commSkuPriceChngRecordMapper;

    @Override
    public RspPage<DycProCommCheckObjCheckRecordDTO> selectCheckObjCheckRecordListPage(DycProCommCheckRecordQryDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getCheckExtObjCode, qryDTO.getCheckExtObjCode());
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getCheckObjCode, qryDTO.getCheckObjCode());
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getCheckObjName, qryDTO.getCheckObjName());
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getVerificationIndexNameList, qryDTO.getVerificationIndexName());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getSupplierId, (Object)qryDTO.getSupplierId());
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getSupplierName, qryDTO.getSupplierName());
        if (StringUtils.hasText((String)qryDTO.getManageCatalogPath())) {
            queryWrapper.likeRight(CommCheckObjCheckRecordPO::getManageCatalogPath, (Object)qryDTO.getManageCatalogPath());
        }
        queryWrapper.betweenIfPresent(CommCheckObjCheckRecordPO::getCreateTime, (Object)qryDTO.getCreateTimeStart(), (Object)qryDTO.getCreateTimeEnd());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCheckObjType, (Object)qryDTO.getCheckObjType());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCheckRuleType, (Object)qryDTO.getCheckRuleType());
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getCheckResultNameList, qryDTO.getCheckResultStr());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCheckStatus, (Object)qryDTO.getCheckStatus());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getClearExceptionFlag, (Object)qryDTO.getClearExceptionFlag());
        queryWrapper.inIfPresent(CommCheckObjCheckRecordPO::getCheckStatus, qryDTO.getCheckStatusList());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCheckSceneCode, (Object)qryDTO.getCheckSceneCode());
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getCreateUserAccount, qryDTO.getCreateUserAccount());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCheckSnId, (Object)qryDTO.getCheckSnId());
        queryWrapper.betweenIfPresent(CommCheckObjCheckRecordPO::getExceptionCount, (Object)qryDTO.getExceptionCountStart(), (Object)qryDTO.getExceptionCountEnd());
        queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getCheckExecActionNameList, qryDTO.getCheckExecActionName());
        if (qryDTO.getRiskType() != null) {
            queryWrapper.likeIfPresent(CommCheckObjCheckRecordPO::getRiskTypeCode, qryDTO.getRiskType());
        }
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getIsLastFlag, (Object)qryDTO.getIsLastFlag());
        queryWrapper.orderByDesc(CommCheckObjCheckRecordPO::getCreateTime);
        queryWrapper.betweenIfPresent(CommCheckObjCheckRecordPO::getAuditTime, (Object)qryDTO.getAuditTimeStart(), (Object)qryDTO.getAuditTimeEnd());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getPersonAuditCheckResult, (Object)qryDTO.getPersonAuditCheckResult());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCreateUserId, (Object)qryDTO.getCreateUserId());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCreateOrgId, (Object)qryDTO.getCreateOrgId());
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCreateCompanyId, (Object)qryDTO.getCreateCompanyId());
        queryWrapper.inIfPresent(CommCheckObjCheckRecordPO::getPersonAuditCheckResult, qryDTO.getPersonAuditCheckResults());
        Page pageResult = (Page)this.commCheckObjCheckRecordMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pageResult.getRecords()), DycProCommCheckObjCheckRecordDTO.class));
        }
        rspPage.setPageNo((int)pageResult.getCurrent());
        rspPage.setTotal((int)pageResult.getPages());
        rspPage.setRecordsTotal((int)pageResult.getTotal());
        return rspPage;
    }

    @Override
    public void updateCheckRecordById(DycProCommCheckRecordDTO dycProCommCheckRecordDTO) {
        CommCheckRecordPO updatePo = (CommCheckRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRecordDTO), CommCheckRecordPO.class);
        this.commCheckRecordMapper.updateById((Object)updatePo);
    }

    @Override
    public void deleteCheckRecordItemAndAdd(List<DycProCommCheckRecordItemDTO> dycProCommCheckRecordItemDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eq(CommCheckRecordItemPO::getCheckRecordId, (Object)dycProCommCheckRecordItemDTO.get(0).getCheckRecordId());
        List commCheckRecordItemPO1 = this.commCheckRecordItemMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)commCheckRecordItemPO1)) {
            List itemIds = commCheckRecordItemPO1.stream().map(CommCheckRecordItemPO::getItemId).collect(Collectors.toList());
            LambdaQueryWrapperX deleteWrapper = new LambdaQueryWrapperX();
            deleteWrapper.in(CommCheckRecordItemPO::getItemId, itemIds);
            this.commCheckRecordItemMapper.delete((Wrapper)deleteWrapper);
        }
        List pos = JSONArray.parseArray((String)JSON.toJSONString(dycProCommCheckRecordItemDTO), CommCheckRecordItemPO.class);
        pos.forEach(commCheckRecordItemPO -> commCheckRecordItemPO.setPersonAuditCheckResult(commCheckRecordItemPO.getCheckResult()));
        this.commCheckRecordItemMapper.insertBatch((Collection)pos);
    }

    @Override
    public void updateCheckObjCheckRecordCheckRuleNum(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.setSql("CHECK_RULE_NUM=CHECK_RULE_NUM+1");
        updateWrapper.eq(CommCheckObjCheckRecordPO::getCheckSnId, (Object)checkObjCheckRecordDTO.getCheckSnId());
        this.commCheckObjCheckRecordMapper.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public DycProCommCheckObjCheckRecordDTO selectObjCheckRecord(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eqIfPresent(CommCheckObjCheckRecordPO::getCheckSnId, (Object)checkObjCheckRecordDTO.getCheckSnId());
        CommCheckObjCheckRecordPO resultPo = (CommCheckObjCheckRecordPO)this.commCheckObjCheckRecordMapper.selectOne((Wrapper)queryWrapper);
        return (DycProCommCheckObjCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)resultPo), DycProCommCheckObjCheckRecordDTO.class);
    }

    @Override
    public List<DycProCommCheckRecordDTO> queryCheckRecordInfoListByCondition(DycProCommCheckRecordQryDTO recordQryDTO) {
        List commCheckRecordPOS = this.commCheckRecordMapper.selectList((Wrapper)new LambdaQueryWrapperX().eqIfPresent(CommCheckRecordPO::getCheckObjId, (Object)recordQryDTO.getCheckObjId()).eqIfPresent(CommCheckRecordPO::getCheckObjType, (Object)recordQryDTO.getCheckObjType()).eqIfPresent(CommCheckRecordPO::getCheckSnId, (Object)recordQryDTO.getCheckSnId()).eqIfPresent(CommCheckRecordPO::getIsLastFlag, (Object)recordQryDTO.getIsLastFlag()).inIfPresent(CommCheckRecordPO::getCheckRecordId, recordQryDTO.getCheckRecordIdList()));
        if (CollectionUtils.isEmpty((Collection)commCheckRecordPOS)) {
            return new ArrayList<DycProCommCheckRecordDTO>();
        }
        List dycProCommCheckRecordDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commCheckRecordPOS), DycProCommCheckRecordDTO.class);
        List commCheckRecordItemPOS = this.commCheckRecordItemMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommCheckRecordItemPO::getCheckRecordId, (Collection)commCheckRecordPOS.stream().map(CommCheckRecordPO::getCheckRecordId).collect(Collectors.toList())).orderByDesc(CommCheckRecordItemPO::getCreateTime));
        if (!CollectionUtils.isEmpty((Collection)commCheckRecordItemPOS)) {
            Map<Long, List<CommCheckRecordItemPO>> itemMap = commCheckRecordItemPOS.stream().collect(Collectors.groupingBy(CommCheckRecordItemPO::getCheckRecordId));
            for (DycProCommCheckRecordDTO dycProCommCheckRecordDTO : dycProCommCheckRecordDTOS) {
                if (!itemMap.containsKey(dycProCommCheckRecordDTO.getCheckRecordId())) continue;
                dycProCommCheckRecordDTO.setCheckRecordItemDTOList(JSON.parseArray((String)JSON.toJSONString(itemMap.get(dycProCommCheckRecordDTO.getCheckRecordId())), DycProCommCheckRecordItemDTO.class));
            }
        }
        return dycProCommCheckRecordDTOS;
    }

    @Override
    public int updateCheckObjCheckRecordExceptionNum(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        CommCheckObjCheckRecordPO commCheckObjCheckRecordPO = (CommCheckObjCheckRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)checkObjCheckRecordDTO), CommCheckObjCheckRecordPO.class);
        commCheckObjCheckRecordPO.setUpdateTime(new Date());
        LambdaQueryWrapperX updateWrapper = new LambdaQueryWrapperX();
        updateWrapper.eq(CommCheckObjCheckRecordPO::getCheckSnId, (Object)checkObjCheckRecordDTO.getCheckSnId());
        updateWrapper.eq(CommCheckObjCheckRecordPO::getCheckStatus, (Object)DycProCommConstants.checkRuleCheckStatus.CHECKIING);
        int count = this.commCheckObjCheckRecordMapper.update((Object)commCheckObjCheckRecordPO, (Wrapper)updateWrapper);
        if (count > 0) {
            LambdaUpdateWrapper updateWrapper1 = new LambdaUpdateWrapper();
            updateWrapper1.setSql("EXCEPTION_COUNT=EXCEPTION_COUNT+1");
            updateWrapper1.eq(CommCheckObjCheckRecordPO::getCheckObjId, (Object)checkObjCheckRecordDTO.getCheckObjId());
            updateWrapper1.eq(CommCheckObjCheckRecordPO::getCheckRuleType, (Object)checkObjCheckRecordDTO.getCheckRuleType());
            updateWrapper1.ne(CommCheckObjCheckRecordPO::getCheckSnId, (Object)checkObjCheckRecordDTO.getCheckSnId());
            updateWrapper1.eq(CommCheckObjCheckRecordPO::getIsLastFlag, (Object)DycProCommConstants.YesOrNo.YES);
            updateWrapper1.eq(CommCheckObjCheckRecordPO::getCheckStatus, (Object)DycProCommConstants.checkRuleCheckStatus.CHECKIING);
            this.commCheckObjCheckRecordMapper.update(null, (Wrapper)updateWrapper1);
            LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
            updateWrapper2.ne(CommCheckObjCheckRecordPO::getCheckSnId, (Object)checkObjCheckRecordDTO.getCheckSnId());
            updateWrapper2.eq(CommCheckObjCheckRecordPO::getIsLastFlag, (Object)DycProCommConstants.YesOrNo.YES);
            updateWrapper2.eq(CommCheckObjCheckRecordPO::getCheckStatus, (Object)DycProCommConstants.checkRuleCheckStatus.FINISH);
            updateWrapper2.eq(CommCheckObjCheckRecordPO::getCheckRuleType, (Object)checkObjCheckRecordDTO.getCheckRuleType());
            updateWrapper2.eq(CommCheckObjCheckRecordPO::getCheckObjId, (Object)checkObjCheckRecordDTO.getCheckObjId());
            CommCheckObjCheckRecordPO set = new CommCheckObjCheckRecordPO();
            set.setIsLastFlag(DycProCommConstants.YesOrNo.NO);
            this.commCheckObjCheckRecordMapper.update((Object)set, (Wrapper)updateWrapper2);
        }
        return count;
    }

    @Override
    public int deleteCheckObjCheckRecordById(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        return this.commCheckObjCheckRecordMapper.deleteById((Serializable)checkObjCheckRecordDTO.getCheckSnId());
    }

    @Override
    public void updateCheckObjCheckRecordExceptionFlag(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(CommCheckObjCheckRecordPO::getCheckSnId, checkObjCheckRecordDTO.getCheckSnIds());
        CommCheckObjCheckRecordPO setPo = new CommCheckObjCheckRecordPO();
        setPo.setClearExceptionFlag(DycProCommConstants.YesOrNo.YES);
        setPo.setIsLastFlag(DycProCommConstants.YesOrNo.YES);
        this.commCheckObjCheckRecordMapper.update((Object)setPo, (Wrapper)updateWrapper);
    }

    @Override
    public List<DycProCommCheckRecordDTO> queryCheckRecordInfoList(DycProCommCheckRecordQryDTO recordQryDTO) {
        List commCheckRecordPOS = this.commCheckRecordMapper.selectList((Wrapper)new LambdaQueryWrapperX().eqIfPresent(CommCheckRecordPO::getCheckObjId, (Object)recordQryDTO.getCheckObjId()).eqIfPresent(CommCheckRecordPO::getCheckObjType, (Object)recordQryDTO.getCheckObjType()).eqIfPresent(CommCheckRecordPO::getCheckSnId, (Object)recordQryDTO.getCheckSnId()).eqIfPresent(CommCheckRecordPO::getIsLastFlag, (Object)recordQryDTO.getIsLastFlag()).inIfPresent(CommCheckRecordPO::getCheckRecordId, recordQryDTO.getCheckRecordIdList()));
        return JSON.parseArray((String)JSON.toJSONString((Object)commCheckRecordPOS), DycProCommCheckRecordDTO.class);
    }

    @Override
    public Boolean execCheckRule(DycProCommExecCheckRuleDTO dycProCommExecCheckRuleDTO) {
        return true;
    }

    @Override
    public List<DycProCommCheckRecordDTO> execCheckRuleForConsumer(DycProCommExecCheckRuleDTO dycProCommExecCheckRuleDTO) {
        Integer checkRuleType = dycProCommExecCheckRuleDTO.getCheckRuleType();
        CommSkuInfoPO commSkuInfoPO = (CommSkuInfoPO)this.commSkuInfoMapper.selectById((Serializable)dycProCommExecCheckRuleDTO.getCheckObjId());
        ArrayList<DycProCommCheckRecordDTO> checkRecordDTOList = new ArrayList<DycProCommCheckRecordDTO>();
        CommPropertyTemplateInfoPO commPropertyTemplateInfoPO = (CommPropertyTemplateInfoPO)this.commPropertyTemplateInfoMapper.selectById((Serializable)commSkuInfoPO.getPropertyTemplateId());
        CommManageCatalogInfoPO commManageCatalogInfoPO = (CommManageCatalogInfoPO)this.commManageCatalogInfoMapper.selectById((Serializable)commPropertyTemplateInfoPO.getManageCatalogId());
        DycProCommCheckRuleInfoQryDTO ruleInfoQryDTO = new DycProCommCheckRuleInfoQryDTO();
        ruleInfoQryDTO.setCheckSceneCode(dycProCommExecCheckRuleDTO.getCheckSceneCode());
        ruleInfoQryDTO.setCheckObjType(dycProCommExecCheckRuleDTO.getCheckObjType());
        ruleInfoQryDTO.setCheckRuleType(checkRuleType);
        ruleInfoQryDTO.setSupplierId(commSkuInfoPO.getSupplierId());
        ruleInfoQryDTO.setCatalogId(commManageCatalogInfoPO.getManageCatalogId());
        List<DycProCommCheckRuleInfoDTO> checkRuleInfoDTOs = this.querySkuEffectCheckRule(ruleInfoQryDTO);
        if (!CollectionUtils.isEmpty(checkRuleInfoDTOs)) {
            List<Long> checkRuleIds = checkRuleInfoDTOs.stream().map(DycProCommCheckRuleInfoDTO::getCheckRuleId).collect(Collectors.toList());
            DycProCommCheckObjCheckRecordDTO objCheckRecordDTO = this.buildObjCheckRecordDTO(commSkuInfoPO, commManageCatalogInfoPO, dycProCommExecCheckRuleDTO);
            objCheckRecordDTO.setCheckRuleType(checkRuleType);
            objCheckRecordDTO.setCheckStatus(DycProCommConstants.checkRuleCheckStatus.CHECKIING);
            objCheckRecordDTO.setCheckRecordDTOList(checkRecordDTOList);
            objCheckRecordDTO.setCheckSnIds(dycProCommExecCheckRuleDTO.getCheckSnIds());
            for (DycProCommCheckRuleInfoDTO checkRuleInfoDTO : checkRuleInfoDTOs) {
                DycProCommCheckRecordDTO dycProCommCheckRecordDTO = (DycProCommCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)checkRuleInfoDTO), DycProCommCheckRecordDTO.class);
                BeanUtils.copyProperties((Object)objCheckRecordDTO, (Object)dycProCommCheckRecordDTO);
                dycProCommCheckRecordDTO.setCheckStatus(DycProCommConstants.checkRuleCheckStatus.CHECKIING);
                dycProCommCheckRecordDTO.setCheckResult(null);
                dycProCommCheckRecordDTO.setCheckRuleIds(checkRuleIds);
                checkRecordDTOList.add(dycProCommCheckRecordDTO);
                ArrayList<DycProCommCheckRecordItemDTO> checkRecordItemDTOs = new ArrayList<DycProCommCheckRecordItemDTO>();
                dycProCommCheckRecordDTO.setCheckRecordItemDTOList(checkRecordItemDTOs);
                if (checkRuleInfoDTO.getCheckRuleItemInfoDTOList() != null) {
                    checkRuleInfoDTO.getCheckRuleItemInfoDTOList().forEach(dycProCommCheckRuleItemInfoDTO -> {
                        DycProCommCheckRecordItemDTO checkRecordItemDTO = (DycProCommCheckRecordItemDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleItemInfoDTO), DycProCommCheckRecordItemDTO.class);
                        checkRecordItemDTO.setCheckResult(null);
                        checkRecordItemDTO.setCheckRuleName(checkRuleInfoDTO.getCheckRuleName());
                        checkRecordItemDTOs.add(checkRecordItemDTO);
                    });
                }
                if (!checkRuleType.equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode()))) continue;
                break;
            }
            this.addCheckObjCheckRecord(objCheckRecordDTO);
            this.updateSkuMainInfoAndSyncNosql(commSkuInfoPO.getSkuId());
        } else {
            this.updateBansRecordBatchAndSyncNosql(commSkuInfoPO.getSkuId(), checkRuleType);
        }
        return checkRecordDTOList;
    }

    @Override
    public DycProCommPriceCheckRuleVerifyValueDTO queryAgrDiscountRate(DycProCommPriceCheckRuleParamQryDTO qryDTO) {
        LambdaQueryWrapper queryAgrWrapper = new LambdaQueryWrapper();
        queryAgrWrapper.eq(AgrMainPO::getAgrId, (Object)qryDTO.getAgrId());
        queryAgrWrapper.ne(AgrMainPO::getAgrStatus, (Object)99);
        AgrMainPO resultPo = (AgrMainPO)this.agrMainMapper.selectOne((Wrapper)queryAgrWrapper);
        if (resultPo == null) {
            return null;
        }
        LambdaQueryWrapper queryCatalogWrapper = new LambdaQueryWrapper();
        queryCatalogWrapper.eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)resultPo.getAgrObjPrimaryId());
        queryCatalogWrapper.eq(AgrCooperationCatalogPO::getAgrId, (Object)resultPo.getAgrId());
        queryCatalogWrapper.eq(AgrCooperationCatalogPO::getManageCatalogId, (Object)qryDTO.getCatalogId());
        AgrCooperationCatalogPO agrCooperationCatalogPO = (AgrCooperationCatalogPO)this.agrCooperationCatalogMapper.selectOne((Wrapper)queryCatalogWrapper);
        if (agrCooperationCatalogPO == null) {
            return null;
        }
        DycProCommPriceCheckRuleVerifyValueDTO dto = new DycProCommPriceCheckRuleVerifyValueDTO();
        dto.setAgrDiscountRate(agrCooperationCatalogPO.getDiscountRate());
        return dto;
    }

    @Override
    public DycProCommPriceCheckRuleVerifyValueDTO querFirstSkuPriceChangeRecord(DycProCommPriceCheckRuleParamQryDTO qryDTO) {
        CommSkuPriceChngRecordPO commSkuPriceChngRecordPO = new CommSkuPriceChngRecordPO();
        commSkuPriceChngRecordPO.setSkuId(qryDTO.getSkuId());
        CommSkuPriceChngRecordPO commSkuPriceChngRecordPO1 = this.commSkuPriceChngRecordMapper.selectFirstId(qryDTO.getChngTimeStart(), qryDTO.getChngTimeEnd(), commSkuPriceChngRecordPO);
        if (commSkuPriceChngRecordPO1 == null) {
            return null;
        }
        CommSkuPriceChngRecordPO recordPO = (CommSkuPriceChngRecordPO)this.commSkuPriceChngRecordMapper.selectById((Serializable)commSkuPriceChngRecordPO1.getPriceChngRecordId());
        DycProCommPriceCheckRuleVerifyValueDTO dto = new DycProCommPriceCheckRuleVerifyValueDTO();
        dto.setSupplierPrice(recordPO.getSupplierPrice());
        return dto;
    }

    @Override
    public DycProCommPriceCheckRuleVerifyValueDTO querySkuPriceCycleChangeNum(DycProCommPriceCheckRuleParamQryDTO qryDTO) {
        CommSkuPriceChngRecordPO commSkuPriceChngRecordPO = new CommSkuPriceChngRecordPO();
        commSkuPriceChngRecordPO.setSkuId(qryDTO.getSkuId());
        int count = this.commSkuPriceChngRecordMapper.selectCycleChangeNum(qryDTO.getChngTimeStart(), qryDTO.getChngTimeEnd(), commSkuPriceChngRecordPO);
        DycProCommPriceCheckRuleVerifyValueDTO dto = new DycProCommPriceCheckRuleVerifyValueDTO();
        dto.setSupplierPriceCycleChangeNum(count - 1);
        return dto;
    }

    @Override
    public RspPage<DycProCommCheckRecordItemDTO> queryCheckRecordItemListPage(DycProCommCheckRecordQryDTO recordQryDTO) {
        RspPage rspPage = new RspPage();
        Page page = new Page((long)recordQryDTO.getPageNo().intValue(), (long)recordQryDTO.getPageSize().intValue());
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eqIfPresent(CommCheckRecordItemPO::getCheckSnId, (Object)recordQryDTO.getCheckSnId());
        queryWrapperX.inIfPresent(CommCheckRecordItemPO::getCheckResult, recordQryDTO.getCheckResults());
        queryWrapperX.inIfPresent(CommCheckRecordItemPO::getCheckSnId, recordQryDTO.getCheckSnIds());
        queryWrapperX.orderByDesc(CommCheckRecordItemPO::getCreateTime);
        Page result = (Page)this.commCheckRecordItemMapper.selectPage((IPage)page, (Wrapper)queryWrapperX);
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProCommCheckRecordItemDTO.class));
        return rspPage;
    }

    @Override
    public void updatePersonAuditCheckResultByCheckSnId(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        CommCheckObjCheckRecordPO po = (CommCheckObjCheckRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)checkObjCheckRecordDTO), CommCheckObjCheckRecordPO.class);
        po.setUpdateTime(new Date());
        this.commCheckObjCheckRecordMapper.updateById((Object)po);
        LambdaQueryWrapperX updateCheckRecordItemWrapperX = new LambdaQueryWrapperX();
        updateCheckRecordItemWrapperX.eq(CommCheckRecordItemPO::getCheckSnId, (Object)checkObjCheckRecordDTO.getCheckSnId());
        updateCheckRecordItemWrapperX.ne(CommCheckRecordItemPO::getCheckResult, (Object)Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()));
        CommCheckRecordItemPO commCheckRecordItemPO = new CommCheckRecordItemPO();
        commCheckRecordItemPO.setPersonAuditCheckResult(checkObjCheckRecordDTO.getPersonAuditCheckResult());
        this.commCheckRecordItemMapper.update((Object)commCheckRecordItemPO, (Wrapper)updateCheckRecordItemWrapperX);
    }

    @Override
    public DycProCommCheckObjCheckRecordDTO queryCheckObjCheckRecordByConditon(DycProCommCheckObjCheckRecordDTO dycProCommCheckObjCheckRecordDTO) {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eqIfPresent(CommCheckObjCheckRecordPO::getCheckSnId, (Object)dycProCommCheckObjCheckRecordDTO.getCheckSnId());
        CommCheckObjCheckRecordPO po = (CommCheckObjCheckRecordPO)this.commCheckObjCheckRecordMapper.selectOne((Wrapper)queryWrapperX);
        if (po == null) {
            return null;
        }
        return (DycProCommCheckObjCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)po), DycProCommCheckObjCheckRecordDTO.class);
    }

    @Override
    public DycProCommCheckRecordDTO queryCheckRecordInfoById(DycProCommCheckRecordDTO dycProCommCheckRecordDTO) {
        CommCheckRecordPO po = (CommCheckRecordPO)this.commCheckRecordMapper.selectById((Serializable)dycProCommCheckRecordDTO.getCheckRecordId());
        if (po == null) {
            return null;
        }
        return (DycProCommCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)po), DycProCommCheckRecordDTO.class);
    }

    @Override
    public void updateCheckObjCheckRecordByConditon(DycProCommCheckObjCheckRecordDTO set, DycProCommCheckObjCheckRecordDTO where) {
        LambdaQueryWrapperX whereWrapper1 = new LambdaQueryWrapperX();
        whereWrapper1.eqIfPresent(CommCheckObjCheckRecordPO::getCheckObjId, (Object)where.getCheckObjId());
        whereWrapper1.eqIfPresent(CommCheckObjCheckRecordPO::getCheckRuleType, (Object)where.getCheckRuleType());
        whereWrapper1.eqIfPresent(CommCheckObjCheckRecordPO::getIsLastFlag, (Object)where.getIsLastFlag());
        whereWrapper1.eqIfPresent(CommCheckObjCheckRecordPO::getCheckSnId, (Object)where.getCheckSnId());
        CommCheckObjCheckRecordPO updatePo2 = (CommCheckObjCheckRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)set), CommCheckObjCheckRecordPO.class);
        this.commCheckObjCheckRecordMapper.update((Object)updatePo2, (Wrapper)whereWrapper1);
    }

    @Override
    public void updateCheckRecordByConditon(DycProCommCheckRecordDTO set, DycProCommCheckRecordDTO where) {
        LambdaQueryWrapperX whereWrapper = new LambdaQueryWrapperX();
        whereWrapper.eqIfPresent(CommCheckRecordPO::getCheckRecordId, (Object)where.getCheckRecordId());
        whereWrapper.eqIfPresent(CommCheckRecordPO::getCheckObjId, (Object)where.getCheckObjId());
        whereWrapper.eqIfPresent(CommCheckRecordPO::getCheckRuleType, (Object)where.getCheckRuleType());
        whereWrapper.eqIfPresent(CommCheckRecordPO::getIsLastFlag, (Object)where.getIsLastFlag());
        CommCheckRecordPO updatePo = (CommCheckRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)set), CommCheckRecordPO.class);
        this.commCheckRecordMapper.update((Object)updatePo, (Wrapper)whereWrapper);
    }

    @Override
    public List<DycProCommCheckObjCheckRecordDTO> selectCheckObjCheckRecordList(DycProCommCheckRecordQryDTO qryDTO) {
        List commCheckObjCheckRecordPOS = this.commCheckObjCheckRecordMapper.selectList((Wrapper)new LambdaQueryWrapperX().eqIfPresent(CommCheckObjCheckRecordPO::getCheckObjId, (Object)qryDTO.getCheckObjId()).eqIfPresent(CommCheckObjCheckRecordPO::getCheckObjType, (Object)qryDTO.getCheckObjType()).eqIfPresent(CommCheckObjCheckRecordPO::getCheckSnId, (Object)qryDTO.getCheckSnId()).eqIfPresent(CommCheckObjCheckRecordPO::getIsLastFlag, (Object)qryDTO.getIsLastFlag()).eqIfPresent(CommCheckObjCheckRecordPO::getCheckRuleType, (Object)qryDTO.getCheckRuleType()).inIfPresent(CommCheckObjCheckRecordPO::getCheckStatus, qryDTO.getCheckStatuss()).eqIfPresent(CommCheckObjCheckRecordPO::getClearExceptionFlag, (Object)qryDTO.getClearExceptionFlag()));
        return JSON.parseArray((String)JSON.toJSONString((Object)commCheckObjCheckRecordPOS), DycProCommCheckObjCheckRecordDTO.class);
    }

    private void updateSkuMainInfoAndSyncNosql(Long skuId) {
        LambdaQueryWrapperX whereWrapper = new LambdaQueryWrapperX();
        whereWrapper.eq(CommSkuInfoPO::getSkuId, (Object)skuId);
        whereWrapper.ne(CommSkuInfoPO::getExamineStatus, (Object)Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECKING.getCode()));
        CommSkuInfoPO commSkuInfoPO = new CommSkuInfoPO();
        commSkuInfoPO.setExamineStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECKING.getCode())));
        int count = this.commSkuInfoMapper.update((Object)commSkuInfoPO, (Wrapper)whereWrapper);
        if (count > 0) {
            NosqlUpdateBatchReqBO nosqlUpdateBatchReqBO = new NosqlUpdateBatchReqBO();
            nosqlUpdateBatchReqBO.setIndex(this.skuIndexName);
            ArrayList<NosqlMapBO> nosqlBOList = new ArrayList<NosqlMapBO>();
            NosqlMapBO nosqlMapBO = new NosqlMapBO();
            nosqlMapBO.setId(String.valueOf(commSkuInfoPO.getSkuId()));
            HashMap<String, Integer> skuDataMap = new HashMap<String, Integer>();
            skuDataMap.put("examineStatus", commSkuInfoPO.getExamineStatus());
            nosqlMapBO.setMaps(skuDataMap);
            nosqlBOList.add(nosqlMapBO);
            nosqlUpdateBatchReqBO.setNosqlBOList(nosqlBOList);
            NosqlUpdateBatchRsqBO nosqlUpdateBatchRsqBO = this.nosqlClient.updateBatch(nosqlUpdateBatchReqBO);
            if (!"0000".equals(nosqlUpdateBatchRsqBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528nosql\u5931\u8d25:" + nosqlUpdateBatchRsqBO.getRespDesc());
            }
        }
    }

    private void updateBansRecordBatchAndSyncNosql(Long skuId, Integer checkRuleType) {
        DycProCommBansRecordInfoQryDTO qryDto = new DycProCommBansRecordInfoQryDTO();
        qryDto.setSkuId(skuId);
        qryDto.setBansEndDate(new Date());
        if (checkRuleType.equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
            qryDto.setBansType(DycProCommConstants.bansRuleType.PRICE_DETECTION);
        } else {
            qryDto.setBansType(DycProCommConstants.bansRuleType.PIC_TEXT_DETECTION);
        }
        List<DycProCommBansRecordInfoDTO> recordInfoDTOS = this.queryBansRecordList(qryDto);
        if (!CollectionUtils.isEmpty(recordInfoDTOS)) {
            ArrayList bansRuleIds = new ArrayList();
            recordInfoDTOS.forEach(dycProCommBansRecordInfoDTO -> bansRuleIds.add(dycProCommBansRecordInfoDTO.getBansRuleId()));
            LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
            queryWrapperX.eq(CommBansRecordPO::getSkuId, (Object)skuId);
            queryWrapperX.in(CommBansRecordPO::getBansRuleId, bansRuleIds);
            CommBansRecordPO recordPO = new CommBansRecordPO();
            recordPO.setBansEndDate(new Date());
            int count = this.commBansRecordMapper.update((Object)recordPO, (Wrapper)queryWrapperX);
            if (count > 0) {
                this.syncNoSqlBySku(skuId);
            }
        }
    }

    private void syncNoSqlBySku(Long skuId) {
        LambdaQueryWrapperX queryWrapperX3 = new LambdaQueryWrapperX();
        queryWrapperX3.eq(CommBansRecordPO::getSkuId, (Object)skuId);
        queryWrapperX3.ge(CommBansRecordPO::getBansEndDate, (Object)new Date());
        List recordPOS = this.commBansRecordMapper.selectList((Wrapper)queryWrapperX3);
        List bansRuleList = JSON.parseArray((String)JSONObject.toJSONString((Object)recordPOS), DycProEsIndexMappingBansRuleBO.class);
        DycProEsIndexMappingSkuBO updateIndexMappingSkuBO = new DycProEsIndexMappingSkuBO();
        updateIndexMappingSkuBO.setBansRuleList(bansRuleList);
        NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
        nosqlUpdateSingleReqBO.setIndex(this.skuIndexName);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(skuId));
        nosqlBO.setObject((Object)updateIndexMappingSkuBO);
        nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
        NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
        if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u66f4\u65b0sku\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
        }
    }

    private void updateObjCheckRecordAndCheckRecord(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        LambdaQueryWrapperX whereWrapper = new LambdaQueryWrapperX();
        whereWrapper.eq(CommCheckRecordPO::getCheckObjId, (Object)checkObjCheckRecordDTO.getCheckObjId());
        whereWrapper.eq(CommCheckRecordPO::getCheckRuleType, (Object)checkObjCheckRecordDTO.getCheckRuleType());
        CommCheckRecordPO updatePo = new CommCheckRecordPO();
        updatePo.setIsLastFlag(DycProCommConstants.YesOrNo.NO);
        this.commCheckRecordMapper.update((Object)updatePo, (Wrapper)whereWrapper);
        LambdaQueryWrapperX whereWrapper1 = new LambdaQueryWrapperX();
        whereWrapper1.eq(CommCheckObjCheckRecordPO::getCheckObjId, (Object)checkObjCheckRecordDTO.getCheckObjId());
        whereWrapper1.eq(CommCheckObjCheckRecordPO::getCheckRuleType, (Object)checkObjCheckRecordDTO.getCheckRuleType());
        CommCheckObjCheckRecordPO updatePo2 = new CommCheckObjCheckRecordPO();
        updatePo2.setIsLastFlag(DycProCommConstants.YesOrNo.NO);
        this.commCheckObjCheckRecordMapper.update((Object)updatePo2, (Wrapper)whereWrapper1);
    }

    private void addCheckObjCheckRecord(DycProCommCheckObjCheckRecordDTO checkObjCheckRecordDTO) {
        Date operTime = new Date();
        Long checkSnId = Sequence.getInstance().nextId();
        ArrayList checkRecordItemDTOList = new ArrayList();
        checkObjCheckRecordDTO.getCheckRecordDTOList().forEach(dycProCommCheckRecordDTO -> {
            Long checkRecordId = Sequence.getInstance().nextId();
            dycProCommCheckRecordDTO.setCheckSnId(checkSnId);
            dycProCommCheckRecordDTO.setCheckRecordId(checkRecordId);
            dycProCommCheckRecordDTO.setCreateTime(operTime);
            dycProCommCheckRecordDTO.setIsLastFlag(DycProCommConstants.YesOrNo.YES);
            dycProCommCheckRecordDTO.getCheckRecordItemDTOList().forEach(dycProCommCheckRecordItemDTO -> {
                dycProCommCheckRecordItemDTO.setCheckSnId(checkSnId);
                dycProCommCheckRecordItemDTO.setCheckRecordId(checkRecordId);
                dycProCommCheckRecordItemDTO.setCheckItemId(Sequence.getInstance().nextId());
                dycProCommCheckRecordItemDTO.setCreateTime(operTime);
                checkRecordItemDTOList.add(dycProCommCheckRecordItemDTO);
            });
        });
        List insertPos = JSON.parseArray((String)JSON.toJSONString(checkObjCheckRecordDTO.getCheckRecordDTOList()), CommCheckRecordPO.class);
        this.commCheckRecordMapper.insertBatch((Collection)insertPos);
        List insertItemPos = JSON.parseArray((String)JSON.toJSONString(checkRecordItemDTOList), CommCheckRecordItemPO.class);
        this.commCheckRecordItemMapper.insertBatch((Collection)insertItemPos);
        checkObjCheckRecordDTO.setCheckSnId(checkSnId);
        CommCheckObjCheckRecordPO insertPo = (CommCheckObjCheckRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)checkObjCheckRecordDTO), CommCheckObjCheckRecordPO.class);
        Integer exceptionCount = 1;
        if (!CollectionUtils.isEmpty(checkObjCheckRecordDTO.getCheckSnIds())) {
            log.info("\u5b58\u5728\u5176\u4ed6\u5f02\u5e38\u68c0\u6d4b\u8bb0\u5f55{}", checkObjCheckRecordDTO.getCheckSnIds());
            LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
            queryWrapper.inIfPresent(CommCheckObjCheckRecordPO::getCheckSnId, checkObjCheckRecordDTO.getCheckSnIds());
            List result = this.commCheckObjCheckRecordMapper.selectList((Wrapper)queryWrapper);
            for (CommCheckObjCheckRecordPO checkObjCheckRecordPO : result) {
                if (checkObjCheckRecordPO.getExceptionCount() == null || checkObjCheckRecordPO.getExceptionCount().compareTo(exceptionCount) <= 0) continue;
                exceptionCount = checkObjCheckRecordPO.getExceptionCount();
            }
            Integer n = exceptionCount;
            Integer n2 = exceptionCount = Integer.valueOf(exceptionCount + 1);
        }
        insertPo.setExceptionCount(exceptionCount);
        insertPo.setIsLastFlag(DycProCommConstants.YesOrNo.YES);
        insertPo.setCreateTime(operTime);
        insertPo.setCheckRuleNum(Integer.valueOf(0));
        this.commCheckObjCheckRecordMapper.insert((Object)insertPo);
    }

    private List<DycProCommCheckRuleInfoDTO> querySkuEffectCheckRule(DycProCommCheckRuleInfoQryDTO dycProCommCheckRuleInfoQryDTO) {
        CommCheckRuleAndSkuRangePO commCheckRuleAndSkuRangePO = (CommCheckRuleAndSkuRangePO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleInfoQryDTO), CommCheckRuleAndSkuRangePO.class);
        List checkRulePos = null;
        commCheckRuleAndSkuRangePO.setCheckRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleStatusEnum.ENABLE.getCode())));
        if (dycProCommCheckRuleInfoQryDTO.getCheckRuleType().equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
            checkRulePos = this.commCheckRuleInfoMapper.querySkuEffectCheckRule(commCheckRuleAndSkuRangePO);
        } else {
            LambdaQueryWrapper queryRuleItemWrapper = new LambdaQueryWrapper();
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckRuleType, (Object)dycProCommCheckRuleInfoQryDTO.getCheckRuleType());
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckRuleStatus, (Object)Integer.parseInt(DmcCommCheckRuleStatusEnum.ENABLE.getCode()));
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckSceneCode, (Object)dycProCommCheckRuleInfoQryDTO.getCheckSceneCode());
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckObjType, (Object)dycProCommCheckRuleInfoQryDTO.getCheckObjType());
            checkRulePos = this.commCheckRuleInfoMapper.selectList((Wrapper)queryRuleItemWrapper);
        }
        if (!CollectionUtils.isEmpty((Collection)checkRulePos)) {
            List checkRuleInfoDTOs = JSONArray.parseArray((String)JSON.toJSONString((Object)checkRulePos), DycProCommCheckRuleInfoDTO.class);
            checkRuleInfoDTOs.forEach(dycProCommCheckRuleInfoDTO -> {
                if (dycProCommCheckRuleInfoDTO.getCheckRuleType().equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
                    LambdaQueryWrapper queryRuleItemWrapper = new LambdaQueryWrapper();
                    queryRuleItemWrapper.eq(CommCheckRuleItemInfoPO::getCheckRuleId, (Object)dycProCommCheckRuleInfoDTO.getCheckRuleId());
                    List checkRuleItemPos = this.commCheckRuleItemInfoMapper.selectList((Wrapper)queryRuleItemWrapper);
                    List checkRuleItemInfoDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)checkRuleItemPos), DycProCommCheckRuleItemInfoDTO.class);
                    dycProCommCheckRuleInfoDTO.setCheckRuleItemInfoDTOList(checkRuleItemInfoDTOList);
                }
            });
            return checkRuleInfoDTOs;
        }
        return null;
    }

    private DycProCommCheckObjCheckRecordDTO buildObjCheckRecordDTO(CommSkuInfoPO commSkuInfoPO, CommManageCatalogInfoPO commManageCatalogInfoPO, DycProCommExecCheckRuleDTO dycProCommExecCheckRuleDTO) {
        DycProCommCheckObjCheckRecordDTO objCheckRecordDTO = new DycProCommCheckObjCheckRecordDTO();
        objCheckRecordDTO.setCheckObjId(commSkuInfoPO.getSkuId());
        objCheckRecordDTO.setCheckObjCode(commSkuInfoPO.getSkuCode());
        objCheckRecordDTO.setCheckObjName(commSkuInfoPO.getSkuName());
        objCheckRecordDTO.setCheckObjType(dycProCommExecCheckRuleDTO.getCheckObjType());
        objCheckRecordDTO.setCheckExtObjCode(commSkuInfoPO.getExtSkuId());
        objCheckRecordDTO.setCheckSceneCode(dycProCommExecCheckRuleDTO.getCheckSceneCode());
        objCheckRecordDTO.setSupplierId(commSkuInfoPO.getSupplierId());
        objCheckRecordDTO.setSupplierName(commSkuInfoPO.getSupplierName());
        objCheckRecordDTO.setManageCatalogPath(commManageCatalogInfoPO.getManageCatalogPath());
        List manageCatalogIds = Arrays.stream(commManageCatalogInfoPO.getManageCatalogPath().split("-")).map(Long::valueOf).collect(Collectors.toList());
        LambdaQueryWrapperX queryRuleItemWrapperx = new LambdaQueryWrapperX();
        queryRuleItemWrapperx.in(CommManageCatalogInfoPO::getManageCatalogId, manageCatalogIds);
        queryRuleItemWrapperx.orderByAsc(CommManageCatalogInfoPO::getManageCatalogLevel);
        List manageCatalogInfoList = this.commManageCatalogInfoMapper.selectList((Wrapper)queryRuleItemWrapperx);
        StringBuilder manageCatalogPathName = new StringBuilder();
        for (int i = 0; i < manageCatalogInfoList.size(); ++i) {
            manageCatalogPathName.append(((CommManageCatalogInfoPO)manageCatalogInfoList.get(i)).getManageCatalogName());
            if (i >= manageCatalogInfoList.size() - 1) continue;
            manageCatalogPathName.append(">");
        }
        objCheckRecordDTO.setManageCatalogPathName(manageCatalogPathName.toString());
        if (dycProCommExecCheckRuleDTO.getUserId() == null) {
            objCheckRecordDTO.setCreateUserName("\u7cfb\u7edf");
            objCheckRecordDTO.setCreateUserAccount("\u7cfb\u7edf");
        } else {
            objCheckRecordDTO.setCreateUserId(dycProCommExecCheckRuleDTO.getUserId());
            objCheckRecordDTO.setCreateUserName(dycProCommExecCheckRuleDTO.getName());
            objCheckRecordDTO.setCreateUserAccount(dycProCommExecCheckRuleDTO.getUserName());
            objCheckRecordDTO.setCreateOrgId(dycProCommExecCheckRuleDTO.getOrgId());
            objCheckRecordDTO.setCreateOrgName(dycProCommExecCheckRuleDTO.getOrgName());
            objCheckRecordDTO.setCreateCompanyId(dycProCommExecCheckRuleDTO.getCompanyId());
            objCheckRecordDTO.setCreateCompanyName(dycProCommExecCheckRuleDTO.getCompanyName());
            objCheckRecordDTO.setCreateOrgPath(dycProCommExecCheckRuleDTO.getOrgPath());
        }
        return objCheckRecordDTO;
    }

    public List<DycProCommBansRecordInfoDTO> queryBansRecordList(DycProCommBansRecordInfoQryDTO dycProCommBansRecordInfoQryDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eqIfPresent(CommBansRecordPO::getSkuId, (Object)dycProCommBansRecordInfoQryDTO.getSkuId());
        queryWrapper.inIfPresent(CommBansRecordPO::getSkuId, dycProCommBansRecordInfoQryDTO.getSkuIdList());
        queryWrapper.eqIfPresent(CommBansRecordPO::getBansType, (Object)dycProCommBansRecordInfoQryDTO.getBansType());
        queryWrapper.gtIfPresent(CommBansRecordPO::getBansEndDate, (Object)dycProCommBansRecordInfoQryDTO.getBansEndDate());
        queryWrapper.eqIfPresent(CommBansRecordPO::getBansRuleId, (Object)dycProCommBansRecordInfoQryDTO.getBansRuleId());
        List pos = this.commBansRecordMapper.selectList((Wrapper)queryWrapper);
        return JSONArray.parseArray((String)JSONObject.toJSONString((Object)pos), DycProCommBansRecordInfoDTO.class);
    }
}

